package com.biz.crm.tpm.business.sales.goal.local.service.process;

import com.biz.crm.mdm.business.customer.channel.sdk.service.CustomerChannelVoService;
import com.biz.crm.mdm.business.customer.channel.sdk.vo.CustomerChannelVo;
import com.biz.crm.mdm.business.product.brand.sdk.service.ProductBrandService;
import com.biz.crm.mdm.business.product.brand.sdk.vo.ProductBrandVo;
import com.biz.crm.mdm.business.product.level.sdk.service.ProductLevelVoSdkService;
import com.biz.crm.mdm.business.product.level.sdk.vo.ProductLevelVo;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.mdm.business.terminal.channel.sdk.service.MdmTerminalChannelVoService;
import com.biz.crm.mdm.business.terminal.channel.sdk.vo.MdmTerminalChannelVo;
import com.biz.crm.mn.common.base.eunm.DataFromEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mdm.business.terminal.sdk.service.TerminalVoService;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalVo;
import com.biz.crm.tpm.business.budget.dimension.config.sdk.dto.DimensionInformationQueryData;
import com.biz.crm.tpm.business.budget.dimension.config.sdk.enmus.MenuCodeEnum;
import com.biz.crm.tpm.business.budget.dimension.config.sdk.service.DimensionDimensionInformationService;
import com.biz.crm.tpm.business.budget.dimension.config.sdk.vo.DimensionDimensionInformationVo;
import com.biz.crm.tpm.business.sales.goal.sdk.constant.DictTypeCodeConstant;
import com.biz.crm.tpm.business.sales.goal.sdk.dto.SalesGoalDto;
import com.biz.crm.tpm.business.sales.goal.sdk.service.SalesGoalService;
import com.biz.crm.tpm.business.sales.goal.sdk.vo.SalesGoalImportsVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author huojia
 * @date 2022年10月28日 11:38
 */
@Slf4j
@Component
public class SalesGoalImportsProcess implements ImportProcess<SalesGoalImportsVo> {

    @Resource
    private SalesGoalService salesGoalService;

    @Resource
    private SalesOrgVoService salesOrgVoService;

    @Resource
    private CustomerChannelVoService customerChannelVoService;

    @Resource
    private MdmTerminalChannelVoService mdmTerminalChannelVoService;

    @Resource
    private ProductBrandService productBrandService;

    @Resource
    private ProductLevelVoSdkService productLevelVoSdkService;

    @Resource
    private ProductVoService productVoService;

    @Resource
    private CustomerVoService customerVoService;

    @Resource
    private TerminalVoService terminalVoService;

    @Resource
    private DictToolkitService dictToolkitService;

    @Resource
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private DimensionDimensionInformationService dimensionDimensionInformationService;

    private Map<String, String> mdmBusinessFormatMap = new HashMap<>();
    private Map<String, String> mdmBusinessUnitMap = new HashMap<>();
    private Map<String, String> tpmGroupCodeMap = new HashMap<>();
    private Map<String, CustomerVo> customerVoMap = new HashMap<>();
    private Map<String, TerminalVo> terminalVoMap = new HashMap<>();
    private Map<String, ProductVo> productVoMap = new HashMap<>();
    private Map<String, SalesOrgVo> salesOrgVoMap = new HashMap<>();
    private Map<String, CustomerChannelVo> customerChannelVoMap = new HashMap<>();
    private Map<String, MdmTerminalChannelVo> terminalChannelVoMap = new HashMap<>();
    private Map<String, ProductBrandVo> productBrandVoMap = new HashMap<>();
    private Map<String, ProductLevelVo> productCategoryVoMap = new HashMap<>();
    private Map<String, ProductLevelVo> productItemVoMap = new HashMap<>();

    /**
     * 数据分片
     *
     * @return 分片长度
     */
    @Override
    public Integer getBatchCount() {
        return 2000;
    }

    @Override
    public Map<Integer, String> execute(LinkedHashMap<Integer, SalesGoalImportsVo> data,
                                        TaskGlobalParamsVo paramsVo,
                                        Map<String, Object> params) {
        Validate.notEmpty(data, "导入数据不能为空！");

        List<SalesGoalDto> importList = this.validate(data);

        salesGoalService.importSave(importList);
        return null;
    }

    /**
     * 校验数据
     *
     * @param data
     * @author huojia
     * @date 2022/10/28 14:04
     **/
    private List<SalesGoalDto> validate(LinkedHashMap<Integer, SalesGoalImportsVo> data) {
        List<SalesGoalImportsVo> salesGoalImportsVos = new ArrayList<>(data.values());

        // 构建基础数据map
        this.buildBaseMap(salesGoalImportsVos);

        Map<String, List<DimensionDimensionInformationVo>> dimensionMap = new HashMap<>(8);
        // 通过反射，获取对象中的值
        Class<SalesGoalImportsVo> clazz = SalesGoalImportsVo.class;
        salesGoalImportsVos.forEach(importsVo -> {
            // 查询维度配置表，校验关键字段
            this.buildDimension(dimensionMap, importsVo, clazz);

            // 校验基础数据
            this.buildBaseData(importsVo);

            // 校验数字
            this.buildDecimal(importsVo);

        });
        Collection<SalesGoalDto> salesGoalDtoList = nebulaToolkitService.copyCollectionByWhiteList(salesGoalImportsVos, SalesGoalImportsVo.class, SalesGoalDto.class, LinkedHashSet.class, ArrayList.class);
        return new ArrayList<>(salesGoalDtoList);
    }

    /**
     * 校验维度字段
     *
     * @param importsVo
     * @author huojia
     * @date 2022/11/12 10:38
     **/
    private void buildDimension(Map<String, List<DimensionDimensionInformationVo>> dimensionMap, SalesGoalImportsVo importsVo, Class<SalesGoalImportsVo> clazz) {
        List<DimensionDimensionInformationVo> dimensionVoList = new ArrayList<>();
        if (!dimensionMap.containsKey(importsVo.getBusinessFormatCode() + importsVo.getBusinessUnitCode() + MenuCodeEnum.SALES_GOAL.getCode() + importsVo.getSalesOrgCode())) {
            // 获取维度配置
            DimensionInformationQueryData dto = new DimensionInformationQueryData();
            dto.setBusinessFormatCode(importsVo.getBusinessFormatCode());
            dto.setBusinessUnitCode(importsVo.getBusinessUnitCode());
            dto.setMenu(MenuCodeEnum.SALES_GOAL.getCode());
            dto.setSalesOrgCodeList(Arrays.asList(importsVo.getSalesOrgCode()));
            dimensionVoList = dimensionDimensionInformationService.findDetailsByCodes(dto);
            dimensionMap.put(importsVo.getBusinessFormatCode() + importsVo.getBusinessUnitCode() + MenuCodeEnum.SALES_GOAL.getCode() + importsVo.getSalesOrgCode(), dimensionVoList);
        } else {
            dimensionVoList = dimensionMap.get(importsVo.getBusinessFormatCode() + importsVo.getBusinessUnitCode() + MenuCodeEnum.SALES_GOAL.getCode() + importsVo.getSalesOrgCode());
        }
        if (CollectionUtils.isEmpty(dimensionVoList)) {
            throw new RuntimeException("没有找到对应维度配置数据！");
        }
        // 根据维度配置，判断必填字段
        dimensionVoList.forEach(informationVo -> {
            try {
                if (StringUtils.isEmpty(informationVo.getFieldCoding())) {
                    return;
                }
                Field field = clazz.getDeclaredField(informationVo.getFieldCoding());
                field.setAccessible(true);
                Object o = field.get(importsVo);
                if (ObjectUtils.isEmpty(o)) {
                    throw new RuntimeException(informationVo.getFieldName() + "不能为空！");
                }
            } catch (NoSuchFieldException | IllegalAccessException e) {
                throw new RuntimeException(e.getMessage());
            }
        });
        importsVo.setTypeCoding(dimensionVoList.get(0).getTypeCoding());
    }

    /**
     * 校验数字
     *
     * @param importsVo
     * @author huojia
     * @date 2022/11/10 21:42
     **/
    private void buildDecimal(SalesGoalImportsVo importsVo) {
        // 单价
        try {
            if (!StringUtils.isEmpty(importsVo.getPriceStr())) {
                importsVo.setPrice(new BigDecimal(importsVo.getPriceStr()));
            }
        } catch (Exception e) {
            throw new RuntimeException("单价" + importsVo.getPriceStr() + "格式错误，请检查！");
        }
        // 吨位
        try {
            if (!StringUtils.isEmpty(importsVo.getTonnageStr())) {
                importsVo.setTonnage(new BigDecimal(importsVo.getTonnageStr()));
            }
        } catch (Exception e) {
            throw new RuntimeException("吨位" + importsVo.getTonnageStr() + "格式错误，请检查！");
        }
        // 任务量
        try {
            if (!StringUtils.isEmpty(importsVo.getTaskQuantityStr())) {
                importsVo.setTaskQuantity(new BigDecimal(importsVo.getTaskQuantityStr()));
            }
        } catch (Exception e) {
            throw new RuntimeException("任务量" + importsVo.getTaskQuantityStr() + "格式错误，请检查！");
        }
        // 进货折前销售额
        try {
            if (!StringUtils.isEmpty(importsVo.getPurchaseSalesAmountStr())) {
                importsVo.setPurchaseSalesAmount(new BigDecimal(importsVo.getPurchaseSalesAmountStr()));
            }
        } catch (Exception e) {
            throw new RuntimeException("进货折前销售额" + importsVo.getPurchaseSalesAmountStr() + "格式错误，请检查！");
        }
        // 进货折后销售额
        try {
            if (!StringUtils.isEmpty(importsVo.getPurchaseDiscountSalesAmountStr())) {
                importsVo.setPurchaseDiscountSalesAmount(new BigDecimal(importsVo.getPurchaseDiscountSalesAmountStr()));
            }
        } catch (Exception e) {
            throw new RuntimeException("进货折后销售额" + importsVo.getPurchaseDiscountSalesAmountStr() + "格式错误，请检查！");
        }
        // 出库折前销售额
        try {
            if (!StringUtils.isEmpty(importsVo.getDeliverySalesAmountStr())) {
                importsVo.setDeliverySalesAmount(new BigDecimal(importsVo.getDeliverySalesAmountStr()));
            }
        } catch (Exception e) {
            throw new RuntimeException("出库折前销售额" + importsVo.getDeliverySalesAmountStr() + "格式错误，请检查！");
        }
        // 出库折后销售额
        try {
            if (!StringUtils.isEmpty(importsVo.getDeliveryDiscountSalesAmountStr())) {
                importsVo.setDeliveryDiscountSalesAmount(new BigDecimal(importsVo.getDeliveryDiscountSalesAmountStr()));
            }
        } catch (Exception e) {
            throw new RuntimeException("出库折后销售额" + importsVo.getDeliveryDiscountSalesAmountStr() + "格式错误，请检查！");
        }
        // 出库量
        try {
            if (!StringUtils.isEmpty(importsVo.getDeliveryQuantityStr())) {
                importsVo.setDeliveryQuantity(new BigDecimal(importsVo.getDeliveryQuantityStr()));
            }
        } catch (Exception e) {
            throw new RuntimeException("出库量" + importsVo.getDeliveryQuantityStr() + "格式错误，请检查！");
        }
    }

    /**
     * 校验基础数据
     *
     * @param importsVo
     * @author huojia
     * @date 2022/11/10 21:41
     **/
    private void buildBaseData(SalesGoalImportsVo importsVo) {
        // 设置数据来源
        importsVo.setDataFromCode(DataFromEnum.IMPORT.getCode());
        // 业态
        if (!StringUtils.isEmpty(importsVo.getBusinessFormatCode())) {
            if (!mdmBusinessFormatMap.containsKey(importsVo.getBusinessFormatCode())) {
                throw new RuntimeException("业态" + importsVo.getBusinessFormatCode() + "错误，请检查！");
            } else {
                importsVo.setBusinessFormatCode(mdmBusinessFormatMap.get(importsVo.getBusinessFormatCode()));
            }
        }
        // 业务单元
        if (!StringUtils.isEmpty(importsVo.getBusinessUnitCode())) {
            if (!mdmBusinessUnitMap.containsKey(importsVo.getBusinessUnitCode())) {
                throw new RuntimeException("业务单元" + importsVo.getBusinessUnitCode() + "错误，请检查！");
            } else {
                importsVo.setBusinessUnitCode(mdmBusinessUnitMap.get(importsVo.getBusinessUnitCode()));
            }
        }
        // 年月
        if (!StringUtils.isEmpty(importsVo.getYearMonthLy())) {
            try {
                DateUtil.parseDate(importsVo.getYearMonthLy(), DateUtil.DEFAULT_YEAR_MONTH);
            } catch (Exception ignored) {
                throw new RuntimeException("年月" + importsVo.getYearMonthLy() + "格式错误，应该为" + DateUtil.DEFAULT_YEAR_MONTH);
            }
        }
        // 分组
        if (!StringUtils.isEmpty(importsVo.getGroupCode())) {
            if (!tpmGroupCodeMap.containsKey(importsVo.getGroupCode())) {
                throw new RuntimeException("分组" + importsVo.getGroupCode() + "错误，请检查！");
            } else {
                importsVo.setGroupCode(tpmGroupCodeMap.get(importsVo.getGroupCode()));
            }
        }
        // 销售组织
        if (!StringUtils.isEmpty(importsVo.getSalesOrgCode())) {
            if (!salesOrgVoMap.containsKey(importsVo.getSalesOrgCode())) {
                throw new RuntimeException("销售组织" + importsVo.getSalesOrgCode() + "错误，请检查！");
            } else {
                importsVo.setSalesOrgName(salesOrgVoMap.get(importsVo.getSalesOrgCode()).getSalesOrgName());
                importsVo.setSalesOrgLevelCode(salesOrgVoMap.get(importsVo.getSalesOrgCode()).getSalesOrgLevel());
            }
        }
        // 客户渠道
        if (!StringUtils.isEmpty(importsVo.getCustomerChannelCode())) {
            if (!customerChannelVoMap.containsKey(importsVo.getCustomerChannelCode())) {
                throw new RuntimeException("客户渠道" + importsVo.getCustomerChannelCode() + "错误，请检查！");
            } else {
                importsVo.setCustomerChannelName(customerChannelVoMap.get(importsVo.getCustomerChannelCode()).getCustomerChannelName());
                importsVo.setCustomerChannelLevelCode(customerChannelVoMap.get(importsVo.getCustomerChannelCode()).getCustomerChannelType());
            }
        }
        // 终端渠道
        if (!StringUtils.isEmpty(importsVo.getTerminalChannelCode())) {
            if (!terminalChannelVoMap.containsKey(importsVo.getTerminalChannelCode())) {
                throw new RuntimeException("终端渠道" + importsVo.getTerminalChannelCode() + "错误，请检查！");
            } else {
                importsVo.setTerminalChannelName(terminalChannelVoMap.get(importsVo.getTerminalChannelCode()).getTerminalChannelName());

            }
        }
        // 系统、零售商
        if (!StringUtils.isEmpty(importsVo.getSystemCode())) {

        }
        // 客户
        if (!StringUtils.isEmpty(importsVo.getCustomerCode())) {
            if (customerVoMap.containsKey(importsVo.getCustomerCode())) {
                importsVo.setCustomerName(customerVoMap.get(importsVo.getCustomerCode()).getCustomerName());
            } else {
                throw new RuntimeException("客户编码" + importsVo.getCustomerCode() + "错误，请检查！");
            }
        }
        // 门店
        if (!StringUtils.isEmpty(importsVo.getTerminalCode())) {
            if (terminalVoMap.containsKey(importsVo.getTerminalCode())) {
                importsVo.setTerminalName(terminalVoMap.get(importsVo.getTerminalCode()).getTerminalName());
            } else {
                throw new RuntimeException("门店编码" + importsVo.getTerminalCode() + "错误，请检查！");
            }
        }
        // 产品品牌
        if (!StringUtils.isEmpty(importsVo.getProductBrandCode())) {
            if (productBrandVoMap.containsKey(importsVo.getProductBrandCode())) {
                importsVo.setProductBrandName(productBrandVoMap.get(importsVo.getProductBrandCode()).getProductBrandName());
            } else {
                throw new RuntimeException("产品品牌" + importsVo.getProductBrandCode() + "错误，请检查！");
            }
        }
        // 产品品类
        if (!StringUtils.isEmpty(importsVo.getProductCategoryCode())) {
            if (productCategoryVoMap.containsKey(importsVo.getProductCategoryCode())) {
                importsVo.setProductCategoryName(productCategoryVoMap.get(importsVo.getProductCategoryCode()).getProductLevelName());
            } else {
                throw new RuntimeException("产品品类" + importsVo.getProductCategoryCode() + "错误，请检查！");
            }
        }
        // 产品品项
        if (!StringUtils.isEmpty(importsVo.getProductItemCode())) {
            if (productItemVoMap.containsKey(importsVo.getProductItemCode())) {
                importsVo.setProductItemName(productItemVoMap.get(importsVo.getProductItemCode()).getProductLevelName());
            } else {
                throw new RuntimeException("产品品项" + importsVo.getProductCategoryCode() + "错误，请检查！");
            }
        }
        // 产品
        if (!StringUtils.isEmpty(importsVo.getProductCode())) {
            if (productVoMap.containsKey(importsVo.getProductCode())) {
                importsVo.setProductName(productVoMap.get(importsVo.getProductCode()).getProductName());
            } else {
                throw new RuntimeException("产品编码" + importsVo.getProductCode() + "错误，请检查！");
            }
        }
        // 单位
        if (!StringUtils.isEmpty(importsVo.getUnitCode())) {

        }
    }

    /**
     * 构建基础数据map
     *
     * @param salesGoalImportsVos
     * @author huojia
     * @date 2022/11/10 21:40
     **/
    private void buildBaseMap(List<SalesGoalImportsVo> salesGoalImportsVos) {
        // 查询数据字典
        mdmBusinessFormatMap = dictToolkitService.findConvertMapByDictTypeCode(DictTypeCodeConstant.MDM_BUSINESS_FORMAT);
        mdmBusinessUnitMap = dictToolkitService.findConvertMapByDictTypeCode(DictTypeCodeConstant.MDM_BUSINESS_UNIT);
        tpmGroupCodeMap = dictToolkitService.findConvertMapByDictTypeCode(DictTypeCodeConstant.TPM_GROUP_CODE);

        // 查询主数据数据，校验
        Set<String> salesOrgCodeSet = salesGoalImportsVos.stream().map(SalesGoalImportsVo::getSalesOrgCode).filter(Objects::nonNull).collect(Collectors.toSet());
        Set<String> customerChannelCodeSet = salesGoalImportsVos.stream().map(SalesGoalImportsVo::getCustomerChannelCode).filter(Objects::nonNull).collect(Collectors.toSet());
        Set<String> terminalChannelCodeSet = salesGoalImportsVos.stream().map(SalesGoalImportsVo::getTerminalChannelCode).filter(Objects::nonNull).collect(Collectors.toSet());
        Set<String> systemCodeSet = salesGoalImportsVos.stream().map(SalesGoalImportsVo::getSystemCode).filter(Objects::nonNull).collect(Collectors.toSet());
        Set<String> customerCodeSet = salesGoalImportsVos.stream().map(SalesGoalImportsVo::getCustomerCode).filter(Objects::nonNull).collect(Collectors.toSet());
        Set<String> terminalCodeSet = salesGoalImportsVos.stream().map(SalesGoalImportsVo::getTerminalCode).filter(Objects::nonNull).collect(Collectors.toSet());
        Set<String> productBrandCodeSet = salesGoalImportsVos.stream().map(SalesGoalImportsVo::getProductBrandCode).filter(Objects::nonNull).collect(Collectors.toSet());
        Set<String> productCategoryCodeSet = salesGoalImportsVos.stream().map(SalesGoalImportsVo::getProductCategoryCode).filter(Objects::nonNull).collect(Collectors.toSet());
        Set<String> productItemCodeSet = salesGoalImportsVos.stream().map(SalesGoalImportsVo::getProductItemCode).filter(Objects::nonNull).collect(Collectors.toSet());
        Set<String> productCodeSet = salesGoalImportsVos.stream().map(SalesGoalImportsVo::getProductCode).filter(Objects::nonNull).collect(Collectors.toSet());
        Set<String> unitCodeSet = salesGoalImportsVos.stream().map(SalesGoalImportsVo::getUnitCode).filter(Objects::nonNull).collect(Collectors.toSet());

        // 销售组织
        if (!CollectionUtils.isEmpty(salesOrgCodeSet)) {
            List<SalesOrgVo> salesOrgVos = salesOrgVoService.findBySalesOrgCodes(new ArrayList<>(salesOrgCodeSet));
            if (!CollectionUtils.isEmpty(salesOrgVos)) {
                salesOrgVoMap = salesOrgVos.stream().collect(Collectors.toMap(SalesOrgVo::getSalesOrgCode, Function.identity()));
            }
        }

        // 客户渠道
        if (!CollectionUtils.isEmpty(customerChannelCodeSet)) {
            List<CustomerChannelVo> customerChannelVos = customerChannelVoService.findByCodes(new ArrayList<>(customerChannelCodeSet));
            if (!CollectionUtils.isEmpty(customerChannelVos)) {
                customerChannelVoMap = customerChannelVos.stream().collect(Collectors.toMap(CustomerChannelVo::getCustomerChannelCode, Function.identity()));
            }
        }

        // 终端渠道
        if (!CollectionUtils.isEmpty(terminalChannelCodeSet)) {
            List<MdmTerminalChannelVo> mdmTerminalChannelVos = mdmTerminalChannelVoService.listByCodes(new ArrayList<>(terminalChannelCodeSet));
            if (!CollectionUtils.isEmpty(mdmTerminalChannelVos)) {
                terminalChannelVoMap = mdmTerminalChannelVos.stream().collect(Collectors.toMap(MdmTerminalChannelVo::getTerminalChannelCode, Function.identity()));
            }
        }

        // 客户
        if (!CollectionUtils.isEmpty(customerCodeSet)) {
            List<CustomerVo> customerVos = customerVoService.findByCustomerCodes(new ArrayList<>(customerCodeSet));
            if (!CollectionUtils.isEmpty(customerVos)) {
                customerVoMap = customerVos.stream().collect(Collectors.toMap(CustomerVo::getCustomerCode, Function.identity()));
            }
        }

        // 终端
        if (!CollectionUtils.isEmpty(terminalCodeSet)) {
            List<TerminalVo> terminalVos = terminalVoService.findDetailsByIdsOrTerminalCodes(null, new ArrayList<>(terminalCodeSet));
            if (!CollectionUtils.isEmpty(terminalVos)) {
                terminalVoMap = terminalVos.stream().collect(Collectors.toMap(TerminalVo::getTerminalCode, Function.identity()));
            }
        }

        // 品牌
        if (!CollectionUtils.isEmpty(productBrandCodeSet)) {
            List<ProductBrandVo> productBrandVos = productBrandService.listByCodes(new ArrayList<>(productBrandCodeSet));
            if (!CollectionUtils.isEmpty(productBrandVos)) {
                productBrandVoMap = productBrandVos.stream().collect(Collectors.toMap(ProductBrandVo::getProductBrandCode, Function.identity()));
            }
        }

        // 品类
        if (!CollectionUtils.isEmpty(productCategoryCodeSet)) {
            List<ProductLevelVo> productLevelVos = productLevelVoSdkService.findListByCodes(new ArrayList<>(productCategoryCodeSet));
            if (!CollectionUtils.isEmpty(productLevelVos)) {
                productCategoryVoMap = productLevelVos.stream().collect(Collectors.toMap(ProductLevelVo::getProductLevelCode, Function.identity()));
            }
        }

        // 品项
        if (!CollectionUtils.isEmpty(productItemCodeSet)) {
            List<ProductLevelVo> productLevelVos = productLevelVoSdkService.findListByCodes(new ArrayList<>(productItemCodeSet));
            if (!CollectionUtils.isEmpty(productLevelVos)) {
                productItemVoMap = productLevelVos.stream().collect(Collectors.toMap(ProductLevelVo::getProductLevelCode, Function.identity()));
            }
        }

        // 产品
        if (!CollectionUtils.isEmpty(productCodeSet)) {
            List<ProductVo> productVoList = productVoService.findByCodes(new ArrayList<>(productCodeSet));;
            if (!CollectionUtils.isEmpty(productVoList)) {
                productVoMap = productVoList.stream().collect(Collectors.toMap(ProductVo::getProductCode, Function.identity()));
            }
        }
    }

    @Override
    public Class<SalesGoalImportsVo> findCrmExcelVoClass() {
        return SalesGoalImportsVo.class;
    }

    @Override
    public String getTemplateCode() {
        return "TPM_SALES_GOAL_IMPORT";
    }

    @Override
    public String getTemplateName() {
        return "TPM销售目标导入";
    }
}
