package com.biz.crm.tpm.business.sales.goal.local.service.process;

import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.mdm.business.customer.retailer.sdk.service.CustomerRetailerVoService;
import com.biz.crm.mdm.business.customer.retailer.sdk.vo.CustomerRetailerVo;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.mdm.business.product.brand.sdk.service.ProductBrandService;
import com.biz.crm.mdm.business.product.brand.sdk.vo.ProductBrandVo;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mdm.business.terminal.sdk.service.TerminalVoService;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalVo;
import com.biz.crm.mn.common.base.eunm.DataFromEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.sales.goal.sdk.constant.DictTypeCodeConstant;
import com.biz.crm.tpm.business.sales.goal.sdk.dto.SalesGoalDto;
import com.biz.crm.tpm.business.sales.goal.sdk.service.SalesGoalService;
import com.biz.crm.tpm.business.sales.goal.sdk.vo.SalesGoalVerticalImportsVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author huojia
 * @date 2022年10月28日 11:38
 */
@Slf4j
@Component
public class SalesGoalVerticalImportsProcess implements ImportProcess<SalesGoalVerticalImportsVo> {

    @Resource
    private SalesGoalService salesGoalService;

    @Resource
    private ProductBrandService productBrandService;

    @Resource
    private ProductVoService productVoService;

    @Resource
    private CustomerVoService customerVoService;

    @Resource
    private TerminalVoService terminalVoService;

    @Resource
    private DictToolkitService dictToolkitService;

    @Resource
    private NebulaToolkitService nebulaToolkitService;

    @Resource
    private CustomerRetailerVoService customerRetailerVoService;

    /**
     * 数据分片
     *
     * @return 分片长度
     */
    @Override
    public Integer getBatchCount() {
        return 2000;
    }

    @Override
    public Map<Integer, String> execute(LinkedHashMap<Integer, SalesGoalVerticalImportsVo> data,
                                        TaskGlobalParamsVo paramsVo,
                                        Map<String, Object> params) {
        Map<Integer, String> errorMap = Maps.newHashMap();
        try {
            Validate.notEmpty(data, "导入数据不能为空！");

            Map<String, String> mdmBusinessFormatMap = new HashMap<>();
            Map<String, String> mdmBusinessUnitMap = new HashMap<>();
            Map<String, String> tpmYearSalesTypeMap = new HashMap<>();
            Map<String, String> tpmOldNewProductMap = new HashMap<>();
            Map<String, CustomerVo> customerVoMap = new HashMap<>();
            Map<String, TerminalVo> terminalVoMap = new HashMap<>();
            Map<String, ProductVo> productVoMap = new HashMap<>();
            Map<String, CustomerRetailerVo> customerRetailerVoMap = new HashMap<>();
            Map<String, ProductBrandVo> productBrandVoMap = new HashMap<>();

//            log.info("---------------------------->开始校验数据，开始时间<------------------------:" + DateUtil.format(new Date(), DateUtil.DEFAULT_DATE_ALL_PATTERN));
            List<SalesGoalDto> importList = this.validate(data,errorMap, mdmBusinessFormatMap, mdmBusinessUnitMap, tpmYearSalesTypeMap, tpmOldNewProductMap, customerVoMap, terminalVoMap, productVoMap, customerRetailerVoMap, productBrandVoMap);
//            log.info("---------------------------->开始校验数据，结束时间<------------------------:" + DateUtil.format(new Date(), DateUtil.DEFAULT_DATE_ALL_PATTERN));

//            log.info("---------------------------->开始保存数据，开始时间<------------------------:" + DateUtil.format(new Date(), DateUtil.DEFAULT_DATE_ALL_PATTERN));
            if (errorMap.size() == 0){
                salesGoalService.importSave(importList);
            }
//            log.info("---------------------------->开始保存数据，结束时间<------------------------:" + DateUtil.format(new Date(), DateUtil.DEFAULT_DATE_ALL_PATTERN));
        } catch (Exception e) {
            log.error(e.getMessage(),e);
            throw e;
        }
        return errorMap;
    }

    /**
     * 校验数据
     *
     * @param data
     * @param errorMap
     * @author huojia
     * @date 2022/10/28 14:04
     **/
    private List<SalesGoalDto> validate(LinkedHashMap<Integer, SalesGoalVerticalImportsVo> data,
                                        Map<Integer, String> errorMap, Map<String, String> mdmBusinessFormatMap,
                                        Map<String, String> mdmBusinessUnitMap,
                                        Map<String, String> tpmYearSalesTypeMap,
                                        Map<String, String> tpmOldNewProductMap,
                                        Map<String, CustomerVo> customerVoMap,
                                        Map<String, TerminalVo> terminalVoMap,
                                        Map<String, ProductVo> productVoMap,
                                        Map<String, CustomerRetailerVo> customerRetailerVoMap,
                                        Map<String, ProductBrandVo> productBrandVoMap) {
        List<SalesGoalVerticalImportsVo> salesGoalVerticalImportsVos = new ArrayList<>(data.values());

        // 构建基础数据map
        this.buildBaseMap(salesGoalVerticalImportsVos, mdmBusinessFormatMap, mdmBusinessUnitMap, tpmYearSalesTypeMap, tpmOldNewProductMap, customerVoMap, terminalVoMap, productVoMap, customerRetailerVoMap, productBrandVoMap);

        List<SalesGoalDto> list = Lists.newArrayList();
        for (Map.Entry<Integer, SalesGoalVerticalImportsVo> entry : data.entrySet()) {
            try {
                SalesGoalVerticalImportsVo importsVo = entry.getValue();
                // 数据验空
//                log.info("---------------------------->开始数据验空，开始时间<------------------------:" + DateUtil.format(new Date(), DateUtil.DEFAULT_DATE_ALL_PATTERN));
                this.validateNull(importsVo);
//                log.info("---------------------------->开始数据验空，结束时间<------------------------:" + DateUtil.format(new Date(), DateUtil.DEFAULT_DATE_ALL_PATTERN));

                // 校验基础数据
//                log.info("---------------------------->开始校验基础数据，开始时间<------------------------:" + DateUtil.format(new Date(), DateUtil.DEFAULT_DATE_ALL_PATTERN));
                this.buildBaseData(importsVo, mdmBusinessFormatMap, mdmBusinessUnitMap, tpmYearSalesTypeMap, tpmOldNewProductMap, customerVoMap, terminalVoMap, productVoMap, customerRetailerVoMap, productBrandVoMap);
//                log.info("---------------------------->开始校验基础数据，结束时间<------------------------:" + DateUtil.format(new Date(), DateUtil.DEFAULT_DATE_ALL_PATTERN));

                // 校验数字
//                log.info("---------------------------->开始校验数字，开始时间<------------------------:" + DateUtil.format(new Date(), DateUtil.DEFAULT_DATE_ALL_PATTERN));
                this.buildDecimal(importsVo);
//                log.info("---------------------------->开始校验数字，结束时间<------------------------:" + DateUtil.format(new Date(), DateUtil.DEFAULT_DATE_ALL_PATTERN));
                SalesGoalDto dto = nebulaToolkitService.copyObjectByWhiteList(importsVo, SalesGoalDto.class, HashSet.class, ArrayList.class);
                if (StringUtils.isNotEmpty(dto.getProductCode()) && productVoMap.containsKey(dto.getProductCode())){
                    //有产品的话把品牌品类品项带出来
                    ProductVo productVo = productVoMap.get(dto.getProductCode());
                    dto.setProductBrandCode(productVo.getProductBrandCode());
                    dto.setProductBrandName(productVo.getProductBrandName());
                    dto.setProductItemCode(productVo.getProductLevelCode());
                    dto.setProductItemName(productVo.getProductLevelName());
                    dto.setProductCategoryCode(productVo.getProductCategoryCode());
                    dto.setProductCategoryName(productVo.getProductCategoryName());
                }
                list.add(dto);
            }catch (Exception e){
                log.error(e.getMessage(),e);
                errorMap.put(entry.getKey(),null == e.getMessage() ? "数据处理异常" : e.getMessage());
            }
        }
        return list;
    }

    /**
     * 校验数据
     *
     * @param salesGoalVerticalImportsVos
     * @author huojia
     * @date 2022/10/28 14:04
     **/
    public List<SalesGoalDto> testClass(List<SalesGoalVerticalImportsVo> salesGoalVerticalImportsVos) {

        Map<String, String> mdmBusinessFormatMap = new HashMap<>();
        Map<String, String> mdmBusinessUnitMap = new HashMap<>();
        Map<String, String> tpmYearSalesTypeMap = new HashMap<>();
        Map<String, String> tpmOldNewProductMap = new HashMap<>();
        Map<String, CustomerVo> customerVoMap = new HashMap<>();
        Map<String, TerminalVo> terminalVoMap = new HashMap<>();
        Map<String, ProductVo> productVoMap = new HashMap<>();
        Map<String, CustomerRetailerVo> customerRetailerVoMap = new HashMap<>();
        Map<String, ProductBrandVo> productBrandVoMap = new HashMap<>();

        // 构建基础数据map
        this.buildBaseMap(salesGoalVerticalImportsVos, mdmBusinessFormatMap, mdmBusinessUnitMap, tpmYearSalesTypeMap, tpmOldNewProductMap, customerVoMap, terminalVoMap, productVoMap, customerRetailerVoMap, productBrandVoMap);

        salesGoalVerticalImportsVos.forEach(importsVo -> {

            // 数据验空
            this.validateNull(importsVo);

            // 校验基础数据
            this.buildBaseData(importsVo, mdmBusinessFormatMap, mdmBusinessUnitMap, tpmYearSalesTypeMap, tpmOldNewProductMap, customerVoMap, terminalVoMap, productVoMap, customerRetailerVoMap, productBrandVoMap);

            // 校验数字
            this.buildDecimal(importsVo);

        });
        Collection<SalesGoalDto> salesGoalDtoList = nebulaToolkitService.copyCollectionByWhiteList(salesGoalVerticalImportsVos, SalesGoalVerticalImportsVo.class, SalesGoalDto.class, LinkedHashSet.class, ArrayList.class);
        return new ArrayList<>(salesGoalDtoList);
    }

    /**
     * 数据验空
     *
     * @param importsVo
     * @author huojia
     * @date 2023/1/2 11:03
     **/
    private void validateNull(SalesGoalVerticalImportsVo importsVo) {
        if (StringUtils.isEmpty(importsVo.getBusinessFormatCode())) {
            throw new NullPointerException("业态不能为空！");
        }
        /*if (StringUtils.isEmpty(importsVo.getBusinessUnitCode())) {
            throw new NullPointerException("业务单元不能为空！");
        }
        if (StringUtils.isEmpty(importsVo.getBusinessFormatCode())) {
            throw new NullPointerException("年度销量分类不能为空！");
        }*/
    }

    /**
     * 校验数字
     *
     * @param importsVo
     * @author huojia
     * @date 2022/11/10 21:42
     **/
    private void buildDecimal(SalesGoalVerticalImportsVo importsVo) {
        // 出库量
        try {
            if (!StringUtils.isEmpty(importsVo.getDeliveryQuantityStr())) {
                importsVo.setDeliveryQuantity(new BigDecimal(importsVo.getDeliveryQuantityStr()));
            }
        } catch (Exception e) {
            throw new IllegalArgumentException("出库量" + importsVo.getDeliveryQuantityStr() + "格式错误，请检查！");
        }
        // 出库折前销售额
        try {
            if (!StringUtils.isEmpty(importsVo.getDeliverySalesAmountStr())) {
                importsVo.setDeliverySalesAmount(new BigDecimal(importsVo.getDeliverySalesAmountStr()));
            }
        } catch (Exception e) {
            throw new IllegalArgumentException("折前销售额" + importsVo.getDeliverySalesAmountStr() + "格式错误，请检查！");
        }
        // 出库折后销售额
        try {
            if (!StringUtils.isEmpty(importsVo.getDeliveryDiscountSalesAmountStr())) {
                importsVo.setDeliveryDiscountSalesAmount(new BigDecimal(importsVo.getDeliveryDiscountSalesAmountStr()));
            }
        } catch (Exception e) {
            throw new IllegalArgumentException("折后销售额" + importsVo.getDeliveryDiscountSalesAmountStr() + "格式错误，请检查！");
        }
    }

    /**
     * 校验基础数据
     *
     * @param importsVo
     * @author huojia
     * @date 2022/11/10 21:41
     **/
    private void buildBaseData(SalesGoalVerticalImportsVo importsVo,
                               Map<String, String> mdmBusinessFormatMap,
                               Map<String, String> mdmBusinessUnitMap,
                               Map<String, String> tpmYearSalesTypeMap,
                               Map<String, String> tpmOldNewProductMap,
                               Map<String, CustomerVo> customerVoMap,
                               Map<String, TerminalVo> terminalVoMap,
                               Map<String, ProductVo> productVoMap,
                               Map<String, CustomerRetailerVo> customerRetailerVoMap,
                               Map<String, ProductBrandVo> productBrandVoMap) {
        // 设置数据来源
        importsVo.setDataFromCode(DataFromEnum.IMPORT.getCode());
        // 业态
        if (!StringUtils.isEmpty(importsVo.getBusinessFormatCode())) {
            if (!mdmBusinessFormatMap.containsKey(importsVo.getBusinessFormatCode())) {
                throw new IllegalArgumentException("业态" + importsVo.getBusinessFormatCode() + "错误，请检查！");
            } else {
                importsVo.setBusinessFormatCode(mdmBusinessFormatMap.get(importsVo.getBusinessFormatCode()));
            }
        }
        // 业务单元
        if (!StringUtils.isEmpty(importsVo.getBusinessUnitCode())) {
            if (!mdmBusinessUnitMap.containsKey(importsVo.getBusinessUnitCode())) {
                throw new IllegalArgumentException("业务单元" + importsVo.getBusinessUnitCode() + "错误，请检查！");
            } else {
                importsVo.setBusinessUnitCode(mdmBusinessUnitMap.get(importsVo.getBusinessUnitCode()));
            }
        }
        // 年度销量分类
        if (!StringUtils.isEmpty(importsVo.getYearSalesTypeCode())) {
            if (!tpmYearSalesTypeMap.containsKey(importsVo.getYearSalesTypeCode())) {
                throw new IllegalArgumentException("年度销量分类" + importsVo.getYearSalesTypeCode() + "错误，请检查！");
            } else {
                importsVo.setYearSalesTypeCode(tpmYearSalesTypeMap.get(importsVo.getYearSalesTypeCode()));
            }
        }
        // 年月
        if (!StringUtils.isEmpty(importsVo.getYearMonthLy())) {
            try {
                DateUtil.parseDate(importsVo.getYearMonthLy(), DateUtil.DEFAULT_YEAR_MONTH);
            } catch (Exception ignored) {
                throw new IllegalArgumentException("年月" + importsVo.getYearMonthLy() + "格式错误，应该为" + DateUtil.DEFAULT_YEAR_MONTH);
            }
        }
        // 零售商
        if (!StringUtils.isEmpty(importsVo.getSystemCode())) {
            if (customerRetailerVoMap.containsKey(importsVo.getSystemCode())) {
                importsVo.setSystemName(customerRetailerVoMap.get(importsVo.getSystemCode()).getCustomerRetailerName());
            } else {
                throw new IllegalArgumentException("零售商编码" + importsVo.getSystemCode() + "错误，请检查！");
            }
        }
        // 客户
        if (!StringUtils.isEmpty(importsVo.getCustomerCode())) {
            if (customerVoMap.containsKey(importsVo.getCustomerCode())) {
                importsVo.setCustomerName(customerVoMap.get(importsVo.getCustomerCode()).getCustomerName());
            } else {
                throw new IllegalArgumentException("售达方编码" + importsVo.getCustomerCode() + "错误，请检查！");
            }
        }
        // 门店
        if (!StringUtils.isEmpty(importsVo.getTerminalCode())) {
            if (terminalVoMap.containsKey(importsVo.getTerminalCode())) {
                importsVo.setTerminalName(terminalVoMap.get(importsVo.getTerminalCode()).getTerminalName());
            } else {
                throw new IllegalArgumentException("送达方编码" + importsVo.getTerminalCode() + "错误，请检查！");
            }
        }
        // 产品品牌
        if (!StringUtils.isEmpty(importsVo.getProductBrandCode())) {
            if (productBrandVoMap.containsKey(importsVo.getProductBrandCode())) {
                importsVo.setProductBrandName(productBrandVoMap.get(importsVo.getProductBrandCode()).getProductBrandName());
            } else {
                throw new IllegalArgumentException("产品品牌" + importsVo.getProductBrandCode() + "错误，请检查！");
            }
        }
        // 产品
        if (!StringUtils.isEmpty(importsVo.getProductCode())) {
            if (productVoMap.containsKey(importsVo.getProductCode())) {
                importsVo.setProductName(productVoMap.get(importsVo.getProductCode()).getProductName());
            } else {
                throw new IllegalArgumentException("产品编码" + importsVo.getProductCode() + "错误，请检查！");
            }
        }
    }

    /**
     * 构建基础数据map
     *
     * @param salesGoalVerticalImportsVos
     * @author huojia
     * @date 2022/11/10 21:40
     **/
    private void buildBaseMap(List<SalesGoalVerticalImportsVo> salesGoalVerticalImportsVos,
                              Map<String, String> mdmBusinessFormatMap,
                              Map<String, String> mdmBusinessUnitMap,
                              Map<String, String> tpmYearSalesTypeMap,
                              Map<String, String> tpmOldNewProductMap,
                              Map<String, CustomerVo> customerVoMap,
                              Map<String, TerminalVo> terminalVoMap,
                              Map<String, ProductVo> productVoMap,
                              Map<String, CustomerRetailerVo> customerRetailerVoMap,
                              Map<String, ProductBrandVo> productBrandVoMap) {
        // 查询数据字典
        mdmBusinessFormatMap.putAll(dictToolkitService.findConvertMapByDictTypeCode(DictTypeCodeConstant.MDM_BUSINESS_FORMAT));
        mdmBusinessUnitMap.putAll(dictToolkitService.findConvertMapByDictTypeCode(DictTypeCodeConstant.MDM_BUSINESS_UNIT));
        tpmYearSalesTypeMap.putAll(dictToolkitService.findConvertMapByDictTypeCode(DictTypeCodeConstant.TPM_YEAR_SALES_TYPE));
        tpmOldNewProductMap.putAll(dictToolkitService.findConvertMapByDictTypeCode(DictTypeCodeConstant.TPM_OLD_NEW_PRODUCT));

        // 查询主数据数据，校验
        Set<String> systemCodeSet = salesGoalVerticalImportsVos.stream().map(SalesGoalVerticalImportsVo::getSystemCode).filter(Objects::nonNull).collect(Collectors.toSet());
        Set<String> customerCodeSet = salesGoalVerticalImportsVos.stream().map(SalesGoalVerticalImportsVo::getCustomerCode).filter(Objects::nonNull).collect(Collectors.toSet());
        Set<String> terminalCodeSet = salesGoalVerticalImportsVos.stream().map(SalesGoalVerticalImportsVo::getTerminalCode).filter(Objects::nonNull).collect(Collectors.toSet());
        Set<String> productBrandCodeSet = salesGoalVerticalImportsVos.stream().map(SalesGoalVerticalImportsVo::getProductBrandCode).filter(Objects::nonNull).collect(Collectors.toSet());
        Set<String> productCodeSet = salesGoalVerticalImportsVos.stream().map(SalesGoalVerticalImportsVo::getProductCode).filter(Objects::nonNull).collect(Collectors.toSet());

        // 客户
        if (!CollectionUtils.isEmpty(customerCodeSet)) {
            List<CustomerVo> customerVos = customerVoService.findBaseByCustomerCodes(new ArrayList<>(customerCodeSet));
            if (!CollectionUtils.isEmpty(customerVos)) {
                customerVoMap.putAll(customerVos.stream().collect(Collectors.toMap(CustomerVo::getCustomerCode, Function.identity())));
            }
        }

        // 终端
        if (!CollectionUtils.isEmpty(terminalCodeSet)) {
            List<TerminalVo> terminalVos = terminalVoService.findDetailsByIdsOrTerminalCodes(null, new ArrayList<>(terminalCodeSet));
            if (!CollectionUtils.isEmpty(terminalVos)) {
                terminalVoMap.putAll(terminalVos.stream().collect(Collectors.toMap(TerminalVo::getTerminalCode, Function.identity())));
            }
        }

        // 品牌
        if (!CollectionUtils.isEmpty(productBrandCodeSet)) {
            List<ProductBrandVo> productBrandVos = productBrandService.listByCodes(new ArrayList<>(productBrandCodeSet));
            if (!CollectionUtils.isEmpty(productBrandVos)) {
                productBrandVoMap.putAll(productBrandVos.stream().collect(Collectors.toMap(ProductBrandVo::getProductBrandCode, Function.identity())));
            }
        }

        // 产品
        if (!CollectionUtils.isEmpty(productCodeSet)) {
            List<ProductVo> productVoList = productVoService.findByCodes(new ArrayList<>(productCodeSet));
            ;
            if (!CollectionUtils.isEmpty(productVoList)) {
                productVoMap.putAll(productVoList.stream().collect(Collectors.toMap(ProductVo::getProductCode, Function.identity())));
            }
        }

        // 系统
        if (!CollectionUtils.isEmpty(systemCodeSet)) {
            List<CustomerRetailerVo> customerRetailerVos = customerRetailerVoService.findByCodes(new ArrayList<>(systemCodeSet));
            if (!CollectionUtils.isEmpty(customerRetailerVos)) {
                customerRetailerVoMap.putAll(customerRetailerVos.stream().collect(Collectors.toMap(CustomerRetailerVo::getCustomerRetailerCode, Function.identity())));
            }
        }
    }

    @Override
    public Class<SalesGoalVerticalImportsVo> findCrmExcelVoClass() {
        return SalesGoalVerticalImportsVo.class;
    }

    @Override
    public String getTemplateCode() {
        return "TPM_SALES_GOAL_VERTICAL_IMPORT";
    }

    @Override
    public String getTemplateName() {
        return "TPM垂直销售目标导入";
    }
}
