package com.biz.crm.tpm.business.sales.goal.local.xxjob;

import com.alibaba.fastjson.JSON;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.third.system.master.data.mdg.sdk.dto.MasterDataMdgBaseDto;
import com.biz.crm.tpm.business.sales.goal.sdk.constant.SalesGoalConstant;
import com.biz.crm.tpm.business.sales.goal.sdk.service.SalesGoalService;
import com.bizunited.nebula.task.annotations.DynamicTaskService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Calendar;
import java.util.Map;

/**
 * @author: chenlong
 * @date: 2023/2/24 11:12
 * @description: 主体销售任务和日销售数据拉去定时任务
 */
@Slf4j
@Service
public class PullSalesGoalXxJob {

    @Autowired(required = false)
    private SalesGoalService salesGoalService;
    @Autowired(required = false)
    private DictToolkitService dictToolkitService;
    @Autowired(required = false)
    private LoginUserService loginUserService;

    /**
     * 主体销售任务拉取定时任务,每月1号执行
     */
    @DynamicTaskService(cornExpression = "0 0 3 1 * ?", taskDesc = "主体销售任务拉取定时任务")
    public void pullSalesGoalXxJob() {

        log.info("=====>    主体销售任务拉去定时任务[{}] start    <=====", DateUtil.dateStrNowAll());
        //设置基础信息
        loginUserService.refreshAuthentication(null);
        AbstractCrmUserIdentity loginDetails = this.loginUserService.getAbstractLoginUser();
        //先获取拉取范围
        Map<String, String> map = dictToolkitService.findMapByDictTypeCode(SalesGoalConstant.DICT_SALES_GOAL_PULL_SALES_ORG);
        if (map.isEmpty()) {
            return;
        }
        log.info("=====>    主体销售任务拉去定时任务：拉取范围：[{}] <=====", JSON.toJSONString(map));
        for (String s : map.keySet()) {
            //拉去前五天的数据
            log.info("=====>    主体销售任务和拉去定时任务：拉取范围：[{}] 开始<=====", map.get(s));
            MasterDataMdgBaseDto dto = new MasterDataMdgBaseDto();
            dto.setFullPullFlag(BooleanEnum.TRUE.getCapital());
            dto.setSales_organization(s);
            dto.setPageNum("1");
            dto.setPageSize("2000");
            //获取当前的日期
            Calendar calendar = Calendar.getInstance();
            dto.setM_id(String.valueOf(calendar.get(Calendar.MONTH) + 1));
            dto.setY_id(String.valueOf(calendar.get(Calendar.YEAR)));
            salesGoalService.pullSalesDayReport(dto);
            log.info("=====>    主体销售任务拉去定时任务：拉取数据：日期{} 结束<=====", DateUtil.dateToStr(DateUtil.date_yyyy_MM_dd, calendar.getTime()));
            log.info("=====>    主体销售任务和日销售数据拉去定时任务：拉取范围：[{}] 结束<=====", map.get(s));
        }
        log.info("=====>    主体销售任务和日销售数据拉去定时任务[{}] end    <=====", DateUtil.dateStrNowAll());
    }
}
