/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.sales.goal.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.biz.crm.mn.third.system.master.data.mdg.sdk.dto.MasterDataMdgBaseDto;
import com.biz.crm.tpm.business.sales.goal.sdk.dto.SalesGoalDiscountSalesStatisticsDto;
import com.biz.crm.tpm.business.sales.goal.sdk.dto.SalesGoalDto;
import com.biz.crm.tpm.business.sales.goal.sdk.dto.SalesGoalStatisticsDto;
import com.biz.crm.tpm.business.sales.goal.sdk.service.SalesGoalService;
import com.biz.crm.tpm.business.sales.goal.sdk.vo.SalesGoalStatisticsVo;
import com.biz.crm.tpm.business.sales.goal.sdk.vo.SalesGoalVo;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/sales/goal"})
@Api(tags={"\u9500\u552e\u76ee\u6807"})
public class SalesGoalController {
    private static final Logger log = LoggerFactory.getLogger(SalesGoalController.class);
    @Autowired(required=false)
    private SalesGoalService salesGoalService;
    @Autowired(required=false)
    private RedisService redisService;
    @Autowired(required=false)
    private LoginUserService loginUserService;

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6240\u6709\u6570\u636e")
    @GetMapping(value={"findByConditions"})
    public Result<Page<SalesGoalVo>> findByConditions(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="salesGoalDto", value="\u9500\u552e\u76ee\u6807\u4fe1\u606f") SalesGoalDto dto) {
        try {
            Page page = this.salesGoalService.findByConditions(pageable, dto);
            return Result.ok((Object)page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u901a\u8fc7\u4e3b\u952e\u67e5\u8be2\u5355\u6761\u6570\u636e")
    @GetMapping(value={"detail"})
    public Result<SalesGoalVo> detail(@RequestParam(value="id") @ApiParam(name="id", value="\u4e3b\u952eid") String id) {
        try {
            SalesGoalVo salesGoalVo = this.salesGoalService.findById(id);
            return Result.ok((Object)salesGoalVo);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u4fee\u6539\u6570\u636e")
    @PatchMapping
    public Result<SalesGoalVo> update(@ApiParam(name="salesGoalDto", value="TPM-\u9500\u552e\u76ee\u6807") @RequestBody SalesGoalDto dto) {
        try {
            SalesGoalVo result = this.salesGoalService.update(dto);
            return Result.ok((Object)result);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @DeleteMapping
    @ApiOperation(value="\u5220\u9664\u6570\u636e")
    public Result<?> delete(@RequestParam(value="ids") List<String> ids) {
        try {
            this.salesGoalService.delete(ids);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6761\u4ef6\u67e5\u8be2")
    @PostMapping(value={"listByConditions"})
    public Result<List<SalesGoalVo>> listByConditions(@RequestBody SalesGoalDto dto) {
        try {
            List result = this.salesGoalService.listByConditions(dto);
            return Result.ok((Object)result);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5ba2\u6237+\u4ea7\u54c1+\u5e74\u6708,\u7edf\u8ba1\u6570\u636e\u7684\u5206\u5b50\u516c\u53f8\u51fa\u5e93\u91cf")
    @PostMapping(value={"outStockNumber"})
    public Result<BigDecimal> outStockNumber(@RequestBody SalesGoalDto dto) {
        try {
            BigDecimal result = this.salesGoalService.outStockNumber(dto);
            return Result.ok((Object)result);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5ba2\u6237+\u4ea7\u54c1+\u5e74\u6708,\u7edf\u8ba1\u7ecf\u9500\u5546\u8fdb\u8d27\u91cf")
    @PostMapping(value={"inStockNumber"})
    public Result<BigDecimal> inStockNumber(@RequestBody SalesGoalDto dto) {
        try {
            BigDecimal result = this.salesGoalService.inStockNumber(dto);
            return Result.ok((Object)result);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5ba2\u6237+\u4ea7\u54c1+\u5e74\u6708,\u7edf\u8ba1\u9500\u552e\u6570\u91cf")
    @PostMapping(value={"getSaleAmount"})
    public Result<BigDecimal> getSaleAmount(@RequestBody SalesGoalDto dto) {
        try {
            BigDecimal result = this.salesGoalService.getSaleAmount(dto);
            return Result.ok((Object)result);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5ba2\u6237+\u4ea7\u54c1+\u5e74\u6708,\u7edf\u8ba1\u4efb\u52a1\u91cf")
    @PostMapping(value={"getTaskAmount"})
    public Result<BigDecimal> getTaskAmount(@RequestBody SalesGoalDto dto) {
        try {
            BigDecimal result = this.salesGoalService.getTaskAmount(dto);
            return Result.ok((Object)result);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6240\u6709\u6570\u636e")
    @GetMapping(value={"statistics/findByConditions"})
    public Result<Page<SalesGoalStatisticsVo>> findByConditions(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="salesGoalDto", value="\u9500\u552e\u76ee\u6807\u4fe1\u606f") SalesGoalStatisticsDto dto) {
        try {
            Page page = this.salesGoalService.findByConditions(pageable, dto);
            return Result.ok((Object)page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u6309\u533a\u57df\u5206\u7ec4\u7684\u6570\u636e")
    @PostMapping(value={"findListGroupByRegion"})
    public Result<List<SalesGoalVo>> findListGroupByRegion(@ApiParam(name="salesGoalDto", value="\u9500\u552e\u76ee\u6807\u4fe1\u606f") SalesGoalDto dto) {
        try {
            List result = this.salesGoalService.findListGroupByRegion(dto);
            return Result.ok((Object)result);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5bfc\u5165\u6d4b\u8bd5")
    @PostMapping(value={"importTest"})
    public Result<?> importTest(@RequestBody @ApiParam(name="importsVos", value="\u9500\u552e\u76ee\u6807\u5bfc\u5165\u4fe1\u606f") List<SalesGoalDto> importsVos) {
        try {
            this.salesGoalService.importSave(importsVos);
            return Result.ok((String)"\u5bfc\u5165\u6210\u529f");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u62c9\u53d6\u65e5\u9500\u552e\u65e5\u62a5\u6570\u636e")
    @PostMapping(value={"pullSalesDayReport"})
    public Result<?> pullSalesDayReport(@RequestBody MasterDataMdgBaseDto dto) {
        try {
            String lockKey = this.salesGoalService.getLockKey(dto);
            if (this.redisService.hasKey(lockKey).booleanValue()) {
                return Result.error((String)("\u6570\u636e[" + lockKey.replace("sales_goal_lock:lock:", "") + "]\u8fd8\u5728\u62c9\u53d6\u4e2d,\u8bf7\u7a0d\u540e\u518d\u8bd5!"));
            }
            UserIdentity userIdentity = this.loginUserService.getLoginUser();
            this.salesGoalService.pullSalesDayReportAsync(dto, userIdentity);
            return Result.ok((String)"\u6570\u636e\u5f02\u6b65\u62c9\u53d6\u4e2d");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @PostMapping(value={"findSalesGoal"})
    public Result<?> findSalesGoal(@RequestBody SalesGoalDto salesGoal) {
        try {
            List list = this.salesGoalService.findSalesGoal(salesGoal);
            return Result.ok((Object)list);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6307\u6807\u8ba1\u7b97\u67e5\u8be2")
    @GetMapping(value={"listForVariableCal"})
    public Result<List<SalesGoalVo>> listForVariableCal(@ApiParam(name="salesGoalDto", value="\u9500\u552e\u76ee\u6807\u4fe1\u606f") SalesGoalDto dto) {
        try {
            return Result.ok((Object)this.salesGoalService.listForVariableCal(dto));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u83b7\u53d6\u6c47\u603b\u91d1\u989d")
    @PostMapping(value={"getSalesGoalAmount"})
    public Result<BigDecimal> getSalesGoalAmount(@RequestBody SalesGoalDto salesGoal) {
        try {
            return Result.ok((Object)this.salesGoalService.getSalesGoalAmount(salesGoal));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u4e1a\u6001\uff0c\u4e1a\u52a1\u5355\u5143\uff0c\u5206\u7ec4\uff0c\u5e74\u6708\uff0c\u7edf\u8ba1\u6298\u524d\u9500\u91cf\uff0c\u6309\u7167\u96f6\u552e\u5546+\u533a\u57df\u5206\u7ec4\uff0c-\u9694\u5f00")
    @PostMapping(value={"getSalesBeforeDiscount"})
    public Result<Map<String, BigDecimal>> getSalesBeforeDiscount(@RequestBody SalesGoalDiscountSalesStatisticsDto dto) {
        try {
            Map map = this.salesGoalService.getSalesBeforeDiscount(dto);
            return Result.ok((Object)map);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u4e1a\u6001\uff0c\u4e1a\u52a1\u5355\u5143\uff0c\u5206\u7ec4\uff0c\u5e74\u6708\uff0c\u7edf\u8ba1\u6298\u540e\u9500\u91cf\uff0c\u6309\u7167\u96f6\u552e\u5546+\u533a\u57df\u5206\u7ec4\uff0c-\u9694\u5f00")
    @PostMapping(value={"getSalesAfterDiscount"})
    public Result<Map<String, BigDecimal>> getSalesAfterDiscount(@RequestBody SalesGoalDiscountSalesStatisticsDto dto) {
        try {
            Map map = this.salesGoalService.getSalesAfterDiscount(dto);
            return Result.ok((Object)map);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

