/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.sales.goal.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.tpm.business.sales.goal.local.service.SalesPerformanceService;
import com.biz.crm.tpm.business.sales.goal.sdk.dto.SalesPerformanceDto;
import com.biz.crm.tpm.business.sales.goal.sdk.task.PullSalesPerformanceTask;
import com.biz.crm.tpm.business.sales.goal.sdk.vo.SalesDatePeriodSummaryVo;
import com.biz.crm.tpm.business.sales.goal.sdk.vo.SalesPerformanceVo;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/sales/salesPerformance"})
@Api(tags={"\u5782\u76f4\u9500\u552e\u4e1a\u7ee9"})
public class SalesPerformanceController {
    private static final Logger log = LoggerFactory.getLogger(SalesPerformanceController.class);
    @Autowired(required=false)
    private SalesPerformanceService salesPerformanceService;
    @Autowired(required=false)
    private PullSalesPerformanceTask pullSalesPerformanceTask;
    @Autowired(required=false)
    private LoginUserService loginUserService;

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6240\u6709\u6570\u636e")
    @GetMapping(value={"findByConditions"})
    public Result<Page<SalesPerformanceVo>> findByConditions(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="salesGoalDto", value="\u9500\u552e\u76ee\u6807\u4fe1\u606f") SalesPerformanceDto dto) {
        try {
            Page<SalesPerformanceVo> page = this.salesPerformanceService.findByConditions(pageable, dto);
            return Result.ok(page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u624b\u52a8\u62c9\u53d6\u6570\u636e")
    @GetMapping(value={"timedTaskPullDay"})
    public Result timedTaskPullDay() {
        try {
            AbstractCrmUserIdentity loginUser = this.loginUserService.getAbstractLoginUser();
            CompletableFuture.runAsync(() -> this.lambda$timedTaskPullDay$0((UserIdentity)loginUser));
            return Result.ok((String)"\u5f02\u6b65\u62c9\u53d6\u6570\u636e\u4e2d\uff0c\u8bf7\u7b49\u5f85");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6240\u6709\u6570\u636e")
    @GetMapping(value={"findSummaryByConditions"})
    public Result<List<SalesDatePeriodSummaryVo>> findSummaryByConditions(@ApiParam(name="salesGoalDto", value="\u9500\u552e\u76ee\u6807\u4fe1\u606f") SalesPerformanceDto dto, @ApiParam(name="cacheKey", value="\u7f13\u5b58key(UUID+\u4e1a\u52a1\u5355\u5143\u7f16\u7801)") @RequestParam String cacheKey) {
        try {
            List<SalesDatePeriodSummaryVo> list = this.salesPerformanceService.findSummaryByConditions(dto, cacheKey);
            return Result.ok(list);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u624b\u52a8\u62c9\u53d6\u67d0\u4e00\u5929\u6570\u636e")
    @PostMapping(value={"pullDayData"})
    public Result pullDayData(@RequestParam @ApiParam(name="ds", value="ds(yyyyMMdd \u4f8b\uff1a20230206)") String ds) {
        try {
            AbstractCrmUserIdentity loginUser = this.loginUserService.getAbstractLoginUser();
            CompletableFuture.runAsync(() -> this.lambda$pullDayData$1((UserIdentity)loginUser, ds));
            return Result.ok((String)"\u5f02\u6b65\u62c9\u53d6\u6570\u636e\u4e2d\uff0c\u8bf7\u7b49\u5f85");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    private /* synthetic */ void lambda$pullDayData$1(UserIdentity loginUser, String ds) {
        this.loginUserService.refreshAuthentication((Object)loginUser);
        this.pullSalesPerformanceTask.pullDayData(ds);
    }

    private /* synthetic */ void lambda$timedTaskPullDay$0(UserIdentity loginUser) {
        this.loginUserService.refreshAuthentication((Object)loginUser);
        this.pullSalesPerformanceTask.timedTaskPullDay();
    }
}

