/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.sales.goal.local.exports;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.mn.common.base.constant.CommonConstant;
import com.biz.crm.tpm.business.sales.goal.local.service.SalesPerformanceService;
import com.biz.crm.tpm.business.sales.goal.sdk.dto.SalesPerformanceDto;
import com.biz.crm.tpm.business.sales.goal.sdk.vo.SalesPerformanceExportVo;
import com.biz.crm.tpm.business.sales.goal.sdk.vo.SalesPerformanceVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class SalesPerformanceExportsProcess
implements ExportProcess<SalesPerformanceExportVo> {
    @Autowired(required=false)
    private SalesPerformanceService salesPerformanceService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    public Integer getPageSize() {
        return CommonConstant.IE_EXPORT_PAGE_SIZE;
    }

    public Integer getTotal(Map<String, Object> params) {
        SalesPerformanceDto dto = this.convertParams(params);
        Page<SalesPerformanceVo> pageResult = this.salesPerformanceService.findByConditions((Pageable)PageRequest.of((int)0, (int)1), dto);
        Integer total = (int)pageResult.getTotal();
        Validate.isTrue((total < CommonConstant.IE_EXPORT_MAX_TOTAL ? 1 : 0) != 0, (String)("\u5bfc\u51fa\u65f6\uff0c\u5355\u6b21\u6700\u5927\u5bfc\u51fa[" + CommonConstant.IE_EXPORT_MAX_TOTAL + "]\u6761,\u8bf7\u8f93\u5165\u66f4\u591a\u67e5\u8be2\u6761\u4ef6!!"), (Object[])new Object[0]);
        return total;
    }

    private SalesPerformanceDto convertParams(Map<String, Object> params) {
        return (SalesPerformanceDto)JSON.parseObject((String)JSON.toJSONString(params), SalesPerformanceDto.class);
    }

    public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
        SalesPerformanceDto dto = this.convertParams(params);
        Page<SalesPerformanceVo> page = this.salesPerformanceService.findByConditions((Pageable)PageRequest.of((int)(vo.getPageNo() + 1), (int)this.getPageSize()), dto);
        return JSON.parseArray((String)JSON.toJSONString(this.adjustData(page.getRecords())));
    }

    public Class<SalesPerformanceExportVo> findCrmExcelVoClass() {
        return SalesPerformanceExportVo.class;
    }

    public String getBusinessCode() {
        return "TPM_SALES_PERFORMANCE_EXPORT";
    }

    public String getBusinessName() {
        return "\u5782\u76f4\u9500\u552e\u4e1a\u7ee9\u5bfc\u51fa";
    }

    private List<SalesPerformanceExportVo> adjustData(List<SalesPerformanceVo> data) {
        if (CollectionUtils.isEmpty(data)) {
            return new ArrayList<SalesPerformanceExportVo>(0);
        }
        Collection list = this.nebulaToolkitService.copyCollectionByWhiteList(data, SalesPerformanceVo.class, SalesPerformanceExportVo.class, HashSet.class, ArrayList.class, new String[0]);
        return (List)list;
    }
}

