/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.sales.goal.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mn.third.system.master.data.mdg.sdk.dto.MasterDataMdgBaseDto;
import com.biz.crm.tpm.business.sales.goal.local.entity.SalesGoalEntity;
import com.biz.crm.tpm.business.sales.goal.local.mapper.SalesGoalMapper;
import com.biz.crm.tpm.business.sales.goal.sdk.dto.SalesGoalDiscountSalesStatisticsDto;
import com.biz.crm.tpm.business.sales.goal.sdk.dto.SalesGoalDto;
import com.biz.crm.tpm.business.sales.goal.sdk.vo.SalesGoalSumVo;
import com.biz.crm.tpm.business.sales.goal.sdk.vo.SalesGoalVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class SalesGoalRepository
extends ServiceImpl<SalesGoalMapper, SalesGoalEntity> {
    @Resource
    private SalesGoalMapper salesGoalMapper;

    public SalesGoalEntity getById(String id, String delFlag) {
        if (StringUtils.isEmpty((CharSequence)id)) {
            return null;
        }
        return (SalesGoalEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidEntity::getId, (Object)id)).eq(StringUtils.isNotEmpty((CharSequence)delFlag), UuidFlagOpEntity::getDelFlag, (Object)delFlag)).one());
    }

    public List<SalesGoalEntity> listByConditions(SalesGoalDto salesGoalDto) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(SalesGoalEntity::getBusinessFormatCode, (Object)salesGoalDto.getBusinessFormatCode())).eq(SalesGoalEntity::getBusinessUnitCode, (Object)salesGoalDto.getBusinessUnitCode())).eq(SalesGoalEntity::getSalesOrgCode, (Object)salesGoalDto.getSalesOrgCode())).notIn(!CollectionUtils.isEmpty((Collection)salesGoalDto.getExcludeCustomerCodeList()), SalesGoalEntity::getCustomerCode, (Collection)salesGoalDto.getExcludeCustomerCodeList())).notIn(!CollectionUtils.isEmpty((Collection)salesGoalDto.getExcludeTerminalCodeList()), SalesGoalEntity::getTerminalCode, (Collection)salesGoalDto.getExcludeCustomerCodeList())).notIn(!CollectionUtils.isEmpty((Collection)salesGoalDto.getExcludeProductCodeList()), SalesGoalEntity::getProductCode, (Collection)salesGoalDto.getExcludeProductCodeList())).list();
    }

    public BigDecimal outStockNumber(SalesGoalDto salesGoalDto) {
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(SalesGoalEntity::getCustomerCode, (Object)salesGoalDto.getCustomerCode())).eq(SalesGoalEntity::getProductCode, (Object)salesGoalDto.getProductCode())).eq(SalesGoalEntity::getYearMonthLy, (Object)salesGoalDto.getYearMonthLy())).list();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return BigDecimal.ZERO;
        }
        return list.stream().map(SalesGoalEntity::getDeliveryQuantity).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
    }

    public BigDecimal inStockNumber(SalesGoalDto salesGoalDto) {
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(SalesGoalEntity::getCustomerCode, (Object)salesGoalDto.getCustomerCode())).eq(SalesGoalEntity::getProductCode, (Object)salesGoalDto.getProductCode())).eq(SalesGoalEntity::getYearMonthLy, (Object)salesGoalDto.getYearMonthLy())).list();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return BigDecimal.ZERO;
        }
        return list.stream().map(SalesGoalEntity::getDeliveryQuantity).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
    }

    public BigDecimal getSaleAmount(SalesGoalDto salesGoalDto) {
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(SalesGoalEntity::getCustomerCode, (Object)salesGoalDto.getCustomerCode())).eq(SalesGoalEntity::getProductCode, (Object)salesGoalDto.getProductCode())).eq(SalesGoalEntity::getYearMonthLy, (Object)salesGoalDto.getYearMonthLy())).list();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return BigDecimal.ZERO;
        }
        return list.stream().map(SalesGoalEntity::getDeliveryQuantity).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
    }

    public BigDecimal getTaskAmount(SalesGoalDto salesGoalDto) {
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(SalesGoalEntity::getCustomerCode, (Object)salesGoalDto.getCustomerCode())).eq(SalesGoalEntity::getProductCode, (Object)salesGoalDto.getProductCode())).eq(SalesGoalEntity::getYearMonthLy, (Object)salesGoalDto.getYearMonthLy())).list();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return BigDecimal.ZERO;
        }
        return list.stream().map(SalesGoalEntity::getTaskQuantity).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
    }

    public List<SalesGoalEntity> listByCalendar(String calendarDay) {
        if (StringUtils.isEmpty((CharSequence)calendarDay)) {
            return null;
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().like(SalesGoalEntity::getCalendarDay, (Object)calendarDay)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).list();
    }

    public void delByCalendar(String calender, MasterDataMdgBaseDto dto) {
        this.salesGoalMapper.delByCalendar(calender, dto);
    }

    public void importSaveBatch(List<SalesGoalEntity> salesGoalEntities) {
        this.salesGoalMapper.importSaveBatch(salesGoalEntities);
    }

    public List<SalesGoalEntity> getSalesGoalByKeys(List<String> onlyKeys, String tenantCode) {
        if (CollectionUtils.isEmpty(onlyKeys) || StringUtils.isBlank((CharSequence)tenantCode)) {
            return Lists.newArrayList();
        }
        List codes = Lists.partition(onlyKeys, (int)500);
        return this.salesGoalMapper.getSalesGoalByKeys(codes, tenantCode);
    }

    public List<SalesGoalVo> getSalesBeforeDiscount(SalesGoalDiscountSalesStatisticsDto dto) {
        if (StringUtils.isBlank((CharSequence)dto.getBusinessFormatCode())) {
            return new ArrayList<SalesGoalVo>();
        }
        if (StringUtils.isBlank((CharSequence)dto.getBusinessUnitCode())) {
            return new ArrayList<SalesGoalVo>();
        }
        if (StringUtils.isBlank((CharSequence)dto.getYearSalesTypeCode())) {
            return new ArrayList<SalesGoalVo>();
        }
        if (Objects.isNull(dto.getYearMonth())) {
            return new ArrayList<SalesGoalVo>();
        }
        return this.salesGoalMapper.getSalesBeforeDiscount(dto);
    }

    public List<SalesGoalVo> restoreReplaySalesAfterDiscount(SalesGoalDto dto) {
        dto.setTenantCode(TenantUtils.getTenantCode());
        return this.salesGoalMapper.restoreReplaySalesAfterDiscount(dto);
    }

    public List<SalesGoalVo> getSalesAfterDiscount(SalesGoalDiscountSalesStatisticsDto dto) {
        if (StringUtils.isBlank((CharSequence)dto.getBusinessFormatCode())) {
            return new ArrayList<SalesGoalVo>();
        }
        if (StringUtils.isBlank((CharSequence)dto.getBusinessUnitCode())) {
            return new ArrayList<SalesGoalVo>();
        }
        if (StringUtils.isBlank((CharSequence)dto.getYearSalesTypeCode())) {
            return new ArrayList<SalesGoalVo>();
        }
        if (Objects.isNull(dto.getYearMonth())) {
            return new ArrayList<SalesGoalVo>();
        }
        return this.salesGoalMapper.getSalesAfterDiscount(dto);
    }

    public SalesGoalSumVo findDiscountAfterAndDeliveryQuantity(SalesGoalDto salesGoalDto) {
        return this.salesGoalMapper.findDiscountAfterAndDeliveryQuantity(salesGoalDto);
    }

    public BigDecimal findDiscountAfter(SalesGoalDto salesGoalDto) {
        return this.salesGoalMapper.findDiscountAfter(salesGoalDto);
    }

    public List<SalesGoalVo> findListForFR(List<SalesGoalDto> salesGoalDtos) {
        return this.salesGoalMapper.findListForFR(salesGoalDtos);
    }
}

