/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.sales.goal.local.service.internal;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.tpm.business.sales.goal.local.entity.SalesGoalEntity;
import com.biz.crm.tpm.business.sales.goal.local.repository.SalesGoalRepository;
import com.biz.crm.tpm.business.sales.goal.local.service.SalesGoaEditService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SalesGoaEditServiceImpl
implements SalesGoaEditService {
    private static final Logger log = LoggerFactory.getLogger(SalesGoaEditServiceImpl.class);
    @Autowired(required=false)
    private SalesGoalRepository salesGoalRepository;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void editBatch(List<SalesGoalEntity> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        ArrayList<String> onlyKeys = new ArrayList<String>();
        for (SalesGoalEntity entity : list) {
            String onlyKey = entity.getBusinessFormatCode() + entity.getBusinessUnitCode() + entity.getYearMonthLy() + entity.getYearSalesTypeCode() + entity.getSalesInstitutionErpCode() + entity.getSalesOrgRegionErpCode() + entity.getSalesOrgProvinceErpCode() + entity.getCustomerCode() + entity.getCustomerType() + entity.getProductCode();
            entity.setOnlyKey(onlyKey);
            onlyKeys.add(onlyKey);
        }
        List<SalesGoalEntity> oldList = this.salesGoalRepository.getSalesGoalByKeys(onlyKeys, TenantUtils.getTenantCode());
        Map<Object, Object> oldMap = new HashMap();
        if (!CollectionUtils.isEmpty(oldList)) {
            oldMap = oldList.stream().collect(Collectors.toMap(SalesGoalEntity::getOnlyKey, UuidEntity::getId));
        }
        ArrayList<SalesGoalEntity> editList = new ArrayList<SalesGoalEntity>();
        ArrayList<SalesGoalEntity> addList = new ArrayList<SalesGoalEntity>();
        for (SalesGoalEntity entity : list) {
            entity.setTenantCode(TenantUtils.getTenantCode());
            if (oldMap.containsKey(entity.getOnlyKey())) {
                entity.setId((String)oldMap.get(entity.getOnlyKey()));
                editList.add(entity);
                continue;
            }
            addList.add(entity);
        }
        if (!CollectionUtils.isEmpty(editList)) {
            this.salesGoalRepository.updateBatchById(editList);
        }
        if (!CollectionUtils.isEmpty(addList)) {
            this.salesGoalRepository.saveBatch(addList);
        }
    }
}

