/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.sales.goal.local.service.internal;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.eunm.DataFromEnum;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.third.system.master.data.mdg.sdk.dto.MasterDataMdgBaseDto;
import com.biz.crm.mn.third.system.master.data.mdg.sdk.service.MasterDataMdgService;
import com.biz.crm.mn.third.system.master.data.mdg.sdk.vo.MasterDataMdgSalesDayReportVo;
import com.biz.crm.tpm.business.sales.goal.local.entity.SalesGoalEntity;
import com.biz.crm.tpm.business.sales.goal.local.mapper.SalesGoalMapper;
import com.biz.crm.tpm.business.sales.goal.local.repository.SalesGoalRepository;
import com.biz.crm.tpm.business.sales.goal.local.service.SalesGoaEditService;
import com.biz.crm.tpm.business.sales.goal.sdk.dto.MainOneDaySalesDto;
import com.biz.crm.tpm.business.sales.goal.sdk.dto.SalesGoalDiscountSalesStatisticsDto;
import com.biz.crm.tpm.business.sales.goal.sdk.dto.SalesGoalDto;
import com.biz.crm.tpm.business.sales.goal.sdk.dto.SalesGoalLogEventDto;
import com.biz.crm.tpm.business.sales.goal.sdk.dto.SalesGoalStatisticsDto;
import com.biz.crm.tpm.business.sales.goal.sdk.eunm.YearSalesTypeEnum;
import com.biz.crm.tpm.business.sales.goal.sdk.event.SalesGoalForMainOneDaySalesListener;
import com.biz.crm.tpm.business.sales.goal.sdk.event.SalesGoalLogEventListener;
import com.biz.crm.tpm.business.sales.goal.sdk.service.SalesGoalService;
import com.biz.crm.tpm.business.sales.goal.sdk.vo.SalesGoalStatisticsVo;
import com.biz.crm.tpm.business.sales.goal.sdk.vo.SalesGoalSumVo;
import com.biz.crm.tpm.business.sales.goal.sdk.vo.SalesGoalVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class SalesGoalServiceImpl
implements SalesGoalService {
    private static final Logger log = LoggerFactory.getLogger(SalesGoalServiceImpl.class);
    @Autowired(required=false)
    private SalesGoalMapper salesGoalMapper;
    @Autowired(required=false)
    private RedisLockService redisLockService;
    @Autowired(required=false)
    private SalesGoalRepository salesGoalRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired(required=false)
    private MasterDataMdgService masterDataMdgService;
    @Autowired(required=false)
    private List<SalesGoalForMainOneDaySalesListener> salesGoalForMainOneDaySalesListeners;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private SalesGoaEditService salesGoaEditService;
    @Autowired(required=false)
    private ProductVoService productVoService;
    @Autowired(required=false)
    private SalesOrgVoService salesOrgVoService;

    public Page<SalesGoalVo> findByConditions(Pageable pageable, SalesGoalDto dto) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        if (Objects.isNull(dto)) {
            dto = new SalesGoalDto();
        }
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.salesGoalMapper.findByConditions((Page<SalesGoalVo>)page, dto);
    }

    public SalesGoalVo findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        SalesGoalEntity salesGoalEntity = this.salesGoalRepository.getById(id, DelFlagStatusEnum.NORMAL.getCode());
        Validate.notNull((Object)((Object)salesGoalEntity), (String)"\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01", (Object[])new Object[0]);
        return (SalesGoalVo)this.nebulaToolkitService.copyObjectByBlankList((Object)salesGoalEntity, SalesGoalVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
    }

    @Transactional(rollbackFor={Exception.class})
    public SalesGoalVo update(SalesGoalDto dto) {
        this.updateValidate(dto);
        SalesGoalVo salesGoalVo = this.findById(dto.getId());
        if (ObjectUtils.isEmpty((Object)salesGoalVo)) {
            throw new RuntimeException("\u4fee\u6539\u6570\u636e\u5931\u8d25\uff0c\u539f\u6570\u636e\u4e0d\u5b58\u5728\uff01");
        }
        SalesGoalDto oldVo = (SalesGoalDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)salesGoalVo, SalesGoalDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        SalesGoalEntity salesGoalEntity = (SalesGoalEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, SalesGoalEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        this.salesGoalRepository.saveOrUpdate((Object)salesGoalEntity);
        SalesGoalLogEventDto logEventDto = new SalesGoalLogEventDto();
        logEventDto.setOriginal(oldVo);
        logEventDto.setNewest(dto);
        SerializableBiConsumer & Serializable onUpdate = SalesGoalLogEventListener::onUpdate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, SalesGoalLogEventListener.class, (SerializableBiConsumer)onUpdate);
        return (SalesGoalVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, SalesGoalVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
    }

    private void updateValidate(SalesGoalDto dto) {
        if (StringUtils.isEmpty((CharSequence)dto.getTenantCode())) {
            dto.setTenantCode(TenantUtils.getTenantCode());
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void delete(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new RuntimeException("\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u6570\u636e\uff01");
        }
        List salesGoalEntities = this.salesGoalRepository.listByIds(ids);
        if (!CollectionUtils.isEmpty((Collection)salesGoalEntities)) {
            salesGoalEntities.forEach(salesGoalEntity -> {
                Validate.isTrue((!DataFromEnum.FOREIGN_SYSTEM.getCode().equals(salesGoalEntity.getDataFromCode()) ? 1 : 0) != 0, (String)"\u901a\u8fc7\u7cfb\u7edf\u63a5\u53e3\u540c\u6b65\u8fc7\u6765\u7684\u6570\u636e\u4e0d\u652f\u6301\u5220\u9664\uff01", (Object[])new Object[0]);
                salesGoalEntity.setDelFlag(DelFlagStatusEnum.DELETE.getCode());
            });
            this.salesGoalRepository.updateBatchById(salesGoalEntities);
        }
        salesGoalEntities.forEach(salesGoalEntity -> {
            SalesGoalLogEventDto logEventDto = new SalesGoalLogEventDto();
            logEventDto.setOriginal((SalesGoalDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)salesGoalEntity, SalesGoalDto.class, LinkedHashSet.class, ArrayList.class, new String[0]));
            logEventDto.setNewest(null);
            SerializableBiConsumer & Serializable onDelete = SalesGoalLogEventListener::onDelete;
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, SalesGoalLogEventListener.class, (SerializableBiConsumer)onDelete);
        });
    }

    @Transactional(rollbackFor={Exception.class})
    public void importSave(List<SalesGoalDto> importList) {
        if (CollectionUtils.isEmpty(importList)) {
            return;
        }
        importList.forEach(dto -> {
            dto.setId(UUID.randomUUID().toString().replace("-", ""));
            dto.setTenantCode(TenantUtils.getTenantCode());
            dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            dto.setDataFromCode(DataFromEnum.IMPORT.getCode());
        });
        List salesGoalEntities = (List)this.nebulaToolkitService.copyCollectionByWhiteList(importList, SalesGoalDto.class, SalesGoalEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        this.salesGoalRepository.importSaveBatch(salesGoalEntities);
        importList.forEach(dto -> {
            SalesGoalLogEventDto logEventDto = new SalesGoalLogEventDto();
            logEventDto.setOriginal(null);
            logEventDto.setNewest(dto);
            SerializableBiConsumer & Serializable onCreate = SalesGoalLogEventListener::onCreate;
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, SalesGoalLogEventListener.class, (SerializableBiConsumer)onCreate);
        });
    }

    public List<SalesGoalVo> listByConditions(SalesGoalDto salesGoalDto) {
        List<SalesGoalEntity> salesGoalEntities = this.salesGoalMapper.listByConditions(salesGoalDto);
        if (CollectionUtils.isEmpty(salesGoalEntities)) {
            return Lists.newArrayList();
        }
        return new ArrayList<SalesGoalVo>(this.nebulaToolkitService.copyCollectionByWhiteList(salesGoalEntities, SalesGoalEntity.class, SalesGoalVo.class, LinkedHashSet.class, ArrayList.class, new String[0]));
    }

    public BigDecimal getSalesGoalAmount(SalesGoalDto salesGoal) {
        return this.salesGoalMapper.getSalesGoalAmount(salesGoal);
    }

    public BigDecimal outStockNumber(SalesGoalDto salesGoalDto) {
        return this.salesGoalRepository.outStockNumber(salesGoalDto);
    }

    public BigDecimal inStockNumber(SalesGoalDto salesGoalDto) {
        return this.salesGoalRepository.inStockNumber(salesGoalDto);
    }

    public BigDecimal getSaleAmount(SalesGoalDto salesGoalDto) {
        return this.salesGoalRepository.getSaleAmount(salesGoalDto);
    }

    public BigDecimal getTaskAmount(SalesGoalDto salesGoalDto) {
        return this.salesGoalRepository.getTaskAmount(salesGoalDto);
    }

    public Page<SalesGoalStatisticsVo> findByConditions(Pageable pageable, SalesGoalStatisticsDto dto) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        if (Objects.isNull(dto)) {
            dto = new SalesGoalStatisticsDto();
        }
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.salesGoalMapper.listTaskQuantityPage((Page<SalesGoalStatisticsVo>)page, dto);
    }

    public List<SalesGoalVo> findListGroupByRegion(SalesGoalDto dto) {
        return this.salesGoalMapper.findListGroupByRegion(dto);
    }

    @Async
    public void pullSalesDayReportAsync(MasterDataMdgBaseDto dto, UserIdentity userIdentity) {
        this.loginUserService.refreshAuthentication((Object)userIdentity);
        this.pullSalesDayReport(dto);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pullSalesDayReport(MasterDataMdgBaseDto dto) {
        Validate.notBlank((CharSequence)dto.getSales_organization(), (String)"\u9500\u552e\u673a\u6784erp\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getY_id(), (String)"\u5e74[y_id]\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getM_id(), (String)"\u6708[m_id]\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getSales_organization(), (String)"\u9500\u552e\u673a\u6784erp\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (ObjectUtils.isEmpty((Object)dto)) {
            dto = new MasterDataMdgBaseDto();
        }
        if (StringUtils.isEmpty((CharSequence)dto.getPageNum())) {
            dto.setPageNum("1");
        }
        if (StringUtils.isEmpty((CharSequence)dto.getPageSize())) {
            dto.setPageSize("2000");
        }
        String lockKey = this.getLockKey(dto);
        boolean lock = true;
        try {
            lock = this.lock(lockKey);
            if (!lock) {
                return;
            }
            int maxPage = 0;
            maxPage = BooleanEnum.TRUE.getCapital().equals(dto.getFullPullFlag()) ? this.countPageMax(dto) : 1000;
            ArrayList<MasterDataMdgSalesDayReportVo> masterDataMdgSalesDayReportVos = new ArrayList();
            if (StringUtils.isBlank((CharSequence)dto.getD_id())) {
                LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(SalesGoalEntity::getBusinessUnitCode, (Object)BusinessUnitEnum.HEADQUARTERS.getCode())).eq(SalesGoalEntity::getSalesInstitutionErpCode, (Object)dto.getSales_organization())).eq(SalesGoalEntity::getYearMonthLy, (Object)(dto.getY_id() + "-" + dto.getM_id()));
                this.salesGoalRepository.remove((Wrapper)wrapper);
            }
            for (int pageNum = Integer.parseInt(dto.getPageNum()); pageNum <= maxPage; ++pageNum) {
                dto.setPageNum(String.valueOf(pageNum));
                masterDataMdgSalesDayReportVos = this.masterDataMdgService.pullSalesDayReportList(dto);
                if (CollectionUtils.isEmpty(masterDataMdgSalesDayReportVos)) {
                    return;
                }
                ArrayList<SalesGoalEntity> pullList = new ArrayList<SalesGoalEntity>();
                ArrayList<MainOneDaySalesDto> dayList = new ArrayList<MainOneDaySalesDto>();
                this.salesGoalValidate(masterDataMdgSalesDayReportVos, pullList, dayList);
                if (!CollectionUtils.isEmpty(pullList)) {
                    this.salesGoaEditService.editBatch(pullList);
                }
                if (CollectionUtils.isEmpty(dayList) || CollectionUtils.isEmpty(this.salesGoalForMainOneDaySalesListeners)) continue;
                for (SalesGoalForMainOneDaySalesListener salesGoalForMainOneDaySalesListener : this.salesGoalForMainOneDaySalesListeners) {
                    salesGoalForMainOneDaySalesListener.saveOrUpdate(dayList);
                }
            }
        }
        finally {
            if (lock) {
                this.unLock(lockKey);
            }
        }
    }

    public List<SalesGoalVo> listVerticalByConditions(SalesGoalDto salesGoalDto) {
        List<SalesGoalEntity> salesGoalEntities = this.salesGoalMapper.listVerticalByConditions(salesGoalDto);
        if (CollectionUtils.isEmpty(salesGoalEntities)) {
            return Lists.newArrayList();
        }
        return new ArrayList<SalesGoalVo>(this.nebulaToolkitService.copyCollectionByWhiteList(salesGoalEntities, SalesGoalEntity.class, SalesGoalVo.class, LinkedHashSet.class, ArrayList.class, new String[0]));
    }

    public List<SalesGoalSumVo> listVerticalSumByConditions(SalesGoalDto salesGoalDto) {
        return this.salesGoalMapper.listVerticalSumByConditions(salesGoalDto);
    }

    public List<SalesGoalVo> findSalesGoal(SalesGoalDto salesGoal) {
        List salesGoalList = this.salesGoalMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SalesGoalEntity.class).eq(SalesGoalEntity::getCustomerCode, (Object)salesGoal.getCustomerCode())).eq(SalesGoalEntity::getBusinessFormatCode, (Object)salesGoal.getBusinessFormatCode())).eq(SalesGoalEntity::getBusinessUnitCode, (Object)salesGoal.getBusinessUnitCode())).eq(SalesGoalEntity::getYearMonthLy, (Object)salesGoal.getYearMonthLy()));
        if (salesGoalList == null || salesGoalList.isEmpty()) {
            return Lists.newArrayList();
        }
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)salesGoalList, SalesGoalEntity.class, SalesGoalVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public List<SalesGoalVo> listForVariableCal(SalesGoalDto dto) {
        if (StringUtils.isEmpty((CharSequence)dto.getSalesOrgCode()) && StringUtils.isEmpty((CharSequence)dto.getCustomerCode()) && StringUtils.isEmpty((CharSequence)dto.getYearMonthLy()) && StringUtils.isEmpty((CharSequence)dto.getYearLy()) && StringUtils.isEmpty((CharSequence)dto.getCustomerChannelCode()) && StringUtils.isEmpty((CharSequence)dto.getChannelCode()) && StringUtils.isEmpty((CharSequence)dto.getBusinessFormatCode()) && StringUtils.isEmpty((CharSequence)dto.getBusinessUnitCode()) && StringUtils.isEmpty((CharSequence)dto.getSalesInstitutionCode()) && StringUtils.isEmpty((CharSequence)dto.getSalesOrgRegionCode()) && StringUtils.isEmpty((CharSequence)dto.getSalesOrgProvinceCode()) && StringUtils.isEmpty((CharSequence)dto.getYearSalesTypeCode()) && CollectionUtils.isEmpty((Collection)dto.getExcludeProductCodeList()) && CollectionUtils.isEmpty((Collection)dto.getExcludeProductBrandCodeList()) && CollectionUtils.isEmpty((Collection)dto.getExcludeProductCategoryCodeList()) && CollectionUtils.isEmpty((Collection)dto.getExcludeProductItemCodeList()) && CollectionUtils.isEmpty((Collection)dto.getIncludeProductCodeList()) && CollectionUtils.isEmpty((Collection)dto.getYearMonthLySet()) && CollectionUtils.isEmpty((Collection)dto.getCustomerCodeList()) && StringUtils.isEmpty((CharSequence)dto.getCustomerErpCode())) {
            return Lists.newArrayList();
        }
        List entityList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.salesGoalRepository.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(StringUtils.isNotEmpty((CharSequence)dto.getSalesOrgCode()), SalesGoalEntity::getSalesOrgCode, (Object)dto.getSalesOrgCode())).eq(StringUtils.isNotEmpty((CharSequence)dto.getCustomerErpCode()), SalesGoalEntity::getCustomerErpCode, (Object)dto.getCustomerErpCode())).eq(StringUtils.isNotEmpty((CharSequence)dto.getCustomerCode()), SalesGoalEntity::getCustomerCode, (Object)dto.getCustomerCode())).in(!CollectionUtils.isEmpty((Collection)dto.getCustomerCodeList()), SalesGoalEntity::getCustomerCode, (Collection)dto.getCustomerCodeList())).eq(StringUtils.isNotEmpty((CharSequence)dto.getYearMonthLy()), SalesGoalEntity::getYearMonthLy, (Object)dto.getYearMonthLy())).eq(StringUtils.isNotEmpty((CharSequence)dto.getYearLy()), SalesGoalEntity::getYearMonthLy, (Object)dto.getYearLy())).in(!CollectionUtils.isEmpty((Collection)dto.getYearMonthLySet()), SalesGoalEntity::getYearMonthLy, (Collection)dto.getYearMonthLySet())).eq(StringUtils.isNotEmpty((CharSequence)dto.getCustomerChannelCode()), SalesGoalEntity::getCustomerChannelCode, (Object)dto.getCustomerChannelCode())).eq(StringUtils.isNotEmpty((CharSequence)dto.getChannelCode()), SalesGoalEntity::getChannelCode, (Object)dto.getChannelCode())).eq(StringUtils.isNotEmpty((CharSequence)dto.getBusinessFormatCode()), SalesGoalEntity::getBusinessFormatCode, (Object)dto.getBusinessFormatCode())).eq(StringUtils.isNotEmpty((CharSequence)dto.getBusinessUnitCode()), SalesGoalEntity::getBusinessUnitCode, (Object)dto.getBusinessUnitCode())).eq(StringUtils.isNotEmpty((CharSequence)dto.getSalesInstitutionCode()), SalesGoalEntity::getSalesInstitutionCode, (Object)dto.getSalesInstitutionCode())).eq(StringUtils.isNotEmpty((CharSequence)dto.getSalesOrgRegionCode()), SalesGoalEntity::getSalesOrgRegionCode, (Object)dto.getSalesOrgRegionCode())).eq(StringUtils.isNotEmpty((CharSequence)dto.getSalesOrgProvinceCode()), SalesGoalEntity::getSalesOrgProvinceCode, (Object)dto.getSalesOrgProvinceCode())).eq(StringUtils.isNotEmpty((CharSequence)dto.getYearSalesTypeCode()), SalesGoalEntity::getYearSalesTypeCode, (Object)dto.getYearSalesTypeCode())).in(!CollectionUtils.isEmpty((Collection)dto.getIncludeProductCodeList()), SalesGoalEntity::getProductCode, (Collection)dto.getIncludeProductCodeList())).notIn(!CollectionUtils.isEmpty((Collection)dto.getExcludeProductCodeList()), SalesGoalEntity::getProductCode, (Collection)dto.getExcludeProductCodeList())).notIn(!CollectionUtils.isEmpty((Collection)dto.getExcludeProductBrandCodeList()), SalesGoalEntity::getProductBrandCode, (Collection)dto.getExcludeProductBrandCodeList())).notIn(!CollectionUtils.isEmpty((Collection)dto.getExcludeProductCategoryCodeList()), SalesGoalEntity::getProductCategoryCode, (Collection)dto.getExcludeProductCategoryCodeList())).notIn(!CollectionUtils.isEmpty((Collection)dto.getExcludeProductItemCodeList()), SalesGoalEntity::getProductItemCode, (Collection)dto.getExcludeProductItemCodeList())).list();
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)entityList, SalesGoalEntity.class, SalesGoalVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public List<SalesGoalVo> listForVariableCalNew(SalesGoalDto dto) {
        if (StringUtils.isEmpty((CharSequence)dto.getSalesOrgCode()) && StringUtils.isEmpty((CharSequence)dto.getCustomerCode()) && StringUtils.isEmpty((CharSequence)dto.getYearMonthLy()) && StringUtils.isEmpty((CharSequence)dto.getCustomerChannelCode()) && StringUtils.isEmpty((CharSequence)dto.getChannelCode()) && StringUtils.isEmpty((CharSequence)dto.getBusinessFormatCode()) && StringUtils.isEmpty((CharSequence)dto.getBusinessUnitCode()) && StringUtils.isEmpty((CharSequence)dto.getSalesInstitutionCode()) && StringUtils.isEmpty((CharSequence)dto.getSalesOrgRegionCode()) && StringUtils.isEmpty((CharSequence)dto.getSalesOrgProvinceCode()) && StringUtils.isEmpty((CharSequence)dto.getYearSalesTypeCode()) && CollectionUtils.isEmpty((Collection)dto.getExcludeProductCodeList()) && CollectionUtils.isEmpty((Collection)dto.getIncludeProductCodeList()) && StringUtils.isEmpty((CharSequence)dto.getCustomerErpCode())) {
            return Lists.newArrayList();
        }
        String year = dto.getYearMonthLy().substring(0, 4);
        String month = dto.getYearMonthLy().substring(5, dto.getYearMonthLy().length());
        if (!month.equals("01")) {
            Integer m = Integer.parseInt(month) - 1;
            month = m < 10 ? "0" + m : m.toString();
        }
        String startDateStr = year + "01";
        String endDateStr = year + month;
        List entityList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.salesGoalRepository.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(StringUtils.isNotEmpty((CharSequence)dto.getSalesOrgCode()), SalesGoalEntity::getSalesOrgCode, (Object)dto.getSalesOrgCode())).eq(StringUtils.isNotEmpty((CharSequence)dto.getCustomerErpCode()), SalesGoalEntity::getCustomerErpCode, (Object)dto.getCustomerErpCode())).eq(StringUtils.isNotEmpty((CharSequence)dto.getCustomerCode()), SalesGoalEntity::getCustomerCode, (Object)dto.getCustomerCode())).eq(StringUtils.isNotEmpty((CharSequence)dto.getCustomerChannelCode()), SalesGoalEntity::getCustomerChannelCode, (Object)dto.getCustomerChannelCode())).eq(StringUtils.isNotEmpty((CharSequence)dto.getChannelCode()), SalesGoalEntity::getChannelCode, (Object)dto.getChannelCode())).eq(StringUtils.isNotEmpty((CharSequence)dto.getBusinessFormatCode()), SalesGoalEntity::getBusinessFormatCode, (Object)dto.getBusinessFormatCode())).eq(StringUtils.isNotEmpty((CharSequence)dto.getBusinessUnitCode()), SalesGoalEntity::getBusinessUnitCode, (Object)dto.getBusinessUnitCode())).eq(StringUtils.isNotEmpty((CharSequence)dto.getSalesInstitutionCode()), SalesGoalEntity::getSalesInstitutionCode, (Object)dto.getSalesInstitutionCode())).eq(StringUtils.isNotEmpty((CharSequence)dto.getSalesOrgRegionCode()), SalesGoalEntity::getSalesOrgRegionCode, (Object)dto.getSalesOrgRegionCode())).eq(StringUtils.isNotEmpty((CharSequence)dto.getSalesOrgProvinceCode()), SalesGoalEntity::getSalesOrgProvinceCode, (Object)dto.getSalesOrgProvinceCode())).eq(StringUtils.isNotEmpty((CharSequence)dto.getYearSalesTypeCode()), SalesGoalEntity::getYearSalesTypeCode, (Object)dto.getYearSalesTypeCode())).between(StringUtils.isNotEmpty((CharSequence)startDateStr) && StringUtils.isNotEmpty((CharSequence)endDateStr), SalesGoalEntity::getYearMonthLy, (Object)startDateStr, (Object)endDateStr)).in(!CollectionUtils.isEmpty((Collection)dto.getIncludeProductCodeList()), SalesGoalEntity::getProductCode, (Collection)dto.getIncludeProductCodeList())).notIn(!CollectionUtils.isEmpty((Collection)dto.getExcludeProductCodeList()), SalesGoalEntity::getProductCode, (Collection)dto.getExcludeProductCodeList())).list();
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)entityList, SalesGoalEntity.class, SalesGoalVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public List<SalesGoalVo> restoreReplaySalesAfterDiscount(SalesGoalDto dto) {
        return this.salesGoalRepository.restoreReplaySalesAfterDiscount(dto);
    }

    public Map<String, BigDecimal> getSalesBeforeDiscount(SalesGoalDiscountSalesStatisticsDto dto) {
        if (StringUtils.isBlank((CharSequence)dto.getBusinessFormatCode())) {
            return new HashMap<String, BigDecimal>();
        }
        if (StringUtils.isBlank((CharSequence)dto.getBusinessUnitCode())) {
            return new HashMap<String, BigDecimal>();
        }
        if (StringUtils.isBlank((CharSequence)dto.getYearSalesTypeCode())) {
            return new HashMap<String, BigDecimal>();
        }
        if (Objects.isNull(dto.getYearMonth())) {
            return new HashMap<String, BigDecimal>();
        }
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        List<SalesGoalVo> feeVos = this.salesGoalRepository.getSalesBeforeDiscount(dto);
        if (CollectionUtils.isEmpty(feeVos)) {
            return map;
        }
        for (SalesGoalVo feeVo : feeVos) {
            String key = feeVo.getSystemCode() + "-" + feeVo.getRegionCode();
            if (map.containsKey(key)) {
                BigDecimal b = ((BigDecimal)map.get(key)).add(feeVo.getDeliverySalesAmount());
                map.put(key, b);
                continue;
            }
            map.put(key, feeVo.getDeliverySalesAmount());
        }
        return map;
    }

    public Map<String, BigDecimal> getSalesAfterDiscount(SalesGoalDiscountSalesStatisticsDto dto) {
        if (StringUtils.isBlank((CharSequence)dto.getBusinessFormatCode())) {
            return new HashMap<String, BigDecimal>();
        }
        if (StringUtils.isBlank((CharSequence)dto.getBusinessUnitCode())) {
            return new HashMap<String, BigDecimal>();
        }
        if (StringUtils.isBlank((CharSequence)dto.getYearSalesTypeCode())) {
            return new HashMap<String, BigDecimal>();
        }
        if (Objects.isNull(dto.getYearMonth())) {
            return new HashMap<String, BigDecimal>();
        }
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        List<SalesGoalVo> feeVos = this.salesGoalRepository.getSalesAfterDiscount(dto);
        if (CollectionUtils.isEmpty(feeVos)) {
            return map;
        }
        for (SalesGoalVo feeVo : feeVos) {
            String key = feeVo.getSystemCode() + "-" + feeVo.getRegionCode();
            if (map.containsKey(key)) {
                BigDecimal b = ((BigDecimal)map.get(key)).add(feeVo.getDeliveryDiscountSalesAmount());
                map.put(key, b);
                continue;
            }
            map.put(key, feeVo.getDeliveryDiscountSalesAmount());
        }
        return map;
    }

    private int countPageMax(MasterDataMdgBaseDto dto) {
        Integer totalNum = this.masterDataMdgService.countList("/api_ads_mn_sbi_chl_sales_daily_new_d_tpm");
        int maxPage = 1;
        int sizeInt = Integer.parseInt(dto.getPageSize());
        if (totalNum > sizeInt) {
            maxPage = totalNum % sizeInt > 0 ? totalNum / sizeInt + 1 : totalNum / sizeInt;
        }
        return maxPage;
    }

    private List<MainOneDaySalesDto> buildMainOneDaySalesDto(List<MasterDataMdgSalesDayReportVo> masterDataMdgSalesDayReportVos) {
        ArrayList<MainOneDaySalesDto> mainOneDaySalesDtoList = new ArrayList<MainOneDaySalesDto>();
        for (MasterDataMdgSalesDayReportVo masterDataMdgSalesDayReportVo : masterDataMdgSalesDayReportVos) {
            MainOneDaySalesDto mainOneDaySalesDto = new MainOneDaySalesDto();
            mainOneDaySalesDto.setYearMonthDay(masterDataMdgSalesDayReportVo.getCalendar_day());
            mainOneDaySalesDto.setBusinessFormatCode(masterDataMdgSalesDayReportVo.getFormats());
            mainOneDaySalesDto.setBusinessFormatName(null);
            mainOneDaySalesDto.setSalesInstitutionErpCode(masterDataMdgSalesDayReportVo.getSales_organization());
            mainOneDaySalesDto.setSalesInstitutionName(masterDataMdgSalesDayReportVo.getSales_organization_txt());
            mainOneDaySalesDto.setSalesInstitutionCode(masterDataMdgSalesDayReportVo.getSales_organization_tpm());
            mainOneDaySalesDto.setSalesOrgRegionErpCode(masterDataMdgSalesDayReportVo.getManagement_area());
            mainOneDaySalesDto.setSalesOrgRegionName(masterDataMdgSalesDayReportVo.getManagement_area_txt());
            mainOneDaySalesDto.setSalesOrgRegionCode(masterDataMdgSalesDayReportVo.getManagement_area_tpm());
            mainOneDaySalesDto.setSalesOrgProvinceErpCode(masterDataMdgSalesDayReportVo.getProvincial_area());
            mainOneDaySalesDto.setSalesOrgProvinceName(masterDataMdgSalesDayReportVo.getZsalegrp_t());
            mainOneDaySalesDto.setSalesOrgProvinceCode(masterDataMdgSalesDayReportVo.getProvincial_area_tpm());
            mainOneDaySalesDto.setCustomerErpCode(masterDataMdgSalesDayReportVo.getCustomer());
            mainOneDaySalesDto.setCustomerName(masterDataMdgSalesDayReportVo.getCustomer_txt());
            mainOneDaySalesDto.setCustomerCode(masterDataMdgSalesDayReportVo.getCustomer() + masterDataMdgSalesDayReportVo.getSales_organization() + masterDataMdgSalesDayReportVo.getChannel_type() + masterDataMdgSalesDayReportVo.getFormats());
            mainOneDaySalesDto.setChannelCode(masterDataMdgSalesDayReportVo.getChannel_type());
            mainOneDaySalesDto.setChannelName(masterDataMdgSalesDayReportVo.getChannel_type_txt());
            mainOneDaySalesDto.setCustomerClassifyCode(masterDataMdgSalesDayReportVo.getCustomer_category());
            mainOneDaySalesDto.setCustomerClassifyName(masterDataMdgSalesDayReportVo.getCustomer_category_txt());
            mainOneDaySalesDto.setProductCode(masterDataMdgSalesDayReportVo.getProduct());
            mainOneDaySalesDto.setProductName(masterDataMdgSalesDayReportVo.getProduct_txt());
            mainOneDaySalesDto.setNewAndOldProduct(masterDataMdgSalesDayReportVo.getZxlp());
            mainOneDaySalesDto.setSaleQuantity(new BigDecimal(Optional.ofNullable(masterDataMdgSalesDayReportVo.getActual_qty_3_1_1d()).orElse("0")));
            mainOneDaySalesDto.setDiscountFrontSaleAmount(new BigDecimal(Optional.ofNullable(masterDataMdgSalesDayReportVo.getSales_amt_3_1_1d()).orElse("0")));
            mainOneDaySalesDto.setDiscountBehindSaleAmount(new BigDecimal(Optional.ofNullable(masterDataMdgSalesDayReportVo.getDiscount_sales_amt_3_1_1d()).orElse("0")));
            mainOneDaySalesDto.setMilkCardDiscountBehindOrderAmountToB(new BigDecimal(Optional.ofNullable(masterDataMdgSalesDayReportVo.getDiscount_mc_order_sales_amt_3_1_1d()).orElse("0")));
            mainOneDaySalesDto.setMilkCardDiscountBehindOrderAmountToC(new BigDecimal(Optional.ofNullable(masterDataMdgSalesDayReportVo.getToc_mc_area_order_sales_amt_1d()).orElse("0")));
            mainOneDaySalesDto.setProductBrandCode(masterDataMdgSalesDayReportVo.getProductBrandCode());
            mainOneDaySalesDto.setProductBrandName(masterDataMdgSalesDayReportVo.getProductBrandName());
            mainOneDaySalesDto.setProductCategoryCode(masterDataMdgSalesDayReportVo.getProductCategoryCode());
            mainOneDaySalesDto.setProductCategoryName(masterDataMdgSalesDayReportVo.getProductCategoryName());
            mainOneDaySalesDto.setProductItemCode(masterDataMdgSalesDayReportVo.getProductItemCode());
            mainOneDaySalesDto.setProductItemName(masterDataMdgSalesDayReportVo.getProductItemName());
            mainOneDaySalesDtoList.add(mainOneDaySalesDto);
        }
        return mainOneDaySalesDtoList;
    }

    @Transactional(rollbackFor={Exception.class})
    void saveMdgBatch(MasterDataMdgBaseDto dto, List<SalesGoalEntity> pullList) {
        this.salesGoalRepository.saveBatch(pullList);
    }

    private void salesGoalValidate(List<MasterDataMdgSalesDayReportVo> masterDataMdgSalesDayReportVos, List<SalesGoalEntity> pullList, List<MainOneDaySalesDto> dayList) {
        List list = YearSalesTypeEnum.concertSalesDayToList();
        HashSet<String> productCodeSet = new HashSet<String>();
        HashSet<String> salesOrgCodeSet = new HashSet<String>();
        HashMap<String, MasterDataMdgSalesDayReportVo> sumMap = new HashMap<String, MasterDataMdgSalesDayReportVo>();
        for (MasterDataMdgSalesDayReportVo reportVo : masterDataMdgSalesDayReportVos) {
            if (StringUtils.isNotBlank((CharSequence)reportVo.getProduct()) && reportVo.getProduct().startsWith("000000")) {
                reportVo.setProduct(reportVo.getProduct().substring(6));
            }
            productCodeSet.add(reportVo.getProduct());
            String saleOrgKey = reportVo.getChannel_type() + reportVo.getFormats();
            String insKey = saleOrgKey + reportVo.getSales_organization();
            salesOrgCodeSet.add(insKey);
            String regKey = insKey + reportVo.getManagement_area();
            salesOrgCodeSet.add(regKey);
            String provKey = regKey + reportVo.getProvincial_area();
            salesOrgCodeSet.add(provKey);
            String sumKey = reportVo.getFormats() + reportVo.getSales_organization() + reportVo.getManagement_area() + reportVo.getProvincial_area() + reportVo.getChannel_type() + reportVo.getCustomer() + reportVo.getProduct() + reportVo.getY_id() + reportVo.getM_id();
            if (StringUtils.isNotBlank((CharSequence)reportVo.getD_id())) {
                sumKey = reportVo.getFormats() + reportVo.getSales_organization() + reportVo.getChannel_type() + reportVo.getCustomer() + reportVo.getProduct() + reportVo.getY_id() + reportVo.getM_id() + reportVo.getD_id();
            }
            if (sumMap.containsKey(sumKey)) {
                MasterDataMdgSalesDayReportVo sumVo = (MasterDataMdgSalesDayReportVo)sumMap.get(sumKey);
                String dcm = new BigDecimal(Optional.ofNullable(sumVo.getSales_target_d_cm()).orElse("0").trim()).add(new BigDecimal(Optional.ofNullable(reportVo.getSales_target_d_cm()).orElse("0").trim())).toPlainString();
                sumVo.setSales_target_d_cm(dcm);
                String bcm = new BigDecimal(Optional.ofNullable(sumVo.getSales_target_b_cm()).orElse("0").trim()).add(new BigDecimal(Optional.ofNullable(reportVo.getSales_target_b_cm()).orElse("0").trim())).toPlainString();
                sumVo.setSales_target_b_cm(bcm);
                String tdcm = new BigDecimal(Optional.ofNullable(sumVo.getTarget_qty_d_cm()).orElse("0").trim()).add(new BigDecimal(Optional.ofNullable(reportVo.getTarget_qty_d_cm()).orElse("0").trim())).toPlainString();
                sumVo.setTarget_qty_d_cm(tdcm);
                String tbcm = new BigDecimal(Optional.ofNullable(sumVo.getTarget_qty_b_cm()).orElse("0").trim()).add(new BigDecimal(Optional.ofNullable(reportVo.getTarget_qty_b_cm()).orElse("0").trim())).toPlainString();
                sumVo.setTarget_qty_b_cm(tbcm);
                String ddcm = new BigDecimal(Optional.ofNullable(sumVo.getDiscount_sales_target_d_cm()).orElse("0").trim()).add(new BigDecimal(Optional.ofNullable(reportVo.getDiscount_sales_target_d_cm()).orElse("0").trim())).toPlainString();
                sumVo.setDiscount_sales_target_d_cm(ddcm);
                String dbcm = new BigDecimal(Optional.ofNullable(sumVo.getDiscount_sales_target_b_cm()).orElse("0").trim()).add(new BigDecimal(Optional.ofNullable(reportVo.getDiscount_sales_target_b_cm()).orElse("0").trim())).toPlainString();
                sumVo.setDiscount_sales_target_b_cm(dbcm);
                String act1d = new BigDecimal(Optional.ofNullable(sumVo.getActual_qty_3_1_1d()).orElse("0").trim()).add(new BigDecimal(Optional.ofNullable(reportVo.getActual_qty_3_1_1d()).orElse("0").trim())).toPlainString();
                sumVo.setActual_qty_3_1_1d(act1d);
                String sal1d = new BigDecimal(Optional.ofNullable(sumVo.getSales_amt_3_1_1d()).orElse("0").trim()).add(new BigDecimal(Optional.ofNullable(reportVo.getSales_amt_3_1_1d()).orElse("0").trim())).toPlainString();
                sumVo.setSales_amt_3_1_1d(sal1d);
                String dis1d = new BigDecimal(Optional.ofNullable(sumVo.getDiscount_sales_amt_3_1_1d()).orElse("0").trim()).add(new BigDecimal(Optional.ofNullable(reportVo.getDiscount_sales_amt_3_1_1d()).orElse("0").trim())).toPlainString();
                sumVo.setDiscount_sales_amt_3_1_1d(dis1d);
                String tob = new BigDecimal(Optional.ofNullable(sumVo.getDiscount_mc_order_sales_amt_3_1_1d()).orElse("0").trim()).add(new BigDecimal(Optional.ofNullable(reportVo.getDiscount_mc_order_sales_amt_3_1_1d()).orElse("0").trim())).toPlainString();
                sumVo.setDiscount_mc_order_sales_amt_3_1_1d(tob);
                String toc = new BigDecimal(Optional.ofNullable(sumVo.getToc_mc_area_order_sales_amt_1d()).orElse("0").trim()).add(new BigDecimal(Optional.ofNullable(reportVo.getToc_mc_area_order_sales_amt_1d()).orElse("0").trim())).toPlainString();
                sumVo.setToc_mc_area_order_sales_amt_1d(toc);
                continue;
            }
            sumMap.put(sumKey, reportVo);
        }
        Map<Object, Object> productVoMap = new HashMap();
        if (!CollectionUtils.isEmpty(productCodeSet)) {
            List productVoList = this.productVoService.findByProductCodes(new ArrayList(productCodeSet));
            productVoMap = productVoList.stream().collect(Collectors.toMap(ProductVo::getProductCode, Function.identity()));
        }
        HashMap finalProductVoMap = productVoMap;
        Map salesOrgMap = new HashMap();
        if (!CollectionUtils.isEmpty(salesOrgCodeSet)) {
            List salesOrgCodeList = Lists.partition(new ArrayList(salesOrgCodeSet), (int)500);
            salesOrgMap = this.salesOrgVoService.findNameBySalesOrgCodes(salesOrgCodeList);
        }
        HashMap finalSalesOrgMap = salesOrgMap;
        sumMap.values().forEach(masterDataMdgSalesDayReportVo -> {
            String cusKey = masterDataMdgSalesDayReportVo.getCustomer() + masterDataMdgSalesDayReportVo.getSales_organization() + masterDataMdgSalesDayReportVo.getChannel_type() + masterDataMdgSalesDayReportVo.getFormats();
            String saleOrgKey = masterDataMdgSalesDayReportVo.getChannel_type() + masterDataMdgSalesDayReportVo.getFormats();
            String insKey = saleOrgKey + masterDataMdgSalesDayReportVo.getSales_organization();
            masterDataMdgSalesDayReportVo.setSales_organization_tpm(insKey);
            masterDataMdgSalesDayReportVo.setSales_organization_txt(finalSalesOrgMap.getOrDefault(insKey, masterDataMdgSalesDayReportVo.getSales_organization_txt()));
            String regKey = insKey + masterDataMdgSalesDayReportVo.getManagement_area();
            masterDataMdgSalesDayReportVo.setManagement_area_tpm(regKey);
            masterDataMdgSalesDayReportVo.setManagement_area_txt(finalSalesOrgMap.getOrDefault(regKey, masterDataMdgSalesDayReportVo.getManagement_area_txt()));
            String provKey = regKey + masterDataMdgSalesDayReportVo.getProvincial_area();
            masterDataMdgSalesDayReportVo.setProvincial_area_tpm(provKey);
            masterDataMdgSalesDayReportVo.setZsalegrp_t(finalSalesOrgMap.getOrDefault(provKey, masterDataMdgSalesDayReportVo.getZsalegrp_t()));
            ProductVo productVo = (ProductVo)finalProductVoMap.get(masterDataMdgSalesDayReportVo.getProduct());
            if (productVo != null) {
                masterDataMdgSalesDayReportVo.setProduct_txt(productVo.getProductName());
                masterDataMdgSalesDayReportVo.setProductBrandCode(productVo.getProductBrandCode());
                masterDataMdgSalesDayReportVo.setProductBrandName(productVo.getProductBrandName());
                masterDataMdgSalesDayReportVo.setProductCategoryCode(productVo.getProductCategoryCode());
                masterDataMdgSalesDayReportVo.setProductCategoryName(productVo.getProductCategoryName());
                masterDataMdgSalesDayReportVo.setProductItemCode(productVo.getProductLevelCode());
                masterDataMdgSalesDayReportVo.setProductItemName(productVo.getProductLevelName());
            }
            if (StringUtils.isNotBlank((CharSequence)masterDataMdgSalesDayReportVo.getD_id())) {
                MainOneDaySalesDto mainOneDaySalesDto = new MainOneDaySalesDto();
                mainOneDaySalesDto.setYearMonthDay(masterDataMdgSalesDayReportVo.getCalendar_day());
                mainOneDaySalesDto.setYearMonthLy(mainOneDaySalesDto.getYearMonthDay().substring(0, 6));
                mainOneDaySalesDto.setBusinessFormatCode(masterDataMdgSalesDayReportVo.getFormats());
                mainOneDaySalesDto.setBusinessFormatName(null);
                mainOneDaySalesDto.setSalesInstitutionErpCode(masterDataMdgSalesDayReportVo.getSales_organization());
                mainOneDaySalesDto.setSalesInstitutionName(masterDataMdgSalesDayReportVo.getSales_organization_txt());
                mainOneDaySalesDto.setSalesInstitutionCode(masterDataMdgSalesDayReportVo.getSales_organization_tpm());
                mainOneDaySalesDto.setSalesOrgRegionErpCode(masterDataMdgSalesDayReportVo.getManagement_area());
                mainOneDaySalesDto.setSalesOrgRegionName(masterDataMdgSalesDayReportVo.getManagement_area_txt());
                mainOneDaySalesDto.setSalesOrgRegionCode(masterDataMdgSalesDayReportVo.getManagement_area_tpm());
                mainOneDaySalesDto.setSalesOrgProvinceErpCode(masterDataMdgSalesDayReportVo.getProvincial_area());
                mainOneDaySalesDto.setSalesOrgProvinceName(masterDataMdgSalesDayReportVo.getZsalegrp_t());
                mainOneDaySalesDto.setSalesOrgProvinceCode(masterDataMdgSalesDayReportVo.getProvincial_area_tpm());
                mainOneDaySalesDto.setCustomerErpCode(masterDataMdgSalesDayReportVo.getCustomer());
                mainOneDaySalesDto.setCustomerName(masterDataMdgSalesDayReportVo.getCustomer_txt());
                mainOneDaySalesDto.setCustomerCode(masterDataMdgSalesDayReportVo.getCustomer() + masterDataMdgSalesDayReportVo.getSales_organization() + masterDataMdgSalesDayReportVo.getChannel_type() + masterDataMdgSalesDayReportVo.getFormats());
                mainOneDaySalesDto.setChannelCode(masterDataMdgSalesDayReportVo.getChannel_type());
                mainOneDaySalesDto.setChannelName(masterDataMdgSalesDayReportVo.getChannel_type_txt());
                mainOneDaySalesDto.setCustomerClassifyCode(masterDataMdgSalesDayReportVo.getCustomer_category());
                mainOneDaySalesDto.setCustomerClassifyName(masterDataMdgSalesDayReportVo.getCustomer_category_txt());
                mainOneDaySalesDto.setProductCode(masterDataMdgSalesDayReportVo.getProduct());
                mainOneDaySalesDto.setProductName(masterDataMdgSalesDayReportVo.getProduct_txt());
                mainOneDaySalesDto.setNewAndOldProduct(masterDataMdgSalesDayReportVo.getZxlp());
                mainOneDaySalesDto.setSaleQuantity(new BigDecimal(Optional.ofNullable(masterDataMdgSalesDayReportVo.getActual_qty_3_1_1d()).orElse("0")));
                mainOneDaySalesDto.setDiscountFrontSaleAmount(new BigDecimal(Optional.ofNullable(masterDataMdgSalesDayReportVo.getSales_amt_3_1_1d()).orElse("0")));
                mainOneDaySalesDto.setDiscountBehindSaleAmount(new BigDecimal(Optional.ofNullable(masterDataMdgSalesDayReportVo.getDiscount_sales_amt_3_1_1d()).orElse("0")));
                mainOneDaySalesDto.setMilkCardDiscountBehindOrderAmountToB(new BigDecimal(Optional.ofNullable(masterDataMdgSalesDayReportVo.getDiscount_mc_order_sales_amt_3_1_1d()).orElse("0")));
                mainOneDaySalesDto.setMilkCardDiscountBehindOrderAmountToC(new BigDecimal(Optional.ofNullable(masterDataMdgSalesDayReportVo.getToc_mc_area_order_sales_amt_1d()).orElse("0")));
                mainOneDaySalesDto.setProductBrandCode(masterDataMdgSalesDayReportVo.getProductBrandCode());
                mainOneDaySalesDto.setProductBrandName(masterDataMdgSalesDayReportVo.getProductBrandName());
                mainOneDaySalesDto.setProductCategoryCode(masterDataMdgSalesDayReportVo.getProductCategoryCode());
                mainOneDaySalesDto.setProductCategoryName(masterDataMdgSalesDayReportVo.getProductCategoryName());
                mainOneDaySalesDto.setProductItemCode(masterDataMdgSalesDayReportVo.getProductItemCode());
                mainOneDaySalesDto.setProductItemName(masterDataMdgSalesDayReportVo.getProductItemName());
                mainOneDaySalesDto.setOnlyKey(mainOneDaySalesDto.getYearMonthDay() + mainOneDaySalesDto.getSalesInstitutionCode() + mainOneDaySalesDto.getCustomerCode() + mainOneDaySalesDto.getProductCode());
                dayList.add(mainOneDaySalesDto);
            } else {
                list.forEach(groupCode -> {
                    SalesGoalEntity salesGoalEntity = new SalesGoalEntity();
                    salesGoalEntity.setYearMonthLy(masterDataMdgSalesDayReportVo.getY_id() + "-" + masterDataMdgSalesDayReportVo.getM_id());
                    salesGoalEntity.setCalendarDay(masterDataMdgSalesDayReportVo.getCalendar_day());
                    salesGoalEntity.setBusinessFormatCode(masterDataMdgSalesDayReportVo.getFormats());
                    salesGoalEntity.setBusinessUnitCode(BusinessUnitEnum.HEADQUARTERS.getCode());
                    salesGoalEntity.setSalesInstitutionErpCode(masterDataMdgSalesDayReportVo.getSales_organization());
                    salesGoalEntity.setSalesInstitutionName(masterDataMdgSalesDayReportVo.getSales_organization_txt());
                    salesGoalEntity.setSalesInstitutionCode(masterDataMdgSalesDayReportVo.getSales_organization_tpm());
                    salesGoalEntity.setSalesOrgRegionErpCode(masterDataMdgSalesDayReportVo.getManagement_area());
                    salesGoalEntity.setSalesOrgRegionName(masterDataMdgSalesDayReportVo.getManagement_area_txt());
                    salesGoalEntity.setSalesOrgRegionCode(masterDataMdgSalesDayReportVo.getManagement_area_tpm());
                    salesGoalEntity.setSalesOrgProvinceErpCode(masterDataMdgSalesDayReportVo.getProvincial_area());
                    salesGoalEntity.setSalesOrgProvinceName(masterDataMdgSalesDayReportVo.getZsalegrp_t());
                    salesGoalEntity.setSalesOrgProvinceCode(masterDataMdgSalesDayReportVo.getProvincial_area_tpm());
                    salesGoalEntity.setCustomerCode(cusKey);
                    salesGoalEntity.setCustomerName(masterDataMdgSalesDayReportVo.getCustomer_txt());
                    salesGoalEntity.setCustomerErpCode(masterDataMdgSalesDayReportVo.getCustomer());
                    salesGoalEntity.setCustomerType(masterDataMdgSalesDayReportVo.getCustomer_category());
                    salesGoalEntity.setCustomerChannelCode(masterDataMdgSalesDayReportVo.getChannel_type());
                    salesGoalEntity.setCustomerChannelName(masterDataMdgSalesDayReportVo.getChannel_type_txt());
                    salesGoalEntity.setProductCode(masterDataMdgSalesDayReportVo.getProduct());
                    salesGoalEntity.setProductName(masterDataMdgSalesDayReportVo.getProduct_txt());
                    salesGoalEntity.setNewOldProduct(masterDataMdgSalesDayReportVo.getZxlp());
                    salesGoalEntity.setDataFromCode(DataFromEnum.FOREIGN_SYSTEM.getCode());
                    salesGoalEntity.setYearSalesTypeCode((String)groupCode);
                    salesGoalEntity.setProductBrandCode(masterDataMdgSalesDayReportVo.getProductBrandCode());
                    salesGoalEntity.setProductBrandName(masterDataMdgSalesDayReportVo.getProductBrandName());
                    salesGoalEntity.setProductCategoryCode(masterDataMdgSalesDayReportVo.getProductCategoryCode());
                    salesGoalEntity.setProductCategoryName(masterDataMdgSalesDayReportVo.getProductCategoryName());
                    salesGoalEntity.setProductItemCode(masterDataMdgSalesDayReportVo.getProductItemCode());
                    salesGoalEntity.setProductItemName(masterDataMdgSalesDayReportVo.getProductItemName());
                    if (StringUtils.isNotEmpty((CharSequence)salesGoalEntity.getSalesOrgProvinceCode())) {
                        salesGoalEntity.setSalesOrgCode(salesGoalEntity.getSalesOrgProvinceCode());
                        salesGoalEntity.setSalesOrgName(salesGoalEntity.getSalesOrgProvinceName());
                    } else if (StringUtils.isNotEmpty((CharSequence)salesGoalEntity.getSalesOrgRegionCode())) {
                        salesGoalEntity.setSalesOrgCode(salesGoalEntity.getSalesOrgRegionCode());
                        salesGoalEntity.setSalesOrgName(salesGoalEntity.getSalesOrgRegionName());
                    } else if (StringUtils.isNotEmpty((CharSequence)salesGoalEntity.getSalesInstitutionCode())) {
                        salesGoalEntity.setSalesOrgCode(salesGoalEntity.getSalesInstitutionCode());
                        salesGoalEntity.setSalesOrgName(salesGoalEntity.getSalesInstitutionName());
                    } else {
                        salesGoalEntity.setSalesOrgCode("");
                        salesGoalEntity.setSalesOrgName("");
                    }
                    if (YearSalesTypeEnum.INTERNAL_CONTROL.getCode().equals(groupCode)) {
                        salesGoalEntity.setDeliveryDiscountSalesAmount(new BigDecimal(Optional.ofNullable(masterDataMdgSalesDayReportVo.getDiscount_sales_target_d_cm()).orElse("0").trim()));
                        salesGoalEntity.setDeliverySalesAmount(new BigDecimal(Optional.ofNullable(masterDataMdgSalesDayReportVo.getSales_target_d_cm()).orElse("0").trim()));
                        salesGoalEntity.setTaskQuantity(new BigDecimal(Optional.ofNullable(masterDataMdgSalesDayReportVo.getTarget_qty_d_cm()).orElse("0").trim()));
                    }
                    if (YearSalesTypeEnum.CONTRACT.getCode().equals(groupCode)) {
                        salesGoalEntity.setDeliveryDiscountSalesAmount(new BigDecimal(Optional.ofNullable(masterDataMdgSalesDayReportVo.getDiscount_sales_target_b_cm()).orElse("0").trim()));
                        salesGoalEntity.setDeliverySalesAmount(new BigDecimal(Optional.ofNullable(masterDataMdgSalesDayReportVo.getSales_target_b_cm()).orElse("0").trim()));
                        salesGoalEntity.setTaskQuantity(new BigDecimal(Optional.ofNullable(masterDataMdgSalesDayReportVo.getTarget_qty_b_cm()).orElse("0").trim()));
                    }
                    salesGoalEntity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                    salesGoalEntity.setTenantCode(TenantUtils.getTenantCode());
                    pullList.add(salesGoalEntity);
                });
            }
        });
    }

    public String getLockKey(MasterDataMdgBaseDto dto) {
        String lockKey = DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd");
        if (!StringUtils.isEmpty((CharSequence)dto.getUdate())) {
            lockKey = dto.getUdate();
        }
        return "sales_goal_lock:lock:" + lockKey;
    }

    public SalesGoalSumVo findDiscountAfterAndDeliveryQuantity(SalesGoalDto salesGoalDto) {
        if (StringUtils.isBlank((CharSequence)salesGoalDto.getBusinessFormatCode()) || StringUtils.isBlank((CharSequence)salesGoalDto.getBusinessUnitCode()) || StringUtils.isBlank((CharSequence)salesGoalDto.getYearMonthLy())) {
            return null;
        }
        return this.salesGoalRepository.findDiscountAfterAndDeliveryQuantity(salesGoalDto);
    }

    public BigDecimal findDiscountAfter(SalesGoalDto salesGoalDto) {
        return this.salesGoalRepository.findDiscountAfter(salesGoalDto);
    }

    private void unLock(String lockKey) {
        if (StringUtils.isEmpty((CharSequence)lockKey)) {
            throw new RuntimeException("\u62c9\u53d6\u9500\u552e\u65e5\u62a5\u6570\u636e\u89e3\u9501\u5931\u8d25\uff0c\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        this.redisLockService.unlock(lockKey);
    }

    private boolean lock(String lockKey) {
        if (StringUtils.isEmpty((CharSequence)lockKey)) {
            throw new RuntimeException("\u62c9\u53d6\u9500\u552e\u65e5\u62a5\u6570\u636e\u52a0\u9501\u5931\u8d25\uff0c\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        return this.redisLockService.tryLock(lockKey, TimeUnit.HOURS, 12L);
    }

    public List<SalesGoalVo> findListForFR(List<SalesGoalDto> salesGoalDtos) {
        return this.salesGoalRepository.findListForFR(salesGoalDtos);
    }
}

