/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.sales.goal.local.service.internal;

import cn.hutool.core.lang.Snowflake;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.product.brand.sdk.service.ProductBrandService;
import com.biz.crm.mdm.business.product.brand.sdk.vo.ProductBrandVo;
import com.biz.crm.mdm.business.product.level.sdk.enums.ProductLevelEnum;
import com.biz.crm.mdm.business.product.level.sdk.service.ProductLevelVoSdkService;
import com.biz.crm.mdm.business.product.level.sdk.vo.ProductLevelVo;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mn.common.base.eunm.YesOrNoEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.third.system.master.data.mdg.sdk.dto.MasterDataMdgSalesPerformanceDto;
import com.biz.crm.mn.third.system.master.data.mdg.sdk.vo.MasterDataMdgSalesPerformanceVo;
import com.biz.crm.tpm.business.sales.goal.local.entity.SalesPerformanceEntity;
import com.biz.crm.tpm.business.sales.goal.local.mapper.SalesPerformanceMapper;
import com.biz.crm.tpm.business.sales.goal.local.service.SalesPerformanceService;
import com.biz.crm.tpm.business.sales.goal.sdk.dto.SalesPerformanceDto;
import com.biz.crm.tpm.business.sales.goal.sdk.vo.SalesDatePeriodSummaryVo;
import com.biz.crm.tpm.business.sales.goal.sdk.vo.SalesPerformanceVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SalesPerformanceServiceImpl
extends ServiceImpl<SalesPerformanceMapper, SalesPerformanceEntity>
implements SalesPerformanceService {
    private static final Logger log = LoggerFactory.getLogger(SalesPerformanceServiceImpl.class);
    @Resource
    private SalesPerformanceMapper salesPerformanceMapper;
    @Autowired(required=false)
    private Snowflake snowflake;
    @Autowired(required=false)
    private RedisService redisService;
    @Autowired(required=false)
    private ProductVoService productVoService;
    @Autowired(required=false)
    private ProductLevelVoSdkService productLevelVoSdkService;
    @Autowired(required=false)
    private ProductBrandService productBrandService;
    @Autowired(required=false)
    private CustomerVoService customerVoService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeBatch(MasterDataMdgSalesPerformanceDto dto, Integer delPage, Integer size) {
        for (int i = 0; i < delPage; ++i) {
            this.salesPerformanceMapper.deleteBatchByYearAndMonth(dto, size);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveBatchSalesPerformance(List<MasterDataMdgSalesPerformanceVo> masterDataMdgSalesPerformanceVos, MasterDataMdgSalesPerformanceDto dto) {
        if (CollectionUtils.isNotEmpty(masterDataMdgSalesPerformanceVos)) {
            String yearMonth = dto.getSalesMonth();
            masterDataMdgSalesPerformanceVos.forEach(masterDataMdgSalesPerformanceVo -> {
                masterDataMdgSalesPerformanceVo.setSpId(this.snowflake.nextIdStr());
                masterDataMdgSalesPerformanceVo.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                masterDataMdgSalesPerformanceVo.setTenantCode(TenantUtils.getTenantCode());
            });
            this.salesPerformanceMapper.saveBatchSalesPerformanceByYearAndMonth(masterDataMdgSalesPerformanceVos, yearMonth);
            log.info("\u5782\u76f4\u9500\u552e\u4e1a\u7ee9\u4fdd\u5b58\u6210\u529f");
        }
    }

    @Override
    public Integer totalCount(MasterDataMdgSalesPerformanceDto dto) {
        return this.salesPerformanceMapper.totalCount(dto);
    }

    @Override
    public Page<SalesPerformanceVo> findByConditions(Pageable pageable, SalesPerformanceDto dto) {
        Page page;
        Page<SalesPerformanceVo> salesPerformanceVoPage;
        List records;
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        Validate.notNull((Object)dto, (String)"\u8f93\u5165\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getSalesMonth(), (String)"\u8bf7\u9009\u62e9\u5e74\u6708", (Object[])new Object[0]);
        if (dto.getSalesMonth().contains("-")) {
            dto.setSalesMonth(dto.getSalesMonth().replace("-", ""));
        }
        if (CollectionUtils.isNotEmpty((Collection)(records = (salesPerformanceVoPage = this.salesPerformanceMapper.findByConditions((Page<SalesPerformanceVo>)(page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize())), dto)).getRecords())) && !YesOrNoEnum.NO.getCode().equals(dto.getIsExtend())) {
            List brands = records.stream().filter(k -> StringUtils.isNotBlank((CharSequence)k.getBrand())).map(SalesPerformanceVo::getBrand).distinct().collect(Collectors.toList());
            Map brandVoMap = this.productBrandService.listByCodes(brands).stream().filter(k -> StringUtils.isNotBlank((CharSequence)k.getProductBrandCode())).collect(Collectors.toMap(ProductBrandVo::getProductBrandCode, Function.identity(), (b1, b2) -> b2));
            List categoryCodes = records.stream().filter(k -> StringUtils.isNotBlank((CharSequence)k.getCategoryCode())).map(SalesPerformanceVo::getCategoryCode).distinct().collect(Collectors.toList());
            List classifys = records.stream().filter(k -> StringUtils.isNotBlank((CharSequence)k.getClassify())).map(SalesPerformanceVo::getClassify).distinct().collect(Collectors.toList());
            categoryCodes.addAll(classifys);
            List productLevelVoList = this.productLevelVoSdkService.findListByCodes(categoryCodes);
            Map<ProductLevelEnum, List<ProductLevelVo>> productLevelEnumMap = productLevelVoList.stream().collect(Collectors.groupingBy(ProductLevelVo::getProductLevelType));
            List<ProductLevelVo> productLevelCategoryList = productLevelEnumMap.get(ProductLevelEnum.category);
            Map categoryMap = productLevelCategoryList.stream().collect(Collectors.toMap(ProductLevelVo::getProductLevelCode, Function.identity(), (p1, p2) -> p2));
            List<ProductLevelVo> productLevelItemsList = productLevelEnumMap.get(ProductLevelEnum.items);
            Map itemCodeMap = productLevelItemsList.stream().collect(Collectors.toMap(ProductLevelVo::getProductLevelCode, Function.identity(), (pl1, pl2) -> pl2));
            records.forEach(salesPerformanceVo -> {
                String categoryCode;
                String classify;
                String brand = salesPerformanceVo.getBrand();
                if (brandVoMap.containsKey(brand)) {
                    salesPerformanceVo.setBrand(((ProductBrandVo)brandVoMap.get(brand)).getProductBrandName());
                }
                if (categoryMap.containsKey(classify = salesPerformanceVo.getClassify())) {
                    ProductLevelVo productLevelVoClassify = (ProductLevelVo)categoryMap.get(classify);
                    salesPerformanceVo.setClassify(productLevelVoClassify.getProductLevelName());
                }
                if (itemCodeMap.containsKey(categoryCode = salesPerformanceVo.getCategoryCode())) {
                    ProductLevelVo productLevelVo = (ProductLevelVo)itemCodeMap.get(categoryCode);
                    salesPerformanceVo.setCategoryCode(productLevelVo.getProductLevelName());
                }
            });
            salesPerformanceVoPage.setRecords(records);
        }
        return salesPerformanceVoPage;
    }

    @Override
    public Integer findTotalByCondition(SalesPerformanceDto salesPerformanceDto) {
        if (Objects.nonNull(salesPerformanceDto)) {
            return 0;
        }
        return this.salesPerformanceMapper.findTotalByCondition(salesPerformanceDto);
    }

    @Deprecated
    private void checkAndCreate(String yearMonth) {
        if (!this.redisService.hasKey("vertical_sales_performance:year_month").booleanValue()) {
            this.redisService.set("vertical_sales_performance:year_month", (Object)yearMonth);
            this.salesPerformanceMapper.createTableByYearMonth(yearMonth);
            return;
        }
        String yearMonth2 = (String)this.redisService.get("vertical_sales_performance:year_month");
        if (!yearMonth.equals(yearMonth2)) {
            this.salesPerformanceMapper.createTableByYearMonth(yearMonth);
            this.redisService.set("vertical_sales_performance:year_month", (Object)yearMonth);
        }
    }

    @Override
    public List<SalesDatePeriodSummaryVo> findSummaryByConditions(SalesPerformanceDto dto, String cacheKey) {
        if (StringUtils.isNotEmpty((CharSequence)dto.getStartTimeOrDate()) && StringUtils.isNotEmpty((CharSequence)dto.getEndTimeOrDate())) {
            Validate.isTrue((boolean)StringUtils.equals((CharSequence)dto.getStartTimeOrDate().substring(0, 7), (CharSequence)dto.getEndTimeOrDate().substring(0, 7)), (String)"\u67e5\u8be2\u65f6\u95f4\u4e0d\u80fd\u8de8\u6708\uff01", (Object[])new Object[0]);
        }
        if (StringUtils.isNotEmpty((CharSequence)(cacheKey = "TPM:EXAMINE_SALES_DATE_SPLIT:" + cacheKey))) {
            this.redisService.del(cacheKey);
        }
        if (StringUtils.isEmpty((CharSequence)dto.getStartTimeOrDate()) || StringUtils.isEmpty((CharSequence)dto.getCustomerCode()) || StringUtils.isEmpty((CharSequence)dto.getEndTimeOrDate())) {
            return Lists.newArrayList();
        }
        List customerVos = this.customerVoService.findByCustomerCodes((List)Lists.newArrayList((Object[])new String[]{dto.getCustomerCode()}));
        Validate.notEmpty((Collection)customerVos, (String)"\u5ba2\u6237\u7f16\u7801[%s]\u5ba2\u6237\u4fe1\u606f\u4e0d\u5b58\u5728\uff01", (Object[])new Object[]{dto.getCustomerCode()});
        dto.setSoldToparty(((CustomerVo)customerVos.get(0)).getErpCode());
        String beginDate = dto.getStartTimeOrDate().replaceAll("-", "");
        String endDate = dto.getEndTimeOrDate().replaceAll("-", "");
        String beginYearMonthStr = dto.getStartTimeOrDate().substring(0, 7);
        String endYearMonthStr = dto.getEndTimeOrDate().substring(0, 7);
        ArrayList<SalesDatePeriodSummaryVo> list = new ArrayList();
        if (beginYearMonthStr.equals(endYearMonthStr)) {
            dto.setStartTimeOrDate(beginDate);
            dto.setEndTimeOrDate(endDate);
            dto.setSalesMonth(beginYearMonthStr.substring(0, 4) + beginYearMonthStr.substring(5, 7));
            list = this.salesPerformanceMapper.findSummaryByConditions(dto);
        } else {
            ArrayList<SalesDatePeriodSummaryVo> result = new ArrayList<SalesDatePeriodSummaryVo>();
            Calendar beginDateCalendar = Calendar.getInstance();
            beginDateCalendar.setTime(DateUtil.parse((String)dto.getStartTimeOrDate(), (String)"yyyy-MM-dd"));
            String currentYearMonth = dto.getStartTimeOrDate().substring(0, 7);
            while (currentYearMonth.compareTo(endYearMonthStr) != 1) {
                dto.setSalesMonth(currentYearMonth.replaceAll("-", ""));
                if (currentYearMonth.equals(beginYearMonthStr)) {
                    dto.setStartTimeOrDate(beginDate);
                    dto.setEndTimeOrDate(null);
                } else if (currentYearMonth.equals(endYearMonthStr)) {
                    dto.setStartTimeOrDate(null);
                    dto.setEndTimeOrDate(endDate);
                } else {
                    dto.setStartTimeOrDate(null);
                    dto.setEndTimeOrDate(null);
                }
                result.addAll(this.salesPerformanceMapper.findSummaryByConditions(dto));
                beginDateCalendar.add(2, 1);
                currentYearMonth = DateUtil.format((Date)beginDateCalendar.getTime(), (String)"yyyy-MM");
            }
            Map<String, List<SalesDatePeriodSummaryVo>> resultMap = result.stream().collect(Collectors.groupingBy(SalesDatePeriodSummaryVo::getProductCode));
            for (String key : resultMap.keySet()) {
                List<SalesDatePeriodSummaryVo> resultList = resultMap.get(key);
                if (!CollectionUtils.isNotEmpty(resultList)) continue;
                BigDecimal totalQuantity = resultList.stream().map(SalesDatePeriodSummaryVo::getWarehsOutDiscountAmtIncY).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
                resultList.get(0).setWarehsOutDiscountAmtIncY(totalQuantity);
                list.add(resultList.get(0));
            }
        }
        if (CollectionUtils.isNotEmpty(list)) {
            List productCodeList = list.stream().map(SalesDatePeriodSummaryVo::getProductCode).distinct().collect(Collectors.toList());
            List productVoList = this.productVoService.findMainDetailsByProductCodes(productCodeList);
            Map<String, ProductVo> productMap = productVoList.stream().collect(Collectors.toMap(ProductVo::getProductCode, v -> v, (v1, v2) -> v2));
            list.forEach(v -> {
                if (productMap.containsKey(v.getProductCode())) {
                    ProductVo productVo = (ProductVo)productMap.get(v.getProductCode());
                    v.setProductName(productVo.getProductName());
                    v.setProductBrandCode(productVo.getProductBrandCode());
                    v.setProductBrandName(productVo.getProductBrandName());
                    v.setProductCategoryCode(productVo.getProductCategoryCode());
                    v.setProductCategoryName(productVo.getProductCategoryName());
                    v.setProductItemCode(productVo.getProductLevelCode());
                    v.setProductItemName(productVo.getProductLevelName());
                }
                if (Objects.isNull(v.getWarehsOutDiscountAmtIncY())) {
                    v.setWarehsOutDiscountAmtIncY(BigDecimal.ZERO);
                }
            });
        }
        if (CollectionUtils.isNotEmpty(list = list.stream().filter(e -> Objects.nonNull(e.getWarehsOutDiscountAmtIncY()) && BigDecimal.ZERO.compareTo(e.getWarehsOutDiscountAmtIncY()) < 0).collect(Collectors.toList())) && StringUtils.isNotEmpty((CharSequence)cacheKey)) {
            Map<String, BigDecimal> map = list.stream().collect(Collectors.toMap(SalesDatePeriodSummaryVo::getProductCode, SalesDatePeriodSummaryVo::getWarehsOutDiscountAmtIncY, (v1, v2) -> v2));
            this.redisService.set(cacheKey, (Object)JSONObject.toJSONString(map), 43200L);
        }
        return list;
    }

    @Override
    public SalesPerformanceVo findSalesAmountAndOutNumber(SalesPerformanceDto dto) {
        if (StringUtils.isNotEmpty((CharSequence)dto.getSalesMonth())) {
            dto.setSalesMonth(dto.getSalesMonth().replaceAll("-", ""));
        }
        return this.salesPerformanceMapper.findSalesAmountAndOutNumber(dto);
    }

    private /* synthetic */ void lambda$saveBatchSalesPerformance$1(MasterDataMdgSalesPerformanceVo masterDataMdgSalesPerformanceVo) {
        masterDataMdgSalesPerformanceVo.setSpId(this.snowflake.nextIdStr());
    }
}

