/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.sales.goal.local.service.internal;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.sales.goal.local.entity.SalesPerformanceEntity;
import com.biz.crm.tpm.business.sales.goal.local.mapper.SalesPerformanceMapper;
import com.biz.crm.tpm.business.sales.goal.sdk.dto.SalesPerformanceDto;
import com.biz.crm.tpm.business.sales.goal.sdk.dto.SalesPerformanceStatisDto;
import com.biz.crm.tpm.business.sales.goal.sdk.eunm.MonthEnum;
import com.biz.crm.tpm.business.sales.goal.sdk.service.SalesPerformanceVoService;
import com.biz.crm.tpm.business.sales.goal.sdk.vo.SalesPerformanceStatisVo;
import com.biz.crm.tpm.business.sales.goal.sdk.vo.SalesPerformanceSumVo;
import com.biz.crm.tpm.business.sales.goal.sdk.vo.SalesPerformanceVo;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SalesPerformanceVoServiceImpl
extends ServiceImpl<SalesPerformanceMapper, SalesPerformanceEntity>
implements SalesPerformanceVoService {
    private static final Logger log = LoggerFactory.getLogger(SalesPerformanceVoServiceImpl.class);
    @Resource
    private SalesPerformanceMapper salesPerformanceMapper;

    public List<SalesPerformanceSumVo> listYearByConditions(SalesPerformanceDto dto) {
        List<String> monthList = MonthEnum.concertEnumToList();
        ArrayList<SalesPerformanceSumVo> salesPerformanceSumVos = new ArrayList<SalesPerformanceSumVo>();
        if (com.alibaba.excel.util.StringUtils.isNotBlank((CharSequence)dto.getSalesMonth())) {
            monthList = monthList.stream().filter(item -> item.equals(dto.getSalesMonth().substring(4))).collect(Collectors.toList());
        }
        log.info("\u67e5\u8be2\u4e00\u5e74\u7684\u9500\u552e\u6570\u636e,dto.getSalesMonth() ==>:{}", (Object)dto.getSalesMonth());
        log.info("\u67e5\u8be2\u4e00\u5e74\u7684\u9500\u552e\u6570\u636e,monthList ==>:{}", (Object)JSONObject.toJSONString(monthList));
        monthList.forEach(month -> {
            dto.setSalesMonth(dto.getSalesDate() + month);
            log.info("\u67e5\u8be2\u4e00\u5e74\u7684\u9500\u552e\u6570\u636e,\u5f53\u524d\u67e5\u8be2\u6708\u4efd:{},\u67e5\u8be2\u53c2\u6570:{}", (Object)dto.getSalesMonth(), (Object)dto);
            List<SalesPerformanceSumVo> salesPerformanceSums = this.salesPerformanceMapper.listByConditions(dto);
            if (!org.springframework.util.CollectionUtils.isEmpty(salesPerformanceSums)) {
                salesPerformanceSumVos.addAll(salesPerformanceSums);
            }
        });
        return salesPerformanceSumVos;
    }

    public Map<String, BigDecimal> statisSalesAmountByBrand(SalesPerformanceStatisDto dto) {
        if (Objects.isNull(dto.getActivityBeginDate()) || Objects.isNull(dto.getActivityEndDate())) {
            return Maps.newHashMap();
        }
        if (com.alibaba.excel.util.StringUtils.isBlank((CharSequence)dto.getSystemCode()) || com.alibaba.excel.util.StringUtils.isNotBlank((CharSequence)dto.getRegion())) {
            return Maps.newHashMap();
        }
        dto.setActivityBeginDateStr(DateUtil.dateToStr((SimpleDateFormat)DateUtil.date_yyyyMMdd, (Date)dto.getActivityBeginDate()));
        dto.setActivityEndDateStr(DateUtil.dateToStr((SimpleDateFormat)DateUtil.date_yyyyMMdd, (Date)dto.getActivityEndDate()));
        List yearMonthList = DateUtil.getBetweenYearMonths((Date)dto.getActivityBeginDate(), (Date)dto.getActivityEndDate(), (String)"yyyyMMdd");
        if (CollectionUtils.isEmpty((Collection)yearMonthList)) {
            return Maps.newHashMap();
        }
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        for (String s : yearMonthList) {
            dto.setYearMonthStr(s);
            List<SalesPerformanceStatisVo> list = this.salesPerformanceMapper.statisSalesAmountByBrand(dto);
            if (org.springframework.util.CollectionUtils.isEmpty(list)) continue;
            for (SalesPerformanceStatisVo vo : list) {
                if (map.containsKey(vo.getBrand())) {
                    BigDecimal b = (BigDecimal)map.get(vo.getBrand());
                    map.put(vo.getBrand(), b.add(vo.getStatisValue()));
                    continue;
                }
                map.put(vo.getBrand(), vo.getStatisValue());
            }
        }
        return map;
    }

    public SalesPerformanceVo findSalesAmountAndOutNumber(SalesPerformanceDto dto) {
        if (StringUtils.isNotEmpty((CharSequence)dto.getSalesMonth())) {
            dto.setSalesMonth(dto.getSalesMonth().replaceAll("-", ""));
        }
        return this.salesPerformanceMapper.findSalesAmountAndOutNumber(dto);
    }

    public List<SalesPerformanceVo> findSalesPerformanceSumVo(SalesPerformanceDto queryDto) {
        if (org.springframework.util.CollectionUtils.isEmpty((Collection)queryDto.getYearLyCollection()) && org.springframework.util.CollectionUtils.isEmpty((Collection)queryDto.getRegionNameCollection()) && org.springframework.util.CollectionUtils.isEmpty((Collection)queryDto.getSystemNameCollection())) {
            return Collections.emptyList();
        }
        Collection systemNameCollection = queryDto.getSystemNameCollection();
        ArrayList<SalesPerformanceVo> result = new ArrayList<SalesPerformanceVo>();
        queryDto.getYearLyCollection().forEach(yearCol -> queryDto.getRegionNameCollection().forEach(region -> {
            SalesPerformanceDto dto = new SalesPerformanceDto();
            dto.setYearCol(yearCol);
            dto.setRegion(region);
            dto.setSystemNameCollection(systemNameCollection);
            List<SalesPerformanceVo> sumVoList = this.salesPerformanceMapper.findSalesPerformanceSumVo(dto);
            if (CollectionUtil.isNotEmpty(sumVoList)) {
                result.addAll(sumVoList);
            }
        }));
        return result;
    }

    public BigDecimal findSalesAmount(SalesPerformanceDto dto) {
        if (StringUtils.isNotEmpty((CharSequence)dto.getSalesDate())) {
            dto.setSalesDate(dto.getSalesDate().replaceAll("-", ""));
        }
        if (StringUtils.isNotEmpty((CharSequence)dto.getSalesBeginDate())) {
            dto.setSalesBeginDate(dto.getSalesBeginDate().replaceAll("-", ""));
        }
        if (StringUtils.isNotEmpty((CharSequence)dto.getSalesEndDate())) {
            dto.setSalesEndDate(dto.getSalesEndDate().replaceAll("-", ""));
        }
        return this.salesPerformanceMapper.findSalesAmount(dto);
    }

    public List<SalesPerformanceVo> findListForFR(List<SalesPerformanceDto> salesPerformanceDtos) {
        return this.salesPerformanceMapper.findListForFR(salesPerformanceDtos);
    }

    public List<SalesPerformanceVo> findBusinessUnitSetTableForFR(List<SalesPerformanceDto> salesPerformanceDtos) {
        return this.salesPerformanceMapper.findBusinessUnitSetTableForFR(salesPerformanceDtos);
    }
}

