/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.sales.goal.local.service.process;

import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.mdm.business.customer.channel.sdk.service.CustomerChannelVoService;
import com.biz.crm.mdm.business.customer.channel.sdk.vo.CustomerChannelVo;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.mn.common.base.eunm.DataFromEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.sales.goal.sdk.dto.SalesGoalDto;
import com.biz.crm.tpm.business.sales.goal.sdk.service.SalesGoalService;
import com.biz.crm.tpm.business.sales.goal.sdk.vo.SalesGoalEstoreImportsVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class SalesGoalEstoreImportsProcess
implements ImportProcess<SalesGoalEstoreImportsVo> {
    private static final Logger log = LoggerFactory.getLogger(SalesGoalEstoreImportsProcess.class);
    @Autowired(required=false)
    private SalesGoalService salesGoalService;
    @Autowired(required=false)
    private CustomerVoService customerVoService;
    @Autowired(required=false)
    private DictToolkitService dictToolkitService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private CustomerChannelVoService customerChannelVoService;
    @Autowired(required=false)
    private SalesOrgVoService salesOrgVoService;

    public Integer getBatchCount() {
        return 2000;
    }

    public Map<Integer, String> execute(LinkedHashMap<Integer, SalesGoalEstoreImportsVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        try {
            Validate.notEmpty(data, (String)"\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            HashMap<String, String> mdmBusinessFormatMap = new HashMap<String, String>();
            HashMap<String, String> mdmBusinessUnitMap = new HashMap<String, String>();
            HashMap<String, List<CustomerVo>> customerVoMap = new HashMap<String, List<CustomerVo>>();
            HashMap<String, SalesOrgVo> orgVoMap = new HashMap<String, SalesOrgVo>();
            HashMap<String, CustomerChannelVo> channelVoMap = new HashMap<String, CustomerChannelVo>();
            log.info("---------------------------->\u5f00\u59cb\u6821\u9a8c\u6570\u636e\uff0c\u5f00\u59cb\u65f6\u95f4<------------------------:" + DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
            List<SalesGoalDto> importList = this.validate(data, mdmBusinessFormatMap, mdmBusinessUnitMap, customerVoMap, orgVoMap, channelVoMap);
            log.info("---------------------------->\u5f00\u59cb\u6821\u9a8c\u6570\u636e\uff0c\u7ed3\u675f\u65f6\u95f4<------------------------:" + DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
            log.info("---------------------------->\u5f00\u59cb\u4fdd\u5b58\u6570\u636e\uff0c\u5f00\u59cb\u65f6\u95f4<------------------------:" + DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
            this.salesGoalService.importSave(importList);
            log.info("---------------------------->\u5f00\u59cb\u4fdd\u5b58\u6570\u636e\uff0c\u7ed3\u675f\u65f6\u95f4<------------------------:" + DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            e.printStackTrace();
            throw e;
        }
        return null;
    }

    private List<SalesGoalDto> validate(LinkedHashMap<Integer, SalesGoalEstoreImportsVo> data, Map<String, String> mdmBusinessFormatMap, Map<String, String> mdmBusinessUnitMap, Map<String, List<CustomerVo>> customerVoMap, Map<String, SalesOrgVo> orgVoMap, Map<String, CustomerChannelVo> channelVoMap) {
        ArrayList<SalesGoalEstoreImportsVo> salesGoalVerticalImportsVos = new ArrayList<SalesGoalEstoreImportsVo>(data.values());
        log.info("---------------------------->\u5f00\u59cb\u6570\u636e\u9a8c\u7a7a\uff0c\u5f00\u59cb\u65f6\u95f4<------------------------:" + DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        salesGoalVerticalImportsVos.forEach(importsVo -> this.validateNull((SalesGoalEstoreImportsVo)importsVo));
        log.info("---------------------------->\u5f00\u59cb\u6570\u636e\u9a8c\u7a7a\uff0c\u7ed3\u675f\u65f6\u95f4<------------------------:" + DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        this.buildBaseMap(salesGoalVerticalImportsVos, mdmBusinessFormatMap, mdmBusinessUnitMap, customerVoMap, orgVoMap, channelVoMap);
        salesGoalVerticalImportsVos.forEach(importsVo -> {
            log.info("---------------------------->\u5f00\u59cb\u6821\u9a8c\u57fa\u7840\u6570\u636e\uff0c\u5f00\u59cb\u65f6\u95f4<------------------------:" + DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
            this.buildBaseData((SalesGoalEstoreImportsVo)importsVo, mdmBusinessFormatMap, mdmBusinessUnitMap, customerVoMap, orgVoMap, channelVoMap);
            log.info("---------------------------->\u5f00\u59cb\u6821\u9a8c\u57fa\u7840\u6570\u636e\uff0c\u7ed3\u675f\u65f6\u95f4<------------------------:" + DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
            log.info("---------------------------->\u5f00\u59cb\u6821\u9a8c\u6570\u5b57\uff0c\u5f00\u59cb\u65f6\u95f4<------------------------:" + DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
            this.buildDecimal((SalesGoalEstoreImportsVo)importsVo);
            log.info("---------------------------->\u5f00\u59cb\u6821\u9a8c\u6570\u5b57\uff0c\u7ed3\u675f\u65f6\u95f4<------------------------:" + DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        });
        Collection salesGoalDtoList = this.nebulaToolkitService.copyCollectionByWhiteList(salesGoalVerticalImportsVos, SalesGoalEstoreImportsVo.class, SalesGoalDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return new ArrayList<SalesGoalDto>(salesGoalDtoList);
    }

    private void validateNull(SalesGoalEstoreImportsVo importsVo) {
        if (StringUtils.isEmpty((CharSequence)importsVo.getBusinessFormatCode())) {
            throw new NullPointerException("\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((CharSequence)importsVo.getBusinessUnitCode())) {
            throw new NullPointerException("\u4e1a\u52a1\u5355\u5143\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        Validate.notBlank((CharSequence)importsVo.getSalesInstitutionCode(), (String)"\u9500\u552e\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)importsVo.getChannelCode(), (String)"\u6e20\u9053\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)importsVo.getYearMonthLy(), (String)"\u5e74\u6708\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)importsVo.getCustomerCode(), (String)"\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)importsVo.getDeliverySalesAmountStr(), (String)"\u6298\u524d\u76ee\u6807\u9500\u552e\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }

    private void buildDecimal(SalesGoalEstoreImportsVo importsVo) {
        try {
            if (!StringUtils.isEmpty((CharSequence)importsVo.getDeliverySalesAmountStr())) {
                importsVo.setDeliverySalesAmount(new BigDecimal(importsVo.getDeliverySalesAmountStr()));
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("\u6298\u524d\u9500\u552e\u989d" + importsVo.getDeliverySalesAmountStr() + "\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
    }

    private void buildBaseData(SalesGoalEstoreImportsVo importsVo, Map<String, String> mdmBusinessFormatMap, Map<String, String> mdmBusinessUnitMap, Map<String, List<CustomerVo>> customerVoMap, Map<String, SalesOrgVo> orgVoMap, Map<String, CustomerChannelVo> channelVoMap) {
        CustomerVo customerVo;
        importsVo.setDataFromCode(DataFromEnum.IMPORT.getCode());
        if (!StringUtils.isEmpty((CharSequence)importsVo.getBusinessFormatCode())) {
            if (!mdmBusinessFormatMap.containsKey(importsVo.getBusinessFormatCode())) {
                throw new IllegalArgumentException("\u4e1a\u6001" + importsVo.getBusinessFormatCode() + "\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
            importsVo.setBusinessFormatCode(mdmBusinessFormatMap.get(importsVo.getBusinessFormatCode()));
        }
        if (!StringUtils.isEmpty((CharSequence)importsVo.getBusinessUnitCode())) {
            if (!mdmBusinessUnitMap.containsKey(importsVo.getBusinessUnitCode())) {
                throw new IllegalArgumentException("\u4e1a\u52a1\u5355\u5143" + importsVo.getBusinessUnitCode() + "\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
            importsVo.setBusinessUnitCode(mdmBusinessUnitMap.get(importsVo.getBusinessUnitCode()));
        }
        if (!StringUtils.isEmpty((CharSequence)importsVo.getYearMonthLy())) {
            try {
                DateUtil.parseDate((String)importsVo.getYearMonthLy(), (String)"yyyy-MM");
            }
            catch (Exception ignored) {
                throw new IllegalArgumentException("\u5e74\u6708" + importsVo.getYearMonthLy() + "\u683c\u5f0f\u9519\u8bef\uff0c\u5e94\u8be5\u4e3a" + "yyyy-MM");
            }
        }
        if (!channelVoMap.containsKey(importsVo.getChannelCode())) {
            throw new IllegalArgumentException("\u6e20\u9053\u7f16\u7801\u3010" + importsVo.getChannelCode() + "\u3011\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        importsVo.setChannelName(channelVoMap.get(importsVo.getChannelCode()).getCustomerChannelName());
        if (!orgVoMap.containsKey(importsVo.getSalesInstitutionCode())) {
            throw new IllegalArgumentException("\u9500\u552e\u673a\u6784\u7f16\u7801\u3010" + importsVo.getSalesInstitutionCode() + "\u3011\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        importsVo.setSalesInstitutionName(orgVoMap.get(importsVo.getSalesInstitutionCode()).getSalesOrgName());
        if (StringUtils.isNotBlank((CharSequence)importsVo.getSalesOrgRegionCode())) {
            if (orgVoMap.containsKey(importsVo.getSalesOrgRegionCode())) {
                importsVo.setSalesOrgRegionName(orgVoMap.get(importsVo.getSalesOrgRegionCode()).getSalesOrgName());
            } else {
                throw new IllegalArgumentException("\u9500\u552e\u90e8\u95e8\u7f16\u7801\u3010" + importsVo.getSalesOrgRegionCode() + "\u3011\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)importsVo.getSalesOrgProvinceCode())) {
            if (orgVoMap.containsKey(importsVo.getSalesOrgProvinceCode())) {
                importsVo.setSalesOrgProvinceName(orgVoMap.get(importsVo.getSalesOrgProvinceCode()).getSalesOrgName());
            } else {
                throw new IllegalArgumentException("\u9500\u552e\u7ec4\u7f16\u7801\u3010" + importsVo.getSalesOrgProvinceCode() + "\u3011\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
        }
        if (customerVoMap.containsKey(importsVo.getCustomerCode())) {
            List<CustomerVo> list = customerVoMap.get(importsVo.getCustomerCode());
            customerVo = list.stream().filter(e -> importsVo.getChannelCode().equals(e.getCustomerChannelCode()) && importsVo.getSalesInstitutionCode().equals(e.getSalesInstitutionCode()) && importsVo.getBusinessFormatCode().equals(e.getBusinessFormatCode())).findFirst().orElse(null);
            if (customerVo == null) {
                throw new IllegalArgumentException("\u5ba2\u6237\u7f16\u7801\u3010" + importsVo.getCustomerCode() + "\u3011\u672a\u627e\u5230\u5bf9\u5e94\u5ba2\u6237\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
        } else {
            throw new IllegalArgumentException("\u5ba2\u6237\u7f16\u7801\u3010" + importsVo.getCustomerCode() + "\u3011\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        importsVo.setCustomerErpCode(importsVo.getCustomerCode());
        importsVo.setCustomerName(customerVo.getCustomerName());
        importsVo.setCustomerCode(customerVo.getCustomerCode());
    }

    private void buildBaseMap(List<SalesGoalEstoreImportsVo> salesGoalVerticalImportsVos, Map<String, String> mdmBusinessFormatMap, Map<String, String> mdmBusinessUnitMap, Map<String, List<CustomerVo>> customerVoMap, Map<String, SalesOrgVo> orgVoMap, Map<String, CustomerChannelVo> channelVoMap) {
        mdmBusinessFormatMap.putAll(this.dictToolkitService.findConvertMapByDictTypeCode("mdm_business_format"));
        mdmBusinessUnitMap.putAll(this.dictToolkitService.findConvertMapByDictTypeCode("mdm_business_unit"));
        HashSet<String> customerCodeSet = new HashSet<String>();
        HashSet<String> channelCodeSet = new HashSet<String>();
        HashSet<String> orgCodeSet = new HashSet<String>();
        for (SalesGoalEstoreImportsVo vo : salesGoalVerticalImportsVos) {
            customerCodeSet.add(vo.getCustomerCode());
            channelCodeSet.add(vo.getChannelCode());
            orgCodeSet.add(vo.getSalesInstitutionCode());
            if (StringUtils.isNotBlank((CharSequence)vo.getSalesOrgProvinceCode())) {
                orgCodeSet.add(vo.getSalesOrgProvinceCode());
            }
            if (!StringUtils.isNotBlank((CharSequence)vo.getSalesOrgRegionCode())) continue;
            orgCodeSet.add(vo.getSalesOrgRegionCode());
        }
        List customerVos = this.customerVoService.findByCustomerMdgCodes(new ArrayList(customerCodeSet));
        if (CollectionUtils.isEmpty((Collection)customerVos)) {
            throw new IllegalArgumentException("\u672a\u627e\u5230\u4efb\u610f\u5ba2\u6237\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        customerVoMap.putAll(customerVos.stream().collect(Collectors.groupingBy(e -> e.getErpCode())));
        List orgVos = this.salesOrgVoService.findBySalesOrgCodes(new ArrayList(orgCodeSet));
        if (!org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)orgVos)) {
            throw new IllegalArgumentException("\u672a\u627e\u5230\u4efb\u610f\u9500\u552e\u673a\u6784\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        orgVoMap.putAll(orgVos.stream().collect(Collectors.toMap(SalesOrgVo::getSalesOrgCode, Function.identity())));
        List channelList = this.customerChannelVoService.findByCodes(new ArrayList(channelCodeSet));
        if (CollectionUtils.isEmpty((Collection)channelList)) {
            throw new IllegalArgumentException("\u672a\u627e\u5230\u4efb\u610f\u6e20\u9053\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        channelVoMap.putAll(channelList.stream().collect(Collectors.toMap(e -> e.getCustomerChannelCode(), Function.identity())));
    }

    public Class<SalesGoalEstoreImportsVo> findCrmExcelVoClass() {
        return SalesGoalEstoreImportsVo.class;
    }

    public String getTemplateCode() {
        return "TPM_SALES_GOAL_ESTORE_IMPORT";
    }

    public String getTemplateName() {
        return "TPM\u7535\u5546\u9500\u552e\u4efb\u52a1\u5bfc\u5165";
    }

    public String getBusinessCode() {
        return "TPM_SALES_GOAL_VERTICAL_IMPORT";
    }

    public String getBusinessName() {
        return "TPM\u5782\u76f4\u9500\u552e\u76ee\u6807\u5bfc\u5165";
    }
}

