/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.sales.goal.local.service.process;

import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.mdm.business.customer.channel.sdk.service.CustomerChannelVoService;
import com.biz.crm.mdm.business.customer.channel.sdk.vo.CustomerChannelVo;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.mdm.business.product.brand.sdk.service.ProductBrandService;
import com.biz.crm.mdm.business.product.brand.sdk.vo.ProductBrandVo;
import com.biz.crm.mdm.business.product.level.sdk.service.ProductLevelVoSdkService;
import com.biz.crm.mdm.business.product.level.sdk.vo.ProductLevelVo;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.mdm.business.terminal.channel.sdk.service.MdmTerminalChannelVoService;
import com.biz.crm.mdm.business.terminal.channel.sdk.vo.MdmTerminalChannelVo;
import com.biz.crm.mdm.business.terminal.sdk.service.TerminalVoService;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalVo;
import com.biz.crm.mn.common.base.eunm.DataFromEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.budget.dimension.config.sdk.dto.DimensionInformationQueryData;
import com.biz.crm.tpm.business.budget.dimension.config.sdk.enmus.MenuCodeEnum;
import com.biz.crm.tpm.business.budget.dimension.config.sdk.service.DimensionDimensionInformationService;
import com.biz.crm.tpm.business.budget.dimension.config.sdk.vo.DimensionDimensionInformationVo;
import com.biz.crm.tpm.business.sales.goal.sdk.dto.SalesGoalDto;
import com.biz.crm.tpm.business.sales.goal.sdk.service.SalesGoalService;
import com.biz.crm.tpm.business.sales.goal.sdk.vo.SalesGoalImportsVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class SalesGoalImportsProcess
implements ImportProcess<SalesGoalImportsVo> {
    private static final Logger log = LoggerFactory.getLogger(SalesGoalImportsProcess.class);
    @Resource
    private SalesGoalService salesGoalService;
    @Resource
    private SalesOrgVoService salesOrgVoService;
    @Resource
    private CustomerChannelVoService customerChannelVoService;
    @Resource
    private MdmTerminalChannelVoService mdmTerminalChannelVoService;
    @Resource
    private ProductBrandService productBrandService;
    @Resource
    private ProductLevelVoSdkService productLevelVoSdkService;
    @Resource
    private ProductVoService productVoService;
    @Resource
    private CustomerVoService customerVoService;
    @Resource
    private TerminalVoService terminalVoService;
    @Resource
    private DictToolkitService dictToolkitService;
    @Resource
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private DimensionDimensionInformationService dimensionDimensionInformationService;
    private Map<String, String> mdmBusinessFormatMap = new HashMap<String, String>();
    private Map<String, String> mdmBusinessUnitMap = new HashMap<String, String>();
    private Map<String, String> tpmGroupCodeMap = new HashMap<String, String>();
    private Map<String, CustomerVo> customerVoMap = new HashMap<String, CustomerVo>();
    private Map<String, TerminalVo> terminalVoMap = new HashMap<String, TerminalVo>();
    private Map<String, ProductVo> productVoMap = new HashMap<String, ProductVo>();
    private Map<String, SalesOrgVo> salesOrgVoMap = new HashMap<String, SalesOrgVo>();
    private Map<String, CustomerChannelVo> customerChannelVoMap = new HashMap<String, CustomerChannelVo>();
    private Map<String, MdmTerminalChannelVo> terminalChannelVoMap = new HashMap<String, MdmTerminalChannelVo>();
    private Map<String, ProductBrandVo> productBrandVoMap = new HashMap<String, ProductBrandVo>();
    private Map<String, ProductLevelVo> productCategoryVoMap = new HashMap<String, ProductLevelVo>();
    private Map<String, ProductLevelVo> productItemVoMap = new HashMap<String, ProductLevelVo>();

    public Integer getBatchCount() {
        return 2000;
    }

    public Map<Integer, String> execute(LinkedHashMap<Integer, SalesGoalImportsVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        Validate.notEmpty(data, (String)"\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<SalesGoalDto> importList = this.validate(data);
        this.salesGoalService.importSave(importList);
        return null;
    }

    private List<SalesGoalDto> validate(LinkedHashMap<Integer, SalesGoalImportsVo> data) {
        ArrayList<SalesGoalImportsVo> salesGoalImportsVos = new ArrayList<SalesGoalImportsVo>(data.values());
        this.buildBaseMap(salesGoalImportsVos);
        HashMap dimensionMap = new HashMap(8);
        Class<SalesGoalImportsVo> clazz = SalesGoalImportsVo.class;
        salesGoalImportsVos.forEach(importsVo -> {
            this.buildDimension(dimensionMap, (SalesGoalImportsVo)importsVo, clazz);
            this.buildBaseData((SalesGoalImportsVo)importsVo);
            this.buildDecimal((SalesGoalImportsVo)importsVo);
        });
        Collection salesGoalDtoList = this.nebulaToolkitService.copyCollectionByWhiteList(salesGoalImportsVos, SalesGoalImportsVo.class, SalesGoalDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return new ArrayList<SalesGoalDto>(salesGoalDtoList);
    }

    private void buildDimension(Map<String, List<DimensionDimensionInformationVo>> dimensionMap, SalesGoalImportsVo importsVo, Class<SalesGoalImportsVo> clazz) {
        List<Object> dimensionVoList = new ArrayList();
        if (!dimensionMap.containsKey(importsVo.getBusinessFormatCode() + importsVo.getBusinessUnitCode() + MenuCodeEnum.SALES_GOAL.getCode() + importsVo.getSalesOrgCode())) {
            DimensionInformationQueryData dto = new DimensionInformationQueryData();
            dto.setBusinessFormatCode(importsVo.getBusinessFormatCode());
            dto.setBusinessUnitCode(importsVo.getBusinessUnitCode());
            dto.setMenu(MenuCodeEnum.SALES_GOAL.getCode());
            dto.setSalesOrgCodeList(Arrays.asList(importsVo.getSalesOrgCode()));
            dimensionVoList = this.dimensionDimensionInformationService.findDetailsByCodes(dto);
            dimensionMap.put(importsVo.getBusinessFormatCode() + importsVo.getBusinessUnitCode() + MenuCodeEnum.SALES_GOAL.getCode() + importsVo.getSalesOrgCode(), dimensionVoList);
        } else {
            dimensionVoList = dimensionMap.get(importsVo.getBusinessFormatCode() + importsVo.getBusinessUnitCode() + MenuCodeEnum.SALES_GOAL.getCode() + importsVo.getSalesOrgCode());
        }
        if (CollectionUtils.isEmpty(dimensionVoList)) {
            throw new RuntimeException("\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7ef4\u5ea6\u914d\u7f6e\u6570\u636e\uff01");
        }
        dimensionVoList.forEach(informationVo -> {
            try {
                if (StringUtils.isEmpty((CharSequence)informationVo.getFieldCoding())) {
                    return;
                }
                Field field = clazz.getDeclaredField(informationVo.getFieldCoding());
                field.setAccessible(true);
                Object o = field.get(importsVo);
                if (ObjectUtils.isEmpty((Object)o)) {
                    throw new RuntimeException(informationVo.getFieldName() + "\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new RuntimeException(e.getMessage());
            }
        });
        importsVo.setTypeCoding(((DimensionDimensionInformationVo)dimensionVoList.get(0)).getTypeCoding());
    }

    private void buildDecimal(SalesGoalImportsVo importsVo) {
        try {
            if (!StringUtils.isEmpty((CharSequence)importsVo.getPriceStr())) {
                importsVo.setPrice(new BigDecimal(importsVo.getPriceStr()));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("\u5355\u4ef7" + importsVo.getPriceStr() + "\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        try {
            if (!StringUtils.isEmpty((CharSequence)importsVo.getTonnageStr())) {
                importsVo.setTonnage(new BigDecimal(importsVo.getTonnageStr()));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("\u5428\u4f4d" + importsVo.getTonnageStr() + "\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        try {
            if (!StringUtils.isEmpty((CharSequence)importsVo.getTaskQuantityStr())) {
                importsVo.setTaskQuantity(new BigDecimal(importsVo.getTaskQuantityStr()));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("\u4efb\u52a1\u91cf" + importsVo.getTaskQuantityStr() + "\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        try {
            if (!StringUtils.isEmpty((CharSequence)importsVo.getPurchaseSalesAmountStr())) {
                importsVo.setPurchaseSalesAmount(new BigDecimal(importsVo.getPurchaseSalesAmountStr()));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("\u8fdb\u8d27\u6298\u524d\u9500\u552e\u989d" + importsVo.getPurchaseSalesAmountStr() + "\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        try {
            if (!StringUtils.isEmpty((CharSequence)importsVo.getPurchaseDiscountSalesAmountStr())) {
                importsVo.setPurchaseDiscountSalesAmount(new BigDecimal(importsVo.getPurchaseDiscountSalesAmountStr()));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("\u8fdb\u8d27\u6298\u540e\u9500\u552e\u989d" + importsVo.getPurchaseDiscountSalesAmountStr() + "\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        try {
            if (!StringUtils.isEmpty((CharSequence)importsVo.getDeliverySalesAmountStr())) {
                importsVo.setDeliverySalesAmount(new BigDecimal(importsVo.getDeliverySalesAmountStr()));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("\u51fa\u5e93\u6298\u524d\u9500\u552e\u989d" + importsVo.getDeliverySalesAmountStr() + "\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        try {
            if (!StringUtils.isEmpty((CharSequence)importsVo.getDeliveryDiscountSalesAmountStr())) {
                importsVo.setDeliveryDiscountSalesAmount(new BigDecimal(importsVo.getDeliveryDiscountSalesAmountStr()));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("\u51fa\u5e93\u6298\u540e\u9500\u552e\u989d" + importsVo.getDeliveryDiscountSalesAmountStr() + "\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        try {
            if (!StringUtils.isEmpty((CharSequence)importsVo.getDeliveryQuantityStr())) {
                importsVo.setDeliveryQuantity(new BigDecimal(importsVo.getDeliveryQuantityStr()));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("\u51fa\u5e93\u91cf" + importsVo.getDeliveryQuantityStr() + "\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
    }

    private void buildBaseData(SalesGoalImportsVo importsVo) {
        importsVo.setDataFromCode(DataFromEnum.IMPORT.getCode());
        if (!StringUtils.isEmpty((CharSequence)importsVo.getBusinessFormatCode())) {
            if (!this.mdmBusinessFormatMap.containsKey(importsVo.getBusinessFormatCode())) {
                throw new RuntimeException("\u4e1a\u6001" + importsVo.getBusinessFormatCode() + "\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
            importsVo.setBusinessFormatCode(this.mdmBusinessFormatMap.get(importsVo.getBusinessFormatCode()));
        }
        if (!StringUtils.isEmpty((CharSequence)importsVo.getBusinessUnitCode())) {
            if (!this.mdmBusinessUnitMap.containsKey(importsVo.getBusinessUnitCode())) {
                throw new RuntimeException("\u4e1a\u52a1\u5355\u5143" + importsVo.getBusinessUnitCode() + "\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
            importsVo.setBusinessUnitCode(this.mdmBusinessUnitMap.get(importsVo.getBusinessUnitCode()));
        }
        if (!StringUtils.isEmpty((CharSequence)importsVo.getYearMonthLy())) {
            try {
                DateUtil.parseDate((String)importsVo.getYearMonthLy(), (String)"yyyy-MM");
            }
            catch (Exception ignored) {
                throw new RuntimeException("\u5e74\u6708" + importsVo.getYearMonthLy() + "\u683c\u5f0f\u9519\u8bef\uff0c\u5e94\u8be5\u4e3a" + "yyyy-MM");
            }
        }
        if (!StringUtils.isEmpty((CharSequence)importsVo.getGroupCode())) {
            if (!this.tpmGroupCodeMap.containsKey(importsVo.getGroupCode())) {
                throw new RuntimeException("\u5206\u7ec4" + importsVo.getGroupCode() + "\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
            importsVo.setGroupCode(this.tpmGroupCodeMap.get(importsVo.getGroupCode()));
        }
        if (!StringUtils.isEmpty((CharSequence)importsVo.getSalesOrgCode())) {
            if (!this.salesOrgVoMap.containsKey(importsVo.getSalesOrgCode())) {
                throw new RuntimeException("\u9500\u552e\u7ec4\u7ec7" + importsVo.getSalesOrgCode() + "\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
            importsVo.setSalesOrgName(this.salesOrgVoMap.get(importsVo.getSalesOrgCode()).getSalesOrgName());
            importsVo.setSalesOrgLevelCode(this.salesOrgVoMap.get(importsVo.getSalesOrgCode()).getSalesOrgLevel());
        }
        if (!StringUtils.isEmpty((CharSequence)importsVo.getCustomerChannelCode())) {
            if (!this.customerChannelVoMap.containsKey(importsVo.getCustomerChannelCode())) {
                throw new RuntimeException("\u5ba2\u6237\u6e20\u9053" + importsVo.getCustomerChannelCode() + "\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
            importsVo.setCustomerChannelName(this.customerChannelVoMap.get(importsVo.getCustomerChannelCode()).getCustomerChannelName());
            importsVo.setCustomerChannelLevelCode(this.customerChannelVoMap.get(importsVo.getCustomerChannelCode()).getCustomerChannelType());
        }
        if (!StringUtils.isEmpty((CharSequence)importsVo.getTerminalChannelCode())) {
            if (!this.terminalChannelVoMap.containsKey(importsVo.getTerminalChannelCode())) {
                throw new RuntimeException("\u7ec8\u7aef\u6e20\u9053" + importsVo.getTerminalChannelCode() + "\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
            importsVo.setTerminalChannelName(this.terminalChannelVoMap.get(importsVo.getTerminalChannelCode()).getTerminalChannelName());
        }
        if (!StringUtils.isEmpty((CharSequence)importsVo.getSystemCode())) {
            // empty if block
        }
        if (!StringUtils.isEmpty((CharSequence)importsVo.getCustomerCode())) {
            if (this.customerVoMap.containsKey(importsVo.getCustomerCode())) {
                importsVo.setCustomerName(this.customerVoMap.get(importsVo.getCustomerCode()).getCustomerName());
            } else {
                throw new RuntimeException("\u5ba2\u6237\u7f16\u7801" + importsVo.getCustomerCode() + "\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
        }
        if (!StringUtils.isEmpty((CharSequence)importsVo.getTerminalCode())) {
            if (this.terminalVoMap.containsKey(importsVo.getTerminalCode())) {
                importsVo.setTerminalName(this.terminalVoMap.get(importsVo.getTerminalCode()).getTerminalName());
            } else {
                throw new RuntimeException("\u95e8\u5e97\u7f16\u7801" + importsVo.getTerminalCode() + "\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
        }
        if (!StringUtils.isEmpty((CharSequence)importsVo.getProductBrandCode())) {
            if (this.productBrandVoMap.containsKey(importsVo.getProductBrandCode())) {
                importsVo.setProductBrandName(this.productBrandVoMap.get(importsVo.getProductBrandCode()).getProductBrandName());
            } else {
                throw new RuntimeException("\u4ea7\u54c1\u54c1\u724c" + importsVo.getProductBrandCode() + "\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
        }
        if (!StringUtils.isEmpty((CharSequence)importsVo.getProductCategoryCode())) {
            if (this.productCategoryVoMap.containsKey(importsVo.getProductCategoryCode())) {
                importsVo.setProductCategoryName(this.productCategoryVoMap.get(importsVo.getProductCategoryCode()).getProductLevelName());
            } else {
                throw new RuntimeException("\u4ea7\u54c1\u54c1\u7c7b" + importsVo.getProductCategoryCode() + "\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
        }
        if (!StringUtils.isEmpty((CharSequence)importsVo.getProductItemCode())) {
            if (this.productItemVoMap.containsKey(importsVo.getProductItemCode())) {
                importsVo.setProductItemName(this.productItemVoMap.get(importsVo.getProductItemCode()).getProductLevelName());
            } else {
                throw new RuntimeException("\u4ea7\u54c1\u54c1\u9879" + importsVo.getProductCategoryCode() + "\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
        }
        if (!StringUtils.isEmpty((CharSequence)importsVo.getProductCode())) {
            if (this.productVoMap.containsKey(importsVo.getProductCode())) {
                importsVo.setProductName(this.productVoMap.get(importsVo.getProductCode()).getProductName());
            } else {
                throw new RuntimeException("\u4ea7\u54c1\u7f16\u7801" + importsVo.getProductCode() + "\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
        }
        if (!StringUtils.isEmpty((CharSequence)importsVo.getUnitCode())) {
            // empty if block
        }
    }

    private void buildBaseMap(List<SalesGoalImportsVo> salesGoalImportsVos) {
        List productVoList;
        List productLevelVos;
        List productBrandVos;
        List terminalVos;
        List customerVos;
        List mdmTerminalChannelVos;
        List customerChannelVos;
        List salesOrgVos;
        this.mdmBusinessFormatMap = this.dictToolkitService.findConvertMapByDictTypeCode("mdm_business_format");
        this.mdmBusinessUnitMap = this.dictToolkitService.findConvertMapByDictTypeCode("mdm_business_unit");
        this.tpmGroupCodeMap = this.dictToolkitService.findConvertMapByDictTypeCode("tpm_group_code");
        Set salesOrgCodeSet = salesGoalImportsVos.stream().map(SalesGoalImportsVo::getSalesOrgCode).filter(Objects::nonNull).collect(Collectors.toSet());
        Set customerChannelCodeSet = salesGoalImportsVos.stream().map(SalesGoalImportsVo::getCustomerChannelCode).filter(Objects::nonNull).collect(Collectors.toSet());
        Set terminalChannelCodeSet = salesGoalImportsVos.stream().map(SalesGoalImportsVo::getTerminalChannelCode).filter(Objects::nonNull).collect(Collectors.toSet());
        Set systemCodeSet = salesGoalImportsVos.stream().map(SalesGoalImportsVo::getSystemCode).filter(Objects::nonNull).collect(Collectors.toSet());
        Set customerCodeSet = salesGoalImportsVos.stream().map(SalesGoalImportsVo::getCustomerCode).filter(Objects::nonNull).collect(Collectors.toSet());
        Set terminalCodeSet = salesGoalImportsVos.stream().map(SalesGoalImportsVo::getTerminalCode).filter(Objects::nonNull).collect(Collectors.toSet());
        Set productBrandCodeSet = salesGoalImportsVos.stream().map(SalesGoalImportsVo::getProductBrandCode).filter(Objects::nonNull).collect(Collectors.toSet());
        Set productCategoryCodeSet = salesGoalImportsVos.stream().map(SalesGoalImportsVo::getProductCategoryCode).filter(Objects::nonNull).collect(Collectors.toSet());
        Set productItemCodeSet = salesGoalImportsVos.stream().map(SalesGoalImportsVo::getProductItemCode).filter(Objects::nonNull).collect(Collectors.toSet());
        Set productCodeSet = salesGoalImportsVos.stream().map(SalesGoalImportsVo::getProductCode).filter(Objects::nonNull).collect(Collectors.toSet());
        Set unitCodeSet = salesGoalImportsVos.stream().map(SalesGoalImportsVo::getUnitCode).filter(Objects::nonNull).collect(Collectors.toSet());
        if (!CollectionUtils.isEmpty(salesOrgCodeSet) && !CollectionUtils.isEmpty((Collection)(salesOrgVos = this.salesOrgVoService.findBySalesOrgCodes(new ArrayList(salesOrgCodeSet))))) {
            this.salesOrgVoMap = salesOrgVos.stream().collect(Collectors.toMap(SalesOrgVo::getSalesOrgCode, Function.identity()));
        }
        if (!CollectionUtils.isEmpty(customerChannelCodeSet) && !CollectionUtils.isEmpty((Collection)(customerChannelVos = this.customerChannelVoService.findByCodes(new ArrayList(customerChannelCodeSet))))) {
            this.customerChannelVoMap = customerChannelVos.stream().collect(Collectors.toMap(CustomerChannelVo::getCustomerChannelCode, Function.identity()));
        }
        if (!CollectionUtils.isEmpty(terminalChannelCodeSet) && !CollectionUtils.isEmpty((Collection)(mdmTerminalChannelVos = this.mdmTerminalChannelVoService.listByCodes(new ArrayList(terminalChannelCodeSet))))) {
            this.terminalChannelVoMap = mdmTerminalChannelVos.stream().collect(Collectors.toMap(MdmTerminalChannelVo::getTerminalChannelCode, Function.identity()));
        }
        if (!CollectionUtils.isEmpty(customerCodeSet) && !CollectionUtils.isEmpty((Collection)(customerVos = this.customerVoService.findByCustomerCodes(new ArrayList(customerCodeSet))))) {
            this.customerVoMap = customerVos.stream().collect(Collectors.toMap(CustomerVo::getCustomerCode, Function.identity()));
        }
        if (!CollectionUtils.isEmpty(terminalCodeSet) && !CollectionUtils.isEmpty((Collection)(terminalVos = this.terminalVoService.findDetailsByIdsOrTerminalCodes(null, new ArrayList(terminalCodeSet))))) {
            this.terminalVoMap = terminalVos.stream().collect(Collectors.toMap(TerminalVo::getTerminalCode, Function.identity()));
        }
        if (!CollectionUtils.isEmpty(productBrandCodeSet) && !CollectionUtils.isEmpty((Collection)(productBrandVos = this.productBrandService.listByCodes(new ArrayList(productBrandCodeSet))))) {
            this.productBrandVoMap = productBrandVos.stream().collect(Collectors.toMap(ProductBrandVo::getProductBrandCode, Function.identity()));
        }
        if (!CollectionUtils.isEmpty(productCategoryCodeSet) && !CollectionUtils.isEmpty((Collection)(productLevelVos = this.productLevelVoSdkService.findListByCodes(new ArrayList(productCategoryCodeSet))))) {
            this.productCategoryVoMap = productLevelVos.stream().collect(Collectors.toMap(ProductLevelVo::getProductLevelCode, Function.identity()));
        }
        if (!CollectionUtils.isEmpty(productItemCodeSet) && !CollectionUtils.isEmpty((Collection)(productLevelVos = this.productLevelVoSdkService.findListByCodes(new ArrayList(productItemCodeSet))))) {
            this.productItemVoMap = productLevelVos.stream().collect(Collectors.toMap(ProductLevelVo::getProductLevelCode, Function.identity()));
        }
        if (!CollectionUtils.isEmpty(productCodeSet) && !CollectionUtils.isEmpty((Collection)(productVoList = this.productVoService.findByCodes(new ArrayList(productCodeSet))))) {
            this.productVoMap = productVoList.stream().collect(Collectors.toMap(ProductVo::getProductCode, Function.identity()));
        }
    }

    public Class<SalesGoalImportsVo> findCrmExcelVoClass() {
        return SalesGoalImportsVo.class;
    }

    public String getTemplateCode() {
        return "TPM_SALES_GOAL_IMPORT";
    }

    public String getTemplateName() {
        return "TPM\u9500\u552e\u76ee\u6807\u5bfc\u5165";
    }
}

