/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.sales.goal.local.service.process;

import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.mdm.business.customer.retailer.sdk.service.CustomerRetailerVoService;
import com.biz.crm.mdm.business.customer.retailer.sdk.vo.CustomerRetailerVo;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.mdm.business.product.brand.sdk.service.ProductBrandService;
import com.biz.crm.mdm.business.product.brand.sdk.vo.ProductBrandVo;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mdm.business.terminal.sdk.service.TerminalVoService;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalVo;
import com.biz.crm.mn.common.base.eunm.DataFromEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.sales.goal.sdk.dto.SalesGoalDto;
import com.biz.crm.tpm.business.sales.goal.sdk.service.SalesGoalService;
import com.biz.crm.tpm.business.sales.goal.sdk.vo.SalesGoalVerticalImportsVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class SalesGoalVerticalImportsProcess
implements ImportProcess<SalesGoalVerticalImportsVo> {
    private static final Logger log = LoggerFactory.getLogger(SalesGoalVerticalImportsProcess.class);
    @Resource
    private SalesGoalService salesGoalService;
    @Resource
    private ProductBrandService productBrandService;
    @Resource
    private ProductVoService productVoService;
    @Resource
    private CustomerVoService customerVoService;
    @Resource
    private TerminalVoService terminalVoService;
    @Resource
    private DictToolkitService dictToolkitService;
    @Resource
    private NebulaToolkitService nebulaToolkitService;
    @Resource
    private CustomerRetailerVoService customerRetailerVoService;

    public Integer getBatchCount() {
        return 2000;
    }

    public Map<Integer, String> execute(LinkedHashMap<Integer, SalesGoalVerticalImportsVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        HashMap errorMap = Maps.newHashMap();
        try {
            Validate.notEmpty(data, (String)"\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            HashMap<String, String> mdmBusinessFormatMap = new HashMap<String, String>();
            HashMap<String, String> mdmBusinessUnitMap = new HashMap<String, String>();
            HashMap<String, String> tpmYearSalesTypeMap = new HashMap<String, String>();
            HashMap<String, String> tpmOldNewProductMap = new HashMap<String, String>();
            HashMap<String, CustomerVo> customerVoMap = new HashMap<String, CustomerVo>();
            HashMap<String, TerminalVo> terminalVoMap = new HashMap<String, TerminalVo>();
            HashMap<String, ProductVo> productVoMap = new HashMap<String, ProductVo>();
            HashMap<String, CustomerRetailerVo> customerRetailerVoMap = new HashMap<String, CustomerRetailerVo>();
            HashMap<String, ProductBrandVo> productBrandVoMap = new HashMap<String, ProductBrandVo>();
            List<SalesGoalDto> importList = this.validate(data, errorMap, mdmBusinessFormatMap, mdmBusinessUnitMap, tpmYearSalesTypeMap, tpmOldNewProductMap, customerVoMap, terminalVoMap, productVoMap, customerRetailerVoMap, productBrandVoMap);
            if (errorMap.size() == 0) {
                this.salesGoalService.importSave(importList);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        return errorMap;
    }

    private List<SalesGoalDto> validate(LinkedHashMap<Integer, SalesGoalVerticalImportsVo> data, Map<Integer, String> errorMap, Map<String, String> mdmBusinessFormatMap, Map<String, String> mdmBusinessUnitMap, Map<String, String> tpmYearSalesTypeMap, Map<String, String> tpmOldNewProductMap, Map<String, CustomerVo> customerVoMap, Map<String, TerminalVo> terminalVoMap, Map<String, ProductVo> productVoMap, Map<String, CustomerRetailerVo> customerRetailerVoMap, Map<String, ProductBrandVo> productBrandVoMap) {
        ArrayList<SalesGoalVerticalImportsVo> salesGoalVerticalImportsVos = new ArrayList<SalesGoalVerticalImportsVo>(data.values());
        this.buildBaseMap(salesGoalVerticalImportsVos, mdmBusinessFormatMap, mdmBusinessUnitMap, tpmYearSalesTypeMap, tpmOldNewProductMap, customerVoMap, terminalVoMap, productVoMap, customerRetailerVoMap, productBrandVoMap);
        ArrayList list = Lists.newArrayList();
        for (Map.Entry<Integer, SalesGoalVerticalImportsVo> entry : data.entrySet()) {
            try {
                SalesGoalVerticalImportsVo importsVo = entry.getValue();
                this.validateNull(importsVo);
                this.buildBaseData(importsVo, mdmBusinessFormatMap, mdmBusinessUnitMap, tpmYearSalesTypeMap, tpmOldNewProductMap, customerVoMap, terminalVoMap, productVoMap, customerRetailerVoMap, productBrandVoMap);
                this.buildDecimal(importsVo);
                SalesGoalDto dto = (SalesGoalDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)importsVo, SalesGoalDto.class, HashSet.class, ArrayList.class, new String[0]);
                if (StringUtils.isNotEmpty((CharSequence)dto.getProductCode()) && productVoMap.containsKey(dto.getProductCode())) {
                    ProductVo productVo = productVoMap.get(dto.getProductCode());
                    dto.setProductBrandCode(productVo.getProductBrandCode());
                    dto.setProductBrandName(productVo.getProductBrandName());
                    dto.setProductItemCode(productVo.getProductLevelCode());
                    dto.setProductItemName(productVo.getProductLevelName());
                    dto.setProductCategoryCode(productVo.getProductCategoryCode());
                    dto.setProductCategoryName(productVo.getProductCategoryName());
                }
                list.add(dto);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                errorMap.put(entry.getKey(), null == e.getMessage() ? "\u6570\u636e\u5904\u7406\u5f02\u5e38" : e.getMessage());
            }
        }
        return list;
    }

    public List<SalesGoalDto> testClass(List<SalesGoalVerticalImportsVo> salesGoalVerticalImportsVos) {
        HashMap<String, String> mdmBusinessFormatMap = new HashMap<String, String>();
        HashMap<String, String> mdmBusinessUnitMap = new HashMap<String, String>();
        HashMap<String, String> tpmYearSalesTypeMap = new HashMap<String, String>();
        HashMap<String, String> tpmOldNewProductMap = new HashMap<String, String>();
        HashMap<String, CustomerVo> customerVoMap = new HashMap<String, CustomerVo>();
        HashMap<String, TerminalVo> terminalVoMap = new HashMap<String, TerminalVo>();
        HashMap<String, ProductVo> productVoMap = new HashMap<String, ProductVo>();
        HashMap<String, CustomerRetailerVo> customerRetailerVoMap = new HashMap<String, CustomerRetailerVo>();
        HashMap<String, ProductBrandVo> productBrandVoMap = new HashMap<String, ProductBrandVo>();
        this.buildBaseMap(salesGoalVerticalImportsVos, mdmBusinessFormatMap, mdmBusinessUnitMap, tpmYearSalesTypeMap, tpmOldNewProductMap, customerVoMap, terminalVoMap, productVoMap, customerRetailerVoMap, productBrandVoMap);
        salesGoalVerticalImportsVos.forEach(importsVo -> {
            this.validateNull((SalesGoalVerticalImportsVo)importsVo);
            this.buildBaseData((SalesGoalVerticalImportsVo)importsVo, (Map<String, String>)mdmBusinessFormatMap, (Map<String, String>)mdmBusinessUnitMap, (Map<String, String>)tpmYearSalesTypeMap, (Map<String, String>)tpmOldNewProductMap, (Map<String, CustomerVo>)customerVoMap, (Map<String, TerminalVo>)terminalVoMap, (Map<String, ProductVo>)productVoMap, (Map<String, CustomerRetailerVo>)customerRetailerVoMap, (Map<String, ProductBrandVo>)productBrandVoMap);
            this.buildDecimal((SalesGoalVerticalImportsVo)importsVo);
        });
        Collection salesGoalDtoList = this.nebulaToolkitService.copyCollectionByWhiteList(salesGoalVerticalImportsVos, SalesGoalVerticalImportsVo.class, SalesGoalDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return new ArrayList<SalesGoalDto>(salesGoalDtoList);
    }

    private void validateNull(SalesGoalVerticalImportsVo importsVo) {
        if (StringUtils.isEmpty((CharSequence)importsVo.getBusinessFormatCode())) {
            throw new NullPointerException("\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }

    private void buildDecimal(SalesGoalVerticalImportsVo importsVo) {
        try {
            if (!StringUtils.isEmpty((CharSequence)importsVo.getDeliveryQuantityStr())) {
                importsVo.setDeliveryQuantity(new BigDecimal(importsVo.getDeliveryQuantityStr()));
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("\u51fa\u5e93\u91cf" + importsVo.getDeliveryQuantityStr() + "\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        try {
            if (!StringUtils.isEmpty((CharSequence)importsVo.getDeliverySalesAmountStr())) {
                importsVo.setDeliverySalesAmount(new BigDecimal(importsVo.getDeliverySalesAmountStr()));
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("\u6298\u524d\u9500\u552e\u989d" + importsVo.getDeliverySalesAmountStr() + "\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        try {
            if (!StringUtils.isEmpty((CharSequence)importsVo.getDeliveryDiscountSalesAmountStr())) {
                importsVo.setDeliveryDiscountSalesAmount(new BigDecimal(importsVo.getDeliveryDiscountSalesAmountStr()));
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("\u6298\u540e\u9500\u552e\u989d" + importsVo.getDeliveryDiscountSalesAmountStr() + "\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
    }

    private void buildBaseData(SalesGoalVerticalImportsVo importsVo, Map<String, String> mdmBusinessFormatMap, Map<String, String> mdmBusinessUnitMap, Map<String, String> tpmYearSalesTypeMap, Map<String, String> tpmOldNewProductMap, Map<String, CustomerVo> customerVoMap, Map<String, TerminalVo> terminalVoMap, Map<String, ProductVo> productVoMap, Map<String, CustomerRetailerVo> customerRetailerVoMap, Map<String, ProductBrandVo> productBrandVoMap) {
        importsVo.setDataFromCode(DataFromEnum.IMPORT.getCode());
        if (!StringUtils.isEmpty((CharSequence)importsVo.getBusinessFormatCode())) {
            if (!mdmBusinessFormatMap.containsKey(importsVo.getBusinessFormatCode())) {
                throw new IllegalArgumentException("\u4e1a\u6001" + importsVo.getBusinessFormatCode() + "\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
            importsVo.setBusinessFormatCode(mdmBusinessFormatMap.get(importsVo.getBusinessFormatCode()));
        }
        if (!StringUtils.isEmpty((CharSequence)importsVo.getBusinessUnitCode())) {
            if (!mdmBusinessUnitMap.containsKey(importsVo.getBusinessUnitCode())) {
                throw new IllegalArgumentException("\u4e1a\u52a1\u5355\u5143" + importsVo.getBusinessUnitCode() + "\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
            importsVo.setBusinessUnitCode(mdmBusinessUnitMap.get(importsVo.getBusinessUnitCode()));
        }
        if (!StringUtils.isEmpty((CharSequence)importsVo.getYearSalesTypeCode())) {
            if (!tpmYearSalesTypeMap.containsKey(importsVo.getYearSalesTypeCode())) {
                throw new IllegalArgumentException("\u5e74\u5ea6\u9500\u91cf\u5206\u7c7b" + importsVo.getYearSalesTypeCode() + "\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
            importsVo.setYearSalesTypeCode(tpmYearSalesTypeMap.get(importsVo.getYearSalesTypeCode()));
        }
        if (!StringUtils.isEmpty((CharSequence)importsVo.getYearMonthLy())) {
            try {
                DateUtil.parseDate((String)importsVo.getYearMonthLy(), (String)"yyyy-MM");
            }
            catch (Exception ignored) {
                throw new IllegalArgumentException("\u5e74\u6708" + importsVo.getYearMonthLy() + "\u683c\u5f0f\u9519\u8bef\uff0c\u5e94\u8be5\u4e3a" + "yyyy-MM");
            }
        }
        if (!StringUtils.isEmpty((CharSequence)importsVo.getSystemCode())) {
            if (customerRetailerVoMap.containsKey(importsVo.getSystemCode())) {
                importsVo.setSystemName(customerRetailerVoMap.get(importsVo.getSystemCode()).getCustomerRetailerName());
            } else {
                throw new IllegalArgumentException("\u96f6\u552e\u5546\u7f16\u7801" + importsVo.getSystemCode() + "\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
        }
        if (!StringUtils.isEmpty((CharSequence)importsVo.getCustomerCode())) {
            if (customerVoMap.containsKey(importsVo.getCustomerCode())) {
                importsVo.setCustomerName(customerVoMap.get(importsVo.getCustomerCode()).getCustomerName());
            } else {
                throw new IllegalArgumentException("\u552e\u8fbe\u65b9\u7f16\u7801" + importsVo.getCustomerCode() + "\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
        }
        if (!StringUtils.isEmpty((CharSequence)importsVo.getTerminalCode())) {
            if (terminalVoMap.containsKey(importsVo.getTerminalCode())) {
                importsVo.setTerminalName(terminalVoMap.get(importsVo.getTerminalCode()).getTerminalName());
            } else {
                throw new IllegalArgumentException("\u9001\u8fbe\u65b9\u7f16\u7801" + importsVo.getTerminalCode() + "\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
        }
        if (!StringUtils.isEmpty((CharSequence)importsVo.getProductBrandCode())) {
            if (productBrandVoMap.containsKey(importsVo.getProductBrandCode())) {
                importsVo.setProductBrandName(productBrandVoMap.get(importsVo.getProductBrandCode()).getProductBrandName());
            } else {
                throw new IllegalArgumentException("\u4ea7\u54c1\u54c1\u724c" + importsVo.getProductBrandCode() + "\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
        }
        if (!StringUtils.isEmpty((CharSequence)importsVo.getProductCode())) {
            if (productVoMap.containsKey(importsVo.getProductCode())) {
                importsVo.setProductName(productVoMap.get(importsVo.getProductCode()).getProductName());
            } else {
                throw new IllegalArgumentException("\u4ea7\u54c1\u7f16\u7801" + importsVo.getProductCode() + "\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
        }
    }

    private void buildBaseMap(List<SalesGoalVerticalImportsVo> salesGoalVerticalImportsVos, Map<String, String> mdmBusinessFormatMap, Map<String, String> mdmBusinessUnitMap, Map<String, String> tpmYearSalesTypeMap, Map<String, String> tpmOldNewProductMap, Map<String, CustomerVo> customerVoMap, Map<String, TerminalVo> terminalVoMap, Map<String, ProductVo> productVoMap, Map<String, CustomerRetailerVo> customerRetailerVoMap, Map<String, ProductBrandVo> productBrandVoMap) {
        List customerRetailerVos;
        List productVoList;
        List productBrandVos;
        List terminalVos;
        List customerVos;
        mdmBusinessFormatMap.putAll(this.dictToolkitService.findConvertMapByDictTypeCode("mdm_business_format"));
        mdmBusinessUnitMap.putAll(this.dictToolkitService.findConvertMapByDictTypeCode("mdm_business_unit"));
        tpmYearSalesTypeMap.putAll(this.dictToolkitService.findConvertMapByDictTypeCode("tpm_year_sales_type"));
        tpmOldNewProductMap.putAll(this.dictToolkitService.findConvertMapByDictTypeCode("tpm_old_new_product"));
        Set systemCodeSet = salesGoalVerticalImportsVos.stream().map(SalesGoalVerticalImportsVo::getSystemCode).filter(Objects::nonNull).collect(Collectors.toSet());
        Set customerCodeSet = salesGoalVerticalImportsVos.stream().map(SalesGoalVerticalImportsVo::getCustomerCode).filter(Objects::nonNull).collect(Collectors.toSet());
        Set terminalCodeSet = salesGoalVerticalImportsVos.stream().map(SalesGoalVerticalImportsVo::getTerminalCode).filter(Objects::nonNull).collect(Collectors.toSet());
        Set productBrandCodeSet = salesGoalVerticalImportsVos.stream().map(SalesGoalVerticalImportsVo::getProductBrandCode).filter(Objects::nonNull).collect(Collectors.toSet());
        Set productCodeSet = salesGoalVerticalImportsVos.stream().map(SalesGoalVerticalImportsVo::getProductCode).filter(Objects::nonNull).collect(Collectors.toSet());
        if (!CollectionUtils.isEmpty(customerCodeSet) && !CollectionUtils.isEmpty((Collection)(customerVos = this.customerVoService.findBaseByCustomerCodes(new ArrayList(customerCodeSet))))) {
            customerVoMap.putAll(customerVos.stream().collect(Collectors.toMap(CustomerVo::getCustomerCode, Function.identity())));
        }
        if (!CollectionUtils.isEmpty(terminalCodeSet) && !CollectionUtils.isEmpty((Collection)(terminalVos = this.terminalVoService.findDetailsByIdsOrTerminalCodes(null, new ArrayList(terminalCodeSet))))) {
            terminalVoMap.putAll(terminalVos.stream().collect(Collectors.toMap(TerminalVo::getTerminalCode, Function.identity())));
        }
        if (!CollectionUtils.isEmpty(productBrandCodeSet) && !CollectionUtils.isEmpty((Collection)(productBrandVos = this.productBrandService.listByCodes(new ArrayList(productBrandCodeSet))))) {
            productBrandVoMap.putAll(productBrandVos.stream().collect(Collectors.toMap(ProductBrandVo::getProductBrandCode, Function.identity())));
        }
        if (!CollectionUtils.isEmpty(productCodeSet) && !CollectionUtils.isEmpty((Collection)(productVoList = this.productVoService.findByCodes(new ArrayList(productCodeSet))))) {
            productVoMap.putAll(productVoList.stream().collect(Collectors.toMap(ProductVo::getProductCode, Function.identity())));
        }
        if (!CollectionUtils.isEmpty(systemCodeSet) && !CollectionUtils.isEmpty((Collection)(customerRetailerVos = this.customerRetailerVoService.findByCodes(new ArrayList(systemCodeSet))))) {
            customerRetailerVoMap.putAll(customerRetailerVos.stream().collect(Collectors.toMap(CustomerRetailerVo::getCustomerRetailerCode, Function.identity())));
        }
    }

    public Class<SalesGoalVerticalImportsVo> findCrmExcelVoClass() {
        return SalesGoalVerticalImportsVo.class;
    }

    public String getTemplateCode() {
        return "TPM_SALES_GOAL_VERTICAL_IMPORT";
    }

    public String getTemplateName() {
        return "TPM\u5782\u76f4\u9500\u552e\u76ee\u6807\u5bfc\u5165";
    }
}

