/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.sales.goal.local.task.imp;

import com.alibaba.fastjson.JSON;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.third.system.master.data.mdg.sdk.dto.MasterDataMdgSalesPerformanceDto;
import com.biz.crm.mn.third.system.master.data.mdg.sdk.service.MasterDataMdgService;
import com.biz.crm.tpm.business.sales.goal.local.service.SalesPerformanceService;
import com.biz.crm.tpm.business.sales.goal.sdk.task.PullSalesPerformanceTask;
import com.bizunited.nebula.task.annotations.DynamicTaskService;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class PullSalesPerformanceTaskImpl
implements PullSalesPerformanceTask {
    private static final Logger log = LoggerFactory.getLogger(PullSalesPerformanceTaskImpl.class);
    @Value(value="${salesPerformance.pageSize:}")
    private String pageSize;
    @Value(value="${salesPerformance.appCode:}")
    private String appCode;
    @Value(value="${salesPerformance.advancedDay:}")
    private Integer advancedDay;
    @Autowired(required=false)
    private MasterDataMdgService masterDataMdgService;
    @Autowired(required=false)
    private SalesPerformanceService salesPerformanceService;
    @Autowired(required=false)
    private RedisLockService redisLockService;
    @Autowired(required=false)
    private LoginUserService loginUserService;

    @Transactional
    public void timedTaskPull() {
        log.info("----> {}\u6267\u884c\u5b9a\u65f6\u4efb\u52a1 <----", (Object)this.getDateAndTime("dateTime"));
        MasterDataMdgSalesPerformanceDto dto = new MasterDataMdgSalesPerformanceDto();
        this.pullPriorMonthDate(dto);
        this.pullCurrentMonthData(dto);
        log.info("----> {}\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u5b8c\u6bd5 <----", (Object)this.getDateAndTime("dateTime"));
    }

    @DynamicTaskService(cornExpression="0 0 6,13,18 * * ?", taskDesc="6\uff0c13\uff0c18\u70b9\u62c9\u5782\u76f4\u65e5\u9500\u552e\u6570\u636e")
    public void timedTaskPullDay() {
        this.loginUserService.refreshAuthentication(null);
        Date date = new Date();
        long startTime = date.getTime();
        log.info("----> {}\u6267\u884c\u5b9a\u65f6\u4efb\u52a1 <----", (Object)this.getDateAndTime("dateTime"));
        MasterDataMdgSalesPerformanceDto dto = new MasterDataMdgSalesPerformanceDto();
        this.pullPriorFiveDay(dto);
        log.info("----> {}\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u5b8c\u6bd5 <----", (Object)this.getDateAndTime("dateTime"));
        long endTime = date.getTime();
        int minutes = (int)((endTime - startTime) / 60000L);
        log.info("\u603b\u5171\u8017\u65f6 {} \u5206\u949f", (Object)minutes);
    }

    public void pullDayData(String data) {
        try {
            DateUtil.date_yyyyMMdd.parse(data);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("\u65e5\u671f\u683c\u5f0f\u9519\u8bef\u3010yyyyMMdd \u4f8b\uff1a20230206\u3011");
        }
        MasterDataMdgSalesPerformanceDto dto = new MasterDataMdgSalesPerformanceDto();
        this.setDate(dto);
        boolean hasLock = false;
        String key = "vertical_sales_performance:lock";
        try {
            hasLock = this.redisLockService.tryLock(key, TimeUnit.DAYS, 1L);
            if (hasLock) {
                dto.setSalesDay(data);
                dto.setSalesMonth(data.substring(0, 6));
                dto.setSalesYear(data.substring(0, 4));
                this.pullSalesPerformance(dto);
            }
        }
        catch (Exception e) {
            log.error("\u62c9\u53d6\u5782\u76f4\u9500\u552e\u4e1a\u7ee9\u6570\u636e\u5931\u8d25", (Throwable)e);
            throw e;
        }
        finally {
            if (hasLock) {
                this.redisLockService.unlock("vertical_sales_performance:lock");
            }
        }
    }

    private void pullPriorFiveDay(MasterDataMdgSalesPerformanceDto dto) {
        Integer advancedDay = this.advancedDay;
        this.setDate(dto);
        boolean hasLock = false;
        String key = "vertical_sales_performance:lock";
        try {
            hasLock = this.redisLockService.tryLock(key, TimeUnit.DAYS, 1L);
            if (hasLock) {
                while (advancedDay > 0) {
                    LocalDate date = LocalDate.now().minusDays(advancedDay.intValue());
                    String salesDay = date.format(DateTimeFormatter.ofPattern("yyyyMMdd"));
                    dto.setSalesDay(salesDay);
                    dto.setSalesYear(String.valueOf(date.getYear()));
                    String salesMonth = date.format(DateTimeFormatter.ofPattern("yyyyMM"));
                    dto.setSalesMonth(salesMonth);
                    this.pullSalesPerformance(dto);
                    Integer n = advancedDay;
                    Integer n2 = advancedDay = Integer.valueOf(advancedDay - 1);
                }
            }
        }
        catch (Exception e) {
            log.error("\u62c9\u53d6\u5782\u76f4\u9500\u552e\u4e1a\u7ee9\u6570\u636e\u5931\u8d25", (Throwable)e);
            throw e;
        }
        finally {
            if (hasLock) {
                this.redisLockService.unlock("vertical_sales_performance:lock");
            }
        }
    }

    private void setDate(MasterDataMdgSalesPerformanceDto dto) {
        dto.setPageSize(this.pageSize);
        dto.setAppCode(this.appCode);
        String date = DateUtil.format((Date)new Date(), (String)"yyyyMMdd");
        dto.setDs(date);
    }

    private void pullPriorMonthDate(MasterDataMdgSalesPerformanceDto dto) {
        dto.setPageSize(this.pageSize);
        dto.setAppCode(this.appCode);
        dto.setDs(this.getDateAndTime("TheDayBefore"));
        if ("1".equals(this.getDateAndTime("month"))) {
            dto.setSalesYear(this.getDateAndTime("TheYearBefore"));
        }
        dto.setSalesMonth(this.getDateAndTime("TheMonthBefore"));
        this.pullSalesPerformance(dto);
    }

    private void pullCurrentMonthData(MasterDataMdgSalesPerformanceDto dto) {
        dto.setPageSize(this.pageSize);
        dto.setAppCode(this.appCode);
        dto.setDs(this.getDateAndTime("TheDayBefore"));
        dto.setSalesMonth(this.getDateAndTime("month"));
        dto.setSalesYear(this.getDateAndTime("year"));
        this.pullSalesPerformance(dto);
    }

    private void pullSalesPerformance(MasterDataMdgSalesPerformanceDto dto) {
        Integer total = this.masterDataMdgService.getSalesPerformanceTotal(dto);
        Integer size = Integer.valueOf(this.pageSize);
        Integer page = total / size;
        page = total % size == 0 ? page : page + 1;
        log.info("\u65e5\u671f\u4e3a{}, \u5171{}\u6761\u6570\u636e, \u9700\u8c03\u7528{}\u6b21, \u6bcf\u6b21\u83b7\u53d6{}\u6761\u6570\u636e", new Object[]{dto.getSalesDay(), total, page, size});
        Integer count = this.salesPerformanceService.totalCount(dto);
        Integer delPage = count / size;
        delPage = count % size == 0 ? delPage : delPage + 1;
        this.salesPerformanceService.removeBatch(dto, delPage, size);
        for (int i = 1; i <= page; ++i) {
            Integer pageNumber = i;
            dto.setPageNum(pageNumber.toString());
            log.info("{},\u5f00\u59cb\u62c9\u53d6\u5782\u76f4\u9500\u552e\u4e1a\u7ee9", (Object)this.getDateAndTime("dateTime"));
            List masterDataMdgSalesPerformanceVos = null;
            int flag = 0;
            do {
                try {
                    masterDataMdgSalesPerformanceVos = this.masterDataMdgService.pullSalesPerformance(dto);
                    flag = 3;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    ++flag;
                    log.error("\u53d6\u5782\u76f4\u9500\u552e\u4e1a\u7ee9\u6570\u636e\u5931\u8d25\u5f02\u5e38", (Throwable)e);
                }
            } while (flag < 3);
            log.info("{},\u62c9\u53d6\u6570\u636e\u6210\u529f\uff0c\u62c9\u53d6\u6570\u636e\u4e3a{}", (Object)this.getDateAndTime("dateTime"));
            JSON.toJSONString((Object)masterDataMdgSalesPerformanceVos);
            this.salesPerformanceService.saveBatchSalesPerformance(masterDataMdgSalesPerformanceVos, dto);
            log.info("{} \u7b2c{}\u6279\u6570\u636e\u4fdd\u5b58\u6210\u529f", (Object)dto.getSalesDay(), (Object)dto.getPageNum());
        }
    }

    private String getDateAndTime(String flag) {
        if ("TheDayBefore".equals(flag)) {
            LocalDate localDate = LocalDate.now().minusDays(1L);
            return localDate.format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        }
        if ("TheMonthBefore".equals(flag)) {
            LocalDate localDate = LocalDate.now().minusMonths(1L);
            return String.valueOf(localDate.getMonthValue());
        }
        if ("TheYearBefore".equals(flag)) {
            LocalDate localDate = LocalDate.now().minusYears(1L);
            return localDate.getYear() + String.valueOf(localDate.getMonthValue());
        }
        if ("year".equals(flag)) {
            LocalDate localDate = LocalDate.now();
            return String.valueOf(localDate.getYear());
        }
        if ("month".equals(flag)) {
            LocalDate localDate = LocalDate.now();
            return localDate.getYear() + String.valueOf(localDate.getYear());
        }
        Date date = new Date();
        if ("dateTime".equals(flag)) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            return format.format(date);
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        return format.format(date);
    }
}

