/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.sales.goal.local.xxjob;

import com.alibaba.fastjson.JSON;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.third.system.master.data.mdg.sdk.dto.MasterDataMdgBaseDto;
import com.biz.crm.tpm.business.sales.goal.sdk.service.SalesGoalService;
import com.bizunited.nebula.task.annotations.DynamicTaskService;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PullSalesDayReportXxJob {
    private static final Logger log = LoggerFactory.getLogger(PullSalesDayReportXxJob.class);
    @Autowired(required=false)
    private SalesGoalService salesGoalService;
    @Autowired(required=false)
    private DictToolkitService dictToolkitService;
    @Autowired(required=false)
    private LoginUserService loginUserService;

    @DynamicTaskService(cornExpression="0 0 5 * * ?", taskDesc="\u65e5\u9500\u552e\u6570\u636e\u62c9\u53bb\u5b9a\u65f6\u4efb\u52a1")
    public void pullSalesDayReportXxJob() {
        log.info("=====>    \u65e5\u9500\u552e\u6570\u636e\u62c9\u53bb\u5b9a\u65f6\u4efb\u52a1[{}] start    <=====", (Object)DateUtil.dateStrNowAll());
        this.loginUserService.refreshAuthentication(null);
        AbstractCrmUserIdentity loginDetails = this.loginUserService.getAbstractLoginUser();
        Map map = this.dictToolkitService.findMapByDictTypeCode("sales_goal_pull_sales_org");
        if (map.isEmpty()) {
            return;
        }
        log.info("=====>    \u65e5\u9500\u552e\u6570\u636e\u62c9\u53bb\u5b9a\u65f6\u4efb\u52a1\uff1a\u62c9\u53d6\u8303\u56f4\uff1a[{}] <=====", (Object)JSON.toJSONString((Object)map));
        for (String s : map.keySet()) {
            log.info("=====>    \u65e5\u9500\u552e\u6570\u636e\u62c9\u53bb\u5b9a\u65f6\u4efb\u52a1\uff1a\u62c9\u53d6\u8303\u56f4\uff1a[{}] \u5f00\u59cb<=====", map.get(s));
            MasterDataMdgBaseDto dto = new MasterDataMdgBaseDto();
            dto.setFullPullFlag(BooleanEnum.TRUE.getCapital());
            dto.setSales_organization(s);
            dto.setPageNum("1");
            dto.setPageSize("2000");
            Calendar calendar = Calendar.getInstance();
            calendar.add(5, -5);
            for (int i = 0; i < 5; ++i) {
                dto.setD_id(String.format("%02d", calendar.get(5)));
                dto.setM_id(String.format("%02d", calendar.get(2) + 1));
                dto.setY_id(String.format("%02d", calendar.get(1)));
                this.salesGoalService.pullSalesDayReport(dto);
                log.info("=====>    \u65e5\u9500\u552e\u6570\u636e\u62c9\u53bb\u5b9a\u65f6\u4efb\u52a1\uff1a\u62c9\u53d6\u6570\u636e\uff1a\u65e5\u671f{} \u7ed3\u675f<=====", (Object)DateUtil.dateToStr((SimpleDateFormat)DateUtil.date_yyyy_MM_dd, (Date)calendar.getTime()));
                calendar.add(5, 1);
            }
            log.info("=====>    \u65e5\u9500\u552e\u6570\u636e\u62c9\u53bb\u5b9a\u65f6\u4efb\u52a1\uff1a\u62c9\u53d6\u8303\u56f4\uff1a[{}] \u7ed3\u675f<=====", map.get(s));
        }
        log.info("=====>    \u65e5\u9500\u552e\u6570\u636e\u62c9\u53bb\u5b9a\u65f6\u4efb\u52a1[{}] end    <=====", (Object)DateUtil.dateStrNowAll());
    }
}

