package com.biz.crm.tpm.business.sales.goal.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @author ：dengwei
 * @date ：Created in 2023/1/7 16:17
 * @description：主体日销售数据
 */
@Data
public class MainOneDaySalesDto extends TenantFlagOpDto {

    @ApiModelProperty(value = "年月", notes = "")
    private String yearMonthLy;

    @ApiModelProperty("年月日")
    private String yearMonthDay;

    @ApiModelProperty("业态编码")
    private String businessFormatCode;

    @ApiModelProperty("业态名称")
    private String businessFormatName;

//    @ApiModelProperty("销售机构编码")
//    private String salesOrganizationCode;
//
//    @ApiModelProperty("销售机构名称")
//    private String salesOrganizationName;
//
//    @ApiModelProperty("销售部门编码")
//    private String salesOrgCode;
//
//    @ApiModelProperty("销售部门名称")
//    private String salesOrgName;
//
//    @ApiModelProperty("销售组编码")
//    private String salesGroupCode;
//
//    @ApiModelProperty("销售组名称")
//    private String salesGroupName;

    @ApiModelProperty(name = "salesInstitutionCode", value = "销售机构编码", notes = "销售机构编码")
    private String salesInstitutionCode;

    @ApiModelProperty(name = "salesInstitutionName", value = "销售机构名称", notes = "销售机构名称")
    private String salesInstitutionName;

    @ApiModelProperty(name = "salesInstitutionErpCode", value = "销售机构编码", notes = "销售机构erp编码")
    private String salesInstitutionErpCode;

    @ApiModelProperty(name = "销售组织编码（大区）", notes = "")
    private String salesOrgRegionCode;

    @ApiModelProperty(name = "销售组织名称（大区）", notes = "")
    private String salesOrgRegionName;

    @ApiModelProperty(name = "销售组织erp编码（大区）", notes = "")
    private String salesOrgRegionErpCode;

    @ApiModelProperty(name = "销售组织编码（省区）", notes = "")
    private String salesOrgProvinceCode;

    @ApiModelProperty(name = "销售组织名称（省区）", notes = "")
    private String salesOrgProvinceName;

    @ApiModelProperty(name = "销售组织erp编码（省区）", notes = "")
    private String salesOrgProvinceErpCode;

    @ApiModelProperty("客户编码")
    private String customerCode;

    @ApiModelProperty("客户名称")
    private String customerName;

    @ApiModelProperty("客户erp编码")
    private String customerErpCode;

    @ApiModelProperty("渠道编码")
    private String channelCode;

    @ApiModelProperty("渠道名称")
    private String channelName;

    @ApiModelProperty("客户分类编码")
    private String customerClassifyCode;

    @ApiModelProperty("客户分类名称")
    private String customerClassifyName;

    @ApiModelProperty("产品编码")
    private String productCode;

    @ApiModelProperty("产品名称")
    private String productName;

    @ApiModelProperty("新品/老品")
    private String newAndOldProduct;

    @ApiModelProperty("销量")
    private BigDecimal saleQuantity;

    @ApiModelProperty("折前销售额")
    private BigDecimal discountFrontSaleAmount;

    @ApiModelProperty("折后销售额（不含奶卡）")
    private BigDecimal discountBehindSaleAmount;

    @ApiModelProperty("奶卡折后订单额（toB）")
    private BigDecimal milkCardDiscountBehindOrderAmountToB;

    @ApiModelProperty("奶卡折后订单额（toC）")
    private BigDecimal milkCardDiscountBehindOrderAmountToC;

    /**
     * 品牌编码
     */
    @ApiModelProperty("品牌编码")
    private String productBrandCode;
    /**
     * 品牌名称
     */
    @ApiModelProperty("品牌名称")
    private String productBrandName;
    /**
     * 品类编码
     */
    @ApiModelProperty("品类编码")
    private String productCategoryCode;
    /**
     * 品类名称
     */
    @ApiModelProperty("品类名称")
    private String productCategoryName;
    /**
     * 品项编码
     */
    @ApiModelProperty("品项编码")
    private String productItemCode;
    /**
     * 品项名称
     */
    @ApiModelProperty("品项名称")
    private String productItemName;

    @ApiModelProperty("唯一键")
    private String onlyKey;

}
