package com.biz.crm.tpm.business.sales.goal.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.util.List;

/**
 * @author chenlong
 * @date 2022/11/30 11:30
 */
@ApiModel(value = "SalesGoalDiscountSalesStatisticsDto", description = "TPM-销售目标统计销量dto")
@Getter
@Setter
public class SalesGoalDiscountSalesStatisticsDto extends TenantFlagOpDto {

    @ApiModelProperty(name = "年月", notes = "年月")
    private String yearMonth;

    @ApiModelProperty(name = "businessFormatCode", notes = "业态[数据字典:mdm_business_format]")
    private String businessFormatCode;

    @ApiModelProperty(name = "businessUnitCode", notes = "业务单元[数据字典:mdm_business_unit]")
    private String businessUnitCode;

    /**
     * 年度销量分类[数据字典:tpm_year_sales_type]
     */
    @ApiModelProperty(value = "分组[数据字典:tpm_year_sales_type]", notes = "")
    private String yearSalesTypeCode;
}
