package com.biz.crm.tpm.business.sales.goal.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.util.List;

/**
 * @author chenlong
 * @date 2022/11/30 11:30
 */
@ApiModel(value = "SalesGoalStatisticsDto", description = "TPM-销售目标统计任务量dto")
@Getter
@Setter
public class SalesGoalStatisticsDto extends TenantFlagOpDto {

    @ApiModelProperty(name = "开始年月", notes = "开始年月")
    private String yearMonthBegin;

    @ApiModelProperty(name = "结束年月", notes = "结束年月")
    private String yearMonthEnd;

    @ApiModelProperty(name = "销售组织编码列表", notes = "销售组织编码列表", hidden = true)
    private List<String> salesOrgCodes;

    @ApiModelProperty(name = "客户编码", notes = "客户编码")
    private String customerCode;

    @ApiModelProperty("客户编码列表")
    private List<String> customerCodeList;

    @ApiModelProperty("业务单元列表（剔除）")
    private List<String> businessUnitCodeNotInList;
}
