package com.biz.crm.tpm.business.sales.goal.sdk.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;

/**
 * 
 * @TableName tpm_sales_performance
 */
@ApiModel(value = "SalesPerformanceEntity", description = "垂直销售业绩")
@Data
public class SalesPerformanceDto implements Serializable{

    /**
     * id
     */
    @ApiModelProperty("主键id")
    private String spId;

    /**
     * 日期
     */
    @ApiModelProperty("日期")
    private String salesDate;
    /**
     * 日期
     */
    @ApiModelProperty("日期")
    private List<String> salesDateList;

    @ApiModelProperty("日期")
    private String salesBeginDate;

    @ApiModelProperty("日期")
    private String salesEndDate;

    private String activityBeginTime;

    private String activityEndTime;

    /**
     * 销售组织
     */
    @ApiModelProperty("销售组织")
    private String salesOrg;

    /**
     * 销售大区
     */
    @ApiModelProperty("销售大区(销售区域)")
    private String region;

    /**
     * 品牌
     */
    @ApiModelProperty("品牌")
    private String brand;

    /**
     * 品项
     */
    @ApiModelProperty("品项")
    private String categoryCode;

    /**
     * 品类划分
     */
    @ApiModelProperty("品类划分")
    private String classify;

    /**
     * 产品名称
     */
    @ApiModelProperty("产品名称")
    private String materialName;

    /**
     * 产品类型（新品、主品等）
     */
    @ApiModelProperty("产品类型（新品、主品等）")
    private String productType;

    /**
     * 产品编码
     */
    @ApiModelProperty("产品编码")
    private String materialCode;

    List<String> productCodes;

    /**
     * 运达方（送达方）
     */
    @ApiModelProperty(" 运达方（送达方）")
    private String shipToparty;

    /**
     * 送达方名称(门店名称)
     */
    @ApiModelProperty("送达方名称(门店名称)")
    private String shipTopartyName;

    /**
     * 售达方名称出
     */
    @ApiModelProperty("系统（售达方）")
    private String soldTopartName;

    /**
     * 系统（售达方）
     */
    @ApiModelProperty("系统（售达方）")
    private String soldToparty;

    /**
     * 零售商
     */
    @ApiModelProperty(" 零售商")
    private String retailer;

    /**
     * 出库数量(收货订单数量)
     */
    @ApiModelProperty(" 出库数量(收货订单数量)")
    private BigDecimal warehsOutQty;

    /**
     * 出库折扣
     */
    @ApiModelProperty("出库折扣")
    private BigDecimal actualDiscount;

    /**
     * 折前金额(订单含返点常规金额)
     */
    @ApiModelProperty("折前金额(订单含返点常规金额)")
    private BigDecimal orderRuleAmtInRebate;

    /**
     * 折后实际销额
     */
    @ApiModelProperty("折后实际销额")
    private BigDecimal warehsOutDiscountAmt;

    /**
     * 月累出库数量(收货订单数量)
     */
    @ApiModelProperty("月累出库数量(收货订单数量)")
    private BigDecimal warehsOutQtyIncM;

    /**
     * 月累出库折扣
     */
    @ApiModelProperty("月累出库折扣")
    private BigDecimal actualDiscountIncM;

    /**
     * 月累折前金额(订单含返点常规金额)
     */
    @ApiModelProperty("月累折前金额(订单含返点常规金额)")
    private BigDecimal orderRuleAmtInRebateIncM;

    /**
     * 月累折后实际销额
     */
    @ApiModelProperty("月累折后实际销额")
    private BigDecimal warehsOutDiscountAmtIncM;

    /**
     * 年累出库数量(收货订单数量)
     */
    @ApiModelProperty("年累出库数量(收货订单数量)")
    private BigDecimal warehsOutQtyIncY;

    /**
     * 年累出库折扣
     */
    @ApiModelProperty("年累出库折扣")
    private BigDecimal actualDiscountIncY;

    /**
     * 年累折前金额(订单含返点常规金额)
     */
    @ApiModelProperty("年累折前金额(订单含返点常规金额)")
    private BigDecimal orderRuleAmtInRebateIncY;

    /**
     * 年累折后实际销额
     */
    @ApiModelProperty("年累折后实际销额")
    private BigDecimal warehsOutDiscountAmtIncY;

    @ApiModelProperty("销售 年 yyyy")
    private String yearCol;

    @ApiModelProperty("销售 月份 yyyyMM")
    private String salesMonth;

    @ApiModelProperty("开始时间/日期")
    private String startTimeOrDate;

    @ApiModelProperty("结束时间/日期")
    private String endTimeOrDate;

    @ApiModelProperty("业态")
    private String businessFormatCode;

    @ApiModelProperty("销售组织编码")
    private String salesOrgCode;

    @ApiModelProperty("客户编码")
    private String customerCode;

    /**
     * 非包含产品编码
     */
    private List<String> excludeProductCodeList;

    /**
     * 非包含终端编码
     */
    private List<String> excludeTerminalCodeList;

    /**
     * 包含产品编码
     */
    private List<String> includeProductCodeList;

    /**
     * 扩展查询
     */
    private String isExtend;

    /**
     * 是否为0
     */
    private boolean warehsOutDiscountAmtNotZero;

    /**
     * 非包含客户编码
     */
    private List<String> excludeCustomerCodeList;

    //查询条件

    @ApiModelProperty("开始日期")
    private String startDate;

    @ApiModelProperty("结束日期")
    private String endDate;

    //查询条件
    private Collection<String> yearLyCollection;
    private Collection<String> regionNameCollection;
    private Collection<String> systemNameCollection;

}