package com.biz.crm.tpm.business.sales.goal.sdk.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @author: chenlong
 * @date: 2023/2/22 17:16
 * @description: 垂直销售业绩统计dto
 */
@Data
@ApiModel(value = "SalesPerformanceStatisDto", description = "垂直销售业绩统计dto")
public class SalesPerformanceStatisDto implements Serializable{

    /**
     * 活动开始时间
     */
    @ApiModelProperty("活动开始时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date activityBeginDate;

    /**
     * 活动开始时间字符串
     */
    @ApiModelProperty("活动开始时间字符串")
    private String activityBeginDateStr;

    /**
     * 活动结束时间
     */
    @ApiModelProperty("活动结束时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date activityEndDate;

    /**
     * 活动结束时间字符串
     */
    @ApiModelProperty("活动结束时间字符串")
    private String activityEndDateStr;

    /**
     * 系统(即零售商)
     */
    @ApiModelProperty("系统(即零售商)")
    private String systemCode;

    /**
     * 区域
     */
    @ApiModelProperty("区域")
    private String region;

    /**
     * 年月(yyyyMM),匹配主体日销售表名
     */
    @ApiModelProperty(value = "年月(yyyyMM)", hidden = true)
    private String yearMonthStr;
}