package com.biz.crm.tpm.business.sales.goal.sdk.eunm;

import lombok.Getter;

import java.util.ArrayList;
import java.util.List;

/**
 * @author huojia
 * @date 2022年11月09日 11:35
 */
@Getter
public enum YearSalesTypeEnum {

    CONTRACT("contract", "合同"),

    INTERNAL_CONTROL("internal_control", "内控"),

    ACHIEVEMENT("achievement", "绩效");

    private String code;

    private String desc;

    public static List<String> concertEnumToList() {
        List<String> list = new ArrayList<>();
        for (YearSalesTypeEnum t : YearSalesTypeEnum.values()) {
            list.add(t.getCode());
        }
        return list;
    }

    public static List<String> concertSalesDayToList() {
        List<String> list = new ArrayList<>();
        list.add(YearSalesTypeEnum.INTERNAL_CONTROL.code);
        list.add(YearSalesTypeEnum.CONTRACT.code);
        return list;
    }

    YearSalesTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

}
