package com.biz.crm.tpm.business.sales.goal.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mn.third.system.master.data.mdg.sdk.dto.MasterDataMdgBaseDto;
import com.biz.crm.tpm.business.sales.goal.sdk.dto.SalesGoalDiscountSalesStatisticsDto;
import com.biz.crm.tpm.business.sales.goal.sdk.dto.SalesGoalDto;
import com.biz.crm.tpm.business.sales.goal.sdk.dto.SalesGoalStatisticsDto;
import com.biz.crm.tpm.business.sales.goal.sdk.vo.SalesGoalStatisticsVo;
import com.biz.crm.tpm.business.sales.goal.sdk.vo.SalesGoalSumVo;
import com.biz.crm.tpm.business.sales.goal.sdk.vo.SalesGoalVo;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import org.springframework.data.domain.Pageable;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * @author huojia
 * @date 2022年10月26日 11:10
 */
public interface SalesGoalService {

    /**
     * 分页查询销售目标
     *
     * @param pageable
     * @param dto
     * @return com.baomidou.mybatisplus.extension.plugins.pagination.Page<com.biz.crm.tpm.business.sales.goal.sdk.vo.SalesGoalVo>
     * @author huojia
     * @date 2022/10/26 11:19
     **/
    Page<SalesGoalVo> findByConditions(Pageable pageable, SalesGoalDto dto);

    /**
     * 通过主键查询数据
     *
     * @param id
     * @return com.biz.crm.tpm.business.sales.goal.sdk.vo.SalesGoalVo
     * @author huojia
     * @date 2022/10/26 11:35
     **/
    SalesGoalVo findById(String id);

    /**
     * 修改
     *
     * @param dto
     * @return com.biz.crm.tpm.business.sales.goal.sdk.vo.SalesGoalVo
     * @author huojia
     * @date 2022/10/26 11:35
     **/
    SalesGoalVo update(SalesGoalDto dto);

    /**
     * 批量删除
     *
     * @param ids
     * @author huojia
     * @date 2022/10/26 11:35
     **/
    void delete(List<String> ids);

    /**
     * 批量导入
     *
     * @param importList
     * @author huojia
     * @date 2022/10/28 14:15
     **/
    void importSave(List<SalesGoalDto> importList);

    /**
     * 条件查询销量目标
     *
     * @param salesGoalDto
     * @return java.util.List<com.biz.crm.tpm.business.sales.goal.sdk.vo.SalesGoalVo>
     * @author huojia
     * @date 2022/11/3 17:35
     **/
    List<SalesGoalVo> listByConditions(SalesGoalDto salesGoalDto);

    /**
     * 根据条件查询金额
     * @param salesGoal 参数
     * @return BigDecimal
     */
    BigDecimal getSalesGoalAmount(SalesGoalDto salesGoal);

    /**
     * 客户+产品+年月,统计数据的分子公司出库量
     *
     * @param salesGoalDto
     * @return
     */
    BigDecimal outStockNumber(SalesGoalDto salesGoalDto);

    /**
     * 客户+产品+年月,统计经销商进货量
     *
     * @param salesGoalDto
     * @return
     */
    BigDecimal inStockNumber(SalesGoalDto salesGoalDto);

    /**
     * 客户+产品+年月,统计销售数量
     *
     * @param salesGoalDto
     * @return
     */
    BigDecimal getSaleAmount(SalesGoalDto salesGoalDto);

    /**
     * 客户+产品+年月,统计任务量
     *
     * @param salesGoalDto
     * @return
     */
    BigDecimal getTaskAmount(SalesGoalDto salesGoalDto);

    /**
     * 分页统计销售目标任务量
     *
     * @param pageable 分页参数
     * @param dto      筛选参数
     * @return Page<SalesGoalStatisticsVo>
     **/
    Page<SalesGoalStatisticsVo> findByConditions(Pageable pageable, SalesGoalStatisticsDto dto);

    /**
     * 查询按区域分组的数据
     */
    List<SalesGoalVo> findListGroupByRegion(SalesGoalDto dto);
    /**
     * 批量拉取
     *
     * @param dto
     * @author huojia
     * @date 2023/1/2 16:38
     **/
    void pullSalesDayReportAsync(MasterDataMdgBaseDto dto, UserIdentity userIdentity);
    /**
     * 批量拉取销售日报数据
     *
     * @param dto
     * @author huojia
     * @date 2023/1/2 16:33
     **/
    void pullSalesDayReport(MasterDataMdgBaseDto dto);

    /**
     * 垂直查询销售任务
     *
     * @param salesGoalDto
     * @return java.util.List<com.biz.crm.tpm.business.sales.goal.sdk.vo.SalesGoalVo>
     * @author huojia
     * @date 2023/1/17 0:48
     **/
    List<SalesGoalVo> listVerticalByConditions(SalesGoalDto salesGoalDto);

    /**
     * 汇总查询年度销售任务
     *
     * @author huojia
     * @date 2023/2/9 10:56
     * @param salesGoalDto
     * @return java.util.List<com.biz.crm.tpm.business.sales.goal.sdk.vo.SalesGoalSumVo>
     **/
    List<SalesGoalSumVo> listVerticalSumByConditions(SalesGoalDto salesGoalDto);

    /**
     * 查询
     * @param salesGoal 参数
     * @return List
     */
    List<SalesGoalVo> findSalesGoal(SalesGoalDto salesGoal);

    /**
     * 指标计算查询
     *
     * @param dto
     * @return
     */
    List<SalesGoalVo> listForVariableCal(SalesGoalDto dto);

    /**
     * 年度销售目标指标变更后查询方法
     * @param dto
     * @return
     */
    List<SalesGoalVo> listForVariableCalNew(SalesGoalDto dto);

    /**
     * 授权预算项目折后销售
     * @param dto
     * @return
     */
    List<SalesGoalVo> restoreReplaySalesAfterDiscount(SalesGoalDto dto);

    /**
     * 根据业态，业务单元，分组，年月，统计折前销量，按照零售商+区域分组，-隔开
     *
     * @param dto
     * @return Map<String,BigDecimal>
     */
    Map<String,BigDecimal> getSalesBeforeDiscount(SalesGoalDiscountSalesStatisticsDto dto);

    /**
     * 根据业态，业务单元，分组，年月，统计折后销量，按照零售商+区域分组，-隔开
     *
     * @param dto
     * @return Map<String,BigDecimal>
     */
    Map<String,BigDecimal> getSalesAfterDiscount(SalesGoalDiscountSalesStatisticsDto dto);

    /**
     * 获取锁定的key
     * @param dto
     * @return
     */
    String getLockKey(MasterDataMdgBaseDto dto);

    /**
     * 根据参数统计折后额和出库数
     *
     * @param salesGoalDto 参数
     * @return SalesGoalSumVo
     */
    SalesGoalSumVo findDiscountAfterAndDeliveryQuantity(SalesGoalDto salesGoalDto);

    /**
     * 按维度获取折后销售额
     * @param salesGoalDto
     * @return
     */
    BigDecimal findDiscountAfter(SalesGoalDto salesGoalDto);

    /**
     * 销售任务：统计“年月+区域+系统”维度内控版的销售任务折后金额
     * @param salesGoalDtos
     * @return
     */
    List<SalesGoalVo> findListForFR(List<SalesGoalDto> salesGoalDtos);
}
