package com.biz.crm.tpm.business.sales.goal.sdk.service;

import com.biz.crm.tpm.business.sales.goal.sdk.dto.SalesGoalDto;
import com.biz.crm.tpm.business.sales.goal.sdk.dto.SalesPerformanceDto;
import com.biz.crm.tpm.business.sales.goal.sdk.dto.SalesPerformanceStatisDto;
import com.biz.crm.tpm.business.sales.goal.sdk.vo.SalesGoalVo;
import com.biz.crm.tpm.business.sales.goal.sdk.vo.SalesPerformanceSumVo;
import com.biz.crm.tpm.business.sales.goal.sdk.vo.SalesPerformanceVo;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * @author huojia
 * @date 2023年01月17日 16:53
 */
public interface SalesPerformanceVoService {

    /**
     * 批量查询
     *
     * @param salesPerformanceDto
     * @return java.util.List<com.biz.crm.tpm.business.sales.goal.sdk.vo.SalesPerformanceVo>
     * @author huojia
     * @date 2023/1/17 20:10
     **/
    List<SalesPerformanceSumVo> listYearByConditions(SalesPerformanceDto salesPerformanceDto);

    /**
     * 根据活动开始结束时间，零售商区域，统计此维度下的每个品牌的折扣实际销额
     *
     * @param dto 主体日销售数据筛选参数
     * @return Map<String, BigDecimal>
     */
    Map<String, BigDecimal> statisSalesAmountByBrand(SalesPerformanceStatisDto dto);

    /**
     * 计算折后实际销额与出库数量
     * @param dto
     * @return
     */
    SalesPerformanceVo findSalesAmountAndOutNumber(SalesPerformanceDto dto);


    List<SalesPerformanceVo> findSalesPerformanceSumVo(SalesPerformanceDto dto);

    /**
     * 计算折后实际销额
     * @param dto
     * @return
     */
    BigDecimal findSalesAmount (SalesPerformanceDto dto);

    List<SalesPerformanceVo> findListForFR(List<SalesPerformanceDto> salesPerformanceDtos);

    List<SalesPerformanceVo> findBusinessUnitSetTableForFR(List<SalesPerformanceDto> salesPerformanceDtos);
}
