package com.biz.crm.tpm.business.sales.goal.sdk.utils;

import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

/**
 * @author yangshen
 * @version 1.0
 * @date 2023/1/9 20:45
 * @ClassName SalesPerformanceUtil
 * @Description TODO
 */
public class SalesPerformanceUtil {

    /**
     * 保存线程池
     *    核心线程数量
     *    最大线程数量
     *    闲时等待时间
     *    时间单位
     *    线程工厂
     *    任务队列
     *      基于数组
     *      基于链表
     *      同步
     *      延迟
     *    拒绝策略：4种
     *       1.AbortPolicy  直接抛异常
     *       2.DiscardPolicy 抛弃新的
     *       3.DiscardOldesPolicy  抛弃老的
     *       3.CallerRunerPolicy 由调用线程 执行
     * @return
     */
    public static ThreadPoolExecutor salesPerformanceThreadPool(){
        return  new ThreadPoolExecutor(4,
                Runtime.getRuntime().availableProcessors()
                ,30
                , TimeUnit.SECONDS
                ,new LinkedBlockingDeque<>(30)
                , Executors.defaultThreadFactory()
                , new ThreadPoolExecutor.AbortPolicy()
        );
    }
}
