package com.biz.crm.tpm.business.sales.goal.sdk.vo;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelImport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;

/**
 * @author yaoyongming
 * @date 2023年3月18日 14:38
 */
@Data
@CrmExcelImport(startRow = 2)
@EqualsAndHashCode(callSuper = true)
public class SalesGoalEstoreImportsVo extends CrmExcelVo {

    /**
     * 业态
     */
    @CrmExcelColumn(value = "业态")
    private String businessFormatCode;

    /**
     * 业务单元
     */
    @CrmExcelColumn(value = "业务单元")
    private String businessUnitCode;

    /**
     * 渠道编码
     */
    @CrmExcelColumn("渠道编码")
    private String channelCode;

    /**
     * 渠道名称
     */
    @CrmExcelColumn("渠道名称")
    private String channelName;

    /**
     * 年月
     */
    @CrmExcelColumn(value = "年月")
    private String yearMonthLy;

    /**
     * 销售机构编码
     */
    @CrmExcelColumn("销售机构编码")
    private String salesInstitutionCode;

    /**
     * 销售机构名称
     */
    @CrmExcelColumn("销售机构名称")
    private String salesInstitutionName;

    /**
     * 销售部门编码
     */
    @CrmExcelColumn("销售部门编码")
    private String salesOrgRegionCode;

    /**
     * 销售部门名称
     */
    @CrmExcelColumn("销售部门名称")
    private String salesOrgRegionName;

    /**
     * 销售组编码
     */
    @CrmExcelColumn("销售组编码")
    private String salesOrgProvinceCode;

    /**
     * 销售组名称
     */
    @CrmExcelColumn("销售组名称")
    private String salesOrgProvinceName;

    /**
     * 客户编码
     */
    @CrmExcelColumn("客户编码")
    private String customerCode;

    /**
     * 客户名称
     */
    @CrmExcelColumn("客户名称")
    private String customerName;

    /**
     * 出库折前销售额
     */
    @CrmExcelColumn("折前销售额")
    private String deliverySalesAmountStr;

    /*数据库字段*/

    /**
     * 数据来源
     */
    @ExcelIgnore
    private String dataFromCode;

    /**
     * 出库量
     */
    @ExcelIgnore
    private BigDecimal deliveryQuantity;

    /**
     * 出库折前销售额
     */
    @ExcelIgnore
    private BigDecimal deliverySalesAmount;

    /**
     * 出库折后销售额
     */
    @ExcelIgnore
    private BigDecimal deliveryDiscountSalesAmount;

    /**
     * 客户MDG编码
     */
    @ExcelIgnore
    private String customerErpCode;

}
