package com.biz.crm.tpm.business.sales.goal.sdk.vo;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelImport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import java.math.BigDecimal;

/**
 * @author huojia
 * @date 2022年10月28日 11:38
 */
@Data
@CrmExcelImport(startRow = 1)
public class SalesGoalImportsVo extends CrmExcelVo {

    /**
     * 业态[数据字典:mdm_business_format]
     */
    @CrmExcelColumn(value = "业态[数据字典:mdm_business_format]", order = 0)
    private String businessFormatCode;

    /**
     * 业务单元[数据字典:mdm_business_unit]
     */
    @CrmExcelColumn(value = "业务单元[数据字典:mdm_business_unit]", order = 1)
    private String businessUnitCode;

    /**
     * 年月
     */
    @CrmExcelColumn(value = "年月", order = 2)
    private String yearMonthLy;

    /**
     * 分组[数据字典:tpm_group_code]
     */
    @CrmExcelColumn(value = "分组[数据字典:tpm_group_code]", order = 3)
    private String groupCode;

    /**
     * 销售组织编码
     */
    @CrmExcelColumn(value = "销售组织编码", order = 4)
    private String salesOrgCode;

    /**
     * 销售组织名称
     */
    @CrmExcelColumn(value = "销售组织名称", order = 5)
    private String salesOrgName;

    /**
     * 销售组织层级编码
     */
    @CrmExcelColumn(value = "销售组织层级编码", order = 6)
    private String salesOrgLevelCode;

    /**
     * 门店渠道层级
     */
    @CrmExcelColumn(value = "门店渠道层级", order = 7)
    private String terminalChannelLevelCode;

    /**
     * 门店渠道编码
     */
    @CrmExcelColumn(value = "门店渠道编码", order = 8)
    private String terminalChannelCode;

    /**
     * 门店渠道名称
     */
    @CrmExcelColumn(value = "门店渠道名称", order = 9)
    private String terminalChannelName;

    /**
     * 客户渠道编码
     */
    @CrmExcelColumn(value = "客户渠道编码", order = 10)
    private String customerChannelCode;

    /**
     * 客户渠道名称
     */
    @CrmExcelColumn(value = "客户渠道名称", order = 11)
    private String customerChannelName;

    /**
     * 客户渠道层级
     */
    @CrmExcelColumn(value = "客户渠道层级", order = 12)
    private String customerChannelLevelCode;

    /**
     * 系统编码
     */
    @CrmExcelColumn(value = "系统编码", order = 13)
    private String systemCode;

    /**
     * 系统名称
     */
    @CrmExcelColumn(value = "系统名称", order = 14)
    private String systemName;

    /**
     * 客户编码
     */
    @CrmExcelColumn(value = "客户编码", order = 15)
    private String customerCode;

    /**
     * 客户名称
     */
    @CrmExcelColumn(value = "客户名称", order = 16)
    private String customerName;

    /**
     * 客户类型
     */
    @CrmExcelColumn(value = "客户类型", order = 17)
    private String customerType;

    /**
     * 门店编码
     */
    @CrmExcelColumn(value = "门店编码", order = 18)
    private String terminalCode;

    /**
     * 门店名称
     */
    @CrmExcelColumn(value = "门店名称", order = 19)
    private String terminalName;

    /**
     * 品牌编码
     */
    @CrmExcelColumn(value = "品牌编码", order = 20)
    private String productBrandCode;

    /**
     * 品牌名称
     */
    @CrmExcelColumn(value = "品牌名称", order = 21)
    private String productBrandName;

    /**
     * 品类编码
     */
    @CrmExcelColumn(value = "品类编码", order = 22)
    private String productCategoryCode;

    /**
     * 品类名称
     */
    @CrmExcelColumn(value = "品类名称", order = 23)
    private String productCategoryName;

    /**
     * 品项编码
     */
    @CrmExcelColumn(value = "品项编码", order = 24)
    private String productItemCode;

    /**
     * 品项名称
     */
    @CrmExcelColumn(value = "品项名称", order = 25)
    private String productItemName;

    /**
     * 产品编码
     */
    @CrmExcelColumn(value = "产品编码", order = 26)
    private String productCode;

    /**
     * 产品名称
     */
    @CrmExcelColumn(value = "产品名称", order = 27)
    private String productName;

    /**
     * 单位编码
     */
    @CrmExcelColumn(value = "单位编码", order = 28)
    private String unitCode;

    /**
     * 单位名称
     */
    @CrmExcelColumn(value = "单位名称", order = 29)
    private String unitName;

    /**
     * 单价
     */
    @CrmExcelColumn(value = "单价", order = 30)
    private String priceStr;

    /**
     * 吨位
     */
    @CrmExcelColumn(value = "吨位", order = 31)
    private String tonnageStr;

    /**
     * 任务量
     */
    @CrmExcelColumn(value = "任务量", order = 32)
    private String taskQuantityStr;

    /**
     * 进货折前销售额
     */
    @CrmExcelColumn(value = "进货折前销售额", order = 33)
    private String purchaseSalesAmountStr;

    /**
     * 进货折后销售额
     */
    @CrmExcelColumn(value = "进货折后销售额", order = 34)
    private String purchaseDiscountSalesAmountStr;

    /**
     * 出库折前销售额
     */
    @CrmExcelColumn(value = "出库折前销售额", order = 35)
    private String deliverySalesAmountStr;

    /**
     * 出库折后销售额
     */
    @CrmExcelColumn(value = "出库折后销售额", order = 36)
    private String deliveryDiscountSalesAmountStr;

    /**
     * 出库量
     */
    @CrmExcelColumn(value = "出库量", order = 37)
    private String deliveryQuantityStr;

    /**
     * 区域编码
     */
    @CrmExcelColumn(value = "区域编码", order = 38)
    private String regionCode;

    /**
     * 区域名称
     */
    @CrmExcelColumn(value = "区域名称", order = 39)
    private String regionName;

    /**
     * 新老品
     */
    @CrmExcelColumn(value = "新老品", order = 40)
    private String newOldProduct;

    /*数据库字段*/

    /**
     * 维度配置编码（模板编码）
     */
    private String typeCoding;

    /**
     * 数据来源[数据字典:tpm_data_from]
     */
    private String dataFromCode;

    /**
     * 单价
     */
    private BigDecimal price;

    /**
     * 吨位
     */
    private BigDecimal tonnage;

    /**
     * 任务量
     */
    private BigDecimal taskQuantity;

    /**
     * 进货折前销售额
     */
    private BigDecimal purchaseSalesAmount;

    /**
     * 进货折后销售额
     */
    private BigDecimal purchaseDiscountSalesAmount;

    /**
     * 出库折前销售额
     */
    private BigDecimal deliverySalesAmount;

    /**
     * 出库折后销售额
     */
    private BigDecimal deliveryDiscountSalesAmount;

    /**
     * 出库量
     */
    private BigDecimal deliveryQuantity;

}
