package com.biz.crm.tpm.business.sales.goal.sdk.vo;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;

/**
 * @author chenlong
 * @date 2022/11/30 11:30
 */
@ApiModel(value = "SalesGoalStatisticsVo", description = "TPM-销售目标统计任务量vo")
@Getter
@Setter
public class SalesGoalStatisticsVo extends TenantFlagOpDto {

    @ApiModelProperty(name = "销售组织编码", notes = "销售组织编码")
    private String salesOrgCode;

    @ApiModelProperty(name = "客户编码", notes = "客户编码")
    private String customerCode;

    @ApiModelProperty(value = "任务量", notes = "任务量")
    private BigDecimal taskQuantity;
}
