package com.biz.crm.tpm.business.sales.goal.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;

/**
 * @author huojia
 * @date 2022年10月26日 11:13
 */
@ApiModel(value = "SalesGoalVo", description = "TPM-销售目标")
@Getter
@Setter
public class SalesGoalSumVo {

    /**
     * 年月
     */
    @ApiModelProperty(value = "年月", notes = "")
    private String yearMonthLy;

    /**
     * 单价
     */
    @ApiModelProperty(value = "单价", notes = "")
    private BigDecimal price;

    /**
     * 吨位
     */
    @ApiModelProperty(value = "吨位", notes = "")
    private BigDecimal tonnage;

    /**
     * 任务量
     */
    @ApiModelProperty(value = "任务量", notes = "")
    private BigDecimal taskQuantity;

    /**
     * 进货折前销售额
     */
    @ApiModelProperty(value = "进货折前销售额", notes = "")
    private BigDecimal purchaseSalesAmount;

    /**
     * 进货折后销售额
     */
    @ApiModelProperty(value = "进货折后销售额", notes = "")
    private BigDecimal purchaseDiscountSalesAmount;

    /**
     * 出库折前销售额
     */
    @ApiModelProperty(value = "出库折前销售额", notes = "")
    private BigDecimal deliverySalesAmount;

    /**
     * 出库折后销售额
     */
    @ApiModelProperty(value = "出库折后销售额", notes = "")
    private BigDecimal deliveryDiscountSalesAmount;

    /**
     * 出库量
     */
    @ApiModelProperty(value = "出库量", notes = "")
    private BigDecimal deliveryQuantity;
}
