package com.biz.crm.tpm.business.sales.goal.sdk.vo;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelImport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;

/**
 * @author huojia
 * @date 2022年10月28日 11:38
 */
@Data
@CrmExcelImport
@EqualsAndHashCode(callSuper = true)
public class SalesGoalVerticalImportsVo extends CrmExcelVo {

    /**
     * 业态
     */
    @CrmExcelColumn(value = "业态")
    private String businessFormatCode;

    /**
     * 业务单元
     */
    @CrmExcelColumn(value = "业务单元")
    private String businessUnitCode;

    /**
     * 年度销量分类[数据字典:tpm_year_sales_type]
     */
    @CrmExcelColumn(value = "年度销量分类")
    private String yearSalesTypeCode;

    /**
     * 零售商编码
     */
    @CrmExcelColumn(value = "零售商编码")
    private String systemCode;

    /**
     * 零售商名称
     */
    @CrmExcelColumn(value = "零售商名称")
    private String systemName;

    /**
     * 区域编码
     */
    @CrmExcelColumn(value = "区域编码")
    private String regionCode;

    /**
     * 区域名称
     */
    @CrmExcelColumn(value = "区域名称")
    private String regionName;

    /**
     * 行政省编码
     */
    @CrmExcelColumn(value = "行政省编码")
    private String provinceCode;

    /**
     * 行政省名称
     */
    @CrmExcelColumn(value = "行政省名称")
    private String provinceName;

    /**
     * 城市编码
     */
    @CrmExcelColumn(value = "城市编码")
    private String cityCode;

    /**
     * 城市名称
     */
    @CrmExcelColumn(value = "城市名称")
    private String cityName;

    /**
     * 送达方编码
     */
    @CrmExcelColumn(value = "送达方编码")
    private String terminalCode;

    /**
     * 送达方名称
     */
    @CrmExcelColumn(value = "送达方名称")
    private String terminalName;

    /**
     * KAD编码
     */
    @CrmExcelColumn(value = "KAD编码")
    private String kadCode;

    /**
     * 售达方编码
     */
    @CrmExcelColumn(value = "售达方编码")
    private String customerCode;

    /**
     * 售达方名称
     */
    @CrmExcelColumn(value = "售达方名称")
    private String customerName;

    /**
     * 大品牌编码
     */
    /*@CrmExcelColumn(value = "大品牌编码", order = 16)
    private String bigProductBrandCode;*/

    /**
     * 大品牌名称
     */
    @CrmExcelColumn(value = "大品牌")
    private String bigProductBrandName;

    /**
     * 品牌细分名称
     */
    @CrmExcelColumn(value = "品牌细分")
    private String detailProductBrandName;

    /**
     * 品牌编码
     */
    @CrmExcelColumn(value = "品牌编码")
    private String productBrandCode;

    /**
     * 品牌名称
     */
    @CrmExcelColumn(value = "品牌名称")
    private String productBrandName;

    /**
     * 新老品
     */
    @CrmExcelColumn(value = "新品/老品")
    private String newOldProduct;

    /**
     * 产品编码
     */
    @CrmExcelColumn(value = "产品编码")
    private String productCode;

    /**
     * 产品名称
     */
    @CrmExcelColumn(value = "产品名称")
    private String productName;

    /**
     * 年月
     */
    @CrmExcelColumn(value = "年月")
    private String yearMonthLy;

    /**
     * 出库量
     */
    @CrmExcelColumn(value = "出库量")
    private String deliveryQuantityStr;

    /**
     * 出库折前销售额
     */
    @CrmExcelColumn(value = "折前销售额")
    private String deliverySalesAmountStr;

    /**
     * 出库折后销售额
     */
    @CrmExcelColumn(value = "折后销售额")
    private String deliveryDiscountSalesAmountStr;

    /*数据库字段*/

    /**
     * 数据来源
     */
    @ExcelIgnore
    private String dataFromCode;

    /**
     * 出库量
     */
    @ExcelIgnore
    private BigDecimal deliveryQuantity;

    /**
     * 出库折前销售额
     */
    @ExcelIgnore
    private BigDecimal deliverySalesAmount;

    /**
     * 出库折后销售额
     */
    @ExcelIgnore
    private BigDecimal deliveryDiscountSalesAmount;

}
