package com.biz.crm.tpm.business.sales.goal.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;

/**
 * @author huojia
 * @date 2022年10月26日 11:13
 */
@ApiModel(value = "SalesGoalVo", description = "TPM-销售目标")
@Getter
@Setter
public class SalesGoalVo extends TenantFlagOpVo {

    /**
     * 维度配置编码（模板编码）
     */
    @ApiModelProperty("维度配置编码（模板编码）")
    private String typeCoding;

    /**
     * 数据来源[数据字典:tpm_data_from]
     */
    @ApiModelProperty(name = "数据来源[数据字典:tpm_data_from]", notes = "")
    private String dataFromCode;

    /**
     * 业态[数据字典:mdm_business_format]
     */
    @ApiModelProperty(value = "业态[数据字典:mdm_business_format]", notes = "")
    private String businessFormatCode;

    /**
     * 业务单元[数据字典:mdm_business_unit]
     */
    @ApiModelProperty(value = "业务单元[数据字典:mdm_business_unit]", notes = "")
    private String businessUnitCode;

    /**
     * 年月
     */
    @ApiModelProperty(value = "年月", notes = "")
    private String yearMonthLy;

    /**
     * 日历日
     */
    @ApiModelProperty(value = "日历日", notes = "")
    private String calendarDay;

    /**
     * 分组[数据字典:tpm_group_code]
     */
    @ApiModelProperty(value = "分组[数据字典:tpm_group_code]", notes = "")
    private String groupCode;

    /**
     * 年度销量分类[数据字典:tpm_year_sales_type]
     */
    @ApiModelProperty(value = "分组[数据字典:tpm_year_sales_type]", notes = "")
    private String yearSalesTypeCode;

    /**
     * 销售机构编码
     */
    @ApiModelProperty(name = "salesInstitutionCode", value = "销售机构编码", notes = "销售机构编码")
    private String salesInstitutionCode;

    /**
     * 销售机构名称
     */
    @ApiModelProperty(name = "salesInstitutionName", value = "销售机构名称", notes = "销售机构名称")
    private String salesInstitutionName;

    /**
     * 销售机构erp编码
     */
    @ApiModelProperty(name = "salesInstitutionErpCode", value = "销售机构编码", notes = "销售机构erp编码")
    private String salesInstitutionErpCode;

    /**
     * 销售组织编码（大区）
     */
    @ApiModelProperty(value = "销售组织编码（大区）", notes = "")
    private String salesOrgRegionCode;

    /**
     * 销售组织名称（大区）
     */
    @ApiModelProperty(value = "销售组织名称（大区）", notes = "")
    private String salesOrgRegionName;

    /**
     * 销售组织erp编码（大区）
     */
    @ApiModelProperty(name = "销售组织erp编码（大区）", notes = "")
    private String salesOrgRegionErpCode;

    /**
     * 销售组织编码（省区）
     */
    @ApiModelProperty(value = "销售组织编码（省区）", notes = "")
    private String salesOrgProvinceCode;

    /**
     * 销售组织名称（省区）
     */
    @ApiModelProperty(value = "销售组织名称（省区）", notes = "")
    private String salesOrgProvinceName;

    /**
     * 销售组织erp编码（省区）
     */
    @ApiModelProperty(name = "销售组织erp编码（省区）", notes = "")
    private String salesOrgProvinceErpCode;

    /**
     * 销售组织编码
     */
    @ApiModelProperty(value = "销售组织编码", notes = "")
    private String salesOrgCode;

    /**
     * 销售组织名称
     */
    @ApiModelProperty(value = "销售组织名称", notes = "")
    private String salesOrgName;

    /**
     * 销售组织层级
     */
    @ApiModelProperty(name = "销售组织层级", notes = "")
    private String salesOrgLevelCode;

    /**
     * 销售组
     */
    @ApiModelProperty(name = "salesGroupName",value = "销售组",notes = "销售组")
    private String salesGroupName;

    /**
     * 销售组编码
     */
    @ApiModelProperty(name = "salesGroupCode",value = "销售组编码",notes = "销售组编码")
    private String salesGroupCode;

    /**
     * 客户渠道编码
     */
    @ApiModelProperty(name = "客户渠道编码", notes = "")
    private String customerChannelCode;

    /**
     * 客户渠道名称
     */
    @ApiModelProperty(name = "客户渠道名称", notes = "")
    private String customerChannelName;

    /**
     * 客户渠道层级
     */
    @ApiModelProperty(value = "客户渠道层级", notes = "")
    private String customerChannelLevelCode;

    /**
     * 门店渠道层级
     */
    @ApiModelProperty(value = "门店渠道层级", notes = "")
    private String terminalChannelLevelCode;

    /**
     * 门店渠道编码
     */
    @ApiModelProperty(value = "门店渠道编码", notes = "")
    private String terminalChannelCode;

    /**
     * 门店渠道名称
     */
    @ApiModelProperty(value = "门店渠道名称", notes = "")
    private String terminalChannelName;

    /**
     * 系统编码
     */
    @ApiModelProperty(value = "系统编码", notes = "")
    private String systemCode;

    /**
     * 系统名称
     */
    @ApiModelProperty(value = "系统名称", notes = "")
    private String systemName;

    /**
     * 客户编码
     */
    @ApiModelProperty(value = "客户编码", notes = "")
    private String customerCode;

    /**
     * 客户名称
     */
    @ApiModelProperty(value = "客户名称", notes = "")
    private String customerName;

    /**
     * 客户类型
     */
    @ApiModelProperty(value = "客户类型", notes = "")
    private String customerType;

    /**
     * 门店编码
     */
    @ApiModelProperty(value = "门店编码", notes = "")
    private String terminalCode;

    /**
     * 门店名称
     */
    @ApiModelProperty(value = "门店名称", notes = "")
    private String terminalName;

    /**
     * 区域编码
     */
    @ApiModelProperty(value = "区域编码", notes = "")
    private String regionCode;

    /**
     * 区域名称
     */
    @ApiModelProperty(value = "区域名称", notes = "")
    private String regionName;

    /**
     * 新老品
     */
    @ApiModelProperty(value = "新老品", notes = "")
    private String newOldProduct;

    /**
     * 品牌编码
     */
    @ApiModelProperty(value = "品牌编码", notes = "")
    private String productBrandCode;

    /**
     * 品牌名称
     */
    @ApiModelProperty(value = "品牌名称", notes = "")
    private String productBrandName;

    /**
     * 品类编码
     */
    @ApiModelProperty(value = "品类编码", notes = "")
    private String productCategoryCode;

    /**
     * 品类名称
     */
    @ApiModelProperty(value = "品类名称", notes = "")
    private String productCategoryName;

    /**
     * 品项编码
     */
    @ApiModelProperty(value = "品项编码", notes = "")
    private String productItemCode;

    /**
     * 品项名称
     */
    @ApiModelProperty(value = "品项名称", notes = "")
    private String productItemName;

    /**
     * 产品编码
     */
    @ApiModelProperty(value = "产品编码", notes = "")
    private String productCode;

    /**
     * 产品名称
     */
    @ApiModelProperty(value = "产品名称", notes = "")
    private String productName;

    /**
     * 单位编码
     */
    @ApiModelProperty(value = "单位编码", notes = "")
    private String unitCode;

    /**
     * 单位名称
     */
    @ApiModelProperty(value = "单位名称", notes = "")
    private String unitName;

    /**
     * 单价
     */
    @ApiModelProperty(value = "单价", notes = "")
    private BigDecimal price;

    /**
     * 吨位
     */
    @ApiModelProperty(value = "吨位", notes = "")
    private BigDecimal tonnage;

    /**
     * 任务量
     */
    @ApiModelProperty(value = "任务量", notes = "")
    private BigDecimal taskQuantity;

    /**
     * 进货折前销售额
     */
    @ApiModelProperty(value = "进货折前销售额", notes = "")
    private BigDecimal purchaseSalesAmount;

    /**
     * 进货折后销售额
     */
    @ApiModelProperty(value = "进货折后销售额", notes = "")
    private BigDecimal purchaseDiscountSalesAmount;

    /**
     * 出库折前销售额
     */
    @ApiModelProperty(value = "出库折前销售额", notes = "")
    private BigDecimal deliverySalesAmount;

    /**
     * 出库折后销售额
     */
    @ApiModelProperty(value = "出库折后销售额", notes = "")
    private BigDecimal deliveryDiscountSalesAmount;

    /**
     * 出库量
     */
    @ApiModelProperty(value = "出库量", notes = "")
    private BigDecimal deliveryQuantity;

    /**
     * 渠道编码
     */
    @ApiModelProperty("渠道编码")
    private String channelCode;

    /**
     * 渠道名称
     */
    @ApiModelProperty("渠道名称")
    private String channelName;
}
