package com.biz.crm.tpm.business.sales.goal.sdk.vo;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelExport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @TableName tpm_sales_performance
 */
@ApiModel(value = "SalesPerformanceExportVo", description = "垂直销售业绩导出VO")
@Data
@CrmExcelExport
public class SalesPerformanceExportVo extends CrmExcelVo {

    /**
     * 销售组织
     */
    @ApiModelProperty("销售组织")
    @CrmExcelColumn("销售组织")
    private String salesOrg;

    /**
     * 销售大区
     */
    @ApiModelProperty("销售大区")
    @CrmExcelColumn("销售大区")
    private String region;

    /**
     * 零售商
     */
    @ApiModelProperty(" 零售商")
    @CrmExcelColumn("零售商")
    private String retailer;

    /**
     * 售达方名称出
     */
    @ApiModelProperty("售达方")
    @CrmExcelColumn("售达方")
    private String soldTopartName;

    /**
     * 系统（售达方）
     */
    @ApiModelProperty("售达方编码")
    @CrmExcelColumn("售达方编码")
    private String soldToparty;


    /**
     * 送达方编码
     */
    @ApiModelProperty("送达方编码")
    @CrmExcelColumn("送达方编码")
    private String shipToparty;

    /**
     * 送达方名称
     */
    @ApiModelProperty("送达方名称")
    @CrmExcelColumn("送达方名称")
    private String shipTopartyName;

    /**
     * 销售-年
     */
    @ApiModelProperty("销售-年")
    @CrmExcelColumn("销售-年")
    private String yearCol;

    /**
     * 销售-年月
     */
    @ApiModelProperty("销售-年月")
    @CrmExcelColumn("销售-年月")
    private String salesMonth;

    /**
     * 品牌
     */
    @ApiModelProperty("品牌")
    @CrmExcelColumn("品牌")
    private String brand;

    /**
     * 品项
     */
    @ApiModelProperty("品项")
    @CrmExcelColumn("品项")
    private String categoryCode;

    /**
     * 品类划分
     */
    @ApiModelProperty("品类")
    @CrmExcelColumn("品类")
    private String classify;

    /**
     * 产品编码
     */
    @ApiModelProperty("产品编码")
    @CrmExcelColumn("产品编码")
    private String materialCode;

    /**
     * 产品名称
     */
    @ApiModelProperty("产品名称")
    @CrmExcelColumn("产品名称")
    private String materialName;

    /**
     * 产品类型（新品、主品等）
     */
    @ApiModelProperty("产品类型")
    @CrmExcelColumn("产品类型")
    private String productType;

    /**
     * 出库数量(收货订单数量)
     */
    @ApiModelProperty(" 出库数量(收货订单数量)")
    @CrmExcelColumn("出库数量")
    private BigDecimal warehsOutQty;

    /**
     * 出库折扣
     */
    @ApiModelProperty("出库折扣")
    @CrmExcelColumn("出库折扣")
    private BigDecimal actualDiscount;


    /**
     * 折前金额(订单含返点常规金额)
     */
    @ApiModelProperty("折前金额(订单含返点常规金额)")
    @CrmExcelColumn("折前金额")
    private BigDecimal orderRuleAmtInRebate;

    /**
     * 折后实际销额
     */
    @ApiModelProperty("折后实际销额")
    @CrmExcelColumn("折后实际销额")
    private BigDecimal warehsOutDiscountAmt;

    /**
     * 月累出库数量(收货订单数量)
     */
    @ApiModelProperty("月累出库数量(收货订单数量)")
    @CrmExcelColumn("月累出库数量")
    private BigDecimal warehsOutQtyIncM;

    /**
     * 月累出库折扣
     */
    @ApiModelProperty("月累出库折扣")
    @CrmExcelColumn("月累出库折扣")
    private BigDecimal actualDiscountIncM;

    /**
     * 月累折前金额(订单含返点常规金额)
     */
    @ApiModelProperty("月累折前金额(订单含返点常规金额)")
    @CrmExcelColumn("月累折前金额")
    private BigDecimal orderRuleAmtInRebateIncM;

    /**
     * 月累折后实际销额
     */
    @ApiModelProperty("月累折后实际销额")
    @CrmExcelColumn("月累折后实际销额")
    private BigDecimal warehsOutDiscountAmtIncM;

    /**
     * 年累出库数量(收货订单数量)
     */
    @ApiModelProperty("年累出库数量(收货订单数量)")
    @CrmExcelColumn("年累出库数量")
    private BigDecimal warehsOutQtyIncY;

    /**
     * 年累出库折扣
     */
    @ApiModelProperty("年累出库折扣")
    @CrmExcelColumn("年累出库折扣")
    private BigDecimal actualDiscountIncY;

    /**
     * 年累折前金额(订单含返点常规金额)
     */
    @ApiModelProperty("年累折前金额(订单含返点常规金额)")
    @CrmExcelColumn("年累折前金额")
    private BigDecimal orderRuleAmtInRebateIncY;

    /**
     * 年累折后实际销额
     */
    @ApiModelProperty("年累折后实际销额")
    @CrmExcelColumn("年累折后实际销额")
    private BigDecimal warehsOutDiscountAmtIncY;

    /**
     * 日期
     */
    @ApiModelProperty("日期")
    @CrmExcelColumn("日期")
    private String salesDate;


    /**
     * id
     */
    @ApiModelProperty("主键id")
    @CrmExcelColumn("主键id")
    private String spId;

}