package com.biz.crm.tpm.business.sales.goal.sdk.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @author: chenlong
 * @date: 2023/2/22 17:16
 * @description: 垂直销售业绩统计Vo
 */
@Data
@ApiModel(value = "SalesPerformanceStatisVo", description = "垂直销售业绩统计Vo")
public class SalesPerformanceStatisVo {

    /**
     * 系统(即零售商)
     */
    @ApiModelProperty("系统(即零售商)")
    private String systemCode;

    /**
     * 区域
     */
    @ApiModelProperty("区域")
    private String region;

    /**
     * 品牌
     */
    @ApiModelProperty("品牌")
    private String brand;

//    /**
//     * 维度拼接编码(-隔开)
//     */
//    @ApiModelProperty("维度拼接编码(-隔开)")
//    private String spliceCode;

    /**
     * 统计值
     */
    @ApiModelProperty("统计值")
    private BigDecimal statisValue;
}
