package com.biz.crm.tpm.business.sales.plan.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.identity.FacturerUserDetails;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.third.system.cow.master.guest.sdk.dto.CowMasterGuestMonthPlanDto;
import com.biz.crm.tpm.business.sales.plan.local.service.SalesPlanCowMasterGuestService;
import com.biz.crm.tpm.business.sales.plan.local.service.process.SalesPlanHeadImportsProcess;
import com.biz.crm.tpm.business.sales.plan.local.service.process.SalesPlanSubCompanyImportsProcess;
import com.biz.crm.tpm.business.sales.plan.sdk.dto.*;
import com.biz.crm.tpm.business.sales.plan.sdk.enums.ConfirmEunm;
import com.biz.crm.tpm.business.sales.plan.sdk.event.SalesPlanJobEventListener;
import com.biz.crm.tpm.business.sales.plan.sdk.service.SalesPlanService;
import com.biz.crm.tpm.business.sales.plan.sdk.vo.SalesPlanHeadImportsVo;
import com.biz.crm.tpm.business.sales.plan.sdk.vo.SalesPlanSubCompanyImportsVo;
import com.biz.crm.tpm.business.sales.plan.sdk.vo.SalesPlanVo;
import com.biz.crm.tpm.business.sales.plan.sdk.vo.SubSaleMonitorVo;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @author huojia
 * @date 2022年10月26日 14:19
 */
@RestController
@RequestMapping("/v1/sales/plan")
@Slf4j
@Api(tags = "销售计划")
public class SalesPlanController {

    @Autowired(required = false)
    private SalesPlanService salesPlanService;

    @Autowired(required = false)
    private SalesPlanHeadImportsProcess salesPlanImportsProcess;

    @Autowired(required = false)
    private SalesPlanSubCompanyImportsProcess salesPlanSubCompanyImportsProcess;

    @Autowired(required = false)
    private SalesPlanCowMasterGuestService salesPlanCowMasterGuestService;

    @Autowired
    private NebulaNetEventClient nebulaNetEventClient;

    @Autowired(required = false)
    private LoginUserService loginUserService;

    /**
     * 导入测试
     *
     * @param importsVos 导入数据
     * @return 所有数据
     */
    @ApiOperation(value = "导入测试")
    @PostMapping("testValidate")
    public Result<?> testValidate(@RequestBody @ApiParam(name = "importsVos", value = "销售计划导入信息") List<SalesPlanHeadImportsVo> importsVos) {
        try {
            this.salesPlanImportsProcess.testValidate(importsVos);
            return Result.ok("导入测试成功");
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 分页查询所有数据
     *
     * @param pageable 分页对象
     * @param dto      查询实体
     * @return 所有数据
     */
    @ApiOperation(value = "分页查询所有数据")
    @GetMapping("findByConditions")
    public Result<Page<SalesPlanVo>> findByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                      @ApiParam(name = "salesPlanDto", value = "销售计划信息") SalesPlanDto dto) {
        try {
            Page<SalesPlanVo> page = this.salesPlanService.findByConditions(pageable, dto);
            return Result.ok(page);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 分子销量监控
     *
     * @param pageable 分页对象
     * @param dto      查询实体
     * @return 所有数据
     */
    @ApiOperation(value = "分子销量监控")
    @GetMapping("subSaleMonitor")
    public Result<Page<SubSaleMonitorVo>> subSaleMonitor(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                         @ApiParam(name = "salesPlanDto", value = "销售计划信息") SalesPlanDto dto) {
        try {
            Page<SubSaleMonitorVo> page = this.salesPlanService.subSaleMonitor(pageable, dto);
            return Result.ok(page);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 条件查询所有数据
     *
     * @param dto 查询实体
     * @return 所有数据
     */
    @ApiOperation(value = "条件查询所有数据")
    @PostMapping("conditions")
    public Result<List<SalesPlanVo>> findByConditions(@RequestBody SalesPlanDto dto) {
        try {
            List<SalesPlanVo> result = this.salesPlanService.findByConditions(dto);
            return Result.ok(result);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 条件查询所有数据
     *
     * @param dto 查询实体
     * @return 所有数据
     */
    @ApiOperation(value = "条件查询所有数据")
    @PostMapping("listByConditions")
    public Result<List<SalesPlanVo>> listByConditions(@RequestBody SalesPlanDto dto) {
        try {
            List<SalesPlanVo> result = this.salesPlanService.listByConditions(dto);
            return Result.ok(result);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 通过主键查询单条数据
     *
     * @param id 主键
     * @return 单条数据
     */
    @ApiOperation(value = "通过主键查询单条数据")
    @GetMapping("detail")
    public Result<SalesPlanVo> detail(@RequestParam("id") @ApiParam(name = "id", value = "主键id") String id) {
        try {
            SalesPlanVo salesPlanVo = this.salesPlanService.findById(id);
            return Result.ok(salesPlanVo);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 新增数据
     *
     * @param dto 实体对象
     * @return 新增结果
     */
    @ApiOperation(value = "新增数据")
    @PostMapping
    public Result<SalesPlanVo> create(@ApiParam(name = "salesPlanDto", value = "TPM-销售计划") @RequestBody SalesPlanDto dto) {
        try {
            SalesPlanVo result = this.salesPlanService.create(dto);
            return Result.ok(result);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 修改数据
     *
     * @param dto 实体对象
     * @return 修改结果
     */
    @ApiOperation(value = "修改数据")
    @PatchMapping
    public Result<SalesPlanVo> update(@ApiParam(name = "salesPlanDto", value = "TPM-销售计划") @RequestBody SalesPlanDto dto) {
        try {
            SalesPlanVo result = this.salesPlanService.update(dto);
            return Result.ok(result);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 删除数据
     *
     * @param ids 主键结合
     * @return 删除结果
     */
    @DeleteMapping
    @ApiOperation(value = "删除数据")
    public Result<?> delete(@RequestParam("ids") List<String> ids) {
        try {
            this.salesPlanService.delete(ids);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 分页拉取数据
     *
     * @param dto 查询实体
     * @return 所有数据
     */
    @ApiOperation(value = "分页拉取数据")
    @PostMapping("pullMonthPlanList")
    public Result<?> pullMonthPlanList(@RequestBody CowMasterGuestMonthPlanDto dto) {
        try {
            this.salesPlanCowMasterGuestService.pullMonthPlanList(dto);
            return Result.ok("");
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 根据维度统计回复量
     *
     * @param dto 查询实体
     * @return 统计数据map
     */
    @ApiOperation(value = "根据维度统计回复量")
    @PostMapping("summaryRecoveryAmount")
    public Result<Map<String, BigDecimal>> summaryRecoveryAmount(@RequestBody SalesPlanSummaryDto dto) {
        try {
            Map<String, BigDecimal> map = this.salesPlanService.summaryRecoveryAmount(dto);
            return Result.ok(map);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 根据维度统计回复量
     *
     * @param dto 查询实体
     * @return 统计数据map
     */
    @ApiOperation(value = "根据维度统计回复量")
    @PostMapping("testImport")
    public Result testImport(@RequestBody List<SalesPlanSubCompanyImportsVo> list) {
        try {
            this.salesPlanSubCompanyImportsProcess.testValidate(list);
            return Result.ok("");
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 根据选择的维度手动计算折后计划量和回复量（主体）
     *
     * @param dto 查询实体
     * @return 结果描述
     */
    @ApiOperation(value = "根据选择的维度手动计算折后计划量和回复量（主体）")
    @PostMapping("manualCalPlanAndReply")
    public Result<?> manualCalPlanAndReply(@RequestBody SalesPlanReCalPlanAndReplyDto dto) {
        try {
            this.salesPlanService.manualCalPlanAndReply(dto);
            return Result.ok("手动计算折后计划量和回复量开始，请稍等");
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 拉取 销售计划 （计划量）
     * @param
     * @return {@link Result}
     */
    @ApiOperation(value = "根据选择的维度手动计算折后计划量和回复量（垂直）")
    @PostMapping("planAutoSyncXxlJob")
    public Result planAutoSyncXxlJob(@RequestBody SalesPlanReCalPlanAndReplyDto dto) {
        try {
            String yearMonthLy = dto.getYearMonthLy();
            Assert.hasText(yearMonthLy,"年月不能为空");
            log.info("=====>    垂直销售计划（计划量）[{}] start    <=====", DateUtil.dateStrNowAll());
            CowMasterGuestMonthPlanDto cowMasterGuestMonthPlanDto = new CowMasterGuestMonthPlanDto();
            cowMasterGuestMonthPlanDto.setYear(yearMonthLy.split("-")[0]);
            cowMasterGuestMonthPlanDto.setMonths(yearMonthLy.split("-")[1]);
            salesPlanCowMasterGuestService.pullMonthPlanList(cowMasterGuestMonthPlanDto);
            //通知更新月度预算
            SerializableBiConsumer<SalesPlanJobEventListener, SalesPlanLogEventDto> onPlan =
                SalesPlanJobEventListener::onPlan;
            SalesPlanLogEventDto eventDto = new SalesPlanLogEventDto();
            SalesPlanDto planDto = new SalesPlanDto();
            planDto.setYearMonthLy(yearMonthLy);
            eventDto.setNewest(planDto);
            this.nebulaNetEventClient.publish(eventDto, SalesPlanJobEventListener.class, onPlan);
            log.info("=====>    垂直销售计划（计划量）[{}] end    <=====", DateUtil.dateStrNowAll());
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 分页查询所有未确认的数据
     *
     * @param pageable 分页对象
     * @param dto      查询实体
     * @return 所有数据
     */
    @ApiOperation(value = "分页查询所有未确认的数据")
    @GetMapping("findConfirmByConditions")
    public Result<Page<SalesPlanVo>> findConfirmByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                             @ApiParam(name = "salesPlanDto", value = "销售计划信息") SalesPlanDto dto) {
        try {
            dto.setSpecialDataStatus(ConfirmEunm.TOBECONFIRMED.getCode());
            dto.setBusinessUnitCode(BusinessUnitEnum.SON_COMPANY.getCode());
            Page<SalesPlanVo> page = this.salesPlanService.findByConditions(pageable, dto);
            return Result.ok(page);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 数据确认
     *
     * @param dto 查询实体
     * @return 返回结果
     */
    @ApiOperation(value = "数据确认")
    @PostMapping("confirmData")
    public Result<?> confirmData(@RequestBody SalesPlanConfirmDto dto) {
        try {
            this.salesPlanService.confirmData(dto);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }
}
