package com.biz.crm.tpm.business.sales.plan.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * @author huojia
 * @date 2022年10月26日 10:06
 */
@ApiModel(value = "SalesPlanEntity", description = "TPM-销售计划")
@TableName("tpm_sales_plan")
@Getter
@Setter
@Entity(name = "tpm_sales_plan")
@Table(name = "tpm_sales_plan", indexes = {
        @Index(name = "tpm_sales_plan_index1", columnList = "business_format_code, business_unit_code, year_month_ly"),
        @Index(name = "tpm_sales_plan_index2", columnList = "create_time,id"),
        @Index(name = "tpm_sales_plan_index3", columnList = "customer_code,product_code,year_month_ly"),
        @Index(name = "tpm_sales_plan_index4", columnList = "customer_retailer_code"),
        @Index(name = "tpm_sales_plan_index5", columnList = "order_no"),
        @Index(name = "tpm_sales_plan_index6", columnList = "org_code"),
        @Index(name = "tpm_sales_plan_index7", columnList = "sales_org_code"),
        @Index(name = "tpm_sales_plan_index8", columnList = "product_code"),
})
@org.hibernate.annotations.Table(appliesTo = "tpm_sales_plan", comment = "TPM-销售计划")
public class SalesPlanEntity extends TenantFlagOpEntity {

    /**
     * 维度配置编码（模板编码）
     */
    @ApiModelProperty("维度配置编码（模板编码）")
    @Column(name = "type_coding", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '维度配置编码（模板编码） '")
    private String typeCoding;

    /**
     * 版本号[数据字典:tpm_sales_plan_version]
     */
    @ApiModelProperty(name = "版本号[数据字典:tpm_sales_plan_version]", notes = "")
    @Column(name = "version_number", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '版本号[数据字典:tpm_sales_plan_version] '")
    private String versionNumber;

    /**
     * 数据来源[数据字典:tpm_data_from]
     */
    @ApiModelProperty(name = "数据来源[数据字典:tpm_data_from]", notes = "")
    @Column(name = "data_from_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '数据来源[数据字典:tpm_data_from] '")
    private String dataFromCode;

    /**
     * 业态[数据字典:mdm_business_format]
     */
    @ApiModelProperty(name = "业态[数据字典:mdm_business_format]", notes = "")
    @Column(name = "business_format_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '业态[数据字典:mdm_business_format] '")
    private String businessFormatCode;

    /**
     * 业务单元[数据字典:mdm_business_unit]
     */
    @ApiModelProperty(name = "业务单元[数据字典:mdm_business_unit]", notes = "")
    @Column(name = "business_unit_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '业务单元[数据字典:mdm_business_unit] '")
    private String businessUnitCode;

    /**
     * 年月
     */
    @ApiModelProperty(name = "年月", notes = "")
    @Column(name = "year_month_ly", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '年月 '")
    private String yearMonthLy;

    /**
     * 分组[数据字典:tpm_group_code]
     */
    @ApiModelProperty(name = "分组[数据字典:tpm_group_code]", notes = "")
    @Column(name = "group_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '分组[数据字典:tpm_group_code] '")
    private String groupCode;

    /**
     * 单据号
     */
    @ApiModelProperty(name = "单据号", notes = "")
    @Column(name = "order_no", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '单据号'")
    private String orderNo;

    /**
     * 来源系统
     */
    @ApiModelProperty(name = "来源系统", notes = "")
    @Column(name = "from_system", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '来源系统'")
    private String fromSystem;

    /**
     * 零售商编码
     */
    @ApiModelProperty(name = "customerRetailerCode", notes = "零售商编码")
    @Column(name = "customer_retailer_code", columnDefinition = "varchar(32) COMMENT '零售商编码'")
    private String customerRetailerCode;

    /**
     * 零售商名称
     */
    @ApiModelProperty(name = "customerRetailerName", notes = "零售商名称")
    @Column(name = "customer_retailer_name", columnDefinition = "varchar(256) COMMENT '零售商名称'")
    private String customerRetailerName;

    /**
     * 分仓编码
     */
    @ApiModelProperty("分仓编码")
    @Column(name = "points_warehouse_code", length = 32, columnDefinition = "varchar(32) COMMENT '分仓编码'")
    private String pointsWarehouseCode;

    /**
     * 分仓名称
     */
    @ApiModelProperty("分仓名称")
    @Column(name = "points_warehouse_name", length = 255, columnDefinition = "varchar(255) COMMENT '分仓名称'")
    private String pointsWarehouseName;

    @ApiModelProperty("HR组织编码")
    @Column(name = "org_code", nullable = true, length = 64, columnDefinition = "VARCHAR(32) COMMENT 'HR组织编码'")
    private String orgCode;

    @ApiModelProperty("HR组织名称")
    @Column(name = "org_name", nullable = true, length = 128, columnDefinition = "VARCHAR(32) COMMENT 'HR组织名称'")
    private String orgName;

    /**
     * 销售组织编码
     */
    @CrmExcelColumn(value = "销售组织编码")
    @Column(name = "sales_org_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售组织编码'")
    private String salesOrgCode;

    /**
     * 销售组织名称
     */
    @CrmExcelColumn(value = "销售组织名称")
    @Column(name = "sales_org_name", nullable = true, length = 128, columnDefinition = "VARCHAR(128) COMMENT '销售组织名称'")
    private String salesOrgName;

    /**
     * 销售机构编码
     */
    @ApiModelProperty(name = "salesInstitutionCode", value = "销售机构编码", notes = "销售机构编码")
    @Column(name = "sales_institution_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售机构编码'")
    private String salesInstitutionCode;

    /**
     * 销售机构erp编码
     */
    @ApiModelProperty(name = "salesInstitutionErpCode", value = "销售机构编码", notes = "销售机构erp编码")
    @Column(name = "sales_institution_erp_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售机构erp编码'")
    private String salesInstitutionErpCode;

    /**
     * 销售机构名称
     */
    @ApiModelProperty(name = "salesInstitutionName", value = "销售机构名称", notes = "销售机构名称")
    @Column(name = "sales_institution_name", nullable = true, length = 255, columnDefinition = "VARCHAR(255) COMMENT '销售机构名称'")
    private String salesInstitutionName;

    /**
     * 销售组织编码（大区）
     */
    @ApiModelProperty(name = "销售组织编码（大区）", notes = "")
    @Column(name = "sales_org_region_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售组织编码（大区） '")
    private String salesOrgRegionCode;

    /**
     * 销售组织erp编码（大区）
     */
    @ApiModelProperty(name = "销售组织erp编码（大区）", notes = "")
    @Column(name = "sales_org_region_erp_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售组织erp编码（大区） '")
    private String salesOrgRegionErpCode;

    /**
     * 销售组织名称（大区）
     */
    @ApiModelProperty(name = "销售组织名称（大区）", notes = "")
    @Column(name = "sales_org_region_name", nullable = true, length = 256, columnDefinition = "VARCHAR(256) COMMENT '销售组织名称（大区） '")
    private String salesOrgRegionName;

    /**
     * 销售组织编码（省区）
     */
    @ApiModelProperty(name = "销售组织编码（省区）", notes = "")
    @Column(name = "sales_org_province_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售组织编码（省区） '")
    private String salesOrgProvinceCode;

    /**
     * 销售组织erp编码（省区）
     */
    @ApiModelProperty(name = "销售组织erp编码（省区）", notes = "")
    @Column(name = "sales_org_province_erp_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售组织erp编码（省区） '")
    private String salesOrgProvinceErpCode;

    /**
     * 销售组织名称（省区）
     */
    @ApiModelProperty(name = "销售组织名称（省区）", notes = "")
    @Column(name = "sales_org_province_name", nullable = true, length = 256, columnDefinition = "VARCHAR(256) COMMENT '销售组织名称（省区） '")
    private String salesOrgProvinceName;

    /**
     * 销售组织层级
     */
    @ApiModelProperty(name = "销售组织层级", notes = "")
    @Column(name = "sales_org_level_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售组织层级 '")
    private String salesOrgLevelCode;

    /**
     * 订单类型
     */
    @ApiModelProperty(name = "订单类型", notes = "")
    @Column(name = "order_type", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '订单类型 '")
    private String orderType;

    /**
     * 客户渠道编码
     */
    @ApiModelProperty(name = "客户渠道编码", notes = "")
    @Column(name = "customer_channel_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '客户渠道编码 '")
    private String customerChannelCode;

    /**
     * 客户渠道名称
     */
    @ApiModelProperty(name = "客户渠道名称", notes = "")
    @Column(name = "customer_channel_name", nullable = true, length = 128, columnDefinition = "VARCHAR(128) COMMENT '客户渠道名称 '")
    private String customerChannelName;

    /**
     * 客户渠道层级
     */
    @ApiModelProperty(value = "客户渠道层级", notes = "")
    @Column(name = "customer_channel_level_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '客户渠道层级 '")
    private String customerChannelLevelCode;

    /**
     * 门店渠道层级
     */
    @ApiModelProperty(value = "门店渠道层级", notes = "")
    @Column(name = "terminal_channel_level_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '门店渠道层级 '")
    private String terminalChannelLevelCode;

    /**
     * 门店渠道编码
     */
    @ApiModelProperty(value = "门店渠道编码", notes = "")
    @Column(name = "terminal_channel_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '门店渠道编码 '")
    private String terminalChannelCode;

    /**
     * 门店渠道名称
     */
    @ApiModelProperty(value = "门店渠道名称", notes = "")
    @Column(name = "terminal_channel_name", nullable = true, length = 128, columnDefinition = "VARCHAR(128) COMMENT '门店渠道名称 '")
    private String terminalChannelName;

    /**
     * 系统编码
     */
    @ApiModelProperty(name = "系统编码", notes = "")
    @Column(name = "system_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '系统编码 '")
    private String systemCode;

    /**
     * 系统名称
     */
    @ApiModelProperty(name = "系统名称", notes = "")
    @Column(name = "system_name", nullable = true, length = 128, columnDefinition = "VARCHAR(128) COMMENT '系统名称 '")
    private String systemName;

    /**
     * 客户编码
     */
    @ApiModelProperty(name = "客户编码", notes = "")
    @Column(name = "customer_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '客户编码 '")
    private String customerCode;

    /**
     * 客户MDG编码
     */
    @ApiModelProperty(name = "客户MDG编码", notes = "")
    @Column(name = "erp_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '客户MDG编码 '")
    private String erpCode;

    /**
     * 客户名称
     */
    @ApiModelProperty(name = "客户名称", notes = "")
    @Column(name = "customer_name", nullable = true, length = 128, columnDefinition = "VARCHAR(128) COMMENT '客户名称 '")
    private String customerName;

    /**
     * 客户类型
     */
    @ApiModelProperty(value = "客户类型", notes = "")
    @Column(name = "customer_type", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '客户类型 '")
    private String customerType;

    /**
     * 门店编码
     */
    @ApiModelProperty(name = "门店编码", notes = "")
    @Column(name = "terminal_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '门店编码 '")
    private String terminalCode;

    /**
     * 门店名称
     */
    @ApiModelProperty(name = "门店名称", notes = "")
    @Column(name = "terminal_name", nullable = true, length = 256, columnDefinition = "VARCHAR(256) COMMENT '门店名称 '")
    private String terminalName;

    /**
     * 区域编码
     */
    @ApiModelProperty(name = "区域编码", notes = "")
    @Column(name = "region_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '区域编码 '")
    private String regionCode;

    /**
     * 区域名称
     */
    @ApiModelProperty(name = "区域名称", notes = "")
    @Column(name = "region_name", nullable = true, length = 256, columnDefinition = "VARCHAR(256) COMMENT '区域名称 '")
    private String regionName;

    /**
     * 品牌编码
     */
    @ApiModelProperty(name = "品牌编码", notes = "")
    @Column(name = "product_brand_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '品牌编码 '")
    private String productBrandCode;

    /**
     * 品牌名称
     */
    @ApiModelProperty(name = "品牌名称", notes = "")
    @Column(name = "product_brand_name", nullable = true, length = 128, columnDefinition = "VARCHAR(128) COMMENT '品牌名称 '")
    private String productBrandName;

    /**
     * 品类编码
     */
    @ApiModelProperty(name = "品类编码", notes = "")
    @Column(name = "product_category_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '品类编码 '")
    private String productCategoryCode;

    /**
     * 品类名称
     */
    @ApiModelProperty(name = "品类名称", notes = "")
    @Column(name = "product_category_name", nullable = true, length = 128, columnDefinition = "VARCHAR(128) COMMENT '品类名称 '")
    private String productCategoryName;

    /**
     * 品项编码
     */
    @ApiModelProperty(name = "品项编码", notes = "")
    @Column(name = "product_item_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '品项编码 '")
    private String productItemCode;

    /**
     * 品项名称
     */
    @ApiModelProperty(name = "品项名称", notes = "")
    @Column(name = "product_item_name", nullable = true, length = 128, columnDefinition = "VARCHAR(128) COMMENT '品项名称 '")
    private String productItemName;

    /**
     * 产品编码
     */
    @ApiModelProperty(name = "产品编码", notes = "")
    @Column(name = "product_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '产品编码 '")
    private String productCode;

    /**
     * 产品名称
     */
    @ApiModelProperty(name = "产品名称", notes = "")
    @Column(name = "product_name", nullable = true, length = 128, columnDefinition = "VARCHAR(128) COMMENT '产品名称 '")
    private String productName;

    /**
     * 单位编码
     */
    @ApiModelProperty(name = "单位编码", notes = "")
    @Column(name = "unit_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '单位编码 '")
    private String unitCode;

    /**
     * 单位名称
     */
    @ApiModelProperty(name = "单位名称", notes = "")
    @Column(name = "unit_name", nullable = true, length = 128, columnDefinition = "VARCHAR(128) COMMENT '单位名称 '")
    private String unitName;

    /**
     * 单价
     */
    @ApiModelProperty(name = "单价", notes = "")
    @Column(name = "price", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '单价 '")
    private BigDecimal price;

    /**
     * 吨位
     */
    @ApiModelProperty(name = "吨位", notes = "")
    @Column(name = "tonnage", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '单价 '")
    private BigDecimal tonnage;

    /**
     * 计划量
     */
    @ApiModelProperty(name = "计划量", notes = "")
    @Column(name = "plan_quantity", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '计划量 '")
    private BigDecimal planQuantity;

    /**
     * 计划金额
     */
    @ApiModelProperty(name = "计划金额", notes = "")
    @Column(name = "plan_amount", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '计划金额 '")
    private BigDecimal planAmount;

    /**
     * 计划折后金额
     */
    @ApiModelProperty(name = "计划折后金额", notes = "")
    @Column(name = "discount_plan_amount", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '计划折后金额 '")
    private BigDecimal discountPlanAmount;

    /**
     * 标准供货价
     */
    @ApiModelProperty(name = "标准供货价", notes = "")
    @Column(name = "standard_supply_price", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '标准供货价 '")
    private BigDecimal standardSupplyPrice;

    /**
     * 理论收入
     */
    @ApiModelProperty(name = "理论收入", notes = "")
    @Column(name = "theory_income", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '理论收入 '")
    private BigDecimal theoryIncome;

    /**
     * 到岸价
     */
    @ApiModelProperty(name = "到岸价", notes = "")
    @Column(name = "cif_price", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '到岸价 '")
    private BigDecimal cifPrice;

    /**
     * 理论成本
     */
    @ApiModelProperty(name = "理论成本", notes = "")
    @Column(name = "theory_cost", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '理论成本 '")
    private BigDecimal theoryCost;

    /**
     * 折前金额
     */
    @ApiModelProperty(name = "折前金额", notes = "")
    @Column(name = "amount", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '折前金额 '")
    private BigDecimal amount;

    /**
     * 折后金额
     */
    @ApiModelProperty(name = "折后金额", notes = "")
    @Column(name = "discount_amount", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '折后金额 '")
    private BigDecimal discountAmount;

    /**
     * 回复数量
     */
    @ApiModelProperty(name = "回复数量", notes = "")
    @Column(name = "restore_quantity", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '回复数量 '")
    private BigDecimal restoreQuantity;

    /**
     * 回复金额
     */
    @ApiModelProperty(name = "回复金额", notes = "")
    @Column(name = "restore_amount", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '回复金额 '")
    private BigDecimal restoreAmount;

    /**
     * 折后回复金额
     */
    @ApiModelProperty(name = "折后回复金额", notes = "")
    @Column(name = "discount_restore_amount", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '折后回复金额 '")
    private BigDecimal discountRestoreAmount;

    /**
     * 税率
     */
    @ApiModelProperty(name = "税率")
    @Column(name = "tax_rate", length = 20, columnDefinition = "decimal(20,6) COMMENT '税率'")
    private BigDecimal taxRate;

    /**
     * 折扣率
     */
    @ApiModelProperty(name = "折扣率")
    @Column(name = "discount_rate", length = 20, columnDefinition = "decimal(20,6) COMMENT '折扣率'")
    private BigDecimal discountRate;

    //    3、【属性】填写内容验证：数据字典sales_plan_attributes_subsidiary；
    @ApiModelProperty(name = "属性-分子")
    @Column(name = "attributes_subsidiary", length = 32, columnDefinition = "VARCHAR(32)  COMMENT '属性-分子'")
    private String attributesSubsidiary;

    //    4、【渠道细分】填写内容验证：数据字典channel_segmentation_subsidiary_companies；
    @ApiModelProperty(name = "渠道细分-分子")
    @Column(name = "channel_segmentation_subsidiary", length = 32, columnDefinition = "VARCHAR(32) COMMENT '渠道细分-分子'")
    private String channelSegmentationSubsidiary;

    //    5、【经营模式】填写内容验证：数据字典sales_plan_business_model_subsidiary_companies；
    @ApiModelProperty(name = "经营模式-分子")
    @Column(name = "business_model_subsidiary", length = 20, columnDefinition = "VARCHAR(32) COMMENT '经营模式-分子'")
    private String businessModelSubsidiary;

    /**
     * 唯一键 ，主体同步数据时，校验使用;业态+业务单元+年月+客户编码+产品编码+单位
     */
    @ApiModelProperty(name = "onlyKey")
    @Column(name = "only_key", length = 256, columnDefinition = "VARCHAR(255) COMMENT '唯一键 业态+业务单元+年月+客户编码+产品编码+单位'")
    private String onlyKey;

    @ApiModelProperty(name = "预留字段1")
    @Column(name = "ext1", length = 64, columnDefinition = "VARCHAR(64) COMMENT '预留字段1'")
    private String ext1;

    @ApiModelProperty(name = "预留字段2")
    @Column(name = "ext2", length = 64, columnDefinition = "VARCHAR(64) COMMENT '预留字段2'")
    private String ext2;

    @ApiModelProperty(name = "预留字段3")
    @Column(name = "ext3", length = 64, columnDefinition = "VARCHAR(63) COMMENT '预留字段3'")
    private String ext3;

    @ApiModelProperty(name = "预留字段4")
    @Column(name = "ext4", length = 64, columnDefinition = "VARCHAR(64) COMMENT '预留字段4'")
    private String ext4;

    @ApiModelProperty(name = "预留字段5")
    @Column(name = "ext5", length = 64, columnDefinition = "VARCHAR(64) COMMENT '预留字段5'")
    private String ext5;

    @ApiModelProperty(name = "预留字段6")
    @Column(name = "ext6", length = 64, columnDefinition = "VARCHAR(64) COMMENT '预留字段6'")
    private String ext6;

    @ApiModelProperty(name = "预留字段7")
    @Column(name = "ext7", length = 64, columnDefinition = "VARCHAR(64) COMMENT '预留字段7'")
    private String ext7;

    @ApiModelProperty(name = "预留字段8")
    @Column(name = "ext8", length = 64, columnDefinition = "VARCHAR(64) COMMENT '预留字段8'")
    private String ext8;

    @ApiModelProperty(name = "预留字段9")
    @Column(name = "ext9", length = 64, columnDefinition = "VARCHAR(64) COMMENT '预留字段9'")
    private String ext9;

    @ApiModelProperty(name = "预留字段10")
    @Column(name = "ext10", length = 64, columnDefinition = "VARCHAR(64) COMMENT '预留字段10'")
    private String ext10;

    @ApiModelProperty("出货折扣率（0.00%）")
    @Column(name = "shipping_discount_rate", length = 20, columnDefinition = "decimal(20,6) COMMENT '出货折扣率（0.00%）'")
    private BigDecimal shippingDiscountRate;

    @ApiModelProperty("折后收入（元）")
    @Column(name = "discounted_income", length = 20, columnDefinition = "decimal(20,6) COMMENT '折后收入'")
    private BigDecimal discountedIncome;

    @ApiModelProperty("折后成本（元）")
    @Column(name = "discounted_cost", length = 20, columnDefinition = "decimal(20,6) COMMENT '折后成本'")
    private BigDecimal discountedCost;

    @ApiModelProperty("增值税（元）")
    @Column(name = "vat", length = 20, columnDefinition = "decimal(20,6) COMMENT '增值税'")
    private BigDecimal vat;

    @ApiModelProperty("税金附加（元）")
    @Column(name = "taxes_additional", length = 20, columnDefinition = "decimal(20,6) COMMENT '税金附加'")
    private BigDecimal taxesAdditional;

    @ApiModelProperty("税费（元）")
    @Column(name = "taxes_fee", length = 20, columnDefinition = "decimal(20,6) COMMENT '税费（元）'")
    private BigDecimal taxesFee;

    /**
     * 数据状态
     */
    @ApiModelProperty(name = "数据状态", notes = "")
    @Column(name = "special_data_status", nullable = true, length = 10, columnDefinition = "VARCHAR(32) COMMENT '数据状态 '")
    private String specialDataStatus;

    /**
     * 确认人账号
     */
    @ApiModelProperty(name = "确认人账号", notes = "")
    @Column(name = "confirmed_account", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '确认人账号 '")
    private String confirmedAccount;

    /**
     * 确认人姓名
     */
    @ApiModelProperty(name = "确认人姓名", notes = "")
    @Column(name = "confirmed_name", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '确认人姓名 '")
    private String confirmedName;

    /**
     * 确认意见
     */
    @ApiModelProperty(name = "确认意见", notes = "")
    @Column(name = "confirmed_opinion", nullable = true, length = 128, columnDefinition = "VARCHAR(128) COMMENT '确认意见 '")
    private String confirmedOpinion;
}
