package com.biz.crm.tpm.business.sales.plan.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.sales.plan.local.entity.SalesPlanEntity;
import com.biz.crm.tpm.business.sales.plan.sdk.dto.SalesPlanDto;
import com.biz.crm.tpm.business.sales.plan.sdk.dto.SalesPlanReCalPlanAndReplyDto;
import com.biz.crm.tpm.business.sales.plan.sdk.dto.SalesPlanSummaryDto;
import com.biz.crm.tpm.business.sales.plan.sdk.vo.SalesPlanVo;
import org.apache.ibatis.annotations.Param;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author huojia
 * @date 2022年10月26日 14:21
 */
public interface SalesPlanMapper extends BaseMapper<SalesPlanEntity> {

    /**
     * 分页查询
     *
     * @param page
     * @param dto
     * @return com.baomidou.mybatisplus.extension.plugins.pagination.Page<com.biz.crm.tpm.business.sales.plan.sdk.vo.SalesPlanVo>
     * @author huojia
     * @date 2022/10/26 14:40
     **/
    Page<SalesPlanVo> findByConditions(Page<SalesPlanVo> page, @Param("dto") SalesPlanDto dto);

    /**
     * 条件查询销售计划
     *
     * @param salesPlanDto
     * @return java.util.List<com.biz.crm.tpm.business.sales.plan.local.entity.SalesPlanEntity>
     * @author huojia
     * @date 2022/11/4 19:53
     **/
    List<SalesPlanEntity> listByConditions(@Param("dto") SalesPlanDto salesPlanDto,@Param("limitSize") int limitSize);

    /**
     * 通过唯一键集合查询最大版本的销售计划
     *
     * @param onlyKeys   唯一键集合
     * @param tenantCode 租户编码
     * @return List<SalesPlanEntity>
     */
    List<SalesPlanEntity> getMaxVersionSalesPlan(@Param("onlyKeys") List<List<String>> onlyKeys, @Param("tenantCode") String tenantCode);

    /**
     * 通过id查询销售计划
     *
     * @param idList id集合
     * @param tenantCode 租户编码
     * @return List<SalesPlanEntity>
     */
    List<SalesPlanEntity> getSalesPlanByIds(@Param("idList") List<List<String>> idList, @Param("tenantCode") String tenantCode);

    /**
     * 根据维度统计回复量
     *
     * @param dto        查询实体
     * @param tenantCode 租户
     * @return List<SalesPlanEntity>
     */
    List<SalesPlanEntity> summaryRecoveryAmountCus(@Param("dto") SalesPlanSummaryDto dto, @Param("tenantCode") String tenantCode);

    /**
     * 根据维度统计回复量
     *
     * @param dto        查询实体
     * @param tenantCode 租户
     * @return List<SalesPlanEntity>
     */
    List<SalesPlanEntity> summaryRecoveryAmountCusAndPro(@Param("dto") SalesPlanSummaryDto dto, @Param("tenantCode") String tenantCode);

    /**
     * 根据维度统计回复量
     *
     * @param dto        查询实体
     * @param tenantCode 租户
     * @return List<SalesPlanEntity>
     */
    List<SalesPlanEntity> summaryRecoveryAmountPro(@Param("dto") SalesPlanSummaryDto dto, @Param("tenantCode") String tenantCode);

    /**
     * 分页查询数据
     *
     * @param page 分页对象
     * @param dto  查询Dto
     * @return Page<SalesPlanEntity>
     */
    Page<SalesPlanEntity> findSalesPlanByConditions(Page<SalesPlanEntity> page, @Param("dto") SalesPlanReCalPlanAndReplyDto dto);

    List<SalesPlanVo> findSalesPlanSumVo(@Param("dto") SalesPlanDto queryDto);

    Page<SalesPlanVo> findForSalesVolumeMonitoring(Page<SalesPlanVo> page,@Param("dto") SalesPlanDto dto);

    List<SalesPlanVo> sumReplayReimburse(@Param("dto") SalesPlanDto dto);

    List<SalesPlanVo> sumReplayRestore(@Param("dto") SalesPlanDto dto);

    List<SalesPlanVo> sumReplayPlan(@Param("dto") SalesPlanDto dto);

    /**
     * 查询销量
     * @param dto
     * @return
     */
    BigDecimal findSaleAmount(@Param("dto") SalesPlanDto dto);

    List<SalesPlanVo> findForSaleAndFeeMonitoring(@Param("list") List<SalesPlanDto> dtos);

    int saveBatch(@Param("list") List<SalesPlanEntity> list);

}
