package com.biz.crm.tpm.business.sales.plan.local.repository;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.enums.SqlMethod;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.dto.DiscountRateDto;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.vo.DiscountRateVo;
import com.biz.crm.tpm.business.sales.plan.local.entity.SalesPlanEntity;
import com.biz.crm.tpm.business.sales.plan.local.mapper.SalesPlanMapper;
import com.biz.crm.tpm.business.sales.plan.sdk.dto.SalesPlanDto;
import com.biz.crm.tpm.business.sales.plan.sdk.dto.SalesPlanReCalPlanAndReplyDto;
import com.biz.crm.tpm.business.sales.plan.sdk.dto.SalesPlanSummaryDto;
import com.biz.crm.tpm.business.sales.plan.sdk.vo.SalesPlanImportsVo;
import com.biz.crm.tpm.business.sales.plan.sdk.vo.SalesPlanVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author huojia
 * @date 2022年10月26日 14:24
 */
@Component
public class SalesPlanRepository extends ServiceImpl<SalesPlanMapper, SalesPlanEntity> {

    @Autowired(required = false)
    private SalesPlanMapper salesPlanMapper;

    @Autowired
    private LoginUserService loginUserService;

    /**
     * 根据id、删除标记查询预算项目
     *
     * @param id
     * @param delFlag
     * @return com.biz.crm.tpm.business.sales.plan.local.entity.SalesPlanEntity
     * @author huojia
     * @date 2022/10/27 11:19
     **/
    public SalesPlanEntity getById(String id, String delFlag) {
        if (StringUtils.isEmpty(id)) {
            return null;
        }
        return this.lambdaQuery().eq(SalesPlanEntity::getId, id)
                .eq(StringUtils.isNotEmpty(delFlag), UuidFlagOpEntity::getDelFlag, delFlag)
                .one();
    }


    public List<SalesPlanEntity> findByConditions(SalesPlanDto dto) {
        if (StringUtils.isEmpty(dto.getYearMonthLy())
                && StringUtils.isEmpty(dto.getYearMonthLyBegin()) && StringUtils.isEmpty(dto.getYearMonthLyEnd())
                && StringUtils.isEmpty(dto.getProductCode()) && CollectionUtils.isEmpty(dto.getSalesProductCodeList())
                && StringUtils.isEmpty(dto.getProductItemCode()) && StringUtils.isEmpty(dto.getProductCategoryCode()) && StringUtils.isEmpty(dto.getProductBrandCode())
                && StringUtils.isEmpty(dto.getProductItemName()) && StringUtils.isEmpty(dto.getUnitCode())
                && StringUtils.isEmpty(dto.getCustomerCode())  && CollectionUtils.isEmpty(dto.getCustomerCodeList()) && StringUtils.isEmpty(dto.getErpCode())
                && StringUtils.isEmpty(dto.getSalesInstitutionCode())
                && StringUtils.isEmpty(dto.getSalesOrgRegionCode()) && StringUtils.isEmpty(dto.getSalesOrgProvinceCode())
                && StringUtils.isEmpty(dto.getSalesInstitutionErpCode())
        ) {
            return Lists.newArrayList();
        }

        return this.lambdaQuery()
                .eq(SalesPlanEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(SalesPlanEntity::getEnableStatus, EnableStatusEnum.ENABLE.getCode())

                .eq(StringUtils.isNotEmpty(dto.getYearMonthLy()), SalesPlanEntity::getYearMonthLy, dto.getYearMonthLy())
                .ge(StringUtils.isNotEmpty(dto.getYearMonthLyBegin()), SalesPlanEntity::getYearMonthLy, dto.getYearMonthLyBegin())
                .le(StringUtils.isNotEmpty(dto.getYearMonthLyEnd()), SalesPlanEntity::getYearMonthLy, dto.getYearMonthLyEnd())
                .eq(StringUtils.isNotEmpty(dto.getProductCode()), SalesPlanEntity::getProductCode, dto.getProductCode())
                .eq(StringUtils.isNotEmpty(dto.getProductBrandCode()), SalesPlanEntity::getProductBrandCode, dto.getProductBrandCode())
                .eq(StringUtils.isNotEmpty(dto.getProductCategoryCode()), SalesPlanEntity::getProductCategoryCode, dto.getProductCategoryCode())
                .eq(StringUtils.isNotEmpty(dto.getProductItemCode()), SalesPlanEntity::getProductItemCode, dto.getProductItemCode())
                .eq(StringUtils.isNotEmpty(dto.getProductItemName()), SalesPlanEntity::getProductItemName, dto.getProductItemName())
                .eq(StringUtils.isNotEmpty(dto.getUnitCode()), SalesPlanEntity::getUnitCode, dto.getUnitCode())
                .eq(StringUtils.isNotEmpty(dto.getCustomerCode()), SalesPlanEntity::getCustomerCode, dto.getCustomerCode())
                .eq(StringUtils.isNotEmpty(dto.getErpCode()), SalesPlanEntity::getErpCode, dto.getErpCode())
                .in(!CollectionUtils.isEmpty(dto.getCustomerCodeList()), SalesPlanEntity::getCustomerCode, dto.getCustomerCodeList())
                .eq(StringUtils.isNotEmpty(dto.getSalesInstitutionCode()), SalesPlanEntity::getSalesInstitutionCode, dto.getSalesInstitutionCode())
                .eq(StringUtils.isNotEmpty(dto.getSalesOrgRegionCode()), SalesPlanEntity::getSalesOrgRegionCode, dto.getSalesOrgRegionCode())
                .eq(StringUtils.isNotEmpty(dto.getSalesInstitutionErpCode()),SalesPlanEntity::getSalesInstitutionErpCode,dto.getSalesInstitutionErpCode())
                .eq(StringUtils.isNotEmpty(dto.getSalesOrgProvinceCode()), SalesPlanEntity::getSalesOrgProvinceCode, dto.getSalesOrgProvinceCode())
                .eq(StringUtils.isNotEmpty(dto.getBusinessUnitCode()),SalesPlanEntity::getBusinessUnitCode,dto.getBusinessUnitCode())
                .eq(StringUtils.isNotEmpty(dto.getTerminalCode()),SalesPlanEntity::getTerminalCode,dto.getTerminalCode())
                .in(CollectionUtils.isNotEmpty(dto.getTerminalCodes()),SalesPlanEntity::getTerminalCode,dto.getTerminalCodes())
                .in(CollectionUtils.isNotEmpty(dto.getSalesProductCodeList()), SalesPlanEntity::getProductCode, dto.getSalesProductCodeList())
                .eq(StringUtils.isNotEmpty(dto.getCustomerRetailerCode()),SalesPlanEntity::getCustomerRetailerCode,dto.getCustomerRetailerCode())
                .in(CollectionUtils.isNotEmpty(dto.getRegionCodes()),SalesPlanEntity::getRegionCode,dto.getRegionCodes())
                .eq(StringUtils.isNotEmpty(dto.getSpecialDataStatus()),SalesPlanEntity::getSpecialDataStatus,dto.getSpecialDataStatus())
                .eq(StringUtils.isNotBlank(dto.getBusinessFormatCode()),SalesPlanEntity::getBusinessFormatCode,dto.getBusinessFormatCode())
                .eq(StringUtils.isNotBlank(dto.getOrgCode()),SalesPlanEntity::getOrgCode,dto.getOrgCode())
                .list();
    }

    /**
     * 根据单据号批量查询
     *
     * @param orderNoList
     * @return java.util.List<com.biz.crm.tpm.business.sales.plan.local.entity.SalesPlanEntity>
     * @author huojia
     * @date 2022/12/21 11:32
     **/
    public List<SalesPlanEntity> findByOrderNos(List<String> orderNoList) {
        if (CollectionUtils.isEmpty(orderNoList)) {
            return null;
        }
        return this.lambdaQuery()
                .in(SalesPlanEntity::getOrderNo, orderNoList)
                .eq(UuidFlagOpEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .list();
    }

    /**
     * 通过唯一键集合查询最大版本的销售计划
     *
     * @param onlyKeys   唯一键集合
     * @param tenantCode 租户编码
     * @return List<SalesPlanEntity>
     */
    public List<SalesPlanEntity> getMaxVersionSalesPlan(List<List<String>> onlyKeys, String tenantCode) {
        return this.baseMapper.getMaxVersionSalesPlan(onlyKeys, tenantCode);
    }

    /**
     * 通过id查询销售计划
     *
     * @param idList id集合
     * @return List<SalesPlanEntity>
     */
    public List<SalesPlanEntity> getSalesPlanByIds(List<List<String>> idList, String tenantCode) {
        return this.baseMapper.getSalesPlanByIds(idList, tenantCode);
    }

    /**
     * 根据维度统计回复量 客户
     *
     * @param dto        查询实体
     * @param tenantCode 租户
     * @return List<SalesPlanEntity>
     */
    public List<SalesPlanEntity> summaryRecoveryAmountCus(SalesPlanSummaryDto dto, String tenantCode) {
        return this.baseMapper.summaryRecoveryAmountCus(dto, tenantCode);
    }

    /**
     * 根据维度统计回复量 客户+产品
     *
     * @param dto        查询实体
     * @param tenantCode 租户
     * @return List<SalesPlanEntity>
     */
    public List<SalesPlanEntity> summaryRecoveryAmountCusAndPro(SalesPlanSummaryDto dto, String tenantCode) {
        return this.baseMapper.summaryRecoveryAmountCusAndPro(dto, tenantCode);
    }

    /**
     * 根据维度统计回复量 产品
     *
     * @param dto        查询实体
     * @param tenantCode 租户
     * @return List<SalesPlanEntity>
     */
    public List<SalesPlanEntity> summaryRecoveryAmountPro(SalesPlanSummaryDto dto, String tenantCode) {
        return this.baseMapper.summaryRecoveryAmountPro(dto, tenantCode);
    }

    /**
     * 唯一性验证
     *
     * @param dto dto
     */
    public List<SalesPlanEntity> uniqueness(SalesPlanDto dto) {

        return this.lambdaQuery()
                //版本号
                .eq(StrUtil.isNotBlank(dto.getVersionNumber()),SalesPlanEntity::getVersionNumber,dto.getVersionNumber())
                //业态
                .eq(StrUtil.isNotBlank(dto.getBusinessFormatCode()),SalesPlanEntity::getBusinessFormatCode,dto.getBusinessFormatCode())
                //业务单元
                .eq(StrUtil.isNotBlank(dto.getBusinessUnitCode()),SalesPlanEntity::getBusinessUnitCode,dto.getBusinessUnitCode())
                //年月
                .eq(StrUtil.isNotBlank(dto.getYearMonthLy()),SalesPlanEntity::getYearMonthLy,dto.getYearMonthLy())
                //分组
                .eq(StrUtil.isNotBlank(dto.getGroupCode()),SalesPlanEntity::getGroupCode,dto.getGroupCode())

                .eq(StrUtil.isNotBlank(dto.getSalesOrgCode()),SalesPlanEntity::getSalesOrgCode,dto.getSalesOrgCode())

                .eq(StrUtil.isNotBlank(dto.getSalesOrgName()),SalesPlanEntity::getSalesOrgName,dto.getSalesOrgName())
                //销售机构编码
                .eq(StrUtil.isNotBlank(dto.getSalesInstitutionCode()),SalesPlanEntity::getSalesInstitutionCode,dto.getSalesInstitutionCode())
                //销售机构名称
                .eq(StrUtil.isNotBlank(dto.getSalesInstitutionName()),SalesPlanEntity::getSalesInstitutionName,dto.getSalesInstitutionName())
                //销售部门编码（大区）
                .eq(StrUtil.isNotBlank(dto.getSalesOrgRegionCode()),SalesPlanEntity::getSalesOrgRegionCode,dto.getSalesOrgRegionCode())
                //销售部门名称（大区）
                .eq(StrUtil.isNotBlank(dto.getSalesOrgRegionName()),SalesPlanEntity::getSalesOrgRegionName,dto.getSalesOrgRegionName())
                //销售组编码（省区）
                .eq(StrUtil.isNotBlank(dto.getSalesOrgProvinceCode()),SalesPlanEntity::getSalesOrgProvinceCode,dto.getSalesOrgProvinceCode())
                //销售组名称（省区）
                .eq(StrUtil.isNotBlank(dto.getSalesOrgProvinceName()),SalesPlanEntity::getSalesOrgProvinceName,dto.getSalesOrgProvinceName())
                //客户编码
                .eq(StrUtil.isNotBlank(dto.getCustomerCode()),SalesPlanEntity::getCustomerCode,dto.getCustomerCode())
                //客户名称
                .eq(StrUtil.isNotBlank(dto.getCustomerName()),SalesPlanEntity::getCustomerName,dto.getCustomerName())
                //门店编码
                .eq(StrUtil.isNotBlank(dto.getTerminalCode()),SalesPlanEntity::getTerminalCode,dto.getTerminalCode())
                //门店名称
                .eq(StrUtil.isNotBlank(dto.getTerminalName()),SalesPlanEntity::getTerminalName,dto.getTerminalName())
                //客户渠道名称
                .eq(StrUtil.isNotBlank(dto.getCustomerChannelCode()),SalesPlanEntity::getCustomerChannelCode,dto.getCustomerChannelCode())
                //客户渠道编码
                .eq(StrUtil.isNotBlank(dto.getCustomerChannelName()),SalesPlanEntity::getCustomerChannelName,dto.getCustomerChannelName())
                //客户渠道层级名称
                .eq(StrUtil.isNotBlank(dto.getCustomerChannelLevelCode()),SalesPlanEntity::getCustomerChannelLevelCode,dto.getCustomerChannelLevelCode())
                //门店渠道名称
                .eq(StrUtil.isNotBlank(dto.getTerminalChannelCode()),SalesPlanEntity::getTerminalChannelCode,dto.getTerminalChannelCode())
                //门店渠道编码
                .eq(StrUtil.isNotBlank(dto.getTerminalChannelName()),SalesPlanEntity::getTerminalChannelName,dto.getTerminalChannelName())
                //门店渠道层级
                .eq(StrUtil.isNotBlank(dto.getTerminalChannelLevelCode()),SalesPlanEntity::getTerminalChannelLevelCode,dto.getTerminalChannelLevelCode())
                //产品编码
                .eq(StrUtil.isNotBlank(dto.getProductCode()),SalesPlanEntity::getProductCode,dto.getProductCode())
                //产品名称
                .eq(StrUtil.isNotBlank(dto.getProductName()),SalesPlanEntity::getProductName,dto.getProductName())
                //单位编码
                .eq(StrUtil.isNotBlank(dto.getUnitCode()),SalesPlanEntity::getUnitCode,dto.getUnitCode())
                //单位名称
                .eq(StrUtil.isNotBlank(dto.getUnitName()),SalesPlanEntity::getUnitName,dto.getUnitName())
                //品牌编码
                .eq(StrUtil.isNotBlank(dto.getProductBrandCode()),SalesPlanEntity::getProductBrandCode,dto.getProductBrandCode())
                //品牌名称
                .eq(StrUtil.isNotBlank(dto.getProductBrandName()),SalesPlanEntity::getProductBrandName,dto.getProductBrandName())
                //品类编码
                .eq(StrUtil.isNotBlank(dto.getProductCategoryCode()),SalesPlanEntity::getProductCategoryCode,dto.getProductCategoryCode())
                //品类名称
                .eq(StrUtil.isNotBlank(dto.getProductCategoryName()),SalesPlanEntity::getProductCategoryName,dto.getProductCategoryName())
                //品项编码
                .eq(StrUtil.isNotBlank(dto.getProductItemCode()),SalesPlanEntity::getProductItemCode,dto.getProductItemCode())
                //品项名称
                .eq(StrUtil.isNotBlank(dto.getProductItemName()),SalesPlanEntity::getProductItemName,dto.getProductItemName())
                //排除删除的数据
                .eq(SalesPlanEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .list();
    }

    /**
     * 分页查询数据
     *
     * @param page 分页对象
     * @param planDto  查询Dto
     * @return Page<DiscountRateConfigVo>
     */
    public Page<SalesPlanEntity> findSalesPlanByConditions(Page<SalesPlanEntity> page, SalesPlanReCalPlanAndReplyDto planDto) {
        return this.salesPlanMapper.findSalesPlanByConditions(page, planDto);
    }


    /**
     * 批量插入
     *
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean saveBatch(Collection<SalesPlanEntity> entityList) {
        return saveBatch(entityList,DEFAULT_BATCH_SIZE);
    }

    /**
     * 批量插入
     *
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean saveBatch(Collection<SalesPlanEntity> entityList, int batchSize) {
        if (CollectionUtils.isEmpty(entityList)){
            return true;
        }
        AbstractCrmUserIdentity context = this.loginUserService.getAbstractLoginUser();
        Date curDate = new Date();
        String account = context != null && StringUtils.isNotBlank(context.getAccount()) ? context.getAccount() : "admin";
        String name = context != null && StringUtils.isNotBlank(context.getRealName()) ? context.getRealName() : "系统用户或系统定时任务";
        List<List<SalesPlanEntity>> partition = Lists.partition(Lists.newArrayList(entityList), batchSize);
        for (List<SalesPlanEntity> partitionList : partition) {
            for (SalesPlanEntity salesPlanEntity : partitionList) {
                salesPlanEntity.setCreateTime(curDate);
                salesPlanEntity.setCreateName(name);
                salesPlanEntity.setCreateAccount(account);
                salesPlanEntity.setModifyTime(curDate);
                salesPlanEntity.setModifyName(name);
                salesPlanEntity.setModifyAccount(account);
                salesPlanEntity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                salesPlanEntity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                salesPlanEntity.setTenantCode(TenantUtils.getTenantCode());
            }
            salesPlanMapper.saveBatch(partitionList);
        }
        return true;
    }

    public List<SalesPlanVo> sumReplayReimburse(SalesPlanDto dto) {
        return salesPlanMapper.sumReplayReimburse(dto);
    }

    public List<SalesPlanVo> sumReplayRestore(SalesPlanDto dto) {
        return salesPlanMapper.sumReplayRestore(dto);
    }

    public List<SalesPlanVo> sumReplayPlan(SalesPlanDto dto) {
        return salesPlanMapper.sumReplayPlan(dto);
    }


    public void updateDelStatus(List<String> ids, String delFlag) {
        if (CollectionUtils.isEmpty(ids)){
            return;
        }
        this.lambdaUpdate()
                .set(SalesPlanEntity::getDelFlag,delFlag)
                .eq(SalesPlanEntity::getTenantCode,TenantUtils.getTenantCode())
                .in(SalesPlanEntity::getId,ids)
                .update();
    }
}
