package com.biz.crm.tpm.business.sales.plan.local.service;

import com.biz.crm.tpm.business.sales.plan.local.entity.SalesPlanEntity;
import com.biz.crm.tpm.business.sales.plan.sdk.dto.SalesPlanDto;

import java.util.List;

/**
 * @author: chenlong
 * @date: 2023/1/12 14:56
 * @description: 月销售计划(SalesPlanEntity)表服务接口
 */
public interface SalesPlanEntityService {

    /**
     * 保存数据
     *
     * @param addList 新增对象
     * @param updateList 更新对象
     * @return List<SalesPlanEntity>
     */
    List<SalesPlanEntity> saveThirdSystemBatch(List<SalesPlanDto> addList, List<SalesPlanDto> updateList);

    /**
     * 异步计算折后数据
     *
     * @param planList 销售计划数据
     */
    void syncCalDiscount(List<SalesPlanEntity> planList);

    /**
     * 通过唯一键集合查询最大版本的销售计划
     *
     * @param onlyKeys 唯一键集合
     * @return List<SalesPlanEntity>
     */
    List<SalesPlanEntity> getMaxVersionSalesPlan(List<List<String>> onlyKeys);

    /**
     * 通过id查询销售计划
     *
     * @param ids id集合
     * @return List<SalesPlanEntity>
     */
    List<SalesPlanEntity> getSalesPlanByIds(List<List<String>> ids);
}
