package com.biz.crm.tpm.business.sales.plan.local.service.internal;

import com.biz.crm.business.common.sdk.dto.UuidDto;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.tpm.business.sales.plan.local.entity.SalesPlanEntity;
import com.biz.crm.tpm.business.sales.plan.local.service.MainPlanAndReplyLogService;
import com.biz.crm.tpm.business.sales.plan.sdk.dto.SalesPlanDto;
import com.biz.crm.tpm.business.sales.plan.sdk.dto.SalesPlanLogEventDto;
import com.biz.crm.tpm.business.sales.plan.sdk.event.SalesPlanLogEventListener;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import liquibase.util.StringUtil;
import lombok.SneakyThrows;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author: chenlong
 * @date: 2023/3/1 16:44
 * @description:
 */
@Service("mainPlanAndReplyLogService")
@Slf4j
public class MainPlanAndReplyLogServiceImpl implements MainPlanAndReplyLogService {

    @Autowired(required = false)
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required = false)
    private LoginUserService loginUserService;


    /**
     * 日志异步处理
     *
     * @param planList 新数据
     * @param oldMap   历史数据
     */
    @Async("logThread")
    @SneakyThrows
    @Override
    public void editLogAsync(List<SalesPlanEntity> planList, Map<String, SalesPlanEntity> oldMap, AbstractCrmUserIdentity loginDetails) {
        loginUserService.refreshAuthentication(loginDetails);
        //保存新增编辑日志
        SerializableBiConsumer<SalesPlanLogEventListener, SalesPlanLogEventDto> onCreate =
                SalesPlanLogEventListener::onCreate;
        SerializableBiConsumer<SalesPlanLogEventListener, SalesPlanLogEventDto> onUpdate =
                SalesPlanLogEventListener::onUpdate;

        Map<String, SalesPlanDto> newMap = this.nebulaToolkitService.copyCollectionByWhiteList(planList,
                SalesPlanEntity.class, SalesPlanDto.class, HashSet.class, ArrayList.class).stream()
                .filter(k -> StringUtil.isNotEmpty(k.getId()))
                .collect(Collectors.toMap(UuidDto::getId, v -> v, (newValue, oldValue) -> newValue));

        Map<String, SalesPlanDto> oldDtoMap = this.nebulaToolkitService.copyCollectionByWhiteList(oldMap.values(),
                SalesPlanEntity.class, SalesPlanDto.class, HashSet.class, ArrayList.class).stream()
                .filter(k -> StringUtil.isNotEmpty(k.getId()))
                .collect(Collectors.toMap(UuidDto::getId, v -> v, (newValue, oldValue) -> newValue));

        for (SalesPlanEntity entity : planList) {

            SalesPlanDto dto = newMap.getOrDefault(entity.getId(), new SalesPlanDto());
            SalesPlanLogEventDto logEventDto = new SalesPlanLogEventDto();
            //编辑日志
            if (oldMap.containsKey(dto.getId())) {
                logEventDto.setOriginal(oldDtoMap.getOrDefault(dto.getId(), new SalesPlanDto()));
                logEventDto.setNewest(dto);
                this.nebulaNetEventClient.publish(logEventDto, SalesPlanLogEventListener.class, onUpdate);
            } else {
                //新增日志
                logEventDto.setOriginal(null);
                logEventDto.setNewest(dto);
                this.nebulaNetEventClient.publish(logEventDto, SalesPlanLogEventListener.class, onCreate);
            }
        }
    }
}
