package com.biz.crm.tpm.business.sales.plan.local.service.internal;

import com.baomidou.mybatisplus.extension.api.R;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.mn.common.base.constant.CommonConstant;
import com.biz.crm.mn.common.base.eunm.BusinessFormatEnum;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.eunm.DataFromEnum;
import com.biz.crm.mn.common.base.eunm.ForeignSystemEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.common.base.util.ExceptionStackMsgUtil;
import com.biz.crm.mn.third.system.cow.master.guest.sdk.dto.CowMasterGuestMonthPlanDto;
import com.biz.crm.mn.third.system.cow.master.guest.sdk.service.CowMasterGuestService;
import com.biz.crm.mn.third.system.cow.master.guest.sdk.vo.CowMasterGuestMonthPlanVo;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.enums.DiscountRateDimensionEnum;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.enums.DiscountRateVersionEnum;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.service.DiscountRateSdkService;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.vo.DiscountRateBudgetVo;
import com.biz.crm.tpm.business.sales.plan.local.entity.SalesPlanEntity;
import com.biz.crm.tpm.business.sales.plan.local.repository.SalesPlanRepository;
import com.biz.crm.tpm.business.sales.plan.local.service.SalesPlanCowMasterGuestService;
import com.biz.crm.tpm.business.sales.plan.sdk.constant.SalesPlanConstant;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author huojia
 * @date 2022年12月21日 16:34
 */
@Slf4j
@Service
public class SalesPlanCowMasterGuestServiceImpl implements SalesPlanCowMasterGuestService {

    @Autowired(required = false)
    private CowMasterGuestService cowMasterGuestService;

    @Autowired(required = false)
    private DiscountRateSdkService discountRateSdkService;

    @Autowired(required = false)
    private ProductVoService productVoService;

    @Autowired(required = false)
    private SalesPlanRepository salesPlanRepository;

    @Autowired(required = false)
    private RedisLockService redisLockService;

    @Autowired(required = false)
    private SalesOrgVoService salesOrgVoService;

    /**
     * 批量拉取数据
     *
     * @author huojia
     * @date 2022/12/21 10:23
     **/
    @Override
    public void pullMonthPlanList(CowMasterGuestMonthPlanDto dto) {
        Validate.notNull(dto, "请求参数不能为空！");
        if (StringUtils.isEmpty(dto.getYear())) {
            dto.setYear(Integer.toString(DateUtil.getCurrentYear()));
        }
        if (StringUtils.isEmpty(dto.getMonths())) {
            dto.setMonths(DateUtil.format(new Date(), DateUtil.DEFAULT_YEAR_MONTH).split("-")[1]);
        }
        boolean lock = true;
        int pageNum = 1;
        String lockKey = DateUtil.format(new Date(), DateUtil.DEFAULT_YEAR_MONTH);
        int loopMAX = 40;
        boolean loopFlag = true;
        try {
            lock = this.lock(lockKey);
            if (!lock) {
                return;
            }
            Map<String, String> codeMap = new HashMap<>(8);
            while (loopFlag) {
                dto.setCurrent(pageNum);
                dto.setSize(CommonConstant.MAX_PAGE_SIZE);
                List<CowMasterGuestMonthPlanVo> cowMasterGuestMonthPlanVoList = cowMasterGuestService.pullMonthPlanVo(dto);
                pageNum++;
                if (CollectionUtils.isEmpty(cowMasterGuestMonthPlanVoList)) {
                    loopFlag = false;
                    return;
                }
                // 数据校验
                List<SalesPlanEntity> pullList = this.monthPlanValidate(cowMasterGuestMonthPlanVoList, codeMap);
                List<String> orderNoList = pullList.stream()
                        .map(SalesPlanEntity::getOrderNo).collect(Collectors.toList());
                // 区分更新、新增操作
                List<SalesPlanEntity> byOrderNos = salesPlanRepository.findByOrderNos(orderNoList);
                if (CollectionUtils.isEmpty(byOrderNos)) {
                    this.saveOrUpdateCowBatch(pullList, null);
                    continue;
                }
                // 区分更新、新增
                List<SalesPlanEntity> saveList = new ArrayList<>();
                List<SalesPlanEntity> updateList = new ArrayList<>();
                Map<String, SalesPlanEntity> map = byOrderNos.stream().collect(Collectors.toMap(SalesPlanEntity::getOrderNo, Function.identity()));
                pullList.forEach(pull -> {
                    if (map.containsKey(pull.getOrderNo())) {
                        SalesPlanEntity salesPlanEntity = map.get(pull.getOrderNo());
                        salesPlanEntity.setOrderNo(pull.getOrderNo());
                        salesPlanEntity.setFromSystem(ForeignSystemEnum.COW_MASTER_GUEST.getCode());
                        salesPlanEntity.setBusinessFormatCode(BusinessFormatEnum.NORMAL.getCode());
                        salesPlanEntity.setBusinessUnitCode(BusinessUnitEnum.VERTICAL.getCode());
                        salesPlanEntity.setYearMonthLy(pull.getYearMonthLy());
                        salesPlanEntity.setSalesOrgRegionCode(pull.getSalesOrgRegionCode());
                        salesPlanEntity.setSalesOrgRegionName(pull.getSalesOrgRegionName());
                        salesPlanEntity.setRegionCode(pull.getRegionCode());
                        salesPlanEntity.setRegionName(pull.getRegionName());
                        salesPlanEntity.setSystemCode(pull.getSystemCode());
                        salesPlanEntity.setSystemName(pull.getSystemName());
                        salesPlanEntity.setCustomerRetailerCode(pull.getCustomerRetailerCode());
                        salesPlanEntity.setCustomerRetailerName(pull.getCustomerRetailerName());
                        salesPlanEntity.setPointsWarehouseCode(pull.getPointsWarehouseCode());
                        salesPlanEntity.setPointsWarehouseName(pull.getPointsWarehouseName());
                        salesPlanEntity.setProductCode(pull.getProductCode());
                        salesPlanEntity.setProductName(pull.getProductName());
                        salesPlanEntity.setProductBrandCode(pull.getProductBrandCode());
                        salesPlanEntity.setProductBrandName(pull.getProductBrandName());
                        salesPlanEntity.setProductCategoryCode(pull.getProductCategoryCode());
                        salesPlanEntity.setProductCategoryName(pull.getProductCategoryName());
                        salesPlanEntity.setProductItemCode(pull.getProductItemCode());
                        salesPlanEntity.setProductItemName(pull.getProductItemName());
                        salesPlanEntity.setPlanQuantity(pull.getPlanQuantity());
                        salesPlanEntity.setDiscountPlanAmount(pull.getDiscountPlanAmount());
                        salesPlanEntity.setDiscountRestoreAmount(pull.getDiscountRestoreAmount());
                        salesPlanEntity.setDiscountRate(pull.getDiscountRate());
                        salesPlanEntity.setRestoreQuantity(pull.getRestoreQuantity());
                        salesPlanEntity.setPlanAmount(pull.getPlanAmount());
                        salesPlanEntity.setCreateTime(pull.getCreateTime());
                        salesPlanEntity.setCreateName(pull.getCreateName());
                        salesPlanEntity.setTenantCode(TenantUtils.getTenantCode());
                        salesPlanEntity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                        updateList.add(salesPlanEntity);
                    } else {
                        saveList.add(pull);
                    }
                });
                this.saveOrUpdateCowBatch(saveList, updateList);
            }
        }catch (Exception e) {
            throw new RuntimeException(ExceptionStackMsgUtil.stackMsg(e));
        }finally {
            if (lock) {
                this.unLock(lockKey);
            }
        }
    }

    /**
     * 批量保存牛要客数据
     *
     * @param saveList
     * @param updateList
     * @author huojia
     * @date 2023/1/3 18:08
     **/
    @Transactional(rollbackFor = Exception.class)
    void saveOrUpdateCowBatch(List<SalesPlanEntity> saveList, List<SalesPlanEntity> updateList) {
        if (!org.springframework.util.CollectionUtils.isEmpty(saveList)) {
            this.salesPlanRepository.saveBatch(saveList);
        }
        if (!org.springframework.util.CollectionUtils.isEmpty(updateList)) {
            this.salesPlanRepository.updateBatchById(updateList);
        }
    }

    private void unLock(String lockKey) {
        if (StringUtils.isEmpty(lockKey)) {
            throw new RuntimeException("拉取月销售计划解锁失败，日期不能为空！");
        }
        redisLockService.unlock(SalesPlanConstant.MONTH_PLAN_LOCK + lockKey);
    }

    private boolean lock(String lockKey) {
        if (StringUtils.isEmpty(lockKey)) {
            throw new RuntimeException("拉取月销售计划加锁失败，日期不能为空！");
        }
        return this.redisLockService.tryLock(SalesPlanConstant.MONTH_PLAN_LOCK + lockKey, TimeUnit.HOURS, 12);
    }

    /**
     * 数据校验
     *
     * @param cowMasterGuestMonthPlanVoList
     * @return java.util.List<com.biz.crm.tpm.business.sales.plan.local.entity.SalesPlanEntity>
     * @author huojia
     * @date 2022/12/21 11:19
     **/
    private List<SalesPlanEntity> monthPlanValidate(List<CowMasterGuestMonthPlanVo> cowMasterGuestMonthPlanVoList, Map<String, String> codeMap) {
        List<SalesPlanEntity> pullList = new ArrayList<>();
        Set<String> productCodeSet = cowMasterGuestMonthPlanVoList.stream()
                .map(CowMasterGuestMonthPlanVo::getSapCode)
                .filter(Objects::nonNull)
                .collect(Collectors.toSet());
        Set<String> regionCodeSet = cowMasterGuestMonthPlanVoList.stream()
                .map(CowMasterGuestMonthPlanVo::getRegionCode)
                .filter(Objects::nonNull)
                .collect(Collectors.toSet());
        List<SalesOrgVo> salesOrgVos = salesOrgVoService.findByErpCodeList(new ArrayList<>(regionCodeSet));
        List<ProductVo> productVoList = productVoService.findByCodes(new ArrayList<>(productCodeSet));
        Map<String, ProductVo> productVoMap = new HashMap<>();
        Map<String, SalesOrgVo> salesOrgVoMap = new HashMap<>();
        if (!CollectionUtils.isEmpty(productVoList)) {
            productVoMap = productVoList.stream().collect(Collectors.toMap(ProductVo::getProductCode, Function.identity()));
        }
        if (!CollectionUtils.isEmpty(salesOrgVos)) {
            salesOrgVoMap = salesOrgVos.stream().collect(Collectors.toMap(SalesOrgVo::getErpCode, Function.identity(), (oldVo, newVo) -> newVo));
        }
        // 单据号不会重复，如果存在重复的情况，直接抛错，需要到对方系统上取检查数据
        Map<String, ProductVo> finalProductVoMap = productVoMap;
        Map<String, SalesOrgVo> finalSalesOrgVoMap = salesOrgVoMap;
        cowMasterGuestMonthPlanVoList.forEach(cowVo -> {
            Validate.notEmpty(cowVo.getOrderNo(), "单据编码不能为空！");
            if (codeMap.containsKey(cowVo.getOrderNo())) {
                return;
            }
            codeMap.put(cowVo.getOrderNo(), "");
            SalesPlanEntity salesPlanEntity = new SalesPlanEntity();
            salesPlanEntity.setOrderNo(cowVo.getOrderNo());
            salesPlanEntity.setFromSystem(ForeignSystemEnum.COW_MASTER_GUEST.getCode());
            salesPlanEntity.setBusinessFormatCode(BusinessFormatEnum.NORMAL.getCode());
            salesPlanEntity.setBusinessUnitCode(BusinessUnitEnum.VERTICAL.getCode());
            salesPlanEntity.setYearMonthLy(cowVo.getYear() + "-" + cowVo.getMonths());
            salesPlanEntity.setSalesOrgRegionErpCode(cowVo.getRegionCode());
            salesPlanEntity.setSalesOrgRegionName(cowVo.getRegion());
            if (finalSalesOrgVoMap.containsKey(salesPlanEntity.getSalesOrgRegionErpCode())) {
                salesPlanEntity.setSalesOrgRegionCode(finalSalesOrgVoMap.get(salesPlanEntity.getSalesOrgRegionErpCode()).getSalesOrgCode());
            }
            salesPlanEntity.setCustomerRetailerCode(cowVo.getRetailerCode());
            salesPlanEntity.setCustomerRetailerName(cowVo.getRetailer());
            salesPlanEntity.setSystemCode(cowVo.getRetailerCode());
            salesPlanEntity.setSystemName(cowVo.getRetailer());
            salesPlanEntity.setDataFromCode(DataFromEnum.FOREIGN_SYSTEM.getCode());
            salesPlanEntity.setPointsWarehouseCode(cowVo.getWhseCode());
            salesPlanEntity.setPointsWarehouseName(cowVo.getWhseName());
            salesPlanEntity.setProductCode(cowVo.getSapCode());
            salesPlanEntity.setProductName(cowVo.getSapName());
            if (finalProductVoMap.containsKey(salesPlanEntity.getProductCode())) {
                salesPlanEntity.setProductBrandCode(finalProductVoMap.get(salesPlanEntity.getProductCode()).getProductBrandCode());
                salesPlanEntity.setProductBrandName(finalProductVoMap.get(salesPlanEntity.getProductCode()).getProductBrandName());
                salesPlanEntity.setProductCategoryCode(finalProductVoMap.get(salesPlanEntity.getProductCode()).getProductCategoryCode());
                salesPlanEntity.setProductCategoryName(finalProductVoMap.get(salesPlanEntity.getProductCode()).getProductCategoryName());
                salesPlanEntity.setProductItemCode(finalProductVoMap.get(salesPlanEntity.getProductCode()).getProductLevelCode());
                salesPlanEntity.setProductItemName(finalProductVoMap.get(salesPlanEntity.getProductCode()).getProductLevelName());
            }
            salesPlanEntity.setPlanQuantity(new BigDecimal(Optional.of(cowVo.getConfirmedQty()).orElse(0)));
            salesPlanEntity.setRestoreQuantity(new BigDecimal(Optional.of(cowVo.getFinalyQty()).orElse(0)));
            salesPlanEntity.setPlanAmount(cowVo.getPlanAmt());
            salesPlanEntity.setRestoreAmount(cowVo.getFinalyAmt());
            salesPlanEntity.setCreateTime(cowVo.getCreateTime());
            salesPlanEntity.setCreateName(cowVo.getCreateBy());
            salesPlanEntity.setTenantCode(TenantUtils.getTenantCode());
            salesPlanEntity.setRegionCode(cowVo.getRegionCode());
            salesPlanEntity.setRegionName(cowVo.getRegion());
            salesPlanEntity.setPrice(cowVo.getOutboundPriceSystem());
            salesPlanEntity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            pullList.add(salesPlanEntity);
        });
        //11DY00000010correctionretailer_region_brand2023-03yonghui1300151028
        List<String> onlyKeyList = pullList.stream()
                .map(pull -> pull.getBusinessFormatCode() +
                        pull.getBusinessUnitCode() +
                        DiscountRateVersionEnum.CORRECTION.getCode() +
//                        DiscountRateDimensionEnum.RETAILER_REGION_BRAND.getCode() +
                        DiscountRateDimensionEnum.RETAILER_REGION.getCode() +
                        pull.getYearMonthLy() +
                        pull.getSystemCode() +
//                        pull.getProductBrandCode() +
                        pull.getRegionCode())
                .collect(Collectors.toList());
        Map<String, DiscountRateBudgetVo> discountRateBudgetMap = discountRateSdkService.getDiscountRateByOnlyKey(onlyKeyList);
        AtomicReference<String> onlyKey = new AtomicReference<>(new String(""));
        pullList.forEach(pull -> {
            onlyKey.set(pull.getBusinessFormatCode() + pull.getBusinessUnitCode() +
                    DiscountRateVersionEnum.CORRECTION.getCode() +
//                    DiscountRateDimensionEnum.RETAILER_REGION_BRAND.getCode() +
                    DiscountRateDimensionEnum.RETAILER_REGION.getCode() +
                    pull.getYearMonthLy() +
                    pull.getSystemCode() +
//                    pull.getProductBrandCode() +
                    pull.getRegionCode());
            if (pull.getPlanAmount() != null && discountRateBudgetMap.containsKey(onlyKey.get())) {
                pull.setDiscountPlanAmount(
                        pull.getPlanAmount().multiply(BigDecimal.ONE.subtract(Optional.ofNullable(discountRateBudgetMap.get(onlyKey.get()).getPlanRate()).orElse(BigDecimal.ZERO)))
                );
                pull.setDiscountRate(discountRateBudgetMap.get(onlyKey.get()).getPlanRate());
            }
            if (pull.getRestoreAmount() != null && discountRateBudgetMap.containsKey(onlyKey.get())) {
                pull.setDiscountRestoreAmount(
                        pull.getRestoreAmount().multiply(BigDecimal.ONE.subtract(Optional.ofNullable(discountRateBudgetMap.get(onlyKey.get()).getPlanRate()).orElse(BigDecimal.ZERO)))
                );
                pull.setDiscountRate(discountRateBudgetMap.get(onlyKey.get()).getPlanRate());
            }
        });
        return pullList;
    }
}
