package com.biz.crm.tpm.business.sales.plan.local.service.process;

import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.mdm.business.customer.channel.sdk.service.CustomerChannelVoService;
import com.biz.crm.mdm.business.customer.channel.sdk.vo.CustomerChannelVo;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.mdm.business.org.sdk.service.OrgVoService;
import com.biz.crm.mdm.business.org.sdk.vo.OrgVo;
import com.biz.crm.mdm.business.product.brand.sdk.service.ProductBrandService;
import com.biz.crm.mdm.business.product.brand.sdk.vo.ProductBrandVo;
import com.biz.crm.mdm.business.product.level.sdk.service.ProductLevelVoSdkService;
import com.biz.crm.mdm.business.product.level.sdk.vo.ProductLevelVo;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.mdm.business.terminal.channel.sdk.service.MdmTerminalChannelVoService;
import com.biz.crm.mdm.business.terminal.channel.sdk.vo.MdmTerminalChannelVo;
import com.biz.crm.mdm.business.terminal.sdk.service.TerminalVoService;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalVo;
import com.biz.crm.mn.common.base.eunm.DataFromEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.budget.dimension.config.sdk.dto.DimensionInformationQueryData;
import com.biz.crm.tpm.business.budget.dimension.config.sdk.enmus.MenuCodeEnum;
import com.biz.crm.tpm.business.budget.dimension.config.sdk.service.DimensionDimensionInformationService;
import com.biz.crm.tpm.business.budget.dimension.config.sdk.vo.DimensionDimensionInformationVo;
import com.biz.crm.tpm.business.profit.goal.discount.sdk.eunm.BudgetAmountTypeEnum;
import com.biz.crm.tpm.business.profit.goal.discount.sdk.service.ProfitGoalDiscountService;
import com.biz.crm.tpm.business.profit.goal.discount.sdk.vo.ProfitGoalDiscountVo;
import com.biz.crm.tpm.business.sales.plan.sdk.constant.DictTypeCodeConstant;
import com.biz.crm.tpm.business.sales.plan.sdk.dto.SalesPlanDto;
import com.biz.crm.tpm.business.sales.plan.sdk.service.SalesPlanService;
import com.biz.crm.tpm.business.sales.plan.sdk.vo.SalesPlanImportsVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author huojia
 * @date 2022年10月28日 11:40
 */
@Slf4j
@Component
public class SalesPlanImportsProcess implements ImportProcess<SalesPlanImportsVo> {

    @Resource
    private OrgVoService orgVoService;

    @Resource
    private ProductVoService productVoService;

    @Resource
    private SalesOrgVoService salesOrgVoService;

    @Resource
    private CustomerChannelVoService customerChannelVoService;

    @Resource
    private MdmTerminalChannelVoService mdmTerminalChannelVoService;

    @Resource
    private ProductBrandService productBrandService;

    @Resource
    private ProductLevelVoSdkService productLevelVoSdkService;

    @Resource
    private CustomerVoService customerVoService;

    @Resource
    private TerminalVoService terminalVoService;

    @Resource
    private SalesPlanService salesPlanService;

    @Resource
    private DictToolkitService dictToolkitService;

    @Resource
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private ProfitGoalDiscountService profitGoalDiscountService;

    @Autowired(required = false)
    private DimensionDimensionInformationService dimensionDimensionInformationService;

    private Map<String, String> mdmBusinessFormatMap = new HashMap<>();
    private Map<String, String> mdmBusinessUnitMap = new HashMap<>();
    private Map<String, String> tpmGroupCodeMap = new HashMap<>();
    private Map<String, CustomerVo> customerVoMap = new HashMap<>();
    private Map<String, TerminalVo> terminalVoMap = new HashMap<>();
    private Map<String, ProductVo> productVoMap = new HashMap<>();
    private Map<String, SalesOrgVo> salesOrgVoMap = new HashMap<>();
    private Map<String, CustomerChannelVo> customerChannelVoMap = new HashMap<>();
    private Map<String, MdmTerminalChannelVo> terminalChannelVoMap = new HashMap<>();
    private Map<String, ProductBrandVo> productBrandVoMap = new HashMap<>();
    private Map<String, ProductLevelVo> productCategoryVoMap = new HashMap<>();
    private Map<String, ProductLevelVo> productItemVoMap = new HashMap<>();
    private Map<String, ProfitGoalDiscountVo> profitGoalDiscountVoMap = new HashMap<>();
    private Map<String, OrgVo> orgVoMap = new HashMap<>();


    @Override
    public Integer getBatchCount() {
        return Integer.MAX_VALUE;
    }

    @Override
    public Map<Integer, String> execute(LinkedHashMap<Integer, SalesPlanImportsVo> data,
                                        TaskGlobalParamsVo paramsVo,
                                        Map<String, Object> params) {
       try {
           Validate.notEmpty(data, "导入数据不能为空！");
           List<SalesPlanDto> importList = this.validate(data);
           salesPlanService.importSave(importList);
       }catch (Exception e){
           e.printStackTrace();
           if (StringUtils.isEmpty(e.getMessage())){
               throw new IllegalArgumentException("空指针异常");
           }else{
               throw new IllegalArgumentException(e.getMessage());
           }
       }
        return null;
    }

    /**
     * 校验并转换数据
     *
     * @param data
     * @return java.util.List<com.biz.crm.tpm.business.sales.plan.sdk.dto.SalesPlanDto>
     * @author huojia
     * @date 2022/10/28 14:31
     **/
    private List<SalesPlanDto> validate(LinkedHashMap<Integer, SalesPlanImportsVo> data) {
        List<SalesPlanImportsVo> salesPlanImportsVos = new ArrayList<>(data.values());
        //唯一性验证
//        Map<String, List<SalesPlanImportsVo>> saleMaps = salesPlanImportsVos.stream().collect(Collectors.groupingBy(x -> x.getVersionNumber()
//                + x.getBusinessFormatCode() + x.getBusinessUnitCode() + x.getYearMonthLy() + x.getGroupCode()
//                + x.getSalesOrgCode() + x.getSalesOrgName() + x.getCustomerCode()
//                + x.getCustomerName() + x.getProductCode() + x.getProductName()
//                + x.getUnitCode() + x.getUnitName()));
//        saleMaps.forEach((k,v)->{
//            if (!CollectionUtils.isEmpty(v)){
//                Validate.isTrue(v.size()<2,"出现重复数据，请检查！");
//            }
//        });


        // 构建基础数据map
        this.buildBaseMap(salesPlanImportsVos);

        salesPlanImportsVos.forEach(importsVo -> {

            // 校验基础数据
            this.buildBaseData(importsVo);

            // 校验数字
            this.buildDecimal(importsVo);

        });
        Collection<SalesPlanDto> salesPlanDtoList = nebulaToolkitService.copyCollectionByWhiteList(salesPlanImportsVos, SalesPlanImportsVo.class, SalesPlanDto.class, LinkedHashSet.class, ArrayList.class);
        return new ArrayList<>(salesPlanDtoList);
    }

    /**
     * 测试方法
     *
     * @param salesPlanImportsVos
     * @author huojia
     * @date 2023/1/10 23:39
     **/
    public void testValidate(List<SalesPlanImportsVo> salesPlanImportsVos) {
        // 构建基础数据map
        this.buildBaseMap(salesPlanImportsVos);

        salesPlanImportsVos.forEach(importsVo -> {

            // 校验基础数据
            this.buildBaseData(importsVo);

            // 校验数字
            this.buildDecimal(importsVo);

        });
    }

    /**
     * 获取维度配置，校验基础数据
     *
     * @param dimensionMap
     * @param importsVo
     * @param clazz
     * @author huojia
     * @date 2022/11/12 10:51
     **/
    private void buildDimension(Map<String, List<DimensionDimensionInformationVo>> dimensionMap, SalesPlanImportsVo importsVo, Class<SalesPlanImportsVo> clazz) {
        List<DimensionDimensionInformationVo> dimensionVoList = new ArrayList<>();
        if (!dimensionMap.containsKey(importsVo.getBusinessFormatCode() + importsVo.getBusinessUnitCode() + MenuCodeEnum.SALES_PLAN.getCode() + importsVo.getSalesOrgCode())) {
            // 获取维度配置
            DimensionInformationQueryData dto = new DimensionInformationQueryData();
            dto.setBusinessFormatCode(importsVo.getBusinessFormatCode());
            dto.setBusinessUnitCode(importsVo.getBusinessUnitCode());
            dto.setMenu(MenuCodeEnum.SALES_PLAN.getCode());
            // dto.setSalesOrganization(importsVo.getSalesOrgCode());
            dimensionVoList = dimensionDimensionInformationService.findDetailsByCodes(dto);
            dimensionMap.put(importsVo.getBusinessFormatCode() + importsVo.getBusinessUnitCode() + MenuCodeEnum.SALES_PLAN.getCode() + importsVo.getSalesOrgCode(), dimensionVoList);
        } else {
            dimensionVoList = dimensionMap.get(importsVo.getBusinessFormatCode() + importsVo.getBusinessUnitCode() + MenuCodeEnum.SALES_PLAN.getCode() + importsVo.getSalesOrgCode());
        }
        if (CollectionUtils.isEmpty(dimensionVoList)) {
            throw new IllegalArgumentException("未维护对应维度配置数据，请检查！");
        }
        // 根据维度配置，判断必填字段
        dimensionVoList.forEach(informationVo -> {
            try {
                if (StringUtils.isEmpty(informationVo.getFieldCoding())) {
                    return;
                }
                Field field = clazz.getDeclaredField(informationVo.getFieldCoding());
                field.setAccessible(true);
                Object o = field.get(importsVo);
                if (ObjectUtils.isEmpty(o)) {
                    throw new IllegalArgumentException(informationVo.getFieldName() + "不能为空！");
                }
            } catch (NoSuchFieldException | IllegalAccessException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        });
        importsVo.setTypeCoding(dimensionVoList.get(0).getTypeCoding());
    }

    /**
     * 校验数字
     *
     * @param importsVo
     * @author huojia
     * @date 2022/11/10 21:36
     **/
    private void buildDecimal(SalesPlanImportsVo importsVo) {
        // 单价
        try {
            if (!StringUtils.isEmpty(importsVo.getPriceStr())) {
                importsVo.setPrice(new BigDecimal(importsVo.getPriceStr()));
            }
        } catch (Exception e) {
            throw new IllegalArgumentException("单价" + importsVo.getPriceStr() + "格式错误，请检查！");
        }
        // 吨位
        try {
            if (!StringUtils.isEmpty(importsVo.getTonnageStr())) {
                importsVo.setTonnage(new BigDecimal(importsVo.getTonnageStr()));
            }
        } catch (Exception e) {
            throw new IllegalArgumentException("吨位" + importsVo.getTonnageStr() + "格式错误，请检查！");
        }
        // 计划量
        try {
            if (!StringUtils.isEmpty(importsVo.getPlanQuantityStr())) {
                importsVo.setPlanQuantity(new BigDecimal(importsVo.getPlanQuantityStr()));
            }
        } catch (Exception e) {
            throw new IllegalArgumentException("计划量" + importsVo.getPlanQuantityStr() + "格式错误，请检查！");
        }
        // 标准供货价
        try {
            if (!StringUtils.isEmpty(importsVo.getStandardSupplyPriceStr())) {
                importsVo.setStandardSupplyPrice(new BigDecimal(importsVo.getStandardSupplyPriceStr()));
            }
        } catch (Exception e) {
            throw new IllegalArgumentException("标准供货价" + importsVo.getStandardSupplyPriceStr() + "格式错误，请检查！");
        }
        // 理论收入
        try {
            if (!StringUtils.isEmpty(importsVo.getTheoryIncomeStr())) {
                importsVo.setTheoryIncome(new BigDecimal(importsVo.getTheoryIncomeStr()));
            }
        } catch (Exception e) {
            throw new IllegalArgumentException("理论收入" + importsVo.getTheoryIncomeStr() + "格式错误，请检查！");
        }
        // 到岸价
        try {
            if (!StringUtils.isEmpty(importsVo.getCifPriceStr())) {
                importsVo.setCifPrice(new BigDecimal(importsVo.getCifPriceStr()));
            }
        } catch (Exception e) {
            throw new IllegalArgumentException("到岸价" + importsVo.getCifPriceStr() + "格式错误，请检查！");
        }
        // 理论成本
        try {
            if (!StringUtils.isEmpty(importsVo.getTheoryCostStr())) {
                importsVo.setTheoryCost(new BigDecimal(importsVo.getTheoryCostStr()));
            }
        } catch (Exception e) {
            throw new IllegalArgumentException("理论成本" + importsVo.getTheoryCostStr() + "格式错误，请检查！");
        }
        // 折前金额
        try {
            if (!StringUtils.isEmpty(importsVo.getAmountStr())) {
                importsVo.setAmount(new BigDecimal(importsVo.getAmountStr()));
            }
        } catch (Exception e) {
            throw new IllegalArgumentException("折前金额" + importsVo.getAmountStr() + "格式错误，请检查！");
        }
        // 折后金额
        try {
            if (!StringUtils.isEmpty(importsVo.getDiscountAmountStr())) {
                importsVo.setDiscountAmount(new BigDecimal(importsVo.getDiscountAmountStr()));
            }
        } catch (Exception e) {
            throw new IllegalArgumentException("折后金额" + importsVo.getDiscountAmountStr() + "格式错误，请检查！");
        }
        // 回复数量
        try {
            if (!StringUtils.isEmpty(importsVo.getRestoreQuantityStr())) {
                importsVo.setRestoreQuantity(new BigDecimal(importsVo.getRestoreQuantityStr()));
            }
        } catch (Exception e) {
            throw new IllegalArgumentException("回复数量" + importsVo.getRestoreQuantityStr() + "格式错误，请检查！");
        }
        // 回复金额
        try {
            if (!StringUtils.isEmpty(importsVo.getRestoreAmountStr())) {
                importsVo.setRestoreAmount(new BigDecimal(importsVo.getRestoreAmountStr()));
            }
        } catch (Exception e) {
            throw new IllegalArgumentException("回复金额" + importsVo.getRestoreAmountStr() + "格式错误，请检查！");
        }
    }

    /**
     * 校验基础数据
     *
     * @param importsVo
     * @author huojia
     * @date 2022/11/10 21:35
     **/
    private void buildBaseData(SalesPlanImportsVo importsVo) {
        // 设置数据来源
        importsVo.setDataFromCode(DataFromEnum.IMPORT.getCode());
        // 业态
        if (!StringUtils.isEmpty(importsVo.getBusinessFormatCode())) {
            if (!mdmBusinessFormatMap.containsKey(importsVo.getBusinessFormatCode())) {
                throw new IllegalArgumentException("业态" + importsVo.getBusinessFormatCode() + "错误，请检查！");
            } else {
                importsVo.setBusinessFormatCode(mdmBusinessFormatMap.get(importsVo.getBusinessFormatCode()));
            }
        }
        // 业务单元
        if (!StringUtils.isEmpty(importsVo.getBusinessUnitCode())) {
            if (!mdmBusinessUnitMap.containsKey(importsVo.getBusinessUnitCode())) {
                throw new IllegalArgumentException("业务单元" + importsVo.getBusinessUnitCode() + "错误，请检查！");
            } else {
                importsVo.setBusinessUnitCode(mdmBusinessUnitMap.get(importsVo.getBusinessUnitCode()));
            }
        }
        // 年月
        if (!StringUtils.isEmpty(importsVo.getYearMonthLy())) {
            try {
                DateUtil.parseDate(importsVo.getYearMonthLy(), DateUtil.DEFAULT_YEAR_MONTH_DAY);
            } catch (Exception ignored) {
                throw new IllegalArgumentException("年月" + importsVo.getYearMonthLy() + "格式错误，应该为" + DateUtil.DEFAULT_YEAR_MONTH_DAY);
            }
        }
        // 分组
        if (!StringUtils.isEmpty(importsVo.getGroupCode())) {
            if (!tpmGroupCodeMap.containsKey(importsVo.getGroupCode())) {
                throw new IllegalArgumentException("分组" + importsVo.getGroupCode() + "错误，请检查！");
            } else {
                importsVo.setGroupCode(tpmGroupCodeMap.get(importsVo.getGroupCode()));
            }
        }
        // 销售组织
        if (!StringUtils.isEmpty(importsVo.getSalesOrgCode())) {
            if (!salesOrgVoMap.containsKey(importsVo.getSalesOrgCode())) {
                throw new IllegalArgumentException("销售组织" + importsVo.getSalesOrgCode() + "错误，请检查！");
            } else {
                importsVo.setSalesOrgName(salesOrgVoMap.get(importsVo.getSalesOrgCode()).getSalesOrgName());
                importsVo.setSalesOrgLevelCode(salesOrgVoMap.get(importsVo.getSalesOrgCode()).getSalesOrgLevel());
            }
        }
        // 客户渠道
        if (!StringUtils.isEmpty(importsVo.getCustomerChannelCode())) {
            if (!customerChannelVoMap.containsKey(importsVo.getCustomerChannelCode())) {
                throw new IllegalArgumentException("客户渠道" + importsVo.getCustomerChannelCode() + "错误，请检查！");
            } else {
                importsVo.setCustomerChannelName(customerChannelVoMap.get(importsVo.getCustomerChannelCode()).getCustomerChannelName());
                importsVo.setCustomerChannelLevelCode(customerChannelVoMap.get(importsVo.getCustomerChannelCode()).getCustomerChannelType());
            }
        }
        // 终端渠道
        if (!StringUtils.isEmpty(importsVo.getTerminalChannelCode())) {
            if (!terminalChannelVoMap.containsKey(importsVo.getTerminalChannelCode())) {
                throw new IllegalArgumentException("终端渠道" + importsVo.getTerminalChannelCode() + "错误，请检查！");
            } else {
                importsVo.setTerminalChannelName(terminalChannelVoMap.get(importsVo.getTerminalChannelCode()).getTerminalChannelName());
            }
        }
        // 系统、零售商
        if (!StringUtils.isEmpty(importsVo.getSystemCode())) {

        }
        // 客户
        if (!StringUtils.isEmpty(importsVo.getCustomerCode())) {
            if (customerVoMap.containsKey(importsVo.getCustomerCode())) {
                importsVo.setCustomerName(customerVoMap.get(importsVo.getCustomerCode()).getCustomerName());
            } else {
                throw new IllegalArgumentException("客户编码" + importsVo.getCustomerCode() + "错误，请检查！");
            }
        }
        // 门店
        if (!StringUtils.isEmpty(importsVo.getTerminalCode())) {
            if (terminalVoMap.containsKey(importsVo.getTerminalCode())) {
                importsVo.setTerminalName(terminalVoMap.get(importsVo.getTerminalCode()).getTerminalName());
            } else {
                throw new IllegalArgumentException("门店编码" + importsVo.getTerminalCode() + "错误，请检查！");
            }
        }
        // 产品品牌
        if (!StringUtils.isEmpty(importsVo.getProductBrandCode())) {
            if (productBrandVoMap.containsKey(importsVo.getProductBrandCode())) {
                importsVo.setProductBrandName(productBrandVoMap.get(importsVo.getProductBrandCode()).getProductBrandName());
            } else {
                throw new IllegalArgumentException("产品品牌" + importsVo.getProductBrandCode() + "错误，请检查！");
            }
        }
        // 产品品类
        if (!StringUtils.isEmpty(importsVo.getProductCategoryCode())) {
            if (productCategoryVoMap.containsKey(importsVo.getProductCategoryCode())) {
                importsVo.setProductCategoryName(productCategoryVoMap.get(importsVo.getProductCategoryCode()).getProductLevelName());
            } else {
                throw new IllegalArgumentException("产品品类" + importsVo.getProductCategoryCode() + "错误，请检查！");
            }
        }
        // 产品品项
        if (!StringUtils.isEmpty(importsVo.getProductItemCode())) {
            if (productItemVoMap.containsKey(importsVo.getProductItemCode())) {
                importsVo.setProductItemName(productItemVoMap.get(importsVo.getProductItemCode()).getProductLevelName());
            } else {
                throw new IllegalArgumentException("产品品项" + importsVo.getProductCategoryCode() + "错误，请检查！");
            }
        }
        // 产品
        if (!StringUtils.isEmpty(importsVo.getProductCode())) {
            if (productVoMap.containsKey(importsVo.getProductCode())) {
                importsVo.setProductName(productVoMap.get(importsVo.getProductCode()).getProductName());
                importsVo.setTaxRate(productVoMap.get(importsVo.getProductCode()).getRate());
            } else {
                throw new IllegalArgumentException("产品编码" + importsVo.getProductCode() + "错误，请检查！");
            }
        }
        // 折扣率
        if (!StringUtils.isEmpty(importsVo.getYearMonthLy())) {
            if (orgVoMap.containsKey(importsVo.getSalesOrgCode())) {
                String orgCode = orgVoMap.get(importsVo.getSalesOrgCode()).getOrgCode();
                if (profitGoalDiscountVoMap.containsKey(importsVo.getBusinessFormatCode() + importsVo.getBusinessUnitCode() + importsVo.getYearMonthLy() + orgCode)) {
                    ProfitGoalDiscountVo profitGoalDiscountVo = profitGoalDiscountVoMap.get(importsVo.getBusinessFormatCode() + importsVo.getBusinessUnitCode() + importsVo.getYearMonthLy() + orgCode);
                    importsVo.setDiscountRate(profitGoalDiscountVo.getDeliveryDiscountRatio());
                }
            }
        }
        // 单位
        if (!StringUtils.isEmpty(importsVo.getUnitCode())) {

        }
    }

    /**
     * 构建基础数据map
     *
     * @param salesPlanImportsVos
     * @author huojia
     * @date 2022/11/10 21:34
     **/
    private void buildBaseMap(List<SalesPlanImportsVo> salesPlanImportsVos) {
        // 查询数据字典
        mdmBusinessFormatMap = dictToolkitService.findConvertMapByDictTypeCode(DictTypeCodeConstant.MDM_BUSINESS_FORMAT);
        mdmBusinessUnitMap = dictToolkitService.findConvertMapByDictTypeCode(DictTypeCodeConstant.MDM_BUSINESS_UNIT);
        tpmGroupCodeMap = dictToolkitService.findConvertMapByDictTypeCode(DictTypeCodeConstant.TPM_GROUP_CODE);

        // 查询主数据数据，校验
        Set<String> salesOrgCodeSet = salesPlanImportsVos.stream().map(SalesPlanImportsVo::getSalesOrgCode).filter(Objects::nonNull).collect(Collectors.toSet());
        Set<String> customerChannelCodeSet = salesPlanImportsVos.stream().map(SalesPlanImportsVo::getCustomerChannelCode).filter(Objects::nonNull).collect(Collectors.toSet());
        Set<String> terminalChannelCodeSet = salesPlanImportsVos.stream().map(SalesPlanImportsVo::getTerminalChannelCode).filter(Objects::nonNull).collect(Collectors.toSet());
        Set<String> systemCodeSet = salesPlanImportsVos.stream().map(SalesPlanImportsVo::getSystemCode).filter(Objects::nonNull).collect(Collectors.toSet());
        Set<String> customerCodeSet = salesPlanImportsVos.stream().map(SalesPlanImportsVo::getCustomerCode).filter(Objects::nonNull).collect(Collectors.toSet());
        Set<String> terminalCodeSet = salesPlanImportsVos.stream().map(SalesPlanImportsVo::getTerminalCode).filter(Objects::nonNull).collect(Collectors.toSet());
        Set<String> productBrandCodeSet = salesPlanImportsVos.stream().map(SalesPlanImportsVo::getProductBrandCode).filter(Objects::nonNull).collect(Collectors.toSet());
        Set<String> productCategoryCodeSet = salesPlanImportsVos.stream().map(SalesPlanImportsVo::getProductCategoryCode).filter(Objects::nonNull).collect(Collectors.toSet());
        Set<String> productItemCodeSet = salesPlanImportsVos.stream().map(SalesPlanImportsVo::getProductItemCode).filter(Objects::nonNull).collect(Collectors.toSet());
        Set<String> productCodeSet = salesPlanImportsVos.stream().map(SalesPlanImportsVo::getProductCode).filter(Objects::nonNull).collect(Collectors.toSet());
        Set<String> unitCodeSet = salesPlanImportsVos.stream().map(SalesPlanImportsVo::getUnitCode).filter(Objects::nonNull).collect(Collectors.toSet());
        Set<String> yearMonthSet = salesPlanImportsVos.stream().map(SalesPlanImportsVo::getYearMonthLy).filter(Objects::nonNull).collect(Collectors.toSet());

        // 销售组织
        if (!CollectionUtils.isEmpty(salesOrgCodeSet)) {
            List<SalesOrgVo> salesOrgVos = salesOrgVoService.findBySalesOrgCodes(new ArrayList<>(salesOrgCodeSet));
            if (!CollectionUtils.isEmpty(salesOrgVos)) {
                salesOrgVoMap = salesOrgVos.stream().collect(Collectors.toMap(SalesOrgVo::getSalesOrgCode, Function.identity()));
            }
            List<OrgVo> orgVos = orgVoService.findBySalesOrgCodes(new ArrayList<>(salesOrgCodeSet));
            if (!CollectionUtils.isEmpty(orgVos)) {
                orgVoMap = orgVos.stream().collect(Collectors.toMap(OrgVo::getSalesOrgCode, Function.identity()));
            }
        }

        // 客户渠道
        if (!CollectionUtils.isEmpty(customerChannelCodeSet)) {
            List<CustomerChannelVo> customerChannelVos = customerChannelVoService.findByCodes(new ArrayList<>(customerChannelCodeSet));
            if (!CollectionUtils.isEmpty(customerChannelVos)) {
                customerChannelVoMap = customerChannelVos.stream().collect(Collectors.toMap(CustomerChannelVo::getCustomerChannelCode, Function.identity()));
            }
        }

        // 终端渠道
        if (!CollectionUtils.isEmpty(terminalChannelCodeSet)) {
            List<MdmTerminalChannelVo> mdmTerminalChannelVos = mdmTerminalChannelVoService.listByCodes(new ArrayList<>(terminalChannelCodeSet));
            if (!CollectionUtils.isEmpty(mdmTerminalChannelVos)) {
                terminalChannelVoMap = mdmTerminalChannelVos.stream().collect(Collectors.toMap(MdmTerminalChannelVo::getTerminalChannelCode, Function.identity()));
            }
        }

        // 客户
        if (!CollectionUtils.isEmpty(customerCodeSet)) {
            List<CustomerVo> customerVos = customerVoService.findByCustomerCodes(new ArrayList<>(customerCodeSet));
            if (!CollectionUtils.isEmpty(customerVos)) {
                customerVoMap = customerVos.stream().collect(Collectors.toMap(CustomerVo::getCustomerCode, Function.identity()));
            }
        }

        // 终端
        if (!CollectionUtils.isEmpty(terminalCodeSet)) {
            List<TerminalVo> terminalVos = terminalVoService.findDetailsByIdsOrTerminalCodes(null, new ArrayList<>(terminalCodeSet));
            if (!CollectionUtils.isEmpty(terminalVos)) {
                terminalVoMap = terminalVos.stream().collect(Collectors.toMap(TerminalVo::getTerminalCode, Function.identity()));
            }
        }

        // 品牌
        if (!CollectionUtils.isEmpty(productBrandCodeSet)) {
            List<ProductBrandVo> productBrandVos = productBrandService.listByCodes(new ArrayList<>(productBrandCodeSet));
            if (!CollectionUtils.isEmpty(productBrandVos)) {
                productBrandVoMap = productBrandVos.stream().collect(Collectors.toMap(ProductBrandVo::getProductBrandCode, Function.identity()));
            }
        }

        // 品类
        if (!CollectionUtils.isEmpty(productCategoryCodeSet)) {
            List<ProductLevelVo> productLevelVos = productLevelVoSdkService.findListByCodes(new ArrayList<>(productCategoryCodeSet));
            if (!CollectionUtils.isEmpty(productLevelVos)) {
                productCategoryVoMap = productLevelVos.stream().collect(Collectors.toMap(ProductLevelVo::getProductLevelCode, Function.identity()));
            }
        }

        // 品项
        if (!CollectionUtils.isEmpty(productItemCodeSet)) {
            List<ProductLevelVo> productLevelVos = productLevelVoSdkService.findListByCodes(new ArrayList<>(productItemCodeSet));
            if (!CollectionUtils.isEmpty(productLevelVos)) {
                productItemVoMap = productLevelVos.stream().collect(Collectors.toMap(ProductLevelVo::getProductLevelCode, Function.identity()));
            }
        }

        // 产品
        if (!CollectionUtils.isEmpty(productCodeSet)) {
            List<ProductVo> productVoList = productVoService.findByCodes(new ArrayList<>(productCodeSet));;
            if (!CollectionUtils.isEmpty(productVoList)) {
                productVoMap = productVoList.stream().collect(Collectors.toMap(ProductVo::getProductCode, Function.identity()));
            }
        }

        if (!CollectionUtils.isEmpty(yearMonthSet)) {
            List<ProfitGoalDiscountVo> profitGoalDiscountVoList = profitGoalDiscountService.findListByYearMonthList(new ArrayList<>(yearMonthSet));
            if (!CollectionUtils.isEmpty(profitGoalDiscountVoList)) {
                profitGoalDiscountVoMap = profitGoalDiscountVoList.stream()
                        .filter(vo -> BudgetAmountTypeEnum.DISCOUNT_RATIO.getCode().equals(vo.getTypeCode()))
                        .collect(Collectors.toMap(vo -> vo.getBusinessFormatCode() + vo.getBusinessUnitCode() + vo.getYearMonthLy() + vo.getOrgCode(), Function.identity()));
            }
        }
    }

    @Override
    public String getBusinessCode() {
        return "TPM_SALES_PLAN_IMPORT";
    }

    @Override
    public String getBusinessName() {
        return "TPM-销售计划导入";
    }

    @Override
    public Class<SalesPlanImportsVo> findCrmExcelVoClass() {
        return SalesPlanImportsVo.class;
    }

    @Override
    public String getTemplateCode() {
        return "TPM_SALES_PLAN_IMPORT";
    }

    @Override
    public String getTemplateName() {
        return "TPM销售计划导入";
    }
}
