package com.biz.crm.tpm.business.sales.plan.local.service.process;

import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.mdm.business.customer.channel.sdk.service.CustomerChannelVoService;
import com.biz.crm.mdm.business.customer.channel.sdk.vo.CustomerChannelVo;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mdm.business.org.sdk.service.OrgVoService;
import com.biz.crm.mdm.business.org.sdk.vo.OrgVo;
import com.biz.crm.mdm.business.product.brand.sdk.service.ProductBrandService;
import com.biz.crm.mdm.business.product.brand.sdk.vo.ProductBrandVo;
import com.biz.crm.mdm.business.product.level.sdk.enums.ProductLevelEnum;
import com.biz.crm.mdm.business.product.level.sdk.service.ProductLevelVoSdkService;
import com.biz.crm.mdm.business.product.level.sdk.vo.ProductLevelVo;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgSubComOrgService;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgSubComOrgVo;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.mdm.business.terminal.channel.sdk.service.MdmTerminalChannelVoService;
import com.biz.crm.mdm.business.terminal.channel.sdk.vo.MdmTerminalChannelVo;
import com.biz.crm.mdm.business.terminal.sdk.service.TerminalVoService;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalVo;
import com.biz.crm.mn.common.base.eunm.DataFromEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.budget.dimension.config.sdk.dto.DimensionInformationQueryData;
import com.biz.crm.tpm.business.budget.dimension.config.sdk.enmus.MenuCodeEnum;
import com.biz.crm.tpm.business.budget.dimension.config.sdk.service.DimensionDimensionInformationService;
import com.biz.crm.tpm.business.budget.dimension.config.sdk.vo.DimensionDimensionInformationVo;
import com.biz.crm.tpm.business.profit.goal.discount.sdk.eunm.BudgetAmountTypeEnum;
import com.biz.crm.tpm.business.profit.goal.discount.sdk.service.ProfitGoalDiscountService;
import com.biz.crm.tpm.business.profit.goal.discount.sdk.vo.ProfitGoalDiscountImportsVo;
import com.biz.crm.tpm.business.profit.goal.discount.sdk.vo.ProfitGoalDiscountVo;
import com.biz.crm.tpm.business.sales.plan.sdk.constant.DictTypeCodeConstant;
import com.biz.crm.tpm.business.sales.plan.sdk.dto.SalesPlanDto;
import com.biz.crm.tpm.business.sales.plan.sdk.service.SalesPlanService;
import com.biz.crm.tpm.business.sales.plan.sdk.vo.SalesPlanSubCompanyImportsVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.*;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author huojia
 * @date 2022年10月28日 11:40
 */
@Slf4j
@Component
public class SalesPlanSubCompanyImportsProcess implements ImportProcess<SalesPlanSubCompanyImportsVo> {

    @Resource
    private OrgVoService orgVoService;

    @Resource
    private ProductVoService productVoService;

    @Resource
    private SalesOrgVoService salesOrgVoService;

    @Resource
    private CustomerChannelVoService customerChannelVoService;

    @Resource
    private MdmTerminalChannelVoService mdmTerminalChannelVoService;

    @Resource
    private ProductBrandService productBrandService;

    @Resource
    private ProductLevelVoSdkService productLevelVoSdkService;

    @Resource
    private CustomerVoService customerVoService;

    @Resource
    private TerminalVoService terminalVoService;

    @Resource
    private SalesPlanService salesPlanService;

    @Resource
    private DictDataVoService dictDataVoService;

    @Resource
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private ProfitGoalDiscountService profitGoalDiscountService;

    @Autowired(required = false)
    private DimensionDimensionInformationService dimensionDimensionInformationService;

    @Autowired
    private SalesOrgSubComOrgService salesOrgSubComOrgService;

    /**
     * 数据分片
     *
     * @return 分片长度
     */
    @Override
    public Integer getBatchCount() {
        return Integer.MAX_VALUE;
    }

    @Override
    public Map<Integer, String> execute(LinkedHashMap<Integer, SalesPlanSubCompanyImportsVo> data,
                                        TaskGlobalParamsVo paramsVo,
                                        Map<String, Object> params) {
        Map<Integer, String> errMap = new HashMap<>();

        Map<String, Map<String, String>> dictMapMap = Maps.newHashMap();
        Map<String, CustomerVo> customerVoMap = new HashMap<>();
        Map<String, TerminalVo> terminalVoMap = new HashMap<>();
        Map<String, ProductVo> productVoMap = new HashMap<>();
        Map<String, SalesOrgVo> salesOrgVoMap = new HashMap<>();
        Map<String, CustomerChannelVo> customerChannelVoMap = new HashMap<>();
        Map<String, MdmTerminalChannelVo> terminalChannelVoMap = new HashMap<>();
        Map<String, ProductBrandVo> productBrandVoMap = new HashMap<>();
        Map<String, ProductLevelVo> productCategoryVoMap = new HashMap<>();
        Map<String, ProductLevelVo> productItemVoMap = new HashMap<>();
        Map<String, ProfitGoalDiscountVo> profitGoalDiscountVoMap = new HashMap<>();
        Map<String, OrgVo> orgVoMap = new HashMap<>();
        Map<String, String> salesOrgErpMap = new HashMap<>();
        Map<String, String> erpOrgMap = new HashMap<>();
        Map<String, ProfitGoalDiscountVo> outDiscountRatioMap = new HashMap<>();

        List<SalesPlanDto> importList = this.validate(outDiscountRatioMap,data, dictMapMap, customerVoMap, terminalVoMap, productVoMap, salesOrgVoMap,
                customerChannelVoMap, terminalChannelVoMap, productBrandVoMap, productCategoryVoMap, productItemVoMap, profitGoalDiscountVoMap, orgVoMap, salesOrgErpMap, erpOrgMap, errMap);

        if (errMap.isEmpty()) {
            //分子转换出hr组织
            importList = salesPlanService.convertOrg(importList);
            salesPlanService.importSave(importList);
        }
        return errMap;
    }

    /**
     * 校验并转换数据
     *
     * @param data
     * @return java.util.List<com.biz.crm.tpm.business.sales.plan.sdk.dto.SalesPlanDto>
     * @author huojia
     * @date 2022/10/28 14:31
     **/
    private List<SalesPlanDto> validate(Map<String, ProfitGoalDiscountVo> outDiscountRatioMap,
                                        LinkedHashMap<Integer, SalesPlanSubCompanyImportsVo> data,
                                        Map<String, Map<String, String>> dictMapMap,
                                        Map<String, CustomerVo> customerVoMap,
                                        Map<String, TerminalVo> terminalVoMap,
                                        Map<String, ProductVo> productVoMap,
                                        Map<String, SalesOrgVo> salesOrgVoMap,
                                        Map<String, CustomerChannelVo> customerChannelVoMap,
                                        Map<String, MdmTerminalChannelVo> terminalChannelVoMap,
                                        Map<String, ProductBrandVo> productBrandVoMap,
                                        Map<String, ProductLevelVo> productCategoryVoMap,
                                        Map<String, ProductLevelVo> productItemVoMap,
                                        Map<String, ProfitGoalDiscountVo> profitGoalDiscountVoMap,
                                        Map<String, OrgVo> orgVoMap,
                                        Map<String, String> salesOrgErpMap,
                                        Map<String, String> erpOrgMap,
                                        Map<Integer, String> errMap) {

        try {
            // 构建基础数据map
            this.buildBaseMap(outDiscountRatioMap, data, dictMapMap, customerVoMap, terminalVoMap, productVoMap, salesOrgVoMap, customerChannelVoMap, terminalChannelVoMap, productBrandVoMap, productCategoryVoMap, productItemVoMap, profitGoalDiscountVoMap, orgVoMap, salesOrgErpMap, erpOrgMap, errMap);

            if (!errMap.isEmpty()) {
                return new ArrayList<>();
            }

            for (Map.Entry<Integer, SalesPlanSubCompanyImportsVo> row : data.entrySet()) {
                int rowNum = row.getKey();
                // 校验基础数据
                this.buildBaseData(row.getValue(), dictMapMap, customerVoMap, terminalVoMap, productVoMap, salesOrgVoMap, customerChannelVoMap, terminalChannelVoMap, productBrandVoMap, productCategoryVoMap, productItemVoMap, profitGoalDiscountVoMap, orgVoMap, salesOrgErpMap, erpOrgMap);

                // 校验数字
                this.buildDecimal(row.getValue(), outDiscountRatioMap, salesOrgErpMap, erpOrgMap);

                String errInfo = this.validateGetErrorInfo();
                if (errInfo != null) {
                    errMap.put(rowNum, errInfo);
                    continue;
                }

                //计算数据
                this.calculateData(row.getValue());
            }
            //处理客户
            this.buildCustomer(data, customerVoMap, errMap);

            if (!errMap.isEmpty()) {
                return new ArrayList<>();
            }
        } catch (Exception e) {
            if (e instanceof IllegalArgumentException || e instanceof NullPointerException || e instanceof IndexOutOfBoundsException) {
                throw e;
            } else {
                log.error("销售计划(分子公司)导入,错误信息={}", e);
                throw new IllegalArgumentException(e.getMessage());
            }
        }
        Collection<SalesPlanDto> salesPlanDtoList = nebulaToolkitService.copyCollectionByWhiteList(data.values(), SalesPlanSubCompanyImportsVo.class, SalesPlanDto.class, LinkedHashSet.class, ArrayList.class);
        return new ArrayList<>(salesPlanDtoList);
    }

    private void buildCustomer(LinkedHashMap<Integer, SalesPlanSubCompanyImportsVo> data, Map<String, CustomerVo> customerVoMap, Map<Integer, String> errMap) {
        //客户编码
        Set<String> customerCodeSet = Sets.newHashSet();
        data.values().forEach(item -> {
            //客户编码=MDG客户编码+所属销售机构ERP编码+渠道编码+业态编码
            customerCodeSet.add(item.getCustomerCode()+item.getSalesInstitutionErpCode()+item.getCustomerChannelCode()+item.getBusinessFormatCode());
        });
        // 客户
        if (!CollectionUtils.isEmpty(customerCodeSet)) {
            List<CustomerVo> customerVos = customerVoService.findBaseByCustomerCodes(new ArrayList<>(customerCodeSet));
            if (!CollectionUtils.isEmpty(customerVos)) {
                customerVoMap.putAll(customerVos.stream().collect(Collectors.toMap(CustomerVo::getErpCode, Function.identity())));
            }
        }
        //校验客户
        for (Map.Entry<Integer, SalesPlanSubCompanyImportsVo> row : data.entrySet()) {
            int rowNum = row.getKey();
            // 客户
            if (!StringUtils.isEmpty(row.getValue().getCustomerCode())) {
                if (customerVoMap.containsKey(row.getValue().getCustomerCode())) {
                    CustomerVo customerVo = customerVoMap.get(row.getValue().getCustomerCode());
                    row.getValue().setCustomerName(customerVo.getCustomerName());
                    row.getValue().setCustomerCode(customerVo.getCustomerCode());
                    row.getValue().setErpCode(customerVo.getErpCode());
                } else {
                    throw new IllegalArgumentException("客户编码" + row.getValue().getCustomerCode() + "错误，请检查！");
                }
            }

            String errInfo = this.validateGetErrorInfo();
            if (errInfo != null) {
                errMap.put(rowNum, errInfo);
            }
        }
    }

    /**
     * 校验字段不为空
     *
     * @param importsVo
     */
    private void baseCheck(SalesPlanSubCompanyImportsVo importsVo) {
        this.validateIsTrue(StringUtils.isNotEmpty(importsVo.getBusinessFormatCode()), "业态不能为空");
        this.validateIsTrue(StringUtils.isNotEmpty(importsVo.getBusinessUnitCode()), "业务单元能为空");
        this.validateIsTrue(StringUtils.isNotEmpty(importsVo.getYearMonthLy()), "年月不能为空");

        this.validateIsTrue(StringUtils.isNotEmpty(importsVo.getGroupCode()), "分组不能为空");
        this.validateIsTrue(StringUtils.isNotEmpty(importsVo.getSalesInstitutionCode()), "销售机构编码不能为空");
        this.validateIsTrue(StringUtils.isNotEmpty(importsVo.getCustomerChannelCode()), "客户渠道编码不能为空");
        this.validateIsTrue(StringUtils.isNotEmpty(importsVo.getCustomerChannelName()), "客户渠道名称不能为空");
        this.validateIsTrue(StringUtils.isNotEmpty(importsVo.getCustomerCode()), "客户编码不能为空");
        this.validateIsTrue(StringUtils.isNotEmpty(importsVo.getCustomerName()), "客户名称不能为空");
        this.validateIsTrue(StringUtils.isNotEmpty(importsVo.getUnitCode()), "单位编码不能为空");
        this.validateIsTrue(StringUtils.isNotEmpty(importsVo.getUnitName()), "单位名称不能为空");
        this.validateIsTrue(StringUtils.isNotEmpty(importsVo.getPlanQuantityStr()), "计划量不能为空");
        this.validateIsTrue(StringUtils.isNotEmpty(importsVo.getCifPriceStr()), "到岸价不能为空");
        this.validateIsTrue(StringUtils.isNotEmpty(importsVo.getStandardSupplyPriceStr()), "标准供货价不能为空");
    }

    /**
     * 计算相关费率
     *
     * @param importsVo
     */
    private void calculateData(SalesPlanSubCompanyImportsVo importsVo) {
        //折前收入（元）=计划量*标准供货价
        BigDecimal beforeDiscount = importsVo.getPlanQuantity().multiply(importsVo.getStandardSupplyPrice()).setScale(6, BigDecimal.ROUND_HALF_UP);
        importsVo.setTheoryIncome(beforeDiscount);
        //折前成本=计划量*到岸价
        BigDecimal theoryCost = importsVo.getPlanQuantity().multiply(importsVo.getCifPrice()).setScale(6, BigDecimal.ROUND_HALF_UP);
        importsVo.setTheoryCost(theoryCost);
        //进货折扣率(目前还不知道怎么取)
        BigDecimal discountRate = importsVo.getDiscountRate();
        //出货折扣率
        BigDecimal shippingDiscountRate = importsVo.getShippingDiscountRate();
        //折后收入（元）=折前收入*（1-出货折扣率）
        BigDecimal discountedIncome = beforeDiscount.multiply(BigDecimal.ONE.subtract(shippingDiscountRate)).setScale(6, BigDecimal.ROUND_HALF_UP);
        importsVo.setDiscountedIncome(discountedIncome);
        //折后成本=折前成本*（1-进货折扣率）
        BigDecimal discountedCost = theoryCost.multiply(BigDecimal.ONE.subtract(discountRate)).setScale(6, BigDecimal.ROUND_HALF_UP);
        importsVo.setDiscountedCost(discountedCost);

        //说明：理论收入税金=（（折前收入）/（1+税率））*税率
        BigDecimal bigDecimal1 = beforeDiscount.divide(BigDecimal.ONE.add(importsVo.getTaxRate()), 6, BigDecimal.ROUND_HALF_UP).multiply(importsVo.getTaxRate()).setScale(6, BigDecimal.ROUND_HALF_UP);
        //      出库折扣税金额=（（折前收入*出货折扣率）/（1+税率））*税率
        BigDecimal bigDecimal2 = beforeDiscount.multiply(shippingDiscountRate).divide(BigDecimal.ONE.add(importsVo.getTaxRate()), 6, BigDecimal.ROUND_HALF_UP).multiply(importsVo.getTaxRate()).setScale(6, BigDecimal.ROUND_HALF_UP);
        //      理论成本税金=（（折前成本）/（1+税率））*税率
        BigDecimal bigDecimal3 = theoryCost.divide(BigDecimal.ONE.add(importsVo.getTaxRate()), 6, BigDecimal.ROUND_HALF_UP).multiply(importsVo.getTaxRate()).setScale(6, BigDecimal.ROUND_HALF_UP);
        //进货折扣税金额=（（理论成本*进货折扣率）/（1+税率））*税率
        BigDecimal bigDecimal4 = theoryCost.multiply(discountRate).divide(BigDecimal.ONE.add(importsVo.getTaxRate()), 6, BigDecimal.ROUND_HALF_UP).multiply(importsVo.getTaxRate()).setScale(6, BigDecimal.ROUND_HALF_UP);
        //增值税（元）=①　增值税=（理论收入税金-出库折扣税金）-（理论成本税金-进货折扣税金额）
        BigDecimal vat = bigDecimal1.subtract(bigDecimal2).subtract(bigDecimal3).add(bigDecimal4);
        importsVo.setVat(vat);
        //税金附加=增值税额*0.12
        /*BigDecimal taxesAdditional = vat.multiply(BigDecimal.valueOf(12).divide(BigDecimal.valueOf(100), 6, BigDecimal.ROUND_HALF_UP)).setScale(6, BigDecimal.ROUND_HALF_UP);
        importsVo.setTaxesAdditional(taxesAdditional);*/
        //税金附加=增值税*增值税及附加税税率
        BigDecimal vatRate = BigDecimal.ZERO;
        //销售机构编码
        String salesInstitutionCode = importsVo.getSalesInstitutionCode();
        if(org.springframework.util.StringUtils.hasText(salesInstitutionCode)){
            String saleOrgErpCode = salesInstitutionCode.substring(salesInstitutionCode.length() - 4, salesInstitutionCode.length());
            List<SalesOrgSubComOrgVo> subComOrgVos = this.salesOrgSubComOrgService.findBySaleOrgErpCode(saleOrgErpCode);
            if(!CollectionUtils.isEmpty(subComOrgVos)){
                SalesOrgSubComOrgVo salesOrgSubComOrgVo = subComOrgVos.get(0);
                //增值税及附加税税率
                vatRate = salesOrgSubComOrgVo.getVatRate();
            }
        }
        if (Objects.isNull(vatRate)) {
            vatRate = new BigDecimal(0.12);
        }
        importsVo.setTaxesAdditional(vat.multiply(vatRate).setScale(6, BigDecimal.ROUND_UP));
        log.info("增值税1，{}",vat);
        log.info("增值税税率1，{}",vatRate);
        log.info("附加税金1,{}",importsVo.getTaxesAdditional());
        //税费=增值税+附加税金
        BigDecimal taxesFee = vat.add(importsVo.getTaxesAdditional());
        importsVo.setTaxesFee(taxesFee);
    }

    /**
     * 测试方法
     *
     * @param list
     * @author huojia
     * @date 2023/1/10 23:39
     **/
    public void testValidate(List<SalesPlanSubCompanyImportsVo> list) {
        Map<String, String> mdmBusinessFormatMap = new HashMap<>();
        Map<String, String> mdmBusinessUnitMap = new HashMap<>();
        Map<String, String> tpmGroupCodeMap = new HashMap<>();
        Map<String, CustomerVo> customerVoMap = new HashMap<>();
        Map<String, TerminalVo> terminalVoMap = new HashMap<>();
        Map<String, ProductVo> productVoMap = new HashMap<>();
        Map<String, SalesOrgVo> salesOrgVoMap = new HashMap<>();
        Map<String, CustomerChannelVo> customerChannelVoMap = new HashMap<>();
        Map<String, MdmTerminalChannelVo> terminalChannelVoMap = new HashMap<>();
        Map<String, ProductBrandVo> productBrandVoMap = new HashMap<>();
        Map<String, ProductLevelVo> productCategoryVoMap = new HashMap<>();
        Map<String, ProductLevelVo> productItemVoMap = new HashMap<>();
        Map<String, ProfitGoalDiscountVo> profitGoalDiscountVoMap = new HashMap<>();
        Map<String, OrgVo> orgVoMap = new HashMap<>();
        Map<String, String> salesOrgErpMap = new HashMap<>();
        Map<String, String> erpOrgMap = new HashMap<>();
        Map<String, ProfitGoalDiscountVo> outDiscountRatioMap = new HashMap<>();

        Validate.notEmpty(list, "导入数据不能为空！");

        LinkedHashMap<Integer, SalesPlanSubCompanyImportsVo> data = new LinkedHashMap<>();
        data.put(1, list.get(0));
//        List<SalesPlanDto> importList = this.validate(outDiscountRatioMap, data, mdmBusinessFormatMap, mdmBusinessUnitMap, tpmGroupCodeMap, customerVoMap, terminalVoMap, productVoMap, salesOrgVoMap, customerChannelVoMap, terminalChannelVoMap, productBrandVoMap, productCategoryVoMap, productItemVoMap, profitGoalDiscountVoMap, orgVoMap, salesOrgErpMap, erpOrgMap);

    }

    /**
     * 获取维度配置，校验基础数据
     *
     * @param dimensionMap
     * @param importsVo
     * @param clazz
     * @author huojia
     * @date 2022/11/12 10:51
     **/
    private void buildDimension(Map<String, List<DimensionDimensionInformationVo>> dimensionMap, SalesPlanSubCompanyImportsVo importsVo, Class<SalesPlanSubCompanyImportsVo> clazz) {
        List<DimensionDimensionInformationVo> dimensionVoList = new ArrayList<>();
        if (!dimensionMap.containsKey(importsVo.getBusinessFormatCode() + importsVo.getBusinessUnitCode() + MenuCodeEnum.SALES_PLAN.getCode() + importsVo.getSalesOrgRegionCode())) {
            // 获取维度配置
            DimensionInformationQueryData dto = new DimensionInformationQueryData();
            dto.setBusinessFormatCode(importsVo.getBusinessFormatCode());
            dto.setBusinessUnitCode(importsVo.getBusinessUnitCode());
            dto.setMenu(MenuCodeEnum.SALES_PLAN.getCode());
            // dto.setSalesOrganization(importsVo.getSalesOrgCode());
            dimensionVoList = dimensionDimensionInformationService.findDetailsByCodes(dto);
            dimensionMap.put(importsVo.getBusinessFormatCode() + importsVo.getBusinessUnitCode() + MenuCodeEnum.SALES_PLAN.getCode() + importsVo.getSalesInstitutionCode(), dimensionVoList);
        } else {
            dimensionVoList = dimensionMap.get(importsVo.getBusinessFormatCode() + importsVo.getBusinessUnitCode() + MenuCodeEnum.SALES_PLAN.getCode() + importsVo.getSalesOrgRegionCode());
        }
        if (CollectionUtils.isEmpty(dimensionVoList)) {
            throw new IllegalArgumentException("未维护对应维度配置数据，请检查！");
        }
        // 根据维度配置，判断必填字段
        dimensionVoList.forEach(informationVo -> {
            try {
                if (StringUtils.isEmpty(informationVo.getFieldCoding())) {
                    return;
                }
                Field field = clazz.getDeclaredField(informationVo.getFieldCoding());
                field.setAccessible(true);
                Object o = field.get(importsVo);
                if (ObjectUtils.isEmpty(o)) {
                    throw new IllegalArgumentException(informationVo.getFieldName() + "不能为空！");
                }
            } catch (NoSuchFieldException | IllegalAccessException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        });
        importsVo.setTypeCoding(dimensionVoList.get(0).getTypeCoding());
    }

    /**
     * 校验数字
     *
     * @param importsVo
     * @author huojia
     * @date 2022/11/10 21:36
     **/
    private void buildDecimal(SalesPlanSubCompanyImportsVo importsVo,
                              Map<String, ProfitGoalDiscountVo> outDiscountRatioMap,
                              Map<String, String> salesOrgErpMap,
                              Map<String, String> erpOrgMap) {
        // 进货折扣率
        try {
            if (!StringUtils.isEmpty(importsVo.getDiscountRateStr())) {
                importsVo.setDiscountRate(new BigDecimal(importsVo.getDiscountRateStr()));
            }
        } catch (Exception e) {
            this.validateIsTrue(false, "进货折扣率" + importsVo.getDiscountRateStr() + "格式错误，请检查！");
        }
        // 出货折扣率
        try {
            if (!StringUtils.isEmpty(importsVo.getShippingDiscountRateStr())) {
                importsVo.setShippingDiscountRate(new BigDecimal(importsVo.getShippingDiscountRateStr()));
            }else{
                //1、出货折扣率不再是必填，从【分子预算配置】那里根据销售机构编码直接取出货折扣率；
                //2、如果填的值和取过来的不一致；则以填写的为准
                String erpCode = salesOrgErpMap.get(importsVo.getSalesInstitutionCode());
                String orgCode = erpOrgMap.get(erpCode);
                if (outDiscountRatioMap.containsKey(importsVo.getBusinessFormatCode() + importsVo.getBusinessUnitCode() + importsVo.getYearMonthLy() + orgCode)) {
                    ProfitGoalDiscountVo profitGoalDiscountVo = outDiscountRatioMap.get(importsVo.getBusinessFormatCode() + importsVo.getBusinessUnitCode() + importsVo.getYearMonthLy() + orgCode);
                    importsVo.setDiscountRate(profitGoalDiscountVo.getPurchaseDiscountRatio());
                    if (StringUtils.isEmpty(importsVo.getShippingDiscountRateStr())) {
                        importsVo.setShippingDiscountRate(profitGoalDiscountVo.getDeliveryDiscountRatio());
                    }
                }
            }
        } catch (Exception e) {
            this.validateIsTrue(false, "出货折扣率" + importsVo.getShippingDiscountRateStr() + "格式错误，请检查！");
        }
        // 计划量
        try {
            if (!StringUtils.isEmpty(importsVo.getPlanQuantityStr())) {
                importsVo.setPlanQuantity(new BigDecimal(importsVo.getPlanQuantityStr()));
            }
        } catch (Exception e) {
            this.validateIsTrue(false, "计划量" + importsVo.getPlanQuantityStr() + "格式错误，请检查！");
        }
        // 标准供货价
        try {
            if (!StringUtils.isEmpty(importsVo.getStandardSupplyPriceStr())) {
                importsVo.setStandardSupplyPrice(new BigDecimal(importsVo.getStandardSupplyPriceStr()));
            }
        } catch (Exception e) {
            this.validateIsTrue(false, "标准供货价" + importsVo.getStandardSupplyPriceStr() + "格式错误，请检查！");
        }

        // 到岸价
        try {
            if (!StringUtils.isEmpty(importsVo.getCifPriceStr())) {
                importsVo.setCifPrice(new BigDecimal(importsVo.getCifPriceStr()));
            }
        } catch (Exception e) {
            this.validateIsTrue(false, "到岸价" + importsVo.getCifPriceStr() + "格式错误，请检查！");
        }

    }

    /**
     * 校验基础数据
     *
     * @param importsVo
     * @author huojia
     * @date 2022/11/10 21:35
     **/
    private void buildBaseData(SalesPlanSubCompanyImportsVo importsVo,
                               Map<String, Map<String, String>> dictMapMap,
                               Map<String, CustomerVo> customerVoMap,
                               Map<String, TerminalVo> terminalVoMap,
                               Map<String, ProductVo> productVoMap,
                               Map<String, SalesOrgVo> salesOrgVoMap,
                               Map<String, CustomerChannelVo> customerChannelVoMap,
                               Map<String, MdmTerminalChannelVo> terminalChannelVoMap,
                               Map<String, ProductBrandVo> productBrandVoMap,
                               Map<String, ProductLevelVo> productCategoryVoMap,
                               Map<String, ProductLevelVo> productItemVoMap,
                               Map<String, ProfitGoalDiscountVo> profitGoalDiscountVoMap,
                               Map<String, OrgVo> orgVoMap,
                               Map<String, String> salesOrgErpMap,
                               Map<String, String> erpOrgMap) {

        Map<String, String> mdmBusinessFormatMap = dictMapMap.getOrDefault(DictTypeCodeConstant.MDM_BUSINESS_FORMAT,Maps.newHashMap());
        Map<String, String> mdmBusinessUnitMap = dictMapMap.getOrDefault(DictTypeCodeConstant.MDM_BUSINESS_UNIT,Maps.newHashMap());
        Map<String, String> tpmGroupCodeMap = dictMapMap.getOrDefault(DictTypeCodeConstant.TPM_GROUP_CODE,Maps.newHashMap());

        // 设置数据来源
        importsVo.setDataFromCode(DataFromEnum.IMPORT.getCode());
        // 业态
        if (!StringUtils.isEmpty(importsVo.getBusinessFormatCode())) {
            if (!mdmBusinessFormatMap.containsKey(importsVo.getBusinessFormatCode())) {
                this.validateIsTrue(false, "业态" + importsVo.getBusinessFormatCode() + "错误，请检查！");
            } else {
                importsVo.setBusinessFormatCode(mdmBusinessFormatMap.get(importsVo.getBusinessFormatCode()));
            }
        }
        // 业务单元
        if (!StringUtils.isEmpty(importsVo.getBusinessUnitCode())) {
            if (!mdmBusinessUnitMap.containsKey(importsVo.getBusinessUnitCode())) {
                this.validateIsTrue(false, "业务单元" + importsVo.getBusinessUnitCode() + "错误，请检查！");
            } else {
                importsVo.setBusinessUnitCode(mdmBusinessUnitMap.get(importsVo.getBusinessUnitCode()));
            }
        }
        // 年月
        String yearMonthLy = importsVo.getYearMonthLy();
        if (!StringUtils.isEmpty(yearMonthLy)) {
            if (yearMonthLy.length() != 7) {
                this.validateIsTrue(false, "年月" + yearMonthLy + "格式错误，应该为" + DateUtil.DEFAULT_YEAR_MONTH);
            }
            try {
                DateUtil.date_yyyy_MM.setLenient(false);
                DateUtil.date_yyyy_MM.parse(yearMonthLy);
            } catch (Exception ignored) {
                this.validateIsTrue(false, "年月" + yearMonthLy + "格式错误，应该为" + DateUtil.DEFAULT_YEAR_MONTH);
            }
        }
        // 分组
        if (!StringUtils.isEmpty(importsVo.getGroupCode())) {
            if (!tpmGroupCodeMap.containsKey(importsVo.getGroupCode())) {
                this.validateIsTrue(false, "分组" + importsVo.getGroupCode() + "错误，请检查！");
            } else {
                importsVo.setGroupCode(tpmGroupCodeMap.get(importsVo.getGroupCode()));
            }
        }
        // 客户渠道
        if (!StringUtils.isEmpty(importsVo.getCustomerChannelCode())) {
            if (!customerChannelVoMap.containsKey(importsVo.getCustomerChannelCode())) {
                this.validateIsTrue(false, "客户渠道" + importsVo.getCustomerChannelCode() + "错误，请检查！");
            } else {
                importsVo.setCustomerChannelName(customerChannelVoMap.get(importsVo.getCustomerChannelCode()).getCustomerChannelName());
                importsVo.setCustomerChannelLevelCode(customerChannelVoMap.get(importsVo.getCustomerChannelCode()).getCustomerChannelType());
            }
        }
        // 销售组织
        String insCode = importsVo.getCustomerChannelCode() + importsVo.getBusinessFormatCode() + importsVo.getSalesInstitutionCode();
        if (!salesOrgVoMap.containsKey(insCode)) {
            this.validateIsTrue(false, "销售机构" + importsVo.getSalesInstitutionCode() + "错误，请检查！");
        } else {
            importsVo.setSalesInstitutionName(salesOrgVoMap.get(insCode).getSalesOrgName());
            importsVo.setSalesInstitutionErpCode(salesOrgVoMap.get(insCode).getErpCode());
            importsVo.setSalesInstitutionCode(insCode);
        }
        // 销售组织
        if (!StringUtils.isEmpty(importsVo.getSalesOrgRegionCode())) {
            String regionCode = insCode + importsVo.getSalesOrgRegionCode();
            if (!salesOrgVoMap.containsKey(regionCode)) {
                this.validateIsTrue(false, "销售组织（大区）" + importsVo.getSalesOrgRegionCode() + "错误，请检查！");
            } else {
                importsVo.setSalesOrgRegionName(salesOrgVoMap.get(regionCode).getSalesOrgName());
                importsVo.setSalesOrgRegionErpCode(salesOrgVoMap.get(regionCode).getErpCode());
                if (!StringUtils.isEmpty(importsVo.getSalesOrgProvinceCode())) {
                    String provinceCode = regionCode + importsVo.getSalesOrgProvinceCode();
                    if (!salesOrgVoMap.containsKey(provinceCode)) {
                        this.validateIsTrue(false, "销售组（省区）" + importsVo.getSalesOrgProvinceCode() + "错误，请检查！");
                    } else {
                        importsVo.setSalesOrgProvinceName(salesOrgVoMap.get(provinceCode).getSalesOrgName());
                        importsVo.setSalesOrgProvinceErpCode(salesOrgVoMap.get(provinceCode).getErpCode());
                    }
                }
            }
        }

        // 终端渠道
        if (!StringUtils.isEmpty(importsVo.getTerminalChannelCode())) {
            if (!terminalChannelVoMap.containsKey(importsVo.getTerminalChannelCode())) {
                this.validateIsTrue(false, "终端渠道" + importsVo.getTerminalChannelCode() + "错误，请检查！");
            } else {
                importsVo.setTerminalChannelName(terminalChannelVoMap.get(importsVo.getTerminalChannelCode()).getTerminalChannelName());
            }
        }
        // 系统、零售商
        if (!StringUtils.isEmpty(importsVo.getSystemCode())) {
        }
        // 门店
        if (!StringUtils.isEmpty(importsVo.getTerminalCode())) {
            if (terminalVoMap.containsKey(importsVo.getTerminalCode())) {
                importsVo.setTerminalName(terminalVoMap.get(importsVo.getTerminalCode()).getTerminalName());
            } else {
                this.validateIsTrue(false, "门店编码" + importsVo.getTerminalCode() + "错误，请检查！");
            }
        }
        // 产品品牌
        if (!StringUtils.isEmpty(importsVo.getProductBrandCode())) {
            if (productBrandVoMap.containsKey(importsVo.getProductBrandCode())) {
                importsVo.setProductBrandName(productBrandVoMap.get(importsVo.getProductBrandCode()).getProductBrandName());
            } else {
                this.validateIsTrue(false, "产品品牌" + importsVo.getProductBrandCode() + "错误，请检查！");
            }
        }
        // 产品品类
        if (!StringUtils.isEmpty(importsVo.getProductCategoryCode())) {
            if (productCategoryVoMap.containsKey(importsVo.getProductCategoryCode())) {
                importsVo.setProductCategoryName(productCategoryVoMap.get(importsVo.getProductCategoryCode()).getProductLevelName());
            } else {
                this.validateIsTrue(false, "产品品类" + importsVo.getProductCategoryCode() + "错误，请检查！");
            }
        }
        // 产品品项
        if (!StringUtils.isEmpty(importsVo.getProductItemCode())) {
            if (productItemVoMap.containsKey(importsVo.getProductItemCode())) {
                importsVo.setProductItemName(productItemVoMap.get(importsVo.getProductItemCode()).getProductLevelName());
            } else {
                this.validateIsTrue(false, "产品品项" + importsVo.getProductItemCode() + "错误，请检查！");
            }
        }
        // 产品
        if (!StringUtils.isEmpty(importsVo.getProductCode())) {
            if (productVoMap.containsKey(importsVo.getProductCode())) {
                ProductVo productVo = productVoMap.get(importsVo.getProductCode());
                importsVo.setProductName(productVo.getProductName());
                importsVo.setTaxRate(productVo.getRate());
                if (StringUtils.isEmpty(importsVo.getProductBrandCode())) {
                    importsVo.setProductBrandCode(productVo.getProductBrandCode());
                    importsVo.setProductBrandName(productVo.getProductBrandName());
                }
                if (StringUtils.isEmpty(importsVo.getProductCategoryCode())) {
                    importsVo.setProductCategoryCode(productVo.getProductCategoryCode());
                    importsVo.setProductCategoryName(productVo.getProductCategoryName());
                }
                if (StringUtils.isEmpty(importsVo.getProductItemCode())) {
                    importsVo.setProductItemCode(productVo.getProductLevelCode());
                    importsVo.setProductItemName(productVo.getProductLevelName());
                }
            } else {
                this.validateIsTrue(false, "产品编码" + importsVo.getProductCode() + "错误，请检查！");
            }
        }
//         销售机构编码
//        if (!StringUtils.isEmpty(importsVo.getSalesInstitutionCode())) {
//            if (salesOrgVoMap.containsKey(importsVo.getSalesInstitutionCode())) {
//                importsVo.setSalesInstitutionName(salesOrgVoMap.get(importsVo.getSalesInstitutionCode()).getSalesOrgName());
//            } else {
//                throw new IllegalArgumentException("销售机构编码" + importsVo.getSalesInstitutionCode() + "错误，请检查！");
//            }
//        }
        // 折扣率
        if (!StringUtils.isEmpty(importsVo.getYearMonthLy())) {
            String erpCode = salesOrgErpMap.get(importsVo.getSalesInstitutionCode());
            String orgCode = erpOrgMap.get(erpCode);
            // String orgCode = orgVoMap.get(importsVo.getSalesInstitutionCode()).getOrgCode();
            if (profitGoalDiscountVoMap.containsKey(importsVo.getBusinessFormatCode() + importsVo.getBusinessUnitCode() + importsVo.getYearMonthLy() + orgCode)) {
                ProfitGoalDiscountVo profitGoalDiscountVo = profitGoalDiscountVoMap.get(importsVo.getBusinessFormatCode() + importsVo.getBusinessUnitCode() + importsVo.getYearMonthLy() + orgCode);
                importsVo.setDiscountRate(profitGoalDiscountVo.getPurchaseDiscountRatio());
                if (StringUtils.isEmpty(importsVo.getShippingDiscountRateStr())) {
                    importsVo.setShippingDiscountRate(profitGoalDiscountVo.getDeliveryDiscountRatio());
                }
            }else {
                this.validateIsTrue(false, "业态[" + importsVo.getBusinessFormatCode() + "]业务单元[" + importsVo.getBusinessUnitCode() +
                        "]年月[" + importsVo.getYearMonthLy() + "]销售公司代码编码[" + orgCode + "]未查找到折扣率数据，请检查！");
            }
        }
        // 单位
        if (!StringUtils.isEmpty(importsVo.getUnitCode())) {

        }

//        4、【属性】：必填；填写内容验证：数据字典sales_plan_attributes_subsidiary；
//        5、【渠道细分】：必填；填写内容验证：数据字典channel_segmentation_subsidiary_companies；
//        6、【经营模式】：必填；填写内容验证：数据字典sales_plan_business_model_subsidiary_companies；
        validateAndConvertDictData(dictMapMap,"sales_plan_attributes_subsidiary",importsVo.getAttributesSubsidiary(),importsVo::setAttributesSubsidiary,"属性");
        validateAndConvertDictData(dictMapMap,"channel_segmentation_subsidiary_companies",importsVo.getChannelSegmentationSubsidiary(),importsVo::setChannelSegmentationSubsidiary,"渠道细分");
        validateAndConvertDictData(dictMapMap,"sales_plan_business_model_subsidiary_companies",importsVo.getBusinessModelSubsidiary(),importsVo::setBusinessModelSubsidiary,"经营模式");

    }


    public void validateAndConvertDictData(Map<String, Map<String,String>> dictMap, String dictTypeCode, String dictValue, Consumer<String> setMethod, String desc){
        if (StringUtils.isEmpty(dictValue)){
            return;
        }
        Map<String, String> dictDataMap = dictMap.get(dictTypeCode);
        if (null == dictDataMap) {
            return;
        }
        String dictCode = dictDataMap.get(dictValue);
        if (StringUtils.isEmpty(dictCode)){
            this.validateIsTrue(false,desc+"["+dictValue+"]有误");
        }
        setMethod.accept(dictCode);
    }

    /**
     * 构建基础数据map
     *
     * @param
     * @author huojia
     * @date 2022/11/10 21:34
     **/
    private void buildBaseMap(Map<String, ProfitGoalDiscountVo> outDiscountRatioMap,
                              LinkedHashMap<Integer, SalesPlanSubCompanyImportsVo> data,
                              Map<String, Map<String, String>> dictMapMap,
                              Map<String, CustomerVo> customerVoMap,
                              Map<String, TerminalVo> terminalVoMap,
                              Map<String, ProductVo> productVoMap,
                              Map<String, SalesOrgVo> salesOrgVoMap,
                              Map<String, CustomerChannelVo> customerChannelVoMap,
                              Map<String, MdmTerminalChannelVo> terminalChannelVoMap,
                              Map<String, ProductBrandVo> productBrandVoMap,
                              Map<String, ProductLevelVo> productCategoryVoMap,
                              Map<String, ProductLevelVo> productItemVoMap,
                              Map<String, ProfitGoalDiscountVo> profitGoalDiscountVoMap,
                              Map<String, OrgVo> orgVoMap,
                              Map<String, String> salesOrgErpMap,
                              Map<String, String> erpOrgMap,
                              Map<Integer, String> errMap) {
        // 查询数据字典
        List<String> dictCodeList = Lists.newArrayList(DictTypeCodeConstant.MDM_BUSINESS_FORMAT,DictTypeCodeConstant.MDM_BUSINESS_UNIT,DictTypeCodeConstant.TPM_GROUP_CODE);
//        4、【属性】：必填；填写内容验证：数据字典sales_plan_attributes_subsidiary；
//        5、【渠道细分】：必填；填写内容验证：数据字典channel_segmentation_subsidiary_companies；
//        6、【经营模式】：必填；填写内容验证：数据字典sales_plan_business_model_subsidiary_companies；
        dictCodeList.add("sales_plan_attributes_subsidiary");
        dictCodeList.add("channel_segmentation_subsidiary_companies");
        dictCodeList.add("sales_plan_business_model_subsidiary_companies");

        Map<String, List<DictDataVo>> dictMap = dictDataVoService.findByDictTypeCodeList(dictCodeList);
        dictMapMap.putAll(!CollectionUtils.isEmpty(dictMap) ? dictMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, item -> item.getValue().stream().collect(Collectors.toMap(DictDataVo::getDictValue, DictDataVo::getDictCode, (o, n) -> n)), (o, n) -> n)) : new HashMap<>());

        Map<String, String> mdmBusinessFormatMap = dictMapMap.getOrDefault(DictTypeCodeConstant.MDM_BUSINESS_FORMAT,Maps.newHashMap());

        // 查询主数据数据，校验
//        Set<String> salesOrgCodeSet = salesPlanSubCompanyImportsVos.stream().map(SalesPlanSubCompanyImportsVo::getSalesInstitutionCode).filter(Objects::nonNull).collect(Collectors.toSet());
//        Set<String> salesOrgRegionCodeSet = salesPlanSubCompanyImportsVos.stream().map(SalesPlanSubCompanyImportsVo::getSalesOrgRegionCode).filter(Objects::nonNull).collect(Collectors.toSet());
//        Set<String> salesOrgProvinceCodeSet = salesPlanSubCompanyImportsVos.stream().map(SalesPlanSubCompanyImportsVo::getSalesOrgProvinceCode).filter(Objects::nonNull).collect(Collectors.toSet());
//        Set<String> customerChannelCodeSet = salesPlanSubCompanyImportsVos.stream().map(SalesPlanSubCompanyImportsVo::getCustomerChannelCode).filter(Objects::nonNull).collect(Collectors.toSet());
//        Set<String> terminalChannelCodeSet = salesPlanSubCompanyImportsVos.stream().map(SalesPlanSubCompanyImportsVo::getTerminalChannelCode).filter(Objects::nonNull).collect(Collectors.toSet());
//        Set<String> systemCodeSet = salesPlanSubCompanyImportsVos.stream().map(SalesPlanSubCompanyImportsVo::getSystemCode).filter(Objects::nonNull).collect(Collectors.toSet());
//        Set<String> terminalCodeSet = salesPlanSubCompanyImportsVos.stream().map(SalesPlanSubCompanyImportsVo::getTerminalCode).filter(Objects::nonNull).collect(Collectors.toSet());
//        Set<String> productBrandCodeSet = salesPlanSubCompanyImportsVos.stream().map(SalesPlanSubCompanyImportsVo::getProductBrandCode).filter(Objects::nonNull).collect(Collectors.toSet());
//        Set<String> productCategoryCodeSet = salesPlanSubCompanyImportsVos.stream().map(SalesPlanSubCompanyImportsVo::getProductCategoryCode).filter(Objects::nonNull).collect(Collectors.toSet());
//        Set<String> productItemCodeSet = salesPlanSubCompanyImportsVos.stream().map(SalesPlanSubCompanyImportsVo::getProductItemCode).filter(Objects::nonNull).collect(Collectors.toSet());
//        Set<String> productCodeSet = salesPlanSubCompanyImportsVos.stream().map(SalesPlanSubCompanyImportsVo::getProductCode).filter(Objects::nonNull).collect(Collectors.toSet());
//        Set<String> unitCodeSet = salesPlanSubCompanyImportsVos.stream().map(SalesPlanSubCompanyImportsVo::getUnitCode).filter(Objects::nonNull).collect(Collectors.toSet());
//        Set<String> yearMonthSet = salesPlanSubCompanyImportsVos.stream().map(SalesPlanSubCompanyImportsVo::getYearMonthLy).filter(Objects::nonNull).collect(Collectors.toSet());

        Set<String> salesOrgCodeSet = new HashSet<>();
        Set<String> salesOrgRegionCodeSet = new HashSet<>();
        Set<String> salesOrgProvinceCodeSet = new HashSet<>();
        Set<String> customerChannelCodeSet = new HashSet<>();
        Set<String> terminalChannelCodeSet = new HashSet<>();
        Set<String> systemCodeSet = new HashSet<>();
        Set<String> terminalCodeSet = new HashSet<>();
        Set<String> productBrandCodeSet = new HashSet<>();
        Set<String> productCategoryCodeSet = new HashSet<>();
        Set<String> productItemCodeSet = new HashSet<>();
        Set<String> productCodeSet = new HashSet<>();
        Set<String> unitCodeSet = new HashSet<>();
        Set<String> yearMonthSet = new HashSet<>();
        for (Map.Entry<Integer, SalesPlanSubCompanyImportsVo> row : data.entrySet()) {
            int rowNum = row.getKey();
            SalesPlanSubCompanyImportsVo importsVo = row.getValue();
            baseCheck(importsVo);
            String businessFormatCode = mdmBusinessFormatMap.get(importsVo.getBusinessFormatCode());
            this.validateIsTrue(StringUtils.isNotEmpty(businessFormatCode), "业态【"+ businessFormatCode +"】填写有误");

            String errInfo = this.validateGetErrorInfo();
            if (errInfo != null) {
                errMap.put(rowNum, errInfo);
                continue;
            }


            String insCode = importsVo.getCustomerChannelCode() + businessFormatCode + importsVo.getSalesInstitutionCode();
            salesOrgCodeSet.add(insCode);
            if (StringUtils.isNotBlank(importsVo.getSalesOrgRegionCode())) {
                String regionCode = insCode + importsVo.getSalesOrgRegionCode();
                salesOrgCodeSet.add(regionCode);
                if (StringUtils.isNotBlank(importsVo.getSalesOrgProvinceCode())) {
                    String provinceCode = regionCode + importsVo.getSalesOrgProvinceCode();
                    salesOrgCodeSet.add(provinceCode);
                }
            }
            customerChannelCodeSet.add(importsVo.getCustomerChannelCode());
            if (StringUtils.isNotBlank(importsVo.getTerminalChannelCode())) {
                terminalChannelCodeSet.add(importsVo.getTerminalChannelCode());
            }
            if (StringUtils.isNotBlank(importsVo.getSystemCode())) {
                systemCodeSet.add(importsVo.getSystemCode());
            }
            if (StringUtils.isNotBlank(importsVo.getTerminalCode())) {
                terminalCodeSet.add(importsVo.getTerminalCode());
            }
            if (StringUtils.isNotBlank(importsVo.getProductBrandCode())) {
                productBrandCodeSet.add(importsVo.getProductBrandCode());
            }
            if (StringUtils.isNotBlank(importsVo.getProductCategoryCode())) {
                productCategoryCodeSet.add(importsVo.getProductCategoryCode());
            }
            if (StringUtils.isNotBlank(importsVo.getProductItemCode())) {
                productItemCodeSet.add(importsVo.getProductItemCode());
            }
            if (StringUtils.isNotBlank(importsVo.getProductCode())) {
                productCodeSet.add(importsVo.getProductCode());
            }
            if (StringUtils.isNotBlank(importsVo.getUnitCode())) {
                unitCodeSet.add(importsVo.getUnitCode());
            }
            if (StringUtils.isNotBlank(importsVo.getYearMonthLy())) {
                yearMonthSet.add(importsVo.getYearMonthLy());
            }
            if (!errMap.isEmpty()) {
                return;
            }
        }



        // 销售组织
        salesOrgCodeSet.addAll(salesOrgRegionCodeSet);
        salesOrgCodeSet.addAll(salesOrgProvinceCodeSet);
        if (!CollectionUtils.isEmpty(salesOrgCodeSet)) {
            List<SalesOrgVo> salesOrgVos = salesOrgVoService.findBySalesOrgCodes(new ArrayList<>(salesOrgCodeSet));
            if (!CollectionUtils.isEmpty(salesOrgVos)) {
                salesOrgErpMap.putAll(salesOrgVos.stream().collect(Collectors.toMap(SalesOrgVo::getSalesOrgCode, SalesOrgVo::getErpCode)));
                salesOrgVoMap.putAll(salesOrgVos.stream().collect(Collectors.toMap(SalesOrgVo::getSalesOrgCode, Function.identity())));
                List<String> erpCodeList = salesOrgVos.stream().map(SalesOrgVo::getErpCode).filter(Objects::nonNull).collect(Collectors.toList());
                // 查询erpCode对应的所有销售机构
                List<SalesOrgSubComOrgVo> salesOrgSubComOrgVos = salesOrgSubComOrgService.listBySalesOrgCodeList(erpCodeList);
                erpOrgMap.putAll(salesOrgSubComOrgVos.stream().collect(Collectors.toMap(SalesOrgSubComOrgVo::getSalesOrgCode, SalesOrgSubComOrgVo::getOrgCode, (v1, v2) -> v2)));
                if (!CollectionUtils.isEmpty(erpOrgMap)) {
                    List<OrgVo> orgVos = orgVoService.findByOrgCodes(Lists.newArrayList(erpOrgMap.values()));
                    if (!CollectionUtils.isEmpty(orgVos)) {
                        orgVoMap.putAll(orgVos.stream().collect(Collectors.toMap(OrgVo::getOrgCode, Function.identity(), (v1, v2) -> v2)));
                    }
                }
//                List<SalesOrgVo> allSalesOrgList = salesOrgVoService.findByErpCodeList(erpCodeList);
//                salesOrgErpMap.putAll(allSalesOrgList.stream().collect(Collectors.toMap(SalesOrgVo::getSalesOrgCode, SalesOrgVo::getErpCode)));
//                Set<String> allSalesOrgCodeSet = allSalesOrgList.stream().map(SalesOrgVo::getSalesOrgCode).collect(Collectors.toSet());
//                // 查询所有销售机构对应的组织
//                List<OrgVo> orgVos = orgVoService.findBySalesOrgCodes(new ArrayList<>(allSalesOrgCodeSet));
//                // 一个erp编码只会对应一个HR组织
//                // 查询
//                if (!CollectionUtils.isEmpty(orgVos)) {
//                    orgVoMap.putAll(orgVos.stream().collect(Collectors.toMap(OrgVo::getSalesOrgCode, Function.identity())));
//                    orgVoMap.forEach((key, value) -> {
//                        erpOrgMap.put(salesOrgErpMap.get(key), value.getOrgCode());
//                    });
//                }
            }
        }

        // 客户渠道
        if (!CollectionUtils.isEmpty(customerChannelCodeSet)) {
            List<CustomerChannelVo> customerChannelVos = customerChannelVoService.findByCodes(new ArrayList<>(customerChannelCodeSet));
            if (!CollectionUtils.isEmpty(customerChannelVos)) {
                customerChannelVoMap.putAll(customerChannelVos.stream().collect(Collectors.toMap(CustomerChannelVo::getCustomerChannelCode, Function.identity())));
            }
        }

        // 终端渠道
        if (!CollectionUtils.isEmpty(terminalChannelCodeSet)) {
            List<MdmTerminalChannelVo> mdmTerminalChannelVos = mdmTerminalChannelVoService.listByCodes(new ArrayList<>(terminalChannelCodeSet));
            if (!CollectionUtils.isEmpty(mdmTerminalChannelVos)) {
                terminalChannelVoMap.putAll(mdmTerminalChannelVos.stream().collect(Collectors.toMap(MdmTerminalChannelVo::getTerminalChannelCode, Function.identity())));
            }
        }

        // 终端
        if (!CollectionUtils.isEmpty(terminalCodeSet)) {
            List<TerminalVo> terminalVos = terminalVoService.findDetailsByIdsOrTerminalCodes(null, new ArrayList<>(terminalCodeSet));
            if (!CollectionUtils.isEmpty(terminalVos)) {
                terminalVoMap.putAll(terminalVos.stream().collect(Collectors.toMap(TerminalVo::getTerminalCode, Function.identity())));
            }
        }

        // 品牌
        if (!CollectionUtils.isEmpty(productBrandCodeSet)) {
            List<ProductBrandVo> productBrandVos = productBrandService.listByCodes(new ArrayList<>(productBrandCodeSet));
            if (!CollectionUtils.isEmpty(productBrandVos)) {
                productBrandVoMap.putAll(productBrandVos.stream().collect(Collectors.toMap(ProductBrandVo::getProductBrandCode, Function.identity())));
            }
        }

        // 品类
        if (!CollectionUtils.isEmpty(productCategoryCodeSet)) {
            List<ProductLevelVo> productLevelVos = productLevelVoSdkService.findListByCodes(new ArrayList<>(productCategoryCodeSet));
            if (!CollectionUtils.isEmpty(productLevelVos)) {
                productCategoryVoMap.putAll(productLevelVos.stream().collect(Collectors.toMap(ProductLevelVo::getProductLevelCode, Function.identity())));
            }
        }

        // 品项
        if (!CollectionUtils.isEmpty(productItemCodeSet)) {
            List<ProductLevelVo> productLevelVos = productLevelVoSdkService.findListByCodes(new ArrayList<>(productItemCodeSet));
            if (!CollectionUtils.isEmpty(productLevelVos)) {
                productItemVoMap.putAll(productLevelVos.stream().filter(a -> ProductLevelEnum.items.equals(a.getProductLevelType()) && a.getParentCode() != null)
                        .collect(Collectors.toMap(ProductLevelVo::getProductLevelCode, Function.identity())));
            }
        }

        // 产品
        if (!CollectionUtils.isEmpty(productCodeSet)) {
            List<ProductVo> productVoList = productVoService.findDetailsByIdsOrProductCodes(Lists.newArrayList(), new ArrayList<>(productCodeSet));
            if (!CollectionUtils.isEmpty(productVoList)) {
                productVoMap.putAll(productVoList.stream().collect(Collectors.toMap(ProductVo::getProductCode, Function.identity())));
            }
        }

        if (!CollectionUtils.isEmpty(yearMonthSet)) {
            List<ProfitGoalDiscountVo> profitGoalDiscountVoList = profitGoalDiscountService.findListByYearMonthList(new ArrayList<>(yearMonthSet));
            if (!CollectionUtils.isEmpty(profitGoalDiscountVoList)) {
                profitGoalDiscountVoMap.putAll(profitGoalDiscountVoList.stream()
                        .filter(vo -> BudgetAmountTypeEnum.DISCOUNT_RATIO.getCode().equals(vo.getTypeCode()))
                        .collect(Collectors.toMap(vo -> vo.getBusinessFormatCode() + vo.getBusinessUnitCode() + vo.getYearMonthLy() + vo.getOrgCode(), Function.identity())));
                outDiscountRatioMap.putAll(profitGoalDiscountVoList.stream()
                        .filter(vo -> BudgetAmountTypeEnum.OUT_DISCOUNT_RATIO.getCode().equals(vo.getTypeCode()))
                        .collect(Collectors.toMap(vo -> vo.getBusinessFormatCode() + vo.getBusinessUnitCode() + vo.getYearMonthLy() + vo.getOrgCode(), Function.identity())));
            }
        }
    }

    @Override
    public String getBusinessCode() {
        return "TPM_SALES_PLAN_IMPORT";
    }

    @Override
    public String getBusinessName() {
        return "TPM-销售计划导入";
    }

    @Override
    public Class<SalesPlanSubCompanyImportsVo> findCrmExcelVoClass() {
        return SalesPlanSubCompanyImportsVo.class;
    }

    @Override
    public String getTemplateCode() {
        return "TPM_SALES_PLAN_SUB_COMPANY_IMPORT";
    }

    @Override
    public String getTemplateName() {
        return "TPM销售计划导入(分子公司)";
    }
}
