package com.biz.crm.tpm.business.sales.plan.local.service.xxjob;

import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.third.system.cow.master.guest.sdk.dto.CowMasterGuestMonthPlanDto;
import com.biz.crm.tpm.business.sales.plan.local.service.SalesPlanCowMasterGuestService;
import com.biz.crm.tpm.business.sales.plan.sdk.dto.SalesPlanDto;
import com.biz.crm.tpm.business.sales.plan.sdk.dto.SalesPlanLogEventDto;
import com.biz.crm.tpm.business.sales.plan.sdk.event.SalesPlanJobEventListener;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.bizunited.nebula.task.annotations.DynamicTaskService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Calendar;
import java.util.Date;

/**
 * 定时拉取 销售计划 （回复量）
 *
 * @author huojia
 * @date 2023年01月31日 0:59
 */
@Slf4j
@Service
public class AutoPullMonthPlanReplayXxJob {

    @Autowired(required = false)
    private SalesPlanCowMasterGuestService salesPlanCowMasterGuestService;

    @Autowired
    private NebulaNetEventClient nebulaNetEventClient;

    @Autowired(required = false)
    private LoginUserService loginUserService;

    /**
     * 计算回复量
     */
    @DynamicTaskService(cornExpression = "0 0 2 6 1/1 ?", taskDesc = "（垂直回复量）拉取当月销售计划并更新当月月度预算")
    public void planAutoSyncXxlJob() {
        loginUserService.refreshAuthentication(null);
        log.info("=====>    垂直销售计划（回复量）[{}] start    <=====", DateUtil.dateStrNowAll());
        Calendar calendar = DateUtil.getCalendar();
        calendar.setTime(new Date());
        Date time = calendar.getTime();
        String nextYearMonth = DateUtil.format(time, DateUtil.DEFAULT_YEAR_MONTH);
        this.handle(nextYearMonth);
        log.info("=====>    垂直销售计划（回复量）[{}] end    <=====", DateUtil.dateStrNowAll());
    }

    public void handle(String yearMonth) {
        log.info("=====>    垂直销售计划（回复量） 年月 [{}] start {}   <=====", yearMonth, DateUtil.dateStrNowAll());
        CowMasterGuestMonthPlanDto cowMasterGuestMonthPlanDto = new CowMasterGuestMonthPlanDto();
        cowMasterGuestMonthPlanDto.setYear(yearMonth.split("-")[0]);
        cowMasterGuestMonthPlanDto.setMonths(yearMonth.split("-")[1]);
        salesPlanCowMasterGuestService.pullMonthPlanList(cowMasterGuestMonthPlanDto);
        //通知更新月度预算
        this.publish(yearMonth);
        log.info("=====>    垂直销售计划（回复量） 年月 [{}] end {}   <=====", yearMonth, DateUtil.dateStrNowAll());
    }

    public void publish(String yearMonth) {
        SerializableBiConsumer<SalesPlanJobEventListener, SalesPlanLogEventDto> onReplay =
                SalesPlanJobEventListener::onReplay;
        SalesPlanLogEventDto eventDto = new SalesPlanLogEventDto();
        SalesPlanDto planDto = new SalesPlanDto();
        planDto.setYearMonthLy(yearMonth);
        eventDto.setNewest(planDto);
        this.nebulaNetEventClient.publish(eventDto, SalesPlanJobEventListener.class, onReplay);
    }
}
