package com.biz.crm.tpm.business.sales.plan.local.service.xxjob;

import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.customer.sdk.dto.CustomerEventDto;
import com.biz.crm.mdm.business.customer.sdk.event.CustomerEventListener;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.third.system.cow.master.guest.sdk.dto.CowMasterGuestMonthPlanDto;
import com.biz.crm.tpm.business.sales.plan.local.service.SalesPlanCowMasterGuestService;
import com.biz.crm.tpm.business.sales.plan.sdk.dto.SalesPlanDto;
import com.biz.crm.tpm.business.sales.plan.sdk.dto.SalesPlanLogEventDto;
import com.biz.crm.tpm.business.sales.plan.sdk.event.SalesPlanJobEventListener;
import com.biz.crm.tpm.business.sales.plan.sdk.event.SalesPlanLogEventListener;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.bizunited.nebula.task.annotations.DynamicTaskService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Calendar;
import java.util.Date;

/**
 * （垂直）拉取下月销售计划并更新下月月度预算
 *
 * @author huojia
 * @date 2023年01月31日 0:59
 */
@Slf4j
@Service
public class AutoPullMonthPlanXxJob {

    @Autowired(required = false)
    private SalesPlanCowMasterGuestService salesPlanCowMasterGuestService;

    @Autowired
    private NebulaNetEventClient nebulaNetEventClient;

    @Autowired(required = false)
    private LoginUserService loginUserService;

    /**
     * 计算回复量
     */
    @DynamicTaskService(cornExpression = "0 0 2 28 1/1 ?", taskDesc = "（垂直计划量）拉取下月销售计划并更新下月月度预算")
    public void planAutoSyncXxlJob() {
        log.info("=====>    （垂直）拉取下月销售计划并更新下月月度预算 [{}] start    <=====", DateUtil.dateStrNowAll());
        loginUserService.refreshAuthentication(null);
        Calendar calendar = DateUtil.getCalendar();
        calendar.setTime(new Date());
        calendar.add(Calendar.MONTH, 1);
        Date time = calendar.getTime();
        String nextYearMonth = DateUtil.format(time, DateUtil.DEFAULT_YEAR_MONTH);
        this.handle(nextYearMonth);
        log.info("=====>    （垂直）拉取下月销售计划并更新下月月度预算 [{}] end    <=====", DateUtil.dateStrNowAll());
    }

    public void handle(String yearMonth) {
        CowMasterGuestMonthPlanDto cowMasterGuestMonthPlanDto = new CowMasterGuestMonthPlanDto();
        cowMasterGuestMonthPlanDto.setYear(yearMonth.split("-")[0]);
        cowMasterGuestMonthPlanDto.setMonths(yearMonth.split("-")[1]);
        salesPlanCowMasterGuestService.pullMonthPlanList(cowMasterGuestMonthPlanDto);
        //通知更新月度预算
        this.publish(yearMonth);
    }

    public void publish(String yearMonth) {
        SerializableBiConsumer<SalesPlanJobEventListener, SalesPlanLogEventDto> onPlan =
                SalesPlanJobEventListener::onPlan;
        SalesPlanLogEventDto eventDto = new SalesPlanLogEventDto();
        SalesPlanDto planDto = new SalesPlanDto();
        planDto.setYearMonthLy(yearMonth);
        eventDto.setNewest(planDto);
        this.nebulaNetEventClient.publish(eventDto, SalesPlanJobEventListener.class, onPlan);
    }
}
