/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.sales.plan.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.third.system.cow.master.guest.sdk.dto.CowMasterGuestMonthPlanDto;
import com.biz.crm.tpm.business.sales.plan.local.service.SalesPlanCowMasterGuestService;
import com.biz.crm.tpm.business.sales.plan.local.service.process.SalesPlanHeadImportsProcess;
import com.biz.crm.tpm.business.sales.plan.local.service.process.SalesPlanSubCompanyImportsProcess;
import com.biz.crm.tpm.business.sales.plan.sdk.dto.SalesPlanConfirmDto;
import com.biz.crm.tpm.business.sales.plan.sdk.dto.SalesPlanDto;
import com.biz.crm.tpm.business.sales.plan.sdk.dto.SalesPlanLogEventDto;
import com.biz.crm.tpm.business.sales.plan.sdk.dto.SalesPlanReCalPlanAndReplyDto;
import com.biz.crm.tpm.business.sales.plan.sdk.dto.SalesPlanSummaryDto;
import com.biz.crm.tpm.business.sales.plan.sdk.enums.ConfirmEunm;
import com.biz.crm.tpm.business.sales.plan.sdk.event.SalesPlanJobEventListener;
import com.biz.crm.tpm.business.sales.plan.sdk.service.SalesPlanService;
import com.biz.crm.tpm.business.sales.plan.sdk.vo.SalesPlanHeadImportsVo;
import com.biz.crm.tpm.business.sales.plan.sdk.vo.SalesPlanSubCompanyImportsVo;
import com.biz.crm.tpm.business.sales.plan.sdk.vo.SalesPlanVo;
import com.biz.crm.tpm.business.sales.plan.sdk.vo.SubSaleMonitorVo;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/sales/plan"})
@Api(tags={"\u9500\u552e\u8ba1\u5212"})
public class SalesPlanController {
    private static final Logger log = LoggerFactory.getLogger(SalesPlanController.class);
    @Autowired(required=false)
    private SalesPlanService salesPlanService;
    @Autowired(required=false)
    private SalesPlanHeadImportsProcess salesPlanImportsProcess;
    @Autowired(required=false)
    private SalesPlanSubCompanyImportsProcess salesPlanSubCompanyImportsProcess;
    @Autowired(required=false)
    private SalesPlanCowMasterGuestService salesPlanCowMasterGuestService;
    @Autowired
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired(required=false)
    private LoginUserService loginUserService;

    @ApiOperation(value="\u5bfc\u5165\u6d4b\u8bd5")
    @PostMapping(value={"testValidate"})
    public Result<?> testValidate(@RequestBody @ApiParam(name="importsVos", value="\u9500\u552e\u8ba1\u5212\u5bfc\u5165\u4fe1\u606f") List<SalesPlanHeadImportsVo> importsVos) {
        try {
            this.salesPlanImportsProcess.testValidate(importsVos);
            return Result.ok((String)"\u5bfc\u5165\u6d4b\u8bd5\u6210\u529f");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6240\u6709\u6570\u636e")
    @GetMapping(value={"findByConditions"})
    public Result<Page<SalesPlanVo>> findByConditions(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="salesPlanDto", value="\u9500\u552e\u8ba1\u5212\u4fe1\u606f") SalesPlanDto dto) {
        try {
            Page page = this.salesPlanService.findByConditions(pageable, dto);
            return Result.ok((Object)page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5206\u5b50\u9500\u91cf\u76d1\u63a7")
    @GetMapping(value={"subSaleMonitor"})
    public Result<Page<SubSaleMonitorVo>> subSaleMonitor(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="salesPlanDto", value="\u9500\u552e\u8ba1\u5212\u4fe1\u606f") SalesPlanDto dto) {
        try {
            Page page = this.salesPlanService.subSaleMonitor(pageable, dto);
            return Result.ok((Object)page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6761\u4ef6\u67e5\u8be2\u6240\u6709\u6570\u636e")
    @PostMapping(value={"conditions"})
    public Result<List<SalesPlanVo>> findByConditions(@RequestBody SalesPlanDto dto) {
        try {
            List result = this.salesPlanService.findByConditions(dto);
            return Result.ok((Object)result);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6761\u4ef6\u67e5\u8be2\u6240\u6709\u6570\u636e")
    @PostMapping(value={"listByConditions"})
    public Result<List<SalesPlanVo>> listByConditions(@RequestBody SalesPlanDto dto) {
        try {
            List result = this.salesPlanService.listByConditions(dto);
            return Result.ok((Object)result);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u901a\u8fc7\u4e3b\u952e\u67e5\u8be2\u5355\u6761\u6570\u636e")
    @GetMapping(value={"detail"})
    public Result<SalesPlanVo> detail(@RequestParam(value="id") @ApiParam(name="id", value="\u4e3b\u952eid") String id) {
        try {
            SalesPlanVo salesPlanVo = this.salesPlanService.findById(id);
            return Result.ok((Object)salesPlanVo);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u65b0\u589e\u6570\u636e")
    @PostMapping
    public Result<SalesPlanVo> create(@ApiParam(name="salesPlanDto", value="TPM-\u9500\u552e\u8ba1\u5212") @RequestBody SalesPlanDto dto) {
        try {
            SalesPlanVo result = this.salesPlanService.create(dto);
            return Result.ok((Object)result);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u4fee\u6539\u6570\u636e")
    @PatchMapping
    public Result<SalesPlanVo> update(@ApiParam(name="salesPlanDto", value="TPM-\u9500\u552e\u8ba1\u5212") @RequestBody SalesPlanDto dto) {
        try {
            SalesPlanVo result = this.salesPlanService.update(dto);
            return Result.ok((Object)result);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @DeleteMapping
    @ApiOperation(value="\u5220\u9664\u6570\u636e")
    public Result<?> delete(@RequestParam(value="ids") List<String> ids) {
        try {
            this.salesPlanService.delete(ids);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5206\u9875\u62c9\u53d6\u6570\u636e")
    @PostMapping(value={"pullMonthPlanList"})
    public Result<?> pullMonthPlanList(@RequestBody CowMasterGuestMonthPlanDto dto) {
        try {
            this.salesPlanCowMasterGuestService.pullMonthPlanList(dto);
            return Result.ok((String)"");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u7ef4\u5ea6\u7edf\u8ba1\u56de\u590d\u91cf")
    @PostMapping(value={"summaryRecoveryAmount"})
    public Result<Map<String, BigDecimal>> summaryRecoveryAmount(@RequestBody SalesPlanSummaryDto dto) {
        try {
            Map map = this.salesPlanService.summaryRecoveryAmount(dto);
            return Result.ok((Object)map);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u7ef4\u5ea6\u7edf\u8ba1\u56de\u590d\u91cf")
    @PostMapping(value={"testImport"})
    public Result testImport(@RequestBody List<SalesPlanSubCompanyImportsVo> list) {
        try {
            this.salesPlanSubCompanyImportsProcess.testValidate(list);
            return Result.ok((String)"");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u9009\u62e9\u7684\u7ef4\u5ea6\u624b\u52a8\u8ba1\u7b97\u6298\u540e\u8ba1\u5212\u91cf\u548c\u56de\u590d\u91cf\uff08\u4e3b\u4f53\uff09")
    @PostMapping(value={"manualCalPlanAndReply"})
    public Result<?> manualCalPlanAndReply(@RequestBody SalesPlanReCalPlanAndReplyDto dto) {
        try {
            this.salesPlanService.manualCalPlanAndReply(dto);
            return Result.ok((String)"\u624b\u52a8\u8ba1\u7b97\u6298\u540e\u8ba1\u5212\u91cf\u548c\u56de\u590d\u91cf\u5f00\u59cb\uff0c\u8bf7\u7a0d\u7b49");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u9009\u62e9\u7684\u7ef4\u5ea6\u624b\u52a8\u8ba1\u7b97\u6298\u540e\u8ba1\u5212\u91cf\u548c\u56de\u590d\u91cf\uff08\u5782\u76f4\uff09")
    @PostMapping(value={"planAutoSyncXxlJob"})
    public Result planAutoSyncXxlJob(@RequestBody SalesPlanReCalPlanAndReplyDto dto) {
        try {
            String yearMonthLy = dto.getYearMonthLy();
            Assert.hasText((String)yearMonthLy, (String)"\u5e74\u6708\u4e0d\u80fd\u4e3a\u7a7a");
            log.info("=====>    \u5782\u76f4\u9500\u552e\u8ba1\u5212\uff08\u8ba1\u5212\u91cf\uff09[{}] start    <=====", (Object)DateUtil.dateStrNowAll());
            CowMasterGuestMonthPlanDto cowMasterGuestMonthPlanDto = new CowMasterGuestMonthPlanDto();
            cowMasterGuestMonthPlanDto.setYear(yearMonthLy.split("-")[0]);
            cowMasterGuestMonthPlanDto.setMonths(yearMonthLy.split("-")[1]);
            this.salesPlanCowMasterGuestService.pullMonthPlanList(cowMasterGuestMonthPlanDto);
            SerializableBiConsumer & Serializable onPlan = SalesPlanJobEventListener::onPlan;
            SalesPlanLogEventDto eventDto = new SalesPlanLogEventDto();
            SalesPlanDto planDto = new SalesPlanDto();
            planDto.setYearMonthLy(yearMonthLy);
            eventDto.setNewest(planDto);
            this.nebulaNetEventClient.publish((NebulaEventDto)eventDto, SalesPlanJobEventListener.class, (SerializableBiConsumer)onPlan);
            log.info("=====>    \u5782\u76f4\u9500\u552e\u8ba1\u5212\uff08\u8ba1\u5212\u91cf\uff09[{}] end    <=====", (Object)DateUtil.dateStrNowAll());
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6240\u6709\u672a\u786e\u8ba4\u7684\u6570\u636e")
    @GetMapping(value={"findConfirmByConditions"})
    public Result<Page<SalesPlanVo>> findConfirmByConditions(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="salesPlanDto", value="\u9500\u552e\u8ba1\u5212\u4fe1\u606f") SalesPlanDto dto) {
        try {
            dto.setSpecialDataStatus(ConfirmEunm.TOBECONFIRMED.getCode());
            dto.setBusinessUnitCode(BusinessUnitEnum.SON_COMPANY.getCode());
            Page page = this.salesPlanService.findByConditions(pageable, dto);
            return Result.ok((Object)page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6570\u636e\u786e\u8ba4")
    @PostMapping(value={"confirmData"})
    public Result<?> confirmData(@RequestBody SalesPlanConfirmDto dto) {
        try {
            this.salesPlanService.confirmData(dto);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

