/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.sales.plan.local.repository;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.tpm.business.sales.plan.local.entity.SalesPlanEntity;
import com.biz.crm.tpm.business.sales.plan.local.mapper.SalesPlanMapper;
import com.biz.crm.tpm.business.sales.plan.sdk.dto.SalesPlanDto;
import com.biz.crm.tpm.business.sales.plan.sdk.dto.SalesPlanReCalPlanAndReplyDto;
import com.biz.crm.tpm.business.sales.plan.sdk.dto.SalesPlanSummaryDto;
import com.biz.crm.tpm.business.sales.plan.sdk.vo.SalesPlanVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class SalesPlanRepository
extends ServiceImpl<SalesPlanMapper, SalesPlanEntity> {
    @Autowired(required=false)
    private SalesPlanMapper salesPlanMapper;
    @Autowired
    private LoginUserService loginUserService;

    public SalesPlanEntity getById(String id, String delFlag) {
        if (StringUtils.isEmpty((CharSequence)id)) {
            return null;
        }
        return (SalesPlanEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidEntity::getId, (Object)id)).eq(StringUtils.isNotEmpty((CharSequence)delFlag), UuidFlagOpEntity::getDelFlag, (Object)delFlag)).one());
    }

    public List<SalesPlanEntity> findByConditions(SalesPlanDto dto) {
        if (StringUtils.isEmpty((CharSequence)dto.getYearMonthLy()) && StringUtils.isEmpty((CharSequence)dto.getYearMonthLyBegin()) && StringUtils.isEmpty((CharSequence)dto.getYearMonthLyEnd()) && StringUtils.isEmpty((CharSequence)dto.getProductCode()) && CollectionUtils.isEmpty((Collection)dto.getSalesProductCodeList()) && StringUtils.isEmpty((CharSequence)dto.getProductItemCode()) && StringUtils.isEmpty((CharSequence)dto.getProductCategoryCode()) && StringUtils.isEmpty((CharSequence)dto.getProductBrandCode()) && StringUtils.isEmpty((CharSequence)dto.getProductItemName()) && StringUtils.isEmpty((CharSequence)dto.getUnitCode()) && StringUtils.isEmpty((CharSequence)dto.getCustomerCode()) && CollectionUtils.isEmpty((Collection)dto.getCustomerCodeList()) && StringUtils.isEmpty((CharSequence)dto.getErpCode()) && StringUtils.isEmpty((CharSequence)dto.getSalesInstitutionCode()) && StringUtils.isEmpty((CharSequence)dto.getSalesOrgRegionCode()) && StringUtils.isEmpty((CharSequence)dto.getSalesOrgProvinceCode()) && StringUtils.isEmpty((CharSequence)dto.getSalesInstitutionErpCode())) {
            return Lists.newArrayList();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(UuidFlagOpEntity::getEnableStatus, (Object)EnableStatusEnum.ENABLE.getCode())).eq(StringUtils.isNotEmpty((CharSequence)dto.getYearMonthLy()), SalesPlanEntity::getYearMonthLy, (Object)dto.getYearMonthLy())).ge(StringUtils.isNotEmpty((CharSequence)dto.getYearMonthLyBegin()), SalesPlanEntity::getYearMonthLy, (Object)dto.getYearMonthLyBegin())).le(StringUtils.isNotEmpty((CharSequence)dto.getYearMonthLyEnd()), SalesPlanEntity::getYearMonthLy, (Object)dto.getYearMonthLyEnd())).eq(StringUtils.isNotEmpty((CharSequence)dto.getProductCode()), SalesPlanEntity::getProductCode, (Object)dto.getProductCode())).eq(StringUtils.isNotEmpty((CharSequence)dto.getProductBrandCode()), SalesPlanEntity::getProductBrandCode, (Object)dto.getProductBrandCode())).eq(StringUtils.isNotEmpty((CharSequence)dto.getProductCategoryCode()), SalesPlanEntity::getProductCategoryCode, (Object)dto.getProductCategoryCode())).eq(StringUtils.isNotEmpty((CharSequence)dto.getProductItemCode()), SalesPlanEntity::getProductItemCode, (Object)dto.getProductItemCode())).eq(StringUtils.isNotEmpty((CharSequence)dto.getProductItemName()), SalesPlanEntity::getProductItemName, (Object)dto.getProductItemName())).eq(StringUtils.isNotEmpty((CharSequence)dto.getUnitCode()), SalesPlanEntity::getUnitCode, (Object)dto.getUnitCode())).eq(StringUtils.isNotEmpty((CharSequence)dto.getCustomerCode()), SalesPlanEntity::getCustomerCode, (Object)dto.getCustomerCode())).eq(StringUtils.isNotEmpty((CharSequence)dto.getErpCode()), SalesPlanEntity::getErpCode, (Object)dto.getErpCode())).in(!CollectionUtils.isEmpty((Collection)dto.getCustomerCodeList()), SalesPlanEntity::getCustomerCode, (Collection)dto.getCustomerCodeList())).eq(StringUtils.isNotEmpty((CharSequence)dto.getSalesInstitutionCode()), SalesPlanEntity::getSalesInstitutionCode, (Object)dto.getSalesInstitutionCode())).eq(StringUtils.isNotEmpty((CharSequence)dto.getSalesOrgRegionCode()), SalesPlanEntity::getSalesOrgRegionCode, (Object)dto.getSalesOrgRegionCode())).eq(StringUtils.isNotEmpty((CharSequence)dto.getSalesInstitutionErpCode()), SalesPlanEntity::getSalesInstitutionErpCode, (Object)dto.getSalesInstitutionErpCode())).eq(StringUtils.isNotEmpty((CharSequence)dto.getSalesOrgProvinceCode()), SalesPlanEntity::getSalesOrgProvinceCode, (Object)dto.getSalesOrgProvinceCode())).eq(StringUtils.isNotEmpty((CharSequence)dto.getBusinessUnitCode()), SalesPlanEntity::getBusinessUnitCode, (Object)dto.getBusinessUnitCode())).eq(StringUtils.isNotEmpty((CharSequence)dto.getTerminalCode()), SalesPlanEntity::getTerminalCode, (Object)dto.getTerminalCode())).in(CollectionUtils.isNotEmpty((Collection)dto.getTerminalCodes()), SalesPlanEntity::getTerminalCode, (Collection)dto.getTerminalCodes())).in(CollectionUtils.isNotEmpty((Collection)dto.getSalesProductCodeList()), SalesPlanEntity::getProductCode, (Collection)dto.getSalesProductCodeList())).eq(StringUtils.isNotEmpty((CharSequence)dto.getCustomerRetailerCode()), SalesPlanEntity::getCustomerRetailerCode, (Object)dto.getCustomerRetailerCode())).in(CollectionUtils.isNotEmpty((Collection)dto.getRegionCodes()), SalesPlanEntity::getRegionCode, (Collection)dto.getRegionCodes())).eq(StringUtils.isNotEmpty((CharSequence)dto.getSpecialDataStatus()), SalesPlanEntity::getSpecialDataStatus, (Object)dto.getSpecialDataStatus())).eq(StringUtils.isNotBlank((CharSequence)dto.getBusinessFormatCode()), SalesPlanEntity::getBusinessFormatCode, (Object)dto.getBusinessFormatCode())).eq(StringUtils.isNotBlank((CharSequence)dto.getOrgCode()), SalesPlanEntity::getOrgCode, (Object)dto.getOrgCode())).list();
    }

    public List<SalesPlanEntity> findByOrderNos(List<String> orderNoList) {
        if (CollectionUtils.isEmpty(orderNoList)) {
            return null;
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(SalesPlanEntity::getOrderNo, orderNoList)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public List<SalesPlanEntity> getMaxVersionSalesPlan(List<List<String>> onlyKeys, String tenantCode) {
        return ((SalesPlanMapper)this.baseMapper).getMaxVersionSalesPlan(onlyKeys, tenantCode);
    }

    public List<SalesPlanEntity> getSalesPlanByIds(List<List<String>> idList, String tenantCode) {
        return ((SalesPlanMapper)this.baseMapper).getSalesPlanByIds(idList, tenantCode);
    }

    public List<SalesPlanEntity> summaryRecoveryAmountCus(SalesPlanSummaryDto dto, String tenantCode) {
        return ((SalesPlanMapper)this.baseMapper).summaryRecoveryAmountCus(dto, tenantCode);
    }

    public List<SalesPlanEntity> summaryRecoveryAmountCusAndPro(SalesPlanSummaryDto dto, String tenantCode) {
        return ((SalesPlanMapper)this.baseMapper).summaryRecoveryAmountCusAndPro(dto, tenantCode);
    }

    public List<SalesPlanEntity> summaryRecoveryAmountPro(SalesPlanSummaryDto dto, String tenantCode) {
        return ((SalesPlanMapper)this.baseMapper).summaryRecoveryAmountPro(dto, tenantCode);
    }

    public List<SalesPlanEntity> uniqueness(SalesPlanDto dto) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(StrUtil.isNotBlank((CharSequence)dto.getVersionNumber()), SalesPlanEntity::getVersionNumber, (Object)dto.getVersionNumber())).eq(StrUtil.isNotBlank((CharSequence)dto.getBusinessFormatCode()), SalesPlanEntity::getBusinessFormatCode, (Object)dto.getBusinessFormatCode())).eq(StrUtil.isNotBlank((CharSequence)dto.getBusinessUnitCode()), SalesPlanEntity::getBusinessUnitCode, (Object)dto.getBusinessUnitCode())).eq(StrUtil.isNotBlank((CharSequence)dto.getYearMonthLy()), SalesPlanEntity::getYearMonthLy, (Object)dto.getYearMonthLy())).eq(StrUtil.isNotBlank((CharSequence)dto.getGroupCode()), SalesPlanEntity::getGroupCode, (Object)dto.getGroupCode())).eq(StrUtil.isNotBlank((CharSequence)dto.getSalesOrgCode()), SalesPlanEntity::getSalesOrgCode, (Object)dto.getSalesOrgCode())).eq(StrUtil.isNotBlank((CharSequence)dto.getSalesOrgName()), SalesPlanEntity::getSalesOrgName, (Object)dto.getSalesOrgName())).eq(StrUtil.isNotBlank((CharSequence)dto.getSalesInstitutionCode()), SalesPlanEntity::getSalesInstitutionCode, (Object)dto.getSalesInstitutionCode())).eq(StrUtil.isNotBlank((CharSequence)dto.getSalesInstitutionName()), SalesPlanEntity::getSalesInstitutionName, (Object)dto.getSalesInstitutionName())).eq(StrUtil.isNotBlank((CharSequence)dto.getSalesOrgRegionCode()), SalesPlanEntity::getSalesOrgRegionCode, (Object)dto.getSalesOrgRegionCode())).eq(StrUtil.isNotBlank((CharSequence)dto.getSalesOrgRegionName()), SalesPlanEntity::getSalesOrgRegionName, (Object)dto.getSalesOrgRegionName())).eq(StrUtil.isNotBlank((CharSequence)dto.getSalesOrgProvinceCode()), SalesPlanEntity::getSalesOrgProvinceCode, (Object)dto.getSalesOrgProvinceCode())).eq(StrUtil.isNotBlank((CharSequence)dto.getSalesOrgProvinceName()), SalesPlanEntity::getSalesOrgProvinceName, (Object)dto.getSalesOrgProvinceName())).eq(StrUtil.isNotBlank((CharSequence)dto.getCustomerCode()), SalesPlanEntity::getCustomerCode, (Object)dto.getCustomerCode())).eq(StrUtil.isNotBlank((CharSequence)dto.getCustomerName()), SalesPlanEntity::getCustomerName, (Object)dto.getCustomerName())).eq(StrUtil.isNotBlank((CharSequence)dto.getTerminalCode()), SalesPlanEntity::getTerminalCode, (Object)dto.getTerminalCode())).eq(StrUtil.isNotBlank((CharSequence)dto.getTerminalName()), SalesPlanEntity::getTerminalName, (Object)dto.getTerminalName())).eq(StrUtil.isNotBlank((CharSequence)dto.getCustomerChannelCode()), SalesPlanEntity::getCustomerChannelCode, (Object)dto.getCustomerChannelCode())).eq(StrUtil.isNotBlank((CharSequence)dto.getCustomerChannelName()), SalesPlanEntity::getCustomerChannelName, (Object)dto.getCustomerChannelName())).eq(StrUtil.isNotBlank((CharSequence)dto.getCustomerChannelLevelCode()), SalesPlanEntity::getCustomerChannelLevelCode, (Object)dto.getCustomerChannelLevelCode())).eq(StrUtil.isNotBlank((CharSequence)dto.getTerminalChannelCode()), SalesPlanEntity::getTerminalChannelCode, (Object)dto.getTerminalChannelCode())).eq(StrUtil.isNotBlank((CharSequence)dto.getTerminalChannelName()), SalesPlanEntity::getTerminalChannelName, (Object)dto.getTerminalChannelName())).eq(StrUtil.isNotBlank((CharSequence)dto.getTerminalChannelLevelCode()), SalesPlanEntity::getTerminalChannelLevelCode, (Object)dto.getTerminalChannelLevelCode())).eq(StrUtil.isNotBlank((CharSequence)dto.getProductCode()), SalesPlanEntity::getProductCode, (Object)dto.getProductCode())).eq(StrUtil.isNotBlank((CharSequence)dto.getProductName()), SalesPlanEntity::getProductName, (Object)dto.getProductName())).eq(StrUtil.isNotBlank((CharSequence)dto.getUnitCode()), SalesPlanEntity::getUnitCode, (Object)dto.getUnitCode())).eq(StrUtil.isNotBlank((CharSequence)dto.getUnitName()), SalesPlanEntity::getUnitName, (Object)dto.getUnitName())).eq(StrUtil.isNotBlank((CharSequence)dto.getProductBrandCode()), SalesPlanEntity::getProductBrandCode, (Object)dto.getProductBrandCode())).eq(StrUtil.isNotBlank((CharSequence)dto.getProductBrandName()), SalesPlanEntity::getProductBrandName, (Object)dto.getProductBrandName())).eq(StrUtil.isNotBlank((CharSequence)dto.getProductCategoryCode()), SalesPlanEntity::getProductCategoryCode, (Object)dto.getProductCategoryCode())).eq(StrUtil.isNotBlank((CharSequence)dto.getProductCategoryName()), SalesPlanEntity::getProductCategoryName, (Object)dto.getProductCategoryName())).eq(StrUtil.isNotBlank((CharSequence)dto.getProductItemCode()), SalesPlanEntity::getProductItemCode, (Object)dto.getProductItemCode())).eq(StrUtil.isNotBlank((CharSequence)dto.getProductItemName()), SalesPlanEntity::getProductItemName, (Object)dto.getProductItemName())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public Page<SalesPlanEntity> findSalesPlanByConditions(Page<SalesPlanEntity> page, SalesPlanReCalPlanAndReplyDto planDto) {
        return this.salesPlanMapper.findSalesPlanByConditions(page, planDto);
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean saveBatch(Collection<SalesPlanEntity> entityList) {
        return this.saveBatch(entityList, 1000);
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean saveBatch(Collection<SalesPlanEntity> entityList, int batchSize) {
        if (CollectionUtils.isEmpty(entityList)) {
            return true;
        }
        AbstractCrmUserIdentity context = this.loginUserService.getAbstractLoginUser();
        Date curDate = new Date();
        String account = context != null && StringUtils.isNotBlank((CharSequence)context.getAccount()) ? context.getAccount() : "admin";
        String name = context != null && StringUtils.isNotBlank((CharSequence)context.getRealName()) ? context.getRealName() : "\u7cfb\u7edf\u7528\u6237\u6216\u7cfb\u7edf\u5b9a\u65f6\u4efb\u52a1";
        List partition = Lists.partition((List)Lists.newArrayList(entityList), (int)batchSize);
        for (List partitionList : partition) {
            for (SalesPlanEntity salesPlanEntity : partitionList) {
                salesPlanEntity.setCreateTime(curDate);
                salesPlanEntity.setCreateName(name);
                salesPlanEntity.setCreateAccount(account);
                salesPlanEntity.setModifyTime(curDate);
                salesPlanEntity.setModifyName(name);
                salesPlanEntity.setModifyAccount(account);
                salesPlanEntity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                salesPlanEntity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                salesPlanEntity.setTenantCode(TenantUtils.getTenantCode());
            }
            this.salesPlanMapper.saveBatch(partitionList);
        }
        return true;
    }

    public List<SalesPlanVo> sumReplayReimburse(SalesPlanDto dto) {
        return this.salesPlanMapper.sumReplayReimburse(dto);
    }

    public List<SalesPlanVo> sumReplayRestore(SalesPlanDto dto) {
        return this.salesPlanMapper.sumReplayRestore(dto);
    }

    public List<SalesPlanVo> sumReplayPlan(SalesPlanDto dto) {
        return this.salesPlanMapper.sumReplayPlan(dto);
    }

    public void updateDelStatus(List<String> ids, String delFlag) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().set(UuidFlagOpEntity::getDelFlag, (Object)delFlag)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(UuidEntity::getId, ids)).update();
    }
}

