/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.sales.plan.local.service.internal;

import com.biz.crm.business.common.sdk.dto.UuidDto;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.tpm.business.sales.plan.local.entity.SalesPlanEntity;
import com.biz.crm.tpm.business.sales.plan.local.service.MainPlanAndReplyLogService;
import com.biz.crm.tpm.business.sales.plan.sdk.dto.SalesPlanDto;
import com.biz.crm.tpm.business.sales.plan.sdk.dto.SalesPlanLogEventDto;
import com.biz.crm.tpm.business.sales.plan.sdk.event.SalesPlanLogEventListener;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import liquibase.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service(value="mainPlanAndReplyLogService")
public class MainPlanAndReplyLogServiceImpl
implements MainPlanAndReplyLogService {
    private static final Logger log = LoggerFactory.getLogger(MainPlanAndReplyLogServiceImpl.class);
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private LoginUserService loginUserService;

    @Override
    @Async(value="logThread")
    public void editLogAsync(List<SalesPlanEntity> planList, Map<String, SalesPlanEntity> oldMap, AbstractCrmUserIdentity loginDetails) {
        this.loginUserService.refreshAuthentication((Object)loginDetails);
        SerializableBiConsumer & Serializable onCreate = SalesPlanLogEventListener::onCreate;
        SerializableBiConsumer & Serializable onUpdate = SalesPlanLogEventListener::onUpdate;
        Map<String, SalesPlanDto> newMap = this.nebulaToolkitService.copyCollectionByWhiteList(planList, SalesPlanEntity.class, SalesPlanDto.class, HashSet.class, ArrayList.class, new String[0]).stream().filter(k -> StringUtil.isNotEmpty((String)k.getId())).collect(Collectors.toMap(UuidDto::getId, v -> v, (newValue, oldValue) -> newValue));
        Map<String, SalesPlanDto> oldDtoMap = this.nebulaToolkitService.copyCollectionByWhiteList(oldMap.values(), SalesPlanEntity.class, SalesPlanDto.class, HashSet.class, ArrayList.class, new String[0]).stream().filter(k -> StringUtil.isNotEmpty((String)k.getId())).collect(Collectors.toMap(UuidDto::getId, v -> v, (newValue, oldValue) -> newValue));
        for (SalesPlanEntity entity : planList) {
            SalesPlanDto dto = newMap.getOrDefault(entity.getId(), new SalesPlanDto());
            SalesPlanLogEventDto logEventDto = new SalesPlanLogEventDto();
            if (oldMap.containsKey(dto.getId())) {
                logEventDto.setOriginal(oldDtoMap.getOrDefault(dto.getId(), new SalesPlanDto()));
                logEventDto.setNewest(dto);
                this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, SalesPlanLogEventListener.class, (SerializableBiConsumer)onUpdate);
                continue;
            }
            logEventDto.setOriginal(null);
            logEventDto.setNewest(dto);
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, SalesPlanLogEventListener.class, (SerializableBiConsumer)onCreate);
        }
    }
}

