/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.sales.plan.local.service.internal;

import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.sdk.dto.UuidDto;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerOrgChannelStoresVo;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.third.system.ecrm.sdk.dto.MainPlanAndReplyDto;
import com.biz.crm.mn.third.system.ecrm.sdk.dto.MainPlanAndReplyItemDto;
import com.biz.crm.mn.third.system.ecrm.sdk.service.MainPlanAndReplyService;
import com.biz.crm.tpm.business.sales.plan.local.entity.SalesPlanEntity;
import com.biz.crm.tpm.business.sales.plan.local.service.MainPlanAndReplyLogService;
import com.biz.crm.tpm.business.sales.plan.local.service.SalesPlanEntityService;
import com.biz.crm.tpm.business.sales.plan.sdk.dto.SalesPlanDto;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="mainPlanAndReplyService")
public class MainPlanAndReplyServiceImpl
implements MainPlanAndReplyService {
    private static final Logger log = LoggerFactory.getLogger(MainPlanAndReplyServiceImpl.class);
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private RedisLockService redisLockService;
    @Autowired(required=false)
    private SalesPlanEntityService salesPlanEntityService;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired(required=false)
    private SalesOrgVoService salesOrgVoService;
    @Autowired(required=false)
    private CustomerVoService customerVoService;
    @Autowired(required=false)
    private ProductVoService productVoService;
    @Autowired(required=false)
    private MainPlanAndReplyLogService mainPlanAndReplyLogService;
    @Autowired(required=false)
    private LoginUserService loginUserService;

    public void mainPlanAndReplySync(MainPlanAndReplyDto dto) {
        Validate.notNull((Object)dto, (String)"\u6570\u636e\u5bf9\u8c61\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notEmpty((Collection)dto.getItemList(), (String)"\u660e\u7ec6\u5217\u8868[itemList]\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        String cusChannelCode = "20";
        List sliceList = Lists.partition((List)dto.getItemList(), (int)2000);
        for (List itemDtos : sliceList) {
            HashSet<String> noSet = new HashSet<String>();
            HashSet<String> sapCodes = new HashSet<String>();
            ArrayList<MainPlanAndReplyItemDto> curList = new ArrayList<MainPlanAndReplyItemDto>();
            for (MainPlanAndReplyItemDto item : itemDtos) {
                item.setProductCode(item.getProductCode().trim());
                try {
                    this.createValidate(item);
                }
                catch (Exception e) {
                    log.error("\u540c\u6b65\u6570\u636e\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
                    continue;
                }
                item.setCustomerChannelCode(cusChannelCode);
                noSet.add(item.getOnlyKey());
                sapCodes.add(cusChannelCode + item.getBusinessFormatCode() + item.getSalesInstitutionCode());
                if (StringUtils.isNotBlank((CharSequence)item.getSalesOrgRegionCode())) {
                    sapCodes.add(cusChannelCode + item.getBusinessFormatCode() + item.getSalesInstitutionCode() + item.getSalesOrgRegionCode());
                    if (StringUtils.isNotBlank((CharSequence)item.getSalesOrgProvinceCode())) {
                        sapCodes.add(cusChannelCode + item.getBusinessFormatCode() + item.getSalesInstitutionCode() + item.getSalesOrgRegionCode() + item.getSalesOrgProvinceCode());
                    }
                }
                curList.add(item);
            }
            if (CollectionUtils.isEmpty(curList)) {
                return;
            }
            Map salesMap = this.salesOrgVoService.getSalesMapByTpmCodes(new ArrayList(sapCodes));
            HashSet<String> cusCodes = new HashSet<String>();
            ArrayList<MainPlanAndReplyItemDto> itemList1 = new ArrayList<MainPlanAndReplyItemDto>();
            for (MainPlanAndReplyItemDto item : curList) {
                this.validateSalesOrg(item, salesMap, itemList1);
                item.setCustomerChannelCode(cusChannelCode);
                String cusCode = item.getCustomerCode() + item.getSalesInstitutionCodeSap() + cusChannelCode + item.getBusinessFormatCode();
                cusCodes.add(cusCode);
            }
            if (CollectionUtils.isEmpty(itemList1)) {
                return;
            }
            sapCodes.clear();
            salesMap.clear();
            ArrayList<SalesPlanDto> dtoList = new ArrayList<SalesPlanDto>();
            List cusList = Lists.partition(new ArrayList(cusCodes), (int)500);
            Map cusMap = this.customerVoService.getCustomerByCodes(cusList);
            HashSet<Object> onlyKeySet = new HashSet<Object>();
            for (MainPlanAndReplyItemDto item : itemList1) {
                String cusCode = item.getCustomerCode() + item.getSalesInstitutionCodeSap() + item.getCustomerChannelCode() + item.getBusinessFormatCode();
                if (!cusMap.containsKey(cusCode)) {
                    log.error("\u5728TPM\u4e2d\uff0c\u5ba2\u6237\u7f16\u7801{}\u672a\u627e\u5230\u5ba2\u6237\u4fe1\u606f", (Object)item.getCustomerCode());
                    continue;
                }
                CustomerOrgChannelStoresVo storesVo = (CustomerOrgChannelStoresVo)cusMap.get(cusCode);
                item.setCustomerCode(cusCode);
                item.setSalesOrgRegionCode(storesVo.getSalesRegionCode());
                item.setSalesOrgRegionName(storesVo.getSalesRegionName());
                item.setSalesOrgProvinceCode(storesVo.getSalesOrgCode());
                item.setSalesOrgProvinceName(storesVo.getSalesOrgName());
                item.setCustomerChannelName(storesVo.getChannelName());
                SalesPlanDto planDto = (SalesPlanDto)this.nebulaToolkitService.copyObjectByBlankList((Object)item, SalesPlanDto.class, null, null, new String[0]);
                planDto.setSalesInstitutionErpCode(item.getSalesInstitutionCodeSap());
                planDto.setSalesOrgProvinceErpCode(item.getSalesOrgProvinceCodeSap());
                planDto.setSalesOrgRegionErpCode(item.getSalesOrgRegionCodeSap());
                planDto.setSalesOrgCode(item.getSalesOrgRegionCode());
                planDto.setSalesOrgName(item.getSalesOrgRegionName());
                String onlyKey = item.getBusinessFormatCode() + item.getBusinessUnitCode() + item.getYearMonthLy() + item.getCustomerCode() + item.getProductCode() + item.getUnitCode();
                onlyKeySet.add(onlyKey);
                planDto.setOnlyKey(onlyKey);
                dtoList.add(planDto);
            }
            if (CollectionUtils.isEmpty(dtoList)) {
                return;
            }
            cusCodes.clear();
            cusMap.clear();
            String version = DateUtil.getDataString((SimpleDateFormat)DateUtil.date_yyyyMMdd);
            List onlyKeys = Lists.partition(new ArrayList(onlyKeySet), (int)500);
            List<SalesPlanEntity> entities = this.salesPlanEntityService.getMaxVersionSalesPlan(onlyKeys);
            Map<Object, Object> planEntityMap = new HashMap();
            if (!CollectionUtils.isEmpty(entities)) {
                planEntityMap = entities.stream().collect(Collectors.toMap(SalesPlanEntity::getOnlyKey, Function.identity()));
            }
            ArrayList<SalesPlanDto> newList = new ArrayList<SalesPlanDto>();
            for (SalesPlanDto planDto : dtoList) {
                if (!planEntityMap.containsKey(planDto.getOnlyKey())) {
                    planDto.setVersionNumber(version);
                    newList.add(planDto);
                    continue;
                }
                SalesPlanEntity entity = (SalesPlanEntity)((Object)planEntityMap.get(planDto.getOnlyKey()));
                planDto.setId(entity.getId());
                planDto.setVersionNumber(version);
                newList.add(planDto);
            }
            entities.clear();
            planEntityMap.clear();
            boolean hasLock = false;
            try {
                hasLock = this.redisLockService.batchLock("month_plan_lock:lock:ecrm:", new ArrayList(noSet), TimeUnit.SECONDS, 10);
                if (!hasLock) {
                    throw new RuntimeException("\u4e3b\u4f53\u8ba1\u5212\u91cf\u548c\u56de\u590d\u91cf\u6570\u636e\u6b63\u5728\u5f55\u5165\u4e2d,\u8bf7\u52ff\u91cd\u590d\u63a8\u9001");
                }
                this.saveBatchAndLog(newList);
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
                throw e;
            }
            finally {
                if (!hasLock) continue;
                this.redisLockService.batchUnLock("month_plan_lock:lock:ecrm:", new ArrayList(noSet));
            }
        }
    }

    private void createValidate(MainPlanAndReplyItemDto itemDto) {
        Validate.notBlank((CharSequence)itemDto.getBusinessFormatCode(), (String)"\u4e1a\u6001\u7f16\u7801[businessFormatCode]\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)itemDto.getBusinessFormatName(), (String)"\u4e1a\u6001\u540d\u79f0[businessFormatName]\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        if (StringUtils.isNotBlank((CharSequence)itemDto.getBusinessUnitCode())) {
            itemDto.setBusinessUnitCode(BusinessUnitEnum.descToEnum((String)itemDto.getBusinessUnitCode()).getCode());
        } else {
            itemDto.setBusinessUnitCode(BusinessUnitEnum.HEADQUARTERS.getCode());
        }
        Validate.notBlank((CharSequence)itemDto.getYearMonthLy(), (String)"\u5e74\u6708[yearMonthLy]\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        try {
            itemDto.setYearMonthLy(DateUtil.formatDate((Date)DateUtil.date_yyyyMM.parse(itemDto.getYearMonthLy()), (String)"yyyy-MM"));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("\u5e74\u6708\u683c\u5f0f\u9519\u8bef");
        }
        Validate.notBlank((CharSequence)itemDto.getSalesInstitutionCode(), (String)"\u9500\u552e\u673a\u6784\u7f16\u7801[salesInstitutionCode]\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)itemDto.getSalesInstitutionName(), (String)"\u9500\u552e\u673a\u6784\u540d\u79f0[salesInstitutionName]\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        if (StringUtils.isNotBlank((CharSequence)itemDto.getSalesOrgProvinceCode())) {
            Validate.notBlank((CharSequence)itemDto.getSalesOrgProvinceName(), (String)"\u9500\u552e\u7ec4\u7ec7\u540d\u79f0\uff08\u7701\u533a\uff09[salesOrgProvinceName]\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)itemDto.getSalesOrgRegionCode(), (String)"\u9500\u552e\u7ec4\u7ec7\u7f16\u7801\uff08\u5927\u533a\uff09[salesOrgRegionCode]\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)itemDto.getSalesOrgRegionName(), (String)"\u9500\u552e\u7ec4\u7ec7\u540d\u79f0\uff08\u5927\u533a\uff09[salesOrgRegionName]\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        }
        Validate.notBlank((CharSequence)itemDto.getCustomerCode(), (String)"\u5ba2\u6237\u7f16\u7801[customerCode]\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)itemDto.getCustomerName(), (String)"\u5ba2\u6237\u540d\u79f0[customerName]\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)itemDto.getProductCode(), (String)"\u4ea7\u54c1\u7f16\u7801[productCode]\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)itemDto.getProductName(), (String)"\u4ea7\u54c1\u540d\u79f0[productName]\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)itemDto.getUnitCode(), (String)"\u5355\u4f4d\u7f16\u7801[unitCode]\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)itemDto.getUnitName(), (String)"\u5355\u4f4d\u540d\u79f0[unitName]\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)itemDto.getPrice(), (String)"\u5355\u4ef7[price]\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)itemDto.getPlanAmount(), (String)"\u8ba1\u5212\u91cf[planQuantity]\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)itemDto.getPlanAmount(), (String)"\u8ba1\u5212\u91cf[planQuantity]\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)itemDto.getRestoreQuantity(), (String)"\u56de\u590d\u6570\u91cf[restoreQuantity]\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)itemDto.getRestoreAmount(), (String)"\u56de\u590d\u91d1\u989d[restoreAmount]\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        String onlyKey = itemDto.getBusinessFormatCode() + itemDto.getBusinessUnitCode() + itemDto.getYearMonthLy() + itemDto.getSalesInstitutionCode() + itemDto.getCustomerCode() + itemDto.getProductCode() + itemDto.getUnitCode();
        itemDto.setOnlyKey(onlyKey);
    }

    private void validateSalesOrg(MainPlanAndReplyItemDto itemDto, Map<String, SalesOrgVo> salesMap, List<MainPlanAndReplyItemDto> itemList) {
        if (StringUtils.isNotBlank((CharSequence)itemDto.getSalesOrgProvinceCode())) {
            String key2;
            SalesOrgVo vo2;
            String key1 = itemDto.getCustomerChannelCode() + itemDto.getBusinessFormatCode() + itemDto.getSalesInstitutionCode() + itemDto.getSalesOrgRegionCode() + itemDto.getSalesOrgProvinceCode();
            SalesOrgVo vo1 = salesMap.getOrDefault(key1, null);
            if (Objects.isNull(vo1)) {
                log.error("\u5728TPM\u4e2d\uff0c\u6b64\u9500\u552e\u7ec4\u7ec7\u7f16\u7801\uff08\u7701\u533a\uff09[{}}]\u672a\u67e5\u627e\u5230\u6570\u636e", (Object)itemDto.getSalesOrgProvinceCode());
                return;
            }
            itemDto.setSalesOrgProvinceCode(vo1.getSalesOrgCode());
            itemDto.setSalesOrgProvinceName(vo1.getSalesOrgName());
            itemDto.setSalesOrgProvinceCodeSap(vo1.getErpCode());
            if (StringUtils.isBlank((CharSequence)itemDto.getBusinessUnitCode())) {
                itemDto.setBusinessUnitCode(vo1.getBusinessUnitCode());
            }
            if (Objects.isNull(vo2 = (SalesOrgVo)salesMap.getOrDefault(key2 = itemDto.getCustomerChannelCode() + itemDto.getBusinessFormatCode() + itemDto.getSalesInstitutionCode() + itemDto.getSalesOrgRegionCode(), null))) {
                log.error("\u5728TPM\u4e2d\uff0c\u6b64\u9500\u552e\u7ec4\u7ec7\u7f16\u7801\uff08\u5927\u533a\uff09[{}]\u672a\u67e5\u627e\u5230\u6570\u636e", (Object)itemDto.getSalesOrgRegionCode());
                return;
            }
            if (StringUtils.isBlank((CharSequence)vo2.getErpCode()) || !vo2.getErpCode().equals(vo1.getParentErpCode())) {
                log.error("\u5728TPM\u4e2d\uff0c[{}]\u4e0d\u662f[{}]\u7684\u4e0a\u7ea7\u7ec4\u7ec7", (Object)itemDto.getSalesOrgRegionCode(), (Object)itemDto.getSalesOrgProvinceCode());
                return;
            }
            itemDto.setSalesOrgRegionCode(vo2.getSalesOrgCode());
            itemDto.setSalesOrgRegionName(vo2.getSalesOrgName());
            itemDto.setSalesOrgRegionCodeSap(vo2.getErpCode());
            String key3 = itemDto.getCustomerChannelCode() + itemDto.getBusinessFormatCode() + itemDto.getSalesInstitutionCode();
            SalesOrgVo vo3 = salesMap.getOrDefault(key3, null);
            if (Objects.isNull(vo3)) {
                log.error("\u5728TPM\u4e2d\uff0c\u6b64\u9500\u552e\u673a\u6784\u7f16\u7801[{}]\u672a\u67e5\u627e\u5230\u6570\u636e", (Object)itemDto.getSalesInstitutionCode());
                return;
            }
            if (StringUtils.isBlank((CharSequence)vo3.getErpCode()) || !vo3.getErpCode().equals(vo2.getParentErpCode())) {
                log.error("\u5728TPM\u4e2d\uff0c[{}]\u4e0d\u662f[{}]\u7684\u4e0a\u7ea7\u7ec4\u7ec7", (Object)itemDto.getSalesInstitutionCode(), (Object)itemDto.getSalesOrgRegionCode());
                return;
            }
            itemDto.setSalesInstitutionCode(vo3.getSalesOrgCode());
            itemDto.setSalesInstitutionName(vo3.getSalesOrgName());
            itemDto.setSalesInstitutionCodeSap(vo3.getErpCode());
        } else if (StringUtils.isNotBlank((CharSequence)itemDto.getSalesOrgRegionCode())) {
            String key3;
            SalesOrgVo vo3;
            String key2 = itemDto.getCustomerChannelCode() + itemDto.getBusinessFormatCode() + itemDto.getSalesInstitutionCode() + itemDto.getSalesOrgRegionCode();
            SalesOrgVo vo2 = salesMap.getOrDefault(key2, null);
            if (Objects.isNull(vo2)) {
                log.error("\u5728TPM\u4e2d\uff0c\u6b64\u9500\u552e\u7ec4\u7ec7\u7f16\u7801\uff08\u5927\u533a\uff09[{}]\u672a\u67e5\u627e\u5230\u6570\u636e", (Object)itemDto.getSalesOrgRegionCode());
                return;
            }
            itemDto.setSalesOrgRegionCode(vo2.getSalesOrgCode());
            itemDto.setSalesOrgRegionName(vo2.getSalesOrgName());
            itemDto.setSalesOrgRegionCodeSap(vo2.getErpCode());
            if (StringUtils.isBlank((CharSequence)itemDto.getBusinessUnitCode())) {
                itemDto.setBusinessUnitCode(vo2.getBusinessUnitCode());
            }
            if (Objects.isNull(vo3 = (SalesOrgVo)salesMap.getOrDefault(key3 = itemDto.getCustomerChannelCode() + itemDto.getBusinessFormatCode() + itemDto.getSalesInstitutionCode(), null))) {
                log.error("\u5728TPM\u4e2d\uff0c\u6b64\u9500\u552e\u673a\u6784\u7f16\u7801[{}]\u672a\u67e5\u627e\u5230\u6570\u636e", (Object)itemDto.getSalesInstitutionCode());
                return;
            }
            if (StringUtils.isBlank((CharSequence)vo3.getErpCode()) || !vo3.getErpCode().equals(vo2.getParentErpCode())) {
                log.error("\u5728TPM\u4e2d\uff0c[{}]\u4e0d\u662f[{}]\u7684\u4e0a\u7ea7\u7ec4\u7ec7", (Object)itemDto.getSalesInstitutionCode(), (Object)itemDto.getSalesOrgRegionCode());
                return;
            }
            itemDto.setSalesInstitutionCode(vo3.getSalesOrgCode());
            itemDto.setSalesInstitutionName(vo3.getSalesOrgName());
            itemDto.setSalesInstitutionCodeSap(vo3.getErpCode());
        } else if (StringUtils.isNotBlank((CharSequence)itemDto.getSalesInstitutionCode())) {
            String key3 = itemDto.getCustomerChannelCode() + itemDto.getBusinessFormatCode() + itemDto.getSalesInstitutionCode();
            SalesOrgVo vo3 = salesMap.getOrDefault(key3, null);
            if (Objects.isNull(vo3)) {
                log.error("\u5728TPM\u4e2d\uff0c\u6b64\u9500\u552e\u673a\u6784\u7f16\u7801[{}]\u672a\u67e5\u627e\u5230\u6570\u636e", (Object)itemDto.getSalesInstitutionCode());
                return;
            }
            itemDto.setSalesInstitutionCode(vo3.getSalesOrgCode());
            itemDto.setSalesInstitutionName(vo3.getSalesOrgName());
            itemDto.setSalesInstitutionCodeSap(vo3.getErpCode());
            if (StringUtils.isBlank((CharSequence)itemDto.getBusinessUnitCode())) {
                itemDto.setBusinessUnitCode(vo3.getBusinessUnitCode());
            }
        } else {
            log.error("\u9500\u552e\u7ec4\u7ec7\u6570\u636e\u5f02\u5e38");
            return;
        }
        itemList.add(itemDto);
    }

    public void saveBatchAndLog(List<SalesPlanDto> list) {
        List<SalesPlanEntity> planList;
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        ArrayList<SalesPlanDto> updateList = new ArrayList<SalesPlanDto>();
        ArrayList<SalesPlanDto> addList = new ArrayList<SalesPlanDto>();
        for (SalesPlanDto planDto : list) {
            if (StringUtils.isNotBlank((CharSequence)planDto.getId())) {
                updateList.add(planDto);
                continue;
            }
            addList.add(planDto);
        }
        List<Object> oldList = new ArrayList();
        if (CollectionUtils.isNotEmpty(updateList)) {
            List ids = updateList.stream().map(UuidDto::getId).collect(Collectors.toList());
            List idList = Lists.partition(ids, (int)1200);
            oldList = this.salesPlanEntityService.getSalesPlanByIds(idList);
        }
        if (CollectionUtils.isEmpty(planList = this.salesPlanEntityService.saveThirdSystemBatch(addList, updateList))) {
            return;
        }
        HashMap<String, SalesPlanEntity> oldMap = new HashMap();
        if (CollectionUtils.isNotEmpty(oldList)) {
            oldMap = oldList.stream().collect(Collectors.toMap(UuidEntity::getId, Function.identity()));
        }
        log.info("\u4e3b\u4f53\u8ba1\u5212\u91cf\u56de\u590d\u91cf\u5f02\u6b65\u4fdd\u5b58\u65e5\u5fd7=====================\u300b");
        AbstractCrmUserIdentity loginDetails = this.loginUserService.getAbstractLoginUser();
        this.mainPlanAndReplyLogService.editLogAsync(planList, oldMap, loginDetails);
        log.info("\u4e3b\u4f53\u8ba1\u5212\u91cf\u56de\u590d\u91cf\u5f02\u6b65\u66f4\u65b0\u8ba1\u7b97\u6298\u6263\u91d1\u989d=====================\u300b");
        this.salesPlanEntityService.syncCalDiscount(planList);
    }
}

