/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.sales.plan.local.service.internal;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.mn.common.base.eunm.BusinessFormatEnum;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.eunm.DataFromEnum;
import com.biz.crm.mn.common.base.eunm.ForeignSystemEnum;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.common.base.util.ExceptionStackMsgUtil;
import com.biz.crm.mn.third.system.cow.master.guest.sdk.dto.CowMasterGuestMonthPlanDto;
import com.biz.crm.mn.third.system.cow.master.guest.sdk.service.CowMasterGuestService;
import com.biz.crm.mn.third.system.cow.master.guest.sdk.vo.CowMasterGuestMonthPlanVo;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.enums.DiscountRateDimensionEnum;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.enums.DiscountRateVersionEnum;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.service.DiscountRateSdkService;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.vo.DiscountRateBudgetVo;
import com.biz.crm.tpm.business.sales.plan.local.entity.SalesPlanEntity;
import com.biz.crm.tpm.business.sales.plan.local.repository.SalesPlanRepository;
import com.biz.crm.tpm.business.sales.plan.local.service.SalesPlanCowMasterGuestService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SalesPlanCowMasterGuestServiceImpl
implements SalesPlanCowMasterGuestService {
    private static final Logger log = LoggerFactory.getLogger(SalesPlanCowMasterGuestServiceImpl.class);
    @Autowired(required=false)
    private CowMasterGuestService cowMasterGuestService;
    @Autowired(required=false)
    private DiscountRateSdkService discountRateSdkService;
    @Autowired(required=false)
    private ProductVoService productVoService;
    @Autowired(required=false)
    private SalesPlanRepository salesPlanRepository;
    @Autowired(required=false)
    private RedisLockService redisLockService;
    @Autowired(required=false)
    private SalesOrgVoService salesOrgVoService;

    @Override
    public void pullMonthPlanList(CowMasterGuestMonthPlanDto dto) {
        Validate.notNull((Object)dto, (String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        if (StringUtils.isEmpty((CharSequence)dto.getYear())) {
            dto.setYear(Integer.toString(DateUtil.getCurrentYear()));
        }
        if (StringUtils.isEmpty((CharSequence)dto.getMonths())) {
            dto.setMonths(DateUtil.format((Date)new Date(), (String)"yyyy-MM").split("-")[1]);
        }
        boolean lock = true;
        int pageNum = 1;
        String lockKey = DateUtil.format((Date)new Date(), (String)"yyyy-MM");
        int loopMAX = 40;
        boolean loopFlag = true;
        try {
            lock = this.lock(lockKey);
            if (!lock) {
                return;
            }
            HashMap<String, String> codeMap = new HashMap<String, String>(8);
            while (loopFlag) {
                dto.setCurrent(pageNum);
                dto.setSize(400);
                List cowMasterGuestMonthPlanVoList = this.cowMasterGuestService.pullMonthPlanVo(dto);
                ++pageNum;
                if (CollectionUtils.isEmpty((Collection)cowMasterGuestMonthPlanVoList)) {
                    loopFlag = false;
                    return;
                }
                List<SalesPlanEntity> pullList = this.monthPlanValidate(cowMasterGuestMonthPlanVoList, codeMap);
                List<String> orderNoList = pullList.stream().map(SalesPlanEntity::getOrderNo).collect(Collectors.toList());
                List<SalesPlanEntity> byOrderNos = this.salesPlanRepository.findByOrderNos(orderNoList);
                if (CollectionUtils.isEmpty(byOrderNos)) {
                    this.saveOrUpdateCowBatch(pullList, null);
                    continue;
                }
                ArrayList<SalesPlanEntity> saveList = new ArrayList<SalesPlanEntity>();
                ArrayList<SalesPlanEntity> updateList = new ArrayList<SalesPlanEntity>();
                Map map = byOrderNos.stream().collect(Collectors.toMap(SalesPlanEntity::getOrderNo, Function.identity()));
                pullList.forEach(pull -> {
                    if (map.containsKey(pull.getOrderNo())) {
                        SalesPlanEntity salesPlanEntity = (SalesPlanEntity)((Object)((Object)map.get(pull.getOrderNo())));
                        salesPlanEntity.setOrderNo(pull.getOrderNo());
                        salesPlanEntity.setFromSystem(ForeignSystemEnum.COW_MASTER_GUEST.getCode());
                        salesPlanEntity.setBusinessFormatCode(BusinessFormatEnum.NORMAL.getCode());
                        salesPlanEntity.setBusinessUnitCode(BusinessUnitEnum.VERTICAL.getCode());
                        salesPlanEntity.setYearMonthLy(pull.getYearMonthLy());
                        salesPlanEntity.setSalesOrgRegionCode(pull.getSalesOrgRegionCode());
                        salesPlanEntity.setSalesOrgRegionName(pull.getSalesOrgRegionName());
                        salesPlanEntity.setRegionCode(pull.getRegionCode());
                        salesPlanEntity.setRegionName(pull.getRegionName());
                        salesPlanEntity.setSystemCode(pull.getSystemCode());
                        salesPlanEntity.setSystemName(pull.getSystemName());
                        salesPlanEntity.setCustomerRetailerCode(pull.getCustomerRetailerCode());
                        salesPlanEntity.setCustomerRetailerName(pull.getCustomerRetailerName());
                        salesPlanEntity.setPointsWarehouseCode(pull.getPointsWarehouseCode());
                        salesPlanEntity.setPointsWarehouseName(pull.getPointsWarehouseName());
                        salesPlanEntity.setProductCode(pull.getProductCode());
                        salesPlanEntity.setProductName(pull.getProductName());
                        salesPlanEntity.setProductBrandCode(pull.getProductBrandCode());
                        salesPlanEntity.setProductBrandName(pull.getProductBrandName());
                        salesPlanEntity.setProductCategoryCode(pull.getProductCategoryCode());
                        salesPlanEntity.setProductCategoryName(pull.getProductCategoryName());
                        salesPlanEntity.setProductItemCode(pull.getProductItemCode());
                        salesPlanEntity.setProductItemName(pull.getProductItemName());
                        salesPlanEntity.setPlanQuantity(pull.getPlanQuantity());
                        salesPlanEntity.setDiscountPlanAmount(pull.getDiscountPlanAmount());
                        salesPlanEntity.setDiscountRestoreAmount(pull.getDiscountRestoreAmount());
                        salesPlanEntity.setDiscountRate(pull.getDiscountRate());
                        salesPlanEntity.setRestoreQuantity(pull.getRestoreQuantity());
                        salesPlanEntity.setPlanAmount(pull.getPlanAmount());
                        salesPlanEntity.setCreateTime(pull.getCreateTime());
                        salesPlanEntity.setCreateName(pull.getCreateName());
                        salesPlanEntity.setTenantCode(TenantUtils.getTenantCode());
                        salesPlanEntity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                        updateList.add(salesPlanEntity);
                    } else {
                        saveList.add((SalesPlanEntity)((Object)pull));
                    }
                });
                this.saveOrUpdateCowBatch(saveList, updateList);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(ExceptionStackMsgUtil.stackMsg((Exception)e));
        }
        finally {
            if (lock) {
                this.unLock(lockKey);
            }
        }
    }

    @Transactional(rollbackFor={Exception.class})
    void saveOrUpdateCowBatch(List<SalesPlanEntity> saveList, List<SalesPlanEntity> updateList) {
        if (!org.springframework.util.CollectionUtils.isEmpty(saveList)) {
            this.salesPlanRepository.saveBatch(saveList);
        }
        if (!org.springframework.util.CollectionUtils.isEmpty(updateList)) {
            this.salesPlanRepository.updateBatchById(updateList);
        }
    }

    private void unLock(String lockKey) {
        if (StringUtils.isEmpty((CharSequence)lockKey)) {
            throw new RuntimeException("\u62c9\u53d6\u6708\u9500\u552e\u8ba1\u5212\u89e3\u9501\u5931\u8d25\uff0c\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        this.redisLockService.unlock("month_plan_lock:lock:" + lockKey);
    }

    private boolean lock(String lockKey) {
        if (StringUtils.isEmpty((CharSequence)lockKey)) {
            throw new RuntimeException("\u62c9\u53d6\u6708\u9500\u552e\u8ba1\u5212\u52a0\u9501\u5931\u8d25\uff0c\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        return this.redisLockService.tryLock("month_plan_lock:lock:" + lockKey, TimeUnit.HOURS, 12L);
    }

    private List<SalesPlanEntity> monthPlanValidate(List<CowMasterGuestMonthPlanVo> cowMasterGuestMonthPlanVoList, Map<String, String> codeMap) {
        ArrayList<SalesPlanEntity> pullList = new ArrayList<SalesPlanEntity>();
        Set productCodeSet = cowMasterGuestMonthPlanVoList.stream().map(CowMasterGuestMonthPlanVo::getSapCode).filter(Objects::nonNull).collect(Collectors.toSet());
        Set regionCodeSet = cowMasterGuestMonthPlanVoList.stream().map(CowMasterGuestMonthPlanVo::getRegionCode).filter(Objects::nonNull).collect(Collectors.toSet());
        List salesOrgVos = this.salesOrgVoService.findByErpCodeList(new ArrayList(regionCodeSet));
        List productVoList = this.productVoService.findByCodes(new ArrayList(productCodeSet));
        Map<Object, Object> productVoMap = new HashMap();
        Map<Object, Object> salesOrgVoMap = new HashMap();
        if (!CollectionUtils.isEmpty((Collection)productVoList)) {
            productVoMap = productVoList.stream().collect(Collectors.toMap(ProductVo::getProductCode, Function.identity()));
        }
        if (!CollectionUtils.isEmpty((Collection)salesOrgVos)) {
            salesOrgVoMap = salesOrgVos.stream().collect(Collectors.toMap(SalesOrgVo::getErpCode, Function.identity(), (oldVo, newVo) -> newVo));
        }
        HashMap finalProductVoMap = productVoMap;
        HashMap finalSalesOrgVoMap = salesOrgVoMap;
        cowMasterGuestMonthPlanVoList.forEach(cowVo -> {
            Validate.notEmpty((CharSequence)cowVo.getOrderNo(), (String)"\u5355\u636e\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            if (codeMap.containsKey(cowVo.getOrderNo())) {
                return;
            }
            codeMap.put(cowVo.getOrderNo(), "");
            SalesPlanEntity salesPlanEntity = new SalesPlanEntity();
            salesPlanEntity.setOrderNo(cowVo.getOrderNo());
            salesPlanEntity.setFromSystem(ForeignSystemEnum.COW_MASTER_GUEST.getCode());
            salesPlanEntity.setBusinessFormatCode(BusinessFormatEnum.NORMAL.getCode());
            salesPlanEntity.setBusinessUnitCode(BusinessUnitEnum.VERTICAL.getCode());
            salesPlanEntity.setYearMonthLy(cowVo.getYear() + "-" + cowVo.getMonths());
            salesPlanEntity.setSalesOrgRegionErpCode(cowVo.getRegionCode());
            salesPlanEntity.setSalesOrgRegionName(cowVo.getRegion());
            if (finalSalesOrgVoMap.containsKey(salesPlanEntity.getSalesOrgRegionErpCode())) {
                salesPlanEntity.setSalesOrgRegionCode(((SalesOrgVo)finalSalesOrgVoMap.get(salesPlanEntity.getSalesOrgRegionErpCode())).getSalesOrgCode());
            }
            salesPlanEntity.setCustomerRetailerCode(cowVo.getRetailerCode());
            salesPlanEntity.setCustomerRetailerName(cowVo.getRetailer());
            salesPlanEntity.setSystemCode(cowVo.getRetailerCode());
            salesPlanEntity.setSystemName(cowVo.getRetailer());
            salesPlanEntity.setDataFromCode(DataFromEnum.FOREIGN_SYSTEM.getCode());
            salesPlanEntity.setPointsWarehouseCode(cowVo.getWhseCode());
            salesPlanEntity.setPointsWarehouseName(cowVo.getWhseName());
            salesPlanEntity.setProductCode(cowVo.getSapCode());
            salesPlanEntity.setProductName(cowVo.getSapName());
            if (finalProductVoMap.containsKey(salesPlanEntity.getProductCode())) {
                salesPlanEntity.setProductBrandCode(((ProductVo)finalProductVoMap.get(salesPlanEntity.getProductCode())).getProductBrandCode());
                salesPlanEntity.setProductBrandName(((ProductVo)finalProductVoMap.get(salesPlanEntity.getProductCode())).getProductBrandName());
                salesPlanEntity.setProductCategoryCode(((ProductVo)finalProductVoMap.get(salesPlanEntity.getProductCode())).getProductCategoryCode());
                salesPlanEntity.setProductCategoryName(((ProductVo)finalProductVoMap.get(salesPlanEntity.getProductCode())).getProductCategoryName());
                salesPlanEntity.setProductItemCode(((ProductVo)finalProductVoMap.get(salesPlanEntity.getProductCode())).getProductLevelCode());
                salesPlanEntity.setProductItemName(((ProductVo)finalProductVoMap.get(salesPlanEntity.getProductCode())).getProductLevelName());
            }
            salesPlanEntity.setPlanQuantity(new BigDecimal(Optional.of(cowVo.getConfirmedQty()).orElse(0)));
            salesPlanEntity.setRestoreQuantity(new BigDecimal(Optional.of(cowVo.getFinalyQty()).orElse(0)));
            salesPlanEntity.setPlanAmount(cowVo.getPlanAmt());
            salesPlanEntity.setRestoreAmount(cowVo.getFinalyAmt());
            salesPlanEntity.setCreateTime(cowVo.getCreateTime());
            salesPlanEntity.setCreateName(cowVo.getCreateBy());
            salesPlanEntity.setTenantCode(TenantUtils.getTenantCode());
            salesPlanEntity.setRegionCode(cowVo.getRegionCode());
            salesPlanEntity.setRegionName(cowVo.getRegion());
            salesPlanEntity.setPrice(cowVo.getOutboundPriceSystem());
            salesPlanEntity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            pullList.add(salesPlanEntity);
        });
        List onlyKeyList = pullList.stream().map(pull -> pull.getBusinessFormatCode() + pull.getBusinessUnitCode() + DiscountRateVersionEnum.CORRECTION.getCode() + DiscountRateDimensionEnum.RETAILER_REGION.getCode() + pull.getYearMonthLy() + pull.getSystemCode() + pull.getRegionCode()).collect(Collectors.toList());
        Map discountRateBudgetMap = this.discountRateSdkService.getDiscountRateByOnlyKey(onlyKeyList);
        AtomicReference<String> onlyKey = new AtomicReference<String>(new String(""));
        pullList.forEach(pull -> {
            onlyKey.set(pull.getBusinessFormatCode() + pull.getBusinessUnitCode() + DiscountRateVersionEnum.CORRECTION.getCode() + DiscountRateDimensionEnum.RETAILER_REGION.getCode() + pull.getYearMonthLy() + pull.getSystemCode() + pull.getRegionCode());
            if (pull.getPlanAmount() != null && discountRateBudgetMap.containsKey(onlyKey.get())) {
                pull.setDiscountPlanAmount(pull.getPlanAmount().multiply(BigDecimal.ONE.subtract(Optional.ofNullable(((DiscountRateBudgetVo)discountRateBudgetMap.get(onlyKey.get())).getPlanRate()).orElse(BigDecimal.ZERO))));
                pull.setDiscountRate(((DiscountRateBudgetVo)discountRateBudgetMap.get(onlyKey.get())).getPlanRate());
            }
            if (pull.getRestoreAmount() != null && discountRateBudgetMap.containsKey(onlyKey.get())) {
                pull.setDiscountRestoreAmount(pull.getRestoreAmount().multiply(BigDecimal.ONE.subtract(Optional.ofNullable(((DiscountRateBudgetVo)discountRateBudgetMap.get(onlyKey.get())).getPlanRate()).orElse(BigDecimal.ZERO))));
                pull.setDiscountRate(((DiscountRateBudgetVo)discountRateBudgetMap.get(onlyKey.get())).getPlanRate());
            }
        });
        return pullList;
    }
}

