/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.sales.plan.local.service.internal;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.dto.DiscountRateDto;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.enums.DiscountRateVersionEnum;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.service.DiscountRateSdkService;
import com.biz.crm.tpm.business.sales.plan.local.entity.SalesPlanEntity;
import com.biz.crm.tpm.business.sales.plan.local.repository.SalesPlanRepository;
import com.biz.crm.tpm.business.sales.plan.local.service.SalesPlanEntityService;
import com.biz.crm.tpm.business.sales.plan.sdk.dto.SalesPlanDto;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="salesPlanEntityService")
public class SalesPlanEntityServiceImpl
implements SalesPlanEntityService {
    private static final Logger log = LoggerFactory.getLogger(SalesPlanEntityServiceImpl.class);
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private SalesPlanRepository salesPlanRepository;
    @Autowired(required=false)
    private DiscountRateSdkService discountRateSdkService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<SalesPlanEntity> saveThirdSystemBatch(List<SalesPlanDto> addList, List<SalesPlanDto> updateList) {
        ArrayList<SalesPlanEntity> newList = new ArrayList<SalesPlanEntity>();
        String tenantCode = TenantUtils.getTenantCode();
        if (!CollectionUtils.isEmpty(addList)) {
            for (SalesPlanDto thirdDto : addList) {
                thirdDto.setTenantCode(tenantCode);
                thirdDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                thirdDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            }
            newList.addAll(this.nebulaToolkitService.copyCollectionByWhiteList(addList, SalesPlanDto.class, SalesPlanEntity.class, HashSet.class, ArrayList.class, new String[0]));
            this.salesPlanRepository.saveBatch(newList);
        }
        if (!CollectionUtils.isEmpty(updateList)) {
            newList.addAll(this.nebulaToolkitService.copyCollectionByWhiteList(updateList, SalesPlanDto.class, SalesPlanEntity.class, HashSet.class, ArrayList.class, new String[0]));
            this.salesPlanRepository.updateBatchById(newList);
        }
        return newList;
    }

    @Override
    @Async
    @Transactional(rollbackFor={Exception.class})
    public void syncCalDiscount(List<SalesPlanEntity> planList) {
        if (CollectionUtils.isEmpty(planList)) {
            return;
        }
        ArrayList<String> keys = new ArrayList<String>();
        ArrayList<String> keys2 = new ArrayList<String>();
        for (SalesPlanEntity entity : planList) {
            String key = entity.getBusinessFormatCode() + entity.getBusinessUnitCode() + entity.getYearMonthLy() + entity.getCustomerCode() + entity.getProductCode();
            keys.add(key);
            String key2 = entity.getBusinessFormatCode() + entity.getBusinessUnitCode() + entity.getYearMonthLy() + entity.getCustomerCode();
            keys2.add(key2);
        }
        List keyList = Lists.partition(keys, (int)500);
        List list = this.discountRateSdkService.getDiscountRateByKeys(keyList);
        Map<Object, Object> map = new HashMap();
        if (!CollectionUtils.isEmpty((Collection)list)) {
            map = list.stream().collect(Collectors.groupingBy(i -> i.getBusinessFormatCode() + i.getBusinessUnitCode() + DateUtil.dateToStr((Date)i.getYearAndMonth(), (SimpleDateFormat)DateUtil.date_yyyy_MM) + i.getCustomerCode() + i.getProductCode()));
        }
        List keyList2 = Lists.partition(keys2, (int)500);
        List list2 = this.discountRateSdkService.getDiscountRateByKeysNoPro(keyList2);
        Map<Object, Object> map2 = new HashMap();
        if (!CollectionUtils.isEmpty((Collection)list2)) {
            map2 = list2.stream().collect(Collectors.groupingBy(i -> i.getBusinessFormatCode() + i.getBusinessUnitCode() + DateUtil.dateToStr((Date)i.getYearAndMonth(), (SimpleDateFormat)DateUtil.date_yyyy_MM) + i.getCustomerCode()));
        }
        ArrayList<SalesPlanEntity> ens = new ArrayList<SalesPlanEntity>();
        for (SalesPlanEntity entity : planList) {
            BigDecimal rate;
            String key = entity.getBusinessFormatCode() + entity.getBusinessUnitCode() + entity.getYearMonthLy() + entity.getCustomerCode() + entity.getProductCode();
            String key2 = entity.getBusinessFormatCode() + entity.getBusinessUnitCode() + entity.getYearMonthLy() + entity.getCustomerCode();
            List dtos = new ArrayList();
            if (map.containsKey(key)) {
                dtos = (List)map.get(key);
            } else if (map2.containsKey(key2)) {
                dtos = (List)map2.get(key2);
            } else {
                log.error("\u9500\u552e\u8ba1\u5212\u540c\u6b65\u672a\u5339\u914d\u5230\u6298\u6263\u7387\uff0cid={},key={},key2={}", new Object[]{entity.getId(), key, key2});
                continue;
            }
            Map<String, List<DiscountRateDto>> dtoMap = dtos.stream().collect(Collectors.groupingBy(DiscountRateDto::getRateVersion));
            if (dtoMap.containsKey(DiscountRateVersionEnum.CORRECTION.getCode())) {
                rate = dtoMap.get(DiscountRateVersionEnum.CORRECTION.getCode()).get(0).getSystemRate();
                entity.setDiscountPlanAmount(entity.getPlanAmount().multiply(new BigDecimal(1).subtract(rate)).setScale(2, 4));
                entity.setDiscountRestoreAmount(entity.getRestoreAmount().multiply(new BigDecimal(1).subtract(rate)).setScale(2, 4));
                ens.add(entity);
                continue;
            }
            if (!dtoMap.containsKey(DiscountRateVersionEnum.PLAN.getCode())) continue;
            rate = dtoMap.get(DiscountRateVersionEnum.PLAN.getCode()).get(0).getSystemRate();
            entity.setDiscountPlanAmount(entity.getPlanAmount().multiply(new BigDecimal(1).subtract(rate)).setScale(2, 4));
            entity.setDiscountRestoreAmount(entity.getRestoreAmount().multiply(new BigDecimal(1).subtract(rate)).setScale(2, 4));
            ens.add(entity);
        }
        if (!CollectionUtils.isEmpty(ens)) {
            this.salesPlanRepository.updateBatchById(ens);
        }
    }

    @Override
    public List<SalesPlanEntity> getMaxVersionSalesPlan(List<List<String>> onlyKeys) {
        if (CollectionUtils.isEmpty(onlyKeys)) {
            return Lists.newArrayList();
        }
        return this.salesPlanRepository.getMaxVersionSalesPlan(onlyKeys, TenantUtils.getTenantCode());
    }

    @Override
    public List<SalesPlanEntity> getSalesPlanByIds(List<List<String>> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Lists.newArrayList();
        }
        return this.salesPlanRepository.getSalesPlanByIds(ids, TenantUtils.getTenantCode());
    }
}

